/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"out_ext.h"
#include"f_c.h"
#include"sf_mrs.h"
#include"mrsg.h"
#include"tptcmac.h"
#include"chep_crt.h"
#include"files.h"
#include"strfun.h"
#include"subproc.h"

/* Common Block Declarations */

double mass_mrs(int i) { return 1.;}

static  char mrsmen[]="\030"   
   " MRS ( A' , Proton )    "
   " MRS ( G  , Proton )    "
   " MRS ( A' , AntiProton) " 
   " MRS ( G  , AntiProton) ";

    static int inhadr[2] = { 1,1 };
    static int nmrs[2]   = { 1,1 };
    static int nquark[2];
    static int first[2]   = { 1,1 };


char *  q_name__(int i)
{
    static char cprtn[13][6] = {"T", "B", "C", "S", "D", 
	    "U","G","u","d","s","c","b","t"};

    if (i < -6 || i > 6) return NULL;
    return  cprtn[i + 6];
  
} /* q_name__ */


int p_mrs__(char *p_name__)
{
 int k; 
 for (k = -5; k <= 5; ++k) {if (!strcmp(p_name__,q_name__(k)))  return 1;}
 return 0;
}


void n_mrs__(int i, char *name)
{
   int mode;
   mode = 1 - inhadr[i - 1] + nmrs[i - 1];    
   sprintf(name,"%.*s",mrsmen[0]-1,mrsmen + (mode - 1)*mrsmen[0] +2);
}

int r_mrs__(int i, char *name)
{
  int mode,k;
  char std_name[100];
  char ch__1[10];  
  i--;

  for (mode = 1; mode <= 4; ++mode) 
  {
     sprintf(std_name,"%.*s",mrsmen[0]-1,mrsmen + (mode-1)*mrsmen[0]+2);    
     if (strcmp(name,std_name ) == 0) 
     {
        switch(mode)
        {
          case 1  : inhadr[i] = 1; nmrs[i]=1;break;
          case 2  : inhadr[i] = 1; nmrs[i]=2;break;
          case 3  : inhadr[i] =-1; nmrs[i]=1;break;
          case 4  : inhadr[i] =-1; nmrs[i]=2;break;
        }
	for (k = -5; k <= 5; ++k) 
        {
	   pinf_(proces_1.nsub, i+1, ch__1, NULL);
	   if (strcmp(ch__1, q_name__(k)) == 0) 
	   {
	      nquark[i] = k*inhadr[i];
	      return 1;
	   }
	}
	return 0;
     }
  }
  return 0;
}

double  i_mrs__(int i) 
{ 
  int k;
  char ch__1[10];
  i--;

  for (k = -5; k <= 5; ++k)
  {
     pinf_(proces_1.nsub, i+1, ch__1, NULL);
     if (strcmp(ch__1, q_name__(k)) == 0)
     {
        nquark[i] = k;
        if(inhadr[i] ==-1) nquark[i] *=-1;
        return 1.;
     }
  }
  return 0.;
}

void m_mrs__(int i)
{
  void * pscr = NULL;
  int mode=1;
  i--;

  menu1(52,10,"",mrsmen,"n_sf_mrs",&pscr,&mode);

  switch(mode)
  {
    case 0  : return ;
    case 1  : inhadr[i] = 1; nmrs[i]=1;break;
    case 2  : inhadr[i] = 1; nmrs[i]=2;break;
    case 3  : inhadr[i] =-1; nmrs[i]=1;break;
    case 4  : inhadr[i] =-1; nmrs[i]=2;break;
  }
  put_text(&pscr);
}


double c_mrs__(int i, double x)
{
    FILE * inifile;

    double gl, chm, bot, dnv, str, upv, dsea, usea;
    char fname[100];
    double dscale;
    double strf;
   
    i--;
    if (first[nmrs[i] - 1]) 
    {
	first[nmrs[i] - 1] = 0;

	if (nmrs[i] == 1) sprintf(fname,"%smrsA_.tbl",pathtocomphep);    
	 else             sprintf(fname,"%smrsG.tbl", pathtocomphep);    	
	inifile=fopen(fname,"r");
    }
    if (x < 1e-5)  x = 1e-5;

    dscale=strfunScale;
    if (dscale < 2.25) dscale = 2.25;
   
    mrseb_(inifile, x, dscale, nmrs[i],  
    &upv, &dnv,  &usea, &dsea, &str, &chm, &bot, &gl);
    switch(nquark[i])
    {
     case  0: strf=gl; break;
     case  1: strf=usea+upv; break;
     case -1: strf=usea; break;
     case  2: strf=dsea+dnv; break;
     case -2: strf=dsea; break;
     case -3:
     case  3: strf=str;  break;
     case -4:
     case  4: strf=chm;  break;
     case -5:
     case  5: strf=bot;  break;
    } 
    return   strf/x; 
}
