/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "out_ext.h"
#include "f_c.h"
#include"sf_ctq.h"
#include"alphas2.h"
#include"sf_mrs.h"
#include"strfun.h"
#include"ctq4fn.h"

#include "tptcmac.h"
#include "chep_crt.h"
#include "files.h"
#include "subproc.h"
/* Table of constant values */

    static long inhadr[2] = { 1,1 };
    static char ctqmen[] = "\31"
                           " CTEQ4m (  Proton )      "
                           " CTEQ4m ( AntiProton )   ";
    static int first = 1;
    static long nquark[2];

void m_ctq__(int i)
{   void  * pscr = NULL;
    int mode =1;
    
    menu1(50,10,"",ctqmen,"n_sf_ctq",&pscr,&mode);
    if (mode == 0) return;
    if (mode >= 1 || mode <= 4) {
	inhadr[i - 1] = 1 - (mode - 1 << 1);
    } 
    put_text(&pscr);   
}



int p_ctq__(char *p_name__)
{
  int k;
  for (k = -5; k <= 5; ++k) if ( strcmp(p_name__, q_name__(k) ) == 0 ) return 1;
  return 0;
}    


void n_ctq__(int i, char *name)
{
int mode;
    mode = (1 - inhadr[i - 1]) / 2 + 1;
    sprintf(name,"%.*s",ctqmen[0]-1,ctqmen +2+(mode - 1)*ctqmen[0]);
}


int r_ctq__(int i, char *name)
{
    int mode;
    char std_name[100];
    for (mode = 0; mode < 2; ++mode) 
    {
       sprintf(std_name,"%.*s",ctqmen[0]-1,ctqmen + mode*ctqmen[0]+2);
       if(!strcmp(name,std_name)) 
       {
	  inhadr[i - 1] = 1 - 2*mode;
	  return 1;
       }
    }
    return 0;
}


double i_ctq__(int i)
{ 
    int k;
    char pname[20];
        
    if (first) 
    { FILE * ff;
      char fname[200];

	first = 0;
        sprintf(fname,"%scteq4m.tbl",pathtocomphep); 
	ff = fopen(fname,"r");
	if(!ff)
	{  fprintf(stderr," Can not open cteq4m.tbl\n");
	   exit(0);
	}
        readtbl_(ff);
	fclose(ff); 
    }
    for (k = -5; k <= 5; ++k) 
    {
       pinf_(proces_1.nsub, i,pname,NULL );
       if (!strcmp(pname, q_name__(k) )) 
       {
          nquark[i-1] = k*inhadr[i-1];
          return 1.0;
	}
    }
    return 0.;
}


double mass_ctq(int i) { return 1.;}


double c_ctq__(int i, double x)
{  
 double strfun, dscale;
    if (x < 1.e-5) x = 1.e-5;
    dscale=strfunScale;
    if(dscale>10000) 
    { printf("WARNING: QCD-Scale =%f, IMPROVED TO 10^4 GeV\n",dscale);
      dscale=10000.;
    }      
    strfun = partonx_(nquark[i-1],x,dscale);
/*printf("CTEQ: nquark=%d, x=%f, scale=%f, strfun=%f\n",
        nquark[i-1],x,dscale,strfun);  */  
    if(strfun<0.0)  strfun=0.0;
    return strfun;
} 
