/* ***************************************************************
 								
     This is a package for the new MRS(A',G) parton            
     distributions. The minimum Q^2  value is 5 GeV^2 and the  
     x range is, as before 10^-5 < x < 1. MSbar factorization  
     is used. The package reads 2 grids, which are in separate 
     files (A'=for111.dat/ftn111, G=for031.dat/ftn31).         
     Note that x times the parton distribution is returned,    
     Q is the scale in GeV,                                    
     and Lambda(MSbar,nf=4) = 231/255 MeV for A'/G.            
 								
 	MODE=1 for MRS(A')                                      
 	MODE=2 for MRS(G)                                       
 								
         The reference is :                                    
         A.D. Martin, R.G. Roberts and W.J. Stirling,          
         RAL preprint  RAL-95-021 (1995)                       
                                                               
         Comments to : W.J.Stirling@durham.ac.uk               
                                                               
             >>>>>>>>  CROSS CHECK  <<<<<<<<                   
                                                               
         THE FIRST NUMBER IN THE 30 GRID IS 0.00341            
         THE FIRST NUMBER IN THE 31 GRID IS 0.00269            
 								
 ***************************************************************/

#include "f_c.h"
#include"mrsg.h"
#include<math.h>

#include<stdio.h>


static int strc30_(FILE *ifile, double *x, double *scale,
	 double *upv, double *dnv, double *usea, double *dsea,
	 double *str, double *chm, double *bot, double *glu)
{
    /* Initialized data */

    static long init = 0;
    static double xx[47] = { 1e-5,2e-5,4e-5,6e-5,8e-5,1e-4,2e-4,4e-4,6e-4,
	    8e-4,.001,.002,.004,.006,.008,.01,.02,.04,.06,.08,.1,.125,.15,
	    .175,.2,.225,.25,.275,.3,.325,.35,.375,.4,.425,.45,.475,.5,.525,
	    .55,.575,.6,.65,.7,.75,.8,.9,1. };
    static double xmin = 1e-5;
    static double xmax = 1.;
    static double qsqmin = 5.;
    static double qsqmax = 1310720.;
    static long n0[8] = { 2,5,5,9,0,0,9,9 };


    /* System generated locals */
    double d__1;

    /* Local variables */
    static double a, b, f[7520]	/* was [8][47][20] */, g[8];
    static long i, j, k, m, n;
    static double rm, fac, qsq, xxx, xsave;


/*     THIS IS THE NEW  "Aprime" FIT -- Feb 1995 -- standard Q^2 range */
    xsave = *x;
    if (init != 0) goto L10;
    init = 1;
    for (n = 1; n <= 46; ++n) {
	for (m = 1; m <= 19; ++m) {
	    fscanf(ifile,"%lf%lf%lf%lf%lf%lf%lf%lf"
	    ,&f[(n + m * 47 << 3) - 384]
	    ,&f[(n + m * 47 << 3) - 383]
	    ,&f[(n + m * 47 << 3) - 382] 
	    ,&f[(n + m * 47 << 3) - 381] 
	    ,&f[(n + m * 47 << 3) - 380] 
	    ,&f[(n + m * 47 << 3) - 378]
	    ,&f[(n + m * 47 << 3) - 379]
	    ,&f[(n + m * 47 << 3) - 377]);

/* 1=UV 2=DV 3=GLUE 4=UBAR 5=CBAR 7=BBAR 6=SBAR 8=DBAR */
	    for (i = 1; i <= 8; ++i) {
/* L25: */
		d__1 = 1. - xx[n - 1];
		f[i + (n + m * 47 << 3) - 385] /= pow_dl(d__1, n0[i - 1]);
	    }
/* L20: */
	}
    }
    for (j = 1; j <= 20; ++j) {
	xx[j - 1] = log10(xx[j - 1]) + 1.1;
	for (i = 1; i <= 8; ++i) {
	    if (i == 7) {
		goto L31;
	    }
	    for (k = 1; k <= 19; ++k) {
/* L30: */
		f[i + (j + k * 47 << 3) - 385] = log(f[i + (j + k * 47 << 3) 
			- 385]) * f[i + (k * 47 + 21 << 3) - 385] / log(f[i + 
			(k * 47 + 21 << 3) - 385]);
	    }
L31:
	    ;
	}
    }
    for (i = 1; i <= 8; ++i) {
	for (m = 1; m <= 19; ++m) {
/* L40: */
	    f[i + (m * 47 + 47 << 3) - 385] = 0.;
	}
    }
L10:
    if (*x < xmin) {
	*x = xmin;
    }
    if (*x > xmax) {
	*x = xmax;
    }
/* Computing 2nd power */
    d__1 = *scale;
    qsq = d__1 * d__1;
    if (qsq < qsqmin) {
	qsq = qsqmin;
    }
    if (qsq > qsqmax) {
	qsq = qsqmax;
    }
    xxx = *x;
    if (*x < .1) {
	xxx = log10(*x) + 1.1;
    }
    n = 0;
L70:
    ++n;
    if (xxx > xx[n]) {
	goto L70;
    }
    a = (xxx - xx[n - 1]) / (xx[n] - xx[n - 1]);
    rm = log(qsq / qsqmin) / log(2.);
    b = rm - d_int(rm);
    m = (long) rm + 1;
    for (i = 1; i <= 8; ++i) {
	g[i - 1] = (1. - a) * (1. - b) * f[i + (n + m * 47 << 3) - 385] + (1. 
		- a) * b * f[i + (n + (m + 1) * 47 << 3) - 385] + a * (1. - b)
		 * f[i + (n + 1 + m * 47 << 3) - 385] + a * b * f[i + (n + 1 
		+ (m + 1) * 47 << 3) - 385];
	if (n >= 21) {
	    goto L65;
	}
	if (i == 7) {
	    goto L65;
	}
	fac = (1. - b) * f[i + (m * 47 + 21 << 3) - 385] + b * f[i + ((m + 1) 
		* 47 + 21 << 3) - 385];
	d__1 = g[i - 1] / fac;
	g[i - 1] = pow(fac, d__1);
L65:
	d__1 = 1. - *x;
	g[i - 1] *= pow_dl(d__1, n0[i - 1]);
/* L60: */
    }
    *upv = g[0];
    *dnv = g[1];
    *usea = g[3];
    *dsea = g[7];
    *str = g[5];
    *chm = g[4];
    *glu = g[2];
    *bot = g[6];
    *x = xsave;
    return 0;
} /* strc30_ */


static int strc31_(FILE *ifile, double *x, double *scale,
	 double *upv, double *dnv, double *usea, double *dsea,
	 double *str, double *chm, double *bot, double *glu)
{
    /* Initialized data */

    static double xx[47] = { 1e-5,2e-5,4e-5,6e-5,8e-5,1e-4,2e-4,4e-4,6e-4,
	    8e-4,.001,.002,.004,.006,.008,.01,.02,.04,.06,.08,.1,.125,.15,
	    .175,.2,.225,.25,.275,.3,.325,.35,.375,.4,.425,.45,.475,.5,.525,
	    .55,.575,.6,.65,.7,.75,.8,.9,1. };
    static double xmin = 1e-5;
    static double xmax = 1.;
    static double qsqmin = 5.;
    static double qsqmax = 1310720.;
    static long n0[8] = { 2,5,5,9,0,0,9,9 };
    static long init = 0;


    /* System generated locals */
    double d__1;


    /* Local variables */
    static double a, b, f[7520]	/* was [8][47][20] */, g[8];
    static long i, j, k, m, n;
    static double rm, fac, qsq, xxx, xsave;


/*     THIS IS THE NEW  "G" FIT -- Feb 1995 -- standard Q^2 range */
    xsave = *x;
    if (init != 0) {
	goto L10;
    }
    init = 1;
    for (n = 1; n <= 46; ++n) {
	for (m = 1; m <= 19; ++m) {
	    fscanf(ifile,"%lf%lf%lf%lf%lf%lf%lf%lf"
	    ,&f[(n + m * 47 << 3) - 384]
	    ,&f[(n + m * 47 << 3) - 383]
	    ,&f[(n + m * 47 << 3) - 382] 
	    ,&f[(n + m * 47 << 3) - 381] 
	    ,&f[(n + m * 47 << 3) - 380] 
	    ,&f[(n + m * 47 << 3) - 378]
	    ,&f[(n + m * 47 << 3) - 379]
	    ,&f[(n + m * 47 << 3) - 377]);
	
/* 1=UV 2=DV 3=GLUE 4=UBAR 5=CBAR 7=BBAR 6=SBAR 8=DBAR */
	    for (i = 1; i <= 8; ++i) {
/* L25: */
		d__1 = 1. - xx[n - 1];
		f[i + (n + m * 47 << 3) - 385] /= pow_dl(d__1, n0[i - 1]);
	    }
/* L20: */
	}
    }
    for (j = 1; j <= 20; ++j) {
	xx[j - 1] = log10(xx[j - 1]) + 1.1;
	for (i = 1; i <= 8; ++i) {
	    if (i == 7) {
		goto L31;
	    }
	    for (k = 1; k <= 19; ++k) {
/* L30: */
		f[i + (j + k * 47 << 3) - 385] = log(f[i + (j + k * 47 << 3) 
			- 385]) * f[i + (k * 47 + 21 << 3) - 385] / log(f[i + 
			(k * 47 + 21 << 3) - 385]);
	    }
L31:
	    ;
	}
    }
    for (i = 1; i <= 8; ++i) {
	for (m = 1; m <= 19; ++m) {
/* L40: */
	    f[i + (m * 47 + 47 << 3) - 385] = 0.;
	}
    }
L10:
    if (*x < xmin) {
	*x = xmin;
    }
    if (*x > xmax) {
	*x = xmax;
    }
/* Computing 2nd power */
    d__1 = *scale;
    qsq = d__1 * d__1;
    if (qsq < qsqmin) {
	qsq = qsqmin;
    }
    if (qsq > qsqmax) {
	qsq = qsqmax;
    }
    xxx = *x;
    if (*x < .1) {
	xxx = log10(*x) + 1.1;
    }
    n = 0;
L70:
    ++n;
    if (xxx > xx[n]) {
	goto L70;
    }
    a = (xxx - xx[n - 1]) / (xx[n] - xx[n - 1]);
    rm = log(qsq / qsqmin) / log(2.);
    b = rm - d_int(rm);
    m = (long) rm + 1;
    for (i = 1; i <= 8; ++i) {
	g[i - 1] = (1. - a) * (1. - b) * f[i + (n + m * 47 << 3) - 385] + (1. 
		- a) * b * f[i + (n + (m + 1) * 47 << 3) - 385] + a * (1. - b)
		 * f[i + (n + 1 + m * 47 << 3) - 385] + a * b * f[i + (n + 1 
		+ (m + 1) * 47 << 3) - 385];
	if (n >= 21) {
	    goto L65;
	}
	if (i == 7) {
	    goto L65;
	}
	fac = (1. - b) * f[i + (m * 47 + 21 << 3) - 385] + b * f[i + ((m + 1) 
		* 47 + 21 << 3) - 385];
	d__1 = g[i - 1] / fac;
	g[i - 1] = pow(fac, d__1);
L65:
	d__1 = 1. - *x;
	g[i - 1] *= pow_dl(d__1, n0[i - 1]);
/* L60: */
    }
    *upv = g[0];
    *dnv = g[1];
    *usea = g[3];
    *dsea = g[7];
    *str = g[5];
    *chm = g[4];
    *glu = g[2];
    *bot = g[6];
    *x = xsave;
    return 0;
} /* strc31_ */







 int mrseb_(FILE * ifile, double x, double scale, int mode, 
 double *upv, double *dnv, double *usea, 
	double *dsea, double *str, double *chm, double *bot, 
	double *glu)
{

    /* Local variables */
    static double q2;


/* Computing 2nd power */
    q2 = scale * scale;
    if (q2 < 5. || q2 > 1310720.) printf("WARNING: Q^2 VALUE IS OUT OF RANGE\n"); 
    if (x < 1e-5 || x > 1.)     printf("WARNING:  X  VALUE IS OUT OF RANGE\n");
    
    if (mode == 1) {
	strc30_(ifile, &x, &scale, upv, dnv, usea, dsea, str, chm, bot, glu);
    }
    if (mode == 2) {
	strc31_(ifile, &x, &scale, upv, dnv, usea, dsea, str, chm, bot, glu);
    }
    return 0;
} /* mrseb_ */


