/*
===========================================================================
                CTEQ Parton Distribution Functions: Version 4 
                          June 21, 1996 

   By: H.L. Lai, J. Huston, S. Kuhlmann, F. Olness, J. Owens, D. Soper 
       W.K. Tung, H. Weerts 
   Ref: MSUHEP-60426, CTEQ-604, e-Print Archive: hep-ph/9606399 

   This package contains 9 sets of CTEQ4 PDF's. Details are: 
---------------------------------------------------------------------------

  Iset   PDF      Description             Alpha_s(Mz)  Q0(GeV)  Table_File
---------------------------------------------------------------------------
  1      CTEQ4M   Standard MSbar scheme   0.116        1.6      cteq4m.tbl
  2      CTEQ4D   Standard DIS scheme     0.116        1.6      cteq4d.tbl
  3      CTEQ4L   Leading Order           0.116        1.6      cteq4l.tbl
  4      CTEQ4A1  Alpha_s series          0.110        1.6      cteq4a1.tbl
  5      CTEQ4A2  Alpha_s series          0.113        1.6      cteq4a2.tbl
  6      CTEQ4A3  same as CTEQ4M          0.116        1.6      cteq4m.tbl
  7      CTEQ4A4  Alpha_s series          0.119        1.6      cteq4a4.tbl
  8      CTEQ4A5  Alpha_s series          0.122        1.6      cteq4a5.tbl
  9      CTEQ4HJ  High Jet                0.116        1.6      cteq4hj.tbl
  10     CTEQ4LQ  Low Q0                  0.114        0.7      cteq4lq.tbl
---------------------------------------------------------------------------


  The available applied range is 10^-5 < x < 1 and 1.6 < Q < 10,000 (GeV)
   except CTEQ4LQ for which Q starts at a lower value of 0.7 GeV. 
   The Table_Files are assumed to be in the working directory. 

   The function Ctq4Fn (Iset, Iparton, X, Q) 
  returns the parton distribution inside the proton for parton [Iparton]
   at [X] Bjorken_X and scale [Q] (GeV) in PDF set [Iset]. 
   Iparton  is the parton label (5, 4, 3, 2, 1, 0, -1, ......, -5) 
                            for (b, c, s, d, u, g, u_bar, ..., b_bar) 

   For detailed information on the parameters used, e.q. quark masses, 
   QCD Lambda, ... etc.,  see info lines at the beginning of the 
   Table_Files. 
  These programs, as provided, are in double precision.  By removing the
   "Implicit Double Precision" lines, they can also be run in single 
   precision. 

   If you have detailed questions concerning these CTEQ4 distributions, 
   or if you find problems/bugs using this package, direct inquires to 
   Hung-Liang Lai(Lai_H@pa.msu.edu) or Wu-Ki Tung(Tung@pa.msu.edu). 

===========================================================================
*/



#include<stdio.h>
#include<math.h>
#include<stdlib.h>
#include"ctq4fn.h"
/* Common Block Declarations */

static struct{
    long nx, nt, nfmx;
} ctqpar2_;

#define ctqpar2_1 ctqpar2_

static struct {
    double alambda;
    long nfl, iorder;
} qcdtable_;

#define qcdtable_1 qcdtable_

static struct {
    double al, xv[106], ql[26], upd[36750];
} ctqpar1_;

#define ctqpar1_1 ctqpar1_

static struct {
    double qini, qmax, xmin;
} xqrange_;

#define xqrange_1 xqrange_

static   double amass[6];



static long  i_dnnt(double  x)
{  if(x>0) x+=0.5; else x-=0.5;
   return (long)x;
}
   
static int polint_(double * xa,double * ya,int n,double  x, double * y,double * dy)
{
    /* System generated locals */
    long i__1, i__2;
    double d__1;

    /* Local variables */
    double dift, c__[10], d__[10];
    long i__, m;
    double w, ho, hp;
    long ns;
    double dif, den;


/*                                        Adapted from "Numerical Recipes"
 */
    /* Parameter adjustments */
    --ya;
    --xa;

    /* Function Body */
    ns = 1;
    dif = (d__1 = x - xa[1], abs(d__1));
    i__1 = n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	dift = (d__1 = x - xa[i__], abs(d__1));
	if (dift < dif) {
	    ns = i__;
	    dif = dift;
	}
	c__[i__ - 1] = ya[i__];
	d__[i__ - 1] = ya[i__];
/* L11: */
    }
    *y = ya[ns];
    --ns;
    i__1 = n - 1;
    for (m = 1; m <= i__1; ++m) {
	i__2 = n - m;
	for (i__ = 1; i__ <= i__2; ++i__) {
	    ho = xa[i__] - x;
	    hp = xa[i__ + m] - x;
	    w = c__[i__] - d__[i__ - 1];
	    den = ho - hp;
	    if (den == 0.) return 0;
	    den = w / den;
	    d__[i__ - 1] = hp * den;
	    c__[i__ - 1] = ho * den;
/* L12: */
	}
	if (ns << 1 < n - m) {
	    *dy = c__[ns];
	} else {
	    *dy = d__[ns - 1];
	    --ns;
	}
	*y += *dy;
/* L13: */
    }
    return 1;
} /* polint_ */




int readtbl_(FILE * f)
{
    /* Local variables */
   long nblk;
   long  npts, i;
   double fl, dr;
   long iq;


    fscanf(f,"%*[^\n]"); fscanf(f,"\n");
    fscanf(f,"%*[^\n]"); fscanf(f,"\n");
    
    fscanf(f,"%lf%lf%lf",&dr,&fl,&ctqpar1_1.al);

    for (i = 0; i < 6; ++i)  fscanf(f,"%lf",amass+i );
    
    qcdtable_1.iorder = i_dnnt(dr);
    qcdtable_1.nfl    = i_dnnt (fl);
    qcdtable_1.alambda = ctqpar1_1.al;
    
    fscanf(f,"%*[^\n]"); fscanf(f,"\n");
    fscanf(f,"%*[^\n]"); fscanf(f,"\n");
     
    fscanf(f,"%ld %ld %ld",&ctqpar2_1.nx,&ctqpar2_1.nt,&ctqpar2_1.nfmx);
     
    fscanf(f,"%*[^\n]");     fscanf(f,"\n"); 
    fscanf(f,"%*[^\n]");     fscanf(f,"\n");
        

    fscanf(f,"%lf%lf",&xqrange_1.qini,&xqrange_1.qmax);


    for (i=0;i <= ctqpar2_1.nt; ++i) fscanf(f,"%lf",&ctqpar1_1.ql[i]);
    
    fscanf(f,"%*[^\n]");   fscanf(f,"\n"); 
    fscanf(f,"%*[^\n]");     fscanf(f,"\n");
    

    fscanf(f,"%lf",&xqrange_1.xmin);
        
    for (i = 0; i <= ctqpar2_1.nx; ++i)  fscanf(f,"%lf",&ctqpar1_1.xv[i]);
    
    for (iq = 0; iq <= ctqpar2_1.nt; ++iq) 
	ctqpar1_1.ql[iq] = log(ctqpar1_1.ql[iq] / ctqpar1_1.al);
    

/*
     Since quark = anti-quark for nfl>2 at this stage, 
     we Read  out only the non-redundent data points 
     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 
*/
    nblk = (ctqpar2_1.nx + 1) * (ctqpar2_1.nt + 1);
    npts = nblk * (ctqpar2_1.nfmx + 3);

    fscanf(f,"%*[^\n]");   fscanf(f,"\n");
    fscanf(f,"%*[^\n]");     fscanf(f,"\n");
        
    for (i = 1; i <= npts; ++i) 
    { if (!fscanf(f,"%lf", &ctqpar1_1.upd[i - 1])) return 0; }
    return 0;
} /* readtbl_ */


double partonx_(int iprtn,double x,double q)
{
    /* System generated locals */
    double ret_val;

    /* Builtin functions */

    /* Local variables */
    static double ftmp;
    static long j0, j1;
    static double df[3];
    static long jl;
    static double fq[3], qg;
    static long jm, ip, jq, iq, ju, jx;
    static double ddf;
    static long jfl;

/*   Given the parton distribution function in the array Upd in */
/*   COMMON / CtqPar1 / , this routine fetches u(fl, x, q) at any value of
 */
/*  x and q using Mth-order polynomial interpolation for x and Ln(Q/Lambda
).*/




/*                                                 Work with Log (Q) */
    qg = log(q / ctqpar1_1.al);
/*                           Find lower end of interval containing X */
    jl = -1;
    ju = ctqpar2_1.nx + 1;
L11:
    if (ju - jl > 1) {
	jm = (ju + jl) / 2;
	if (x > ctqpar1_1.xv[jm]) {
	    jl = jm;
	} else {
	    ju = jm;
	}
	goto L11;
    }
    jx = jl;
    if (x < xqrange_1.xmin)
    {   fprintf(stderr,
       " WARNING: X < Xmin, extrapolation used; X=%f, Xmin =%f\n"
      ,x,xqrange_1.xmin);

	if (jx < 0) {
	    jx = 0;
	}
    } else if (jx > ctqpar2_1.nx - 2) {
	jx = ctqpar2_1.nx - 2;
    }
/*                                    Find the interval where Q lies */
    jl = -1;
    ju = ctqpar2_1.nt + 1;
L12:
    if (ju - jl > 1) {
	jm = (ju + jl) / 2;
	if (qg > ctqpar1_1.ql[jm]) {
	    jl = jm;
	} else {
	    ju = jm;
	}
	goto L12;
    }
    jq = jl;
    if (jq < 0) {
	jq = 0;
	if (q < xqrange_1.qini)
	{  fprintf(stderr,
	   " WARNING: Q < Qini, extrapolation used; Q=%f, Qini =%f\n",
	   q,xqrange_1.qini);
	}
    } else if (jq > ctqpar2_1.nt - 2) {
	jq = ctqpar2_1.nt - 2;
	if (q > xqrange_1.qmax)
	{ fprintf(stderr,
	      " WARNING: Q > Qmax, extrapolation used; Q=%f, Qmax =%f\n",
	    q,xqrange_1.qmax);
	}
    }
    if (iprtn >= 3) {
	ip = -(iprtn);
    } else {
	ip = iprtn;
    }
/*                             Find the off-set in the linear array Upd */
    jfl = ip + ctqpar2_1.nfmx;
    j0 = (jfl * (ctqpar2_1.nt + 1) + jq) * (ctqpar2_1.nx + 1) + jx;

/*                                          Now interpolate in x for M1 Q'
s*/
    for (iq = 1; iq <= 3; ++iq) {
	j1 = j0 + (ctqpar2_1.nx + 1) * (iq - 1) + 1;
	polint_(&ctqpar1_1.xv[jx], &ctqpar1_1.upd[j1 - 1], 3, x, &fq[iq -
		1], &df[iq - 1]);
/* L21: */
    }
/*                                         Finish off by interpolating in
Q*/
    polint_(&ctqpar1_1.ql[jq], fq, 3, qg, &ftmp, &ddf);
    ret_val = ftmp;

    return ret_val;
/*                        **************************** */
} /* partonx_ */

/*
void main(void)
{int i;
 double x;
   FILE *f;
   f=fopen("/home/pukhov/cteq_4/cteq4m.tbl","r");
   if(f)
   {
      readtbl_(f);
      fclose(f);
      for(i=25;i<=25;i++)
      { x=i/50.0;
        printf("%.12f %.12g\n",x,partonx_(1,x,91.188));
      }
   }
}

*/
