/*
 Copyright (C) 1997, Slava Ilyin
*/
#include "out_ext.h"
#include <stdarg.h>
#include"f_c.h"
#include "tptcmac.h"
#include"cut.h"
#include"4_vector.h"
#include"q_kin.h"
#include"regul.h"
#include"runbas.h"
#include"rw_sess.h"
#include"subproc.h"
#include"vegas.h"
#include"strfun.h"
#include"alphas2.h"
#include "crt_util.h"
#include "os.h"
#include "f_c.h"
#include <math.h>
#include "err_code.h"
#include "histogram.h"
#include "rand.h"
#include "n_comphep_.h"

int nSess=1;
double rapidity=0;
mcintr_ mcintr_1 = {10000,5,0};

static  double factor_0;
static double cmMom;
/* Table of constant values */

static int nCall;

/* ****************************************** */
/*  Lorentz rotation to moving C.M. system * */
/* ****************************************** */
static void lorrot_(void)
{
    static double rapid___ = 0.;
    static double sh = 0.;
    static double ch = 1.;

    int i;
    double ee, pp;

    if (rapidity != rapid___) {
	rapid___ = rapidity;
	sh = sinh(rapidity);
	ch = sqrt(sh * sh + 1);
    }
    if (rapidity != 0.) 
    {
	for (i = 1; i <= nin_ + nout_ ; ++i) 
	{
	    ee = pvect[(i << 2) - 4];
	    pp = pvect[(i << 2) - 1];
	    pvect[(i << 2) - 4] = ee * ch + pp * sh;
	    pvect[(i << 2) - 1] = ee * sh + pp * ch;
	}
    }
} 


static void printLn(FILE * iprt,int *line,char * format, ...)
{  
   va_list args;
   char dump[STRSIZ];
   va_start(args, format);
   vsprintf(dump,format,args);
   va_end(args);

   goto_xy(1,*line); clr_eol();
   print("%s\n",dump); 
   (*line)++;
   if (*line >= maxRow()-2 ) *line=12;
   else  print("------------------------------------------------------");   
   if(iprt) { fprintf(iprt,"%s\n",dump); fflush(iprt);}
}

static double func_(double *x, double wgt,long k)
{
    double ret_val;
    int err;

    informline(nCall,mcintr_1.ncall0);
    nCall++;
    ret_val = 0.;
/* * number of the subprocess */
/* ** call kinematics preparation of scalar products */
    mkmom_(x, &factor_0);
           
    if (factor_0 == 0.) goto exi;
   /* ** call for 'running strong coupling constant' */
    alf_();
/* **  structure function  multiplication */
    if (nin_ == 2) 
    { 
	if(sf_num[0]||sf_num[1]) strfunScale=scale_();
	if (sf_num[0])  factor_0 *= strfun_(1, pvect[3]/cmMom);
	if (sf_num[1])  factor_0 *= strfun_(2, -pvect[7]/cmMom);
    }   
    lorrot_();
    factor_0 *= calcCutFactor();
    if (factor_0 == 0.)   goto exi;
        
/* ** squared matrix element */
    err=0;
    ret_val = factor_0 * sqme_(proces_1.nsub,pvect,&err); 
    err_code=err_code|err;
exi:
    fillHists(ret_val*wgt);
    return ret_val;
} /* func_ */

/* static double func2(double *x, double * wgt){return func_(x,*wgt,0);}*/
 
int runbas_(char * message)
{
    vegasGrid * vegPtr;

    /* Local variables */
    long i;
    double sd;
    double avgi;
    int ndim;
    int ierr;
    char mess[25];
    int first = 1;

    int clrstat=TRUE;

    FILE * iprt=NULL;
    int mode;
    void * pscr=NULL;
    int n_Line;

    double ss0=0;
    double ss1=0;
    double ss2=0;
    int    n_it=0;
    int nCallTot;

    if(calcFunc()) 
    {  strcpy(message,"Can not evaluate constraints");
       return 1;
    }

    if(fillCutArray()) 
    {
       strcpy(message,"Can not evaluate cuts limlts");
       return 2;    
    }

    if(fillRegArray()) 
    {
      strcpy(message,"Can not evaluate regularization paremeters");
      return 3;    
    }


    if (nin_ == 2) strcpy(mess, " Cross section [pb] ");
     else 	     strcpy(mess, "  Width     [Gev]   ");
    
/* ** save current session parameters */
    w_sess__(NULL);
/* ** open protocol and resulting files */
    if(!interpret)    
    {  char ch__2[20];
       sprintf(ch__2,"c_prt_%d",nSess);
       iprt= fopen(ch__2,"w");
       fprintf(iprt,"    CompHEP kinematics module \n The session parameters:\n");
       w_sess__(iprt);
       fprintf(iprt,"===================================\n");   
    }

/* **  initkinematics */
    { double be1=0,be2=0;
      if(nin_==2){ initStrFun(1,&be1); initStrFun(2,&be2);}
      ierr=imkmom_(be1,be2, &ndim,&cmMom);
    }
    if (ierr == 1) 
    {  strcpy(message,"Energy is too small!");
       if(iprt)fprintf(iprt,"%s\n",message);
       ++nSess;
       if(iprt)fclose(iprt);
       return (-1); 
    }

    vegPtr=vegini_(ndim,50);

/* *** Main cycle */

#ifdef _WIN32
    scrcolor(White, BGmain);
#else
    scrcolor(Blue, BGmain);
#endif
        
    n_Line=11;
    printLn(iprt,&n_Line," #IT  %20s Error %%    nCall    chi**2",mess); 

    correctHistList();
    clearHists();

    while(TRUE)
    {
        char strmen[]="\030"
         " Start integration      "
         " Itmx   =    N2         "
         " nCall  =    N1         "
         " Clear statistic        "
         " ---------------------  "      
         " Set  Distributions     "
         " Display Distributions  ";

        improveStr(strmen,"N1","%d",mcintr_1.ncall0);
        improveStr(strmen,"N2","%d",mcintr_1.itmx0);

        if(mcintr_1.wrtEvnt) improveStr(strmen,"ON","ON");
                        else improveStr(strmen,"ON","OFF");
        
        nSess++; /* for   case of Quit */        
        menu1(54,7,"",strmen,"n_veg_*",&pscr,&mode);
        nSess--;     
        if (mode == 0)
        {
           clrbox(1,11,80,maxRow());
           if(iprt) {fclose(iprt);iprt=NULL;}
           if(!first && !interpret && mess_y_n(15,20,"Save results ?$"))nSess++; 
           strcpy(message,"");
           return 0;           
        }
        if (mode == 1)
        {  

            if(clrstat) { ss0=0; ss1=0; ss2=0; n_it=0;nCallTot=0;clrstat=0;}     

            for (i = 1; i <= mcintr_1.itmx0; ++i) 
            { 
              nCall=0;
              first=0;
              err_code=0;              
              vegas_(vegPtr, mcintr_1.ncall0 ,1.5,ran2_,  func_, &avgi, &sd);
/*{double CHI2A; vegas1_(&ndim, func2, &avgi, &sd, &CHI2A);} */             
              nCallTot+=nCall;
              scrcolor(FGmain,BGmain);
              printLn(iprt,&n_Line,"%3d    %12.4E     %10.2E %8d ",
                       i, avgi,100*sd/ABS(avgi),nCall);
              if(err_code)
              {  
                 scrcolor(Red,BGmain);
                 printLn(iprt,&n_Line," A pole into the phase space");
                 err_code=0;
              }         
              sd=1/(sd*sd); 
              ss0+=sd;
              ss1+=avgi*sd;
              ss2+=avgi*avgi*sd;
              n_it++;
            }        
            messanykey(45,15,"Integration is over$");

            sprintf(message," < >   %12.4E     %10.2E %8d " ,
                              ss1/ss0, 100*sqrt(ss0)/ABS(ss1), nCallTot); 

            if(n_it>1) 
            {  scrcolor(FGmain,BGmain);
               printLn(iprt,&n_Line," < >   %12.4E     %10.2E %8d     %5.2f " ,
               ss1/ss0, 100*sqrt(ss0)/ABS(ss1), nCallTot,
               (ss2-ss1*ss1/ss0)/(n_it-1));
               sprintf(message+strlen(message),
                              "    %5.2f ",(ss2-ss1*ss1/ss0)/(n_it-1));
            }
        }
        if (mode == 2)  correctInt(50,12,"Enter new value ",&mcintr_1.itmx0,1);
        if (mode == 3)  correctLong(50,12,"Enter new value ",&mcintr_1.ncall0,1);
        
        if (mode == 4)  { clrstat = TRUE; 
                          clearHists();  
                          messanykey(10,13,"Old results for integral $"
                                    "and distributions   are deleted.$"
                                    " Grid information is saved$");
                        }                
        if (mode == 6)  editHist();
        if (mode == 7)  showHist();
    }    
} /* runbas_ */
