/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "out_ext.h"
#include "f_c.h"
#include"decay.h"
#include"cut.h"
#include"kinaux.h"
#include"4_vector.h"
#include<math.h>
#include"rand.h"
#include"strfun.h"
#include"regfunal.h"
#include"subproc.h"
#include"q_kin.h"
#include "const.h"
#include "tools.h"

static int nstep=0;

int isnan_(char *mess, double r)
{
    return 0; /* isnan(r)*/;
} /* isnan_ */

static double  cmfun( double E,double PM1,double PM2)
{
  double e2,s,d;
  e2=E*E;
  s=PM1+PM2;
  d=PM1-PM2;
  return sqrt((e2-s*s)*(e2-d*d))/(2*E);     
}

#define DEPTH 10

static double sqrt_S, ssmin, ssmax, pcm;

static double tfact0;
static    int nout1;
static double  pm[PLISTLEN];

static int nvpos0,nvposx, nvposy;

static int nvout[DEPTH][2], nvin[DEPTH];
static int  lnkbab[DEPTH], lnkleg[DEPTH];
static double  summas[DEPTH][2];
static int nmsreg[DEPTH][2], nmscut[DEPTH][2], nss;	
static int nsph[DEPTH];

static double beta[2];

typedef  struct
{  int ncsreg[2];
   int ncscut[2];
   char  lvpole[PLISTLEN];
   int  itypep;
   double sph_we;
}  sphereStr;
   
static  sphereStr  sph_inf[DEPTH][10]; 


int mkmom_(double *x, double *tfact /* ,  double *sf_fact*/)
{
  int i,k,l;
  int nx=0;
  double  fct0, fct1, fct2;

  double  xcos, cosmin, cosmax, parcos, xfi,  parfi;

  int  i__2;
  double d__1, d__2;

  double ff, al;
  double  xx, yy, bes, fct;

  int  ns;

  double psy1, psy2;

  double  smin, smax, stilda, ss,  rstilda;
  double  amass[DEPTH][2];
 double y1,y2,x1,x2;
  int nvpole;
  int nvpos;

  double hsum[2], hdif;

  double fct_1__;
  int nsing;
  
  sing_struct singar[200];


  *tfact = tfact0;

    for (k = 1; k <= nin_; ++k) vnull4_(k);
    ++nstep;
/* **   MOMENTS */
    if (nin_ == 2) 
    {/*   double y1,y2,x1,x2; */
	if (sf_num[0] || sf_num[1]) 
	{
	    nsing = 0;
	    getreg_(&nsing, singar, 0., 1., nss);
	    bes =  beta[0]+ beta[1];
	    if (bes >= 1.) al = 1.; else if (nsing)  al = 0.5; else al = 0.;
	    
	    ss =  sqrt_S *  sqrt_S;
	    xx = x[nx++];
	    if (xx < al) 
	    {
		xx /= al;
		regfun_(2,nsing,singar,ssmin,ssmax,xx,&stilda,&fct1);
	    } else 
	    {
	       if(xx==al) xx=1; else xx = (1 - xx) / (1 - al);
		stilda=ss-pow(xx*pow(ss-ssmin,bes)+(1-xx)*pow(ss-ssmax,bes),1/bes);
		regfct_(2,nsing,singar,ssmin,ssmax,stilda,&fct1);
	    }
	    fct1 /= ss;
	    if (bes < 1.) 
	    {
		ff = pow(1. - ssmin/ss, bes) - pow(1. - ssmax/ss, bes);
		fct2 = ff / bes * pow( 1 - stilda/ss, 1 - bes);
		*tfact *= ff/ (al * fct2 / fct1 + (1 - al));
	    } else  *tfact *= fct1;
	    
	    yy = log(ss / stilda);
	    if (sf_num[0] && sf_num[1]) 
	    {
		xx = x[nx++];
		if (beta[0] < 1. && beta[1] < 1.) 
		{
		    al = beta[1]/(beta[0]+beta[1]);
		    if (xx < al) 
		    {
			xx /= al;
			psy1 = pow(xx, 1 / beta[0]);
			psy2 = 1 - psy1;
		    } else 
		    {
			if(xx==al) xx=1; else xx = (1 - xx)/(1 - al);
			psy2 = pow(xx, 1 / beta[1]);
			psy1 = 1 - psy2;
		    }
		    y1 = yy * psy1;
		    y2 = yy * psy2;

		    *tfact *=pow(divy_(y1),beta[0]-1)*pow(divy_(y2),beta[1]-1)/
		    	     (pow(psy1,1-beta[0])+pow(psy2,1-beta[1]));

		    if (bes < 1.)  *tfact *= pow( divy_(yy),1-bes);
		     else          *tfact *= bes*pow(yy,bes-1);
		} else if (beta[0] < 1.) 
		{
		    psy1 = pow(xx,  1 / beta[0]);
		    y1 = yy * psy1;
		    y2 = yy * (1 - psy1);
		    *tfact *=  pow(yy, *beta)*pow(divy_(y1),beta[0]-1);
		} else if (beta[1] < 1.) 
		{
		    psy2 = pow(xx,  1 / beta[1]);
		    y2 = yy * psy2;
		    y1 = yy * (1 - psy2);
		    *tfact *= pow(yy,beta[1])*pow(divy_(y2),beta[1]-1);
		} else 
		{
		    y1 = yy * xx;
		    y2 = yy - y1;
		    *tfact *= yy;
		}
		x1 = exp(-y1);
		x2 = exp(-y2);
	    } else if (sf_num[0]) 
	    {
		x1 = stilda / ss;
		x2 = 1.;
	    } else 
	    {
		x1 = 1.;
		x2 = stilda / ss;
	    }
	} else 
	{
	    x1 = 1.;
	    x2 = 1.;
	    stilda = sqrt_S*sqrt_S;
	}
	pvect[3] = pcm * x1;
	pvect[7] = -pcm * x2;
/*  *sf_fact= *tfact/tfact0; */
    }
/* *  FILLING ZERO COMPONENTS FOR in-PARTICLES */
    
    for (k = 0; k < nin_; ++k) 
    {
	 d__1 = pvect[4*k + 3];
	 pvect[(k << 2)] = sqrt(d__1 * d__1 +  pm[k]* pm[k]);
    }
    
    if (nin_ == 1) 
    {
	rstilda = pm[0];
	*tfact /= rstilda * 2;
    } else 
    {
	rstilda = sqrt(stilda);
	d__1 = pm[0] + pm[1];
	d__2 = pm[0] - pm[1];
	*tfact /= sqrt((stilda - d__1 * d__1)*(stilda - d__2 * d__2)) * 2;
    }
/* *    X & Y AXISES */

  
    vnull4_(nvposx); pvect[(nvposx << 2) - 3] = 1.;
    vnull4_(nvposy); pvect[(nvposy << 2) - 2] = 1.;
    
    nvpos = nvpos0;
    nvpole =nvpos++;
    
/* *    MASS INTEGRATION */

    for (i = 0; i < nout1; ++i) 
    {   double sval= i? amass[lnkbab[i]][lnkleg[i]]: rstilda;   

       	for (k = 0; k < 2; ++k) 
	{
	    if (kinmtc_1[i].lvout[k][1]) 
	    { double sqmass,  xx=x[nx++];
	        d__1=  k?  sval - amass[i][0] : sval - summas[i][1];
		         
	        smax = d__1 * d__1;
		
		d__1 = summas[i][k];
		smin = d__1 * d__1;

		if (nmscut[i][k]) rancor_(&smin, &smax,0., 1., nmscut[i][k]);
		
		if (smin >= smax)  {*tfact = 0.; return 0;}
		
		if (nmsreg[i][k] )
		{
		    nsing = 0;
		    getreg_(&nsing, singar, 0., 1.,nmsreg[i][k]);
		    regfun_(2,nsing,singar,smin,smax,xx,&sqmass,&fct);
		} else
		{
		    sqmass = xx * smax + (1 - xx) * smin;
		    fct = smax - smin;
		} 
		amass[i][k] = sqrt(sqmass);
		*tfact *= fct;
	    }
	    else amass[i][k]= summas[i][k];
	}
        if(fabs((amass[i][0]+amass[i][1])/sval-1) <1.E-10) 
        { *tfact = 0.; return 0;}
    }
    
    isnan_(" 80 CONTINUE", *tfact);
    
    lvtonv_(kinmtc_1[0].lvin, nvin[0]); 
    
    for(k=0;k<4;k++) pvect[4*(nvin[0]-1)+ k ] *=-1;     
    
    
    
    for (i = 0; i < nout1; ++i)  /*  MAIN CYCLE */
    {   int ns___=nsph[i]-1;
	if (i == 0 && nin_ == 1)  xcos = ran2_(); else  xcos = x[nx++];
	al = 0.;
	l = 0;
	if (i == 0 || (i == 1 && nin_ == 1)) 
	{
	    xfi = ran2_();
            for(;l<=ns___;l++)
	    {  al +=  sph_inf[i][l].sph_we;
	       if (xcos <= al) ns___ = l;
	    }
	    xcos = (al - xcos) / sph_inf[i][ns___].sph_we;
	} else 
	{
	    xfi = x[nx++];
            for(;l<=ns___;l++)
            {
	       al += sph_inf[i][l].sph_we;
	       if (xfi <= al) ns___ = l;
	    }
	    xfi = (al - xfi) /sph_inf[i][ns___].sph_we;
	}
	lvtonv_( sph_inf[i][ns___].lvpole, nvpole);

	decay0_(nvin[i], amass[i][0], amass[i][1], &fct0);
	isnan_(" ????", fct0);
	decay1_(nvpole, hsum, &hdif);

	cosmin = -1.;
	cosmax = 1.;
	nsing = 0;
	for (k = 0; k < 2; ++k) 
	{
	    d__1 = ((k << 1) - 1) / hdif;
            getreg_(&nsing,singar,hsum[k],d__1,sph_inf[i][ns___].ncsreg[k]);
	    rancor_(&cosmin,&cosmax,hsum[k],d__1,sph_inf[i][ns___].ncscut[k]);
	    if (cosmin >= cosmax) {*tfact = 0.; return 0;}
	}
	regfun_(sph_inf[i][ns___].itypep,nsing,singar,cosmin,cosmax,xcos,&parcos,&fct);
	fct_1__ = sph_inf[i][ns___].sph_we / fct;
	parfi = (xfi * 2 - 1) * M_PI;
	decay3_(nvposy, parcos, parfi, nvout[i][0], nvout[i][1]);

	
	i__2 = nsph[i];
	for (ns = 0; ns < i__2; ++ns)  if (ns != ns___)
	{
	    lvtonv_(sph_inf[i][ns].lvpole, nvpole);
	    decay1_(nvpole, hsum, &hdif);
	    decay2_(nvout[i][1], &parcos);
	    cosmin = -1.;
	    cosmax = 1.;
	    nsing = 0;
	    for (k = 0; k < 2; ++k) 
	    {
		d__1 = ((k << 1) - 1) / hdif;
		getreg_(&nsing,singar,hsum[k],d__1,sph_inf[i][ns].ncsreg[k]);
		rancor_(&cosmin,&cosmax,hsum[k],d__1,sph_inf[i][ns].ncscut[k]);
		if (cosmin>=parcos || parcos>=cosmax){*tfact=0.; return 0;}
	    }
	    regfct_(sph_inf[i][ns].itypep,nsing,singar,cosmin,cosmax,parcos, &fct);
	    fct_1__ += sph_inf[i][ns].sph_we/ fct;
	}
	*tfact = *tfact * fct0 / fct_1__;
    }
    isnan_(" NAN TFACT from MKMOM",*tfact);
    
    return 0;
}    
    

int imkmom_(double be1, double be2,  int *ndim, double *cmMom)
{
    int i, j, k, l;
    double d__1;

    char lvbuf[PLISTLEN];
    int ns;

    beta[0]=be1;
    beta[1]=be2;

    if(nin_==2)  
    {  vinf_(0,NULL,&sqrt_S);
       *ndim = nout_ * 3 - 5;
       if (sf_num[0]) (*ndim)++;
       if (sf_num[1]) (*ndim)++;
       tfact0 = 2*M_PI*389379660.0;
    }else 
    {  if(nout_==2) *ndim=1;else *ndim = nout_ * 3 - 7;
       tfact0 = 2*M_PI;
    }
    
    for (i = 0; i <  nin_ + nout_; ++i) pinf_(proces_1.nsub,i+1,NULL, pm+i);

    nout1 = nout_ - 1;
    if(nout1>DEPTH) return 1;
    nvposx = nin_ + nout_ + 1;
    nvposy = nvposx + 1;
    nvpos0 =  nvposy + 1;

/* *  NVOUT( , ) FILLING */
    for (i = 0; i < nout1; ++i)  for (k = 0; k < 2; ++k) 
    {
       if (kinmtc_1[i].lvout[k][1]) nvout[i][k] = nvpos0++;
       else                         nvout[i][k] = kinmtc_1[i].lvout[k][0];   
    }
    
    nvin[0] = nvpos0++;
    for (i = 1; i < nout1; ++i) 
    {   nvin[i]=0;
	for (j = 0; j < i; ++j) for (k = 0; k < 2; ++k) 
	{
	   if (eqvect_(kinmtc_1[i].lvin, kinmtc_1[j].lvout[k])) 
	   {
               nvin[i] = nvout[j][k];
	       lnkbab[i] = j;
	       lnkleg[i] = k;
	   }
	}
	if(!nvin[i]) { fprintf(stderr,"Error in kinematics \n"); exit(0); }
    }


    for (i = 0; i < nout1; ++i) for (k = 0; k < 2; ++k) 
    {   
      double ss = 0.; int pn;
      
      for(j=0;pn=kinmtc_1[i].lvout[k][j];j++) ss += pm[pn - 1];
       summas[i][k] = ss;
    }

    if (nin_ == 2) 
    {  

     pcm=cmfun(sqrt_S,sf_num[0]?totMass(1):pm[0],sf_num[1]?totMass(2):pm[1]);
     
       *cmMom=pcm;
       if(sf_num[0] && !sf_num[1])
              ssmin = pm[0]*pm[0]+pm[1]*pm[1]+2*pm[0]*sqrt(pm[1]*pm[1]+pcm*pcm);
       else if (sf_num[1] && !sf_num[0])
              ssmin = pm[0]*pm[0]+pm[1]*pm[1]+2*pm[1]*sqrt(pm[0]*pm[0]+pcm*pcm);
       else   ssmin =(pm[0]+pm[1])*(pm[0]+pm[1]);

       d__1 = summas[0][0] + summas[0][1];

       ssmin = MAX(ssmin,d__1*d__1);
       
       sqrt_S=sqrt(pm[0]*pm[0]+pcm*pcm)+sqrt(pm[1]*pm[1]+pcm*pcm);
       ssmax = sqrt_S*sqrt_S;

       if(ssmin>=ssmax)  return 1;
    } else  *cmMom=0;
    
    for (i = 0; i < nout1; ++i) 
    {
	nsph[i] = 0;
	
	for(ns=0; ns<10;ns++) for(k=0;k<2;k++)
        {  
           sph_inf[i][ns].ncsreg[k] = 0;
           sph_inf[i][ns].ncscut[k] = 0;
        }
                                                  	
	
	for (k = 0; k < 2; ++k) 
	{
	    nmsreg[i][k] = 0;
	    nmscut[i][k] = 0;
	}
    }
    
    nss=0;
    for(l=0; invreg_1[l].lvinvr[0]; l++) 
    {  int orig=1, ll=0;
    
       for(;ll<l;ll++) {if( invreg_1[ll].nextrg == l+1) { orig=0; break;}}	
       if (orig) 
       {
	  sngpos_(invreg_1[l].lvinvr, &i, &k, lvbuf);
	  if (i==0)  nss = l+1; else
	  {  i--; k--;
	     if (lvbuf[0] == 0)  nmsreg[i][k] = l+1;
	     else 
	     {
	        for (ns = 0; ns <nsph[i]; ++ns) 
                if (eqvect_(lvbuf,sph_inf[i][ns].lvpole)) 
		{
		  sph_inf[i][ns].ncsreg[k] = l+1;
		  break;
		}
		if(ns==nsph[i] && ns<10)
		{
		  nsph[i]++;
		  strcpy(sph_inf[i][ns].lvpole,lvbuf);
		  if(spole_(invreg_1[l].lvinvr)) sph_inf[i][ns].itypep = -2; 
		  else sph_inf[i][ns].itypep = -1;
		         
	          sph_inf[i][ns].ncsreg[k] = l+1;
	        }
	     }
	  }
       }
    }

    for(l=0;invcut_1[l].key;l++)
    if( invcut_1[l].key == 'S')
    {
	sngpos_(invcut_1[l].lvinvc, &i, &k, lvbuf);
	if (i == 0) 
	{ rancor_(&ssmin, &ssmax, 0., 1., l+1);
	  if(ssmin >=ssmax) {printf("rrr1\n");  return 1;}
	}
	else if (lvbuf[0] == 0)  nmscut[i-1][k-1] = l+1;
	else 
	{   i--; k--;
	    for (ns = 0; ns <  nsph[i ]; ++ns) 
	    {
		if (eqvect_(lvbuf, sph_inf[i][ns].lvpole)) 
		{
		    sph_inf[i][ns].ncscut[k]  = l+1;
		    break;
		}
	    }
	    if(ns==nsph[i] && ns <10 )
	    {
	       nsph[i]++;
	       strcpy(sph_inf[i][ns].lvpole,lvbuf);
	       if(spole_(invcut_1[l].lvinvc))  sph_inf[i][ns].itypep  = 2;
	       else sph_inf[i][ns].itypep = 1;
               sph_inf[i][ns].ncscut[k] = l+1;
	    }
	}
    }

    for (i = 0; i < nout1; ++i) 
    {
	if (nsph[i] == 0) 
	{
	    nsph[i] = 1;
            sph_inf[i][0].lvpole[0] = (i == 0 && nin_ == 1 )?  nvposx:1;
	    sph_inf[i][0].lvpole[1] = 0;
	    sph_inf[i][0].itypep = 1;
	} else 
	{
	    ns = nsph[i]-1;
	    if ( sph_inf[i][ns].ncsreg[0] || sph_inf[i][ns].ncsreg[1])  
	    sph_inf[i][0].itypep *=-1;
	}
    }

    for (i = 0; i < nout1; ++i) 
    {   double wesum = 0.;
	for (ns = 0; ns < nsph[i]; ++ns) 
	{
	    int   nwe = 0;
	    for (k = 0; k < 2; ++k) 
	    for (l = sph_inf[i][ns].ncsreg[k];l;l=invreg_1[l-1].nextrg) ++nwe;
		    
            if (sph_inf[i][ns].itypep >= 0) ++nwe;
	    sph_inf[i][ns].sph_we = nwe;
	    wesum += nwe;
	}
	for (ns = 0; ns <nsph[i]; ++ns)   sph_inf[i][ns].sph_we /= wesum;
    }
#ifdef DEBUG   
    for (i = 0; i < nout1; ++i) 
    {   
        printf("Decay number %d     nmscut= (%d,%d) nmsreg = (%d,%d)\n",
        i, nmscut[i][0], nmscut[i][1],  nmsreg[i][0], nmsreg[i][1]);
        
        {int  l,c;
          printf("kinematics= (");
          for (l=0;c= kinmtc_1[i].lvin[l];l++) printf("%d",c);
          printf(")->(");
          for (l=0;c=kinmtc_1[i].lvout[0][l];l++)  printf("%d",c);
          printf(")+(");
          for (l=0;c=kinmtc_1[i].lvout[1][l];l++)  printf("%d",c);
          printf(")\n");
        }        
        printf(" summas=(%f,%f)\n",summas[i][0],summas[i][1]);

        for (ns = 0; ns < nsph[i]; ++ns) 
	{   int c;
	    printf("   Sphere number = %d  weight=%f type=%d \n", 
	     ns, sph_inf[i][ns].sph_we, sph_inf[i][ns].itypep);
            printf("     pole vector(");
	    for(k=0; c=sph_inf[i][ns].lvpole[k]; k++) printf("%d",c);
            printf(")\n");
	    printf("    ncsreg=(%d,%d) ncscut=(%d,%d) \n",
	    sph_inf[i][ns].ncsreg[0], sph_inf[i][ns].ncsreg[1], 
            sph_inf[i][ns].ncscut[0], sph_inf[i][ns].ncscut[1]); 
	}
    }    
#endif 
    return 0;
} /* mkmom_ */
