/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "tptcmac.h"
#include "os.h"
#include "chep_crt.h"
#include "plot.h"
#include "menu.h"
#include "out_ext.h"
#include "err_code.h"

#include "num_serv.h"


void  paramdependence(r_func  ff, char*  procname, char*  resultname)
{  void *      pscr0 = NULL;
   int         l;
   char        prmname[10];
   int         nprm;
   double      minprm, maxprm;
   int         npoints;
   double      memprm, stepprm;
   unsigned    count;
   double f[200];
   double prmval;   

   l=1;
   nprm=selectParam(55,11,nin_==2,0,"n_param"); 
   if (nprm < 0) return;
   vinf_(nprm,prmname,&memprm);
   minprm = memprm; 
   maxprm = minprm; 
    
label1:

   if (!correctDouble(55,14,"min= ",&minprm,0)) 
   { 
      nprm = 0;
      goto exi;
   } 

label2:
   if (!correctDouble(55,15,"max= ",&maxprm,0)) 
   { 
      goto_xy(55,14);
      clr_eol(); 
      goto label1;
   } 
   if (maxprm <= minprm) 
   { 
      messanykey(55,17,"Range check error$"); 
      goto_xy(55,15);
      clr_eol();
      goto label2;
   } 

label4: npoints = 21;
   if (correctInt(55,16,"Number of points= ",&npoints,0)) 
   { 
      if (npoints < 3) 
      { 
         messanykey(55,17,"Too few points!$"); 
         goto label4;
      } 
      if (npoints > 201) 
      { 
          messanykey(55,17,"Too many points!$"); 
          goto label4;
      } 
   } 
   else
   { 
      goto_xy(55,15);
      clr_eol(); 
      goto label2;
   }

   goto_xy(55,14); clr_eol();
   goto_xy(55,15); clr_eol();
   goto_xy(55,16); clr_eol();

   stepprm = (maxprm - minprm)/(npoints - 1); 

   informline(0,npoints);

   stepprm = (maxprm - minprm) / (npoints - 1); 
   prmval=minprm;
   err_code = 0; 
   for (count = 1; count <= npoints; count++)
   { 
      asgn_(nprm,prmval);
      if(calcFunc()) err_code =5;else   f[count-1] = ff(); 
      if(err_code) { errormessage(); break;} else
      { informline(count,npoints);       
        prmval += stepprm;
      } 
   } 

   if (err_code ==0) 
   { 
      scrcolor(FGmain,BGmain);
      goto_xy(1,23); clr_eol(); 
      plot_0(minprm,maxprm ,npoints,f,NULL,procname,prmname,resultname); 
   } 
   asgn_(nprm,memprm); calcFunc();   
exi:
   put_text(&pscr0);
   goto_xy(1,23);
   scrcolor(FGmain,BGmain);
   clr_eol(); 
} 
