/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"tptcmac.h"
#include"out_ext.h"
#include"strfun.h"
#include"chep_crt.h"
#include"menu.h"
#include"runbas.h"
#include"subproc.h"
/* ################################################### */
/* #            Menu's                               # */
/* #   contents:                                     # */
/* #      IN_SET(2), MDLSET(3), MC_SET(6)            # */
/* #      BATCH(8), VIEWF(9), EVNMEN(11)             # */
/* ################################################### */
/* ******************************************** */
/*    IN states menu                         * */
/* ******************************************** */


static void f7_prog(int mode)
{ int pos=1;
  double be;
  void *pscr=NULL;
  if(mode>2) 
  { messanykey(10,15," Highlight the corresponding$"
                                  "structure function$");
    return;
  }     

  initStrFun(mode,&be); 
  if(!sf_num[mode-1]) return;
  
  f3_key[4]=NULL;

  while(1)
  {  static double xMin=0.0, xMax=1.0, scale = 10;
     static int nPoints=100;
     double f[150];
     
     char strmen[]="\030 "
                  " x-Min = XXX            "
                  " x-Max = YYY            "
                  " Npoints = NNN          "
                  " QCD-scale= QQQ         "
                  " Display plot           ";
     
     improveStr(strmen,"XXX","%.3f",xMin);
     improveStr(strmen,"YYY","%.3f",xMax);
     improveStr(strmen,"NNN","%d",nPoints);
     improveStr(strmen,"QQQ","%.1fGeV",scale); 

     menu1(54,14,"",strmen,"n_alpha_view",&pscr,&pos);

     switch(pos)
     {  case 0: f3_key[4]=f7_prog; 
                return;
        case 1:
          correctDouble(55,18,"xMin = ",&xMin,1);                  
          break; 
        case 2:
          correctDouble(55,18,"xMax = ",&xMax,1);                  
          break; 
        case 3:
          correctInt(50,18,"nPoints = ",&nPoints,1);
          break; 
        case 4: 
          correctDouble(50,18,"QCD-scale = ",&scale,1);
          break;
        case 5:
         if(xMin>=0 && xMax>xMin && xMax<=1 
            && nPoints>=3 && nPoints<=150 && scale>0.5)
         {
           void * screen;
           double dx=(xMax-xMin)/(2*nPoints);
           int i;
           get_text(1,1,maxCol(),maxRow(),&screen);
           strfunScale=scale; 
           for(i=0;i<nPoints;i++)
           {  double x=xMin+(i+0.5)*(xMax-xMin)/nPoints;
              f[i]=strfun_(mode,x)*pow(1-x,be-1.);
           }
           
           {
              char p_name[10], mess[STRSIZ];
              pinf_(proces_1.nsub,mode,p_name,NULL);
              trim(p_name);
              strcat(p_name,"(x)");
              strFunName(mode,mess);
              trim(mess);
              sprintf(mess+strlen(mess)," [QCD-scale = %.1f GeV]",strfunScale); 
              plot_0(xMin+dx,xMax-dx,nPoints,f,NULL,mess,"x",p_name);  
           }
           put_text(&screen);
         } else messanykey(16,5," Correct input is $"
                                "  0<=xMin<xMax<=1,$"
                                " QCD-scale > 0.5 GeV$"
                                " 3<=nPoints<=150$");    
         break;    
      }
   }
}


void  in_set__(void)
{
  int mode=1;
  void * pscr=NULL;    
  double sqrt_S; 
  void (*f7_tmp)(int)=f3_key[4];
  char * f7_mess_tmp= f3_mess[4];
  char sf_txt[STRSIZ];
  double e1,e2,p1,p2,mass1,mass2;

  vinf_(0,NULL,&sqrt_S);

  if(sf_num[0]) mass1=totMass(1);else pinf_(proces_1.nsub,1,NULL,&mass1);
  if(sf_num[1]) mass2=totMass(2);else pinf_(proces_1.nsub,1,NULL,&mass2);

  e1=(sqrt_S*sqrt_S + mass1*mass1 - mass2*mass2)/(2*sqrt_S);
  e2=(sqrt_S*sqrt_S + mass2*mass2 - mass1*mass1)/(2*sqrt_S);
  p1=sqrt(e1*e1-mass1*mass1);
  p2=sqrt(e2*e2-mass2*mass2);
  p1=p1*cosh(rapidity)+e1*sinh(rapidity);
  p2=p2*cosh(rapidity)-e2*sinh(rapidity);  

  if(p1*p1<(10.E-10)*sqrt_S) p1=0;
  if(p2*p2<(10.E-10)*sqrt_S) p2=0;
  
  
/* **   menu loop */

  while(1)
  {    
    char strmen[] = "*"
    " S.F.1: First_structure_function                "                       
    " S.F.2: Second_structure_function               "
    " First  particle momentum[GeV] = PPP1           "
    " Second particle momentum[GeV] = PPP2           ";        
    vinf_(0,NULL,&sqrt_S);
      
    strmen[0]=strlen(strmen)/4;           
      
    strFunName(1,sf_txt); improveStr(strmen,"First","%-40.40s", sf_txt);
    strFunName(2,sf_txt); improveStr(strmen,"Second","%-40.40s",sf_txt);


    improveStr(strmen,"PPP1","%-10.4G",p1);
    improveStr(strmen,"PPP2","%-10.4G",p2);


    f3_key[4]=f7_prog;   f3_mess[4]="Plot";
    menu1(30,7,"",strmen,"n_in_*",&pscr,&mode);
    f3_key[4]= f7_tmp;  f3_mess[4]=f7_mess_tmp;
   

    switch(mode)
    { case 0: 
         if(sf_num[0]) mass1=totMass(1);else pinf_(proces_1.nsub,1,NULL,&mass1);
         if(sf_num[1]) mass2=totMass(2);else pinf_(proces_1.nsub,1,NULL,&mass2);
    
         if(mass1==0 && p1<=0.) messanykey(10,10,"Mass of the first particle$"
                                                      "must be positive$");
         else if(mass2==0 && p2<=0.) messanykey(10,10,"Mass of the second particle$"
                                                      "must be positive$");
                                                      
         else 
         {  
           e1=sqrt(p1*p1+mass1*mass1);
           e2=sqrt(p2*p2+mass2*mass2);
           sqrt_S=sqrt((e1+e2)*(e1+e2)-(p1-p2)*(p1-p2));
           asgn_(0,sqrt_S);
           rapidity=atanh((p1-p2)/(e1+e2));
           return;
         }
         break;
      case 1:
      case 2: sf_menu__(mode); break;
      case 3: correctDouble(50,12,"Enter new value ",&p1,1); break;
      case 4: correctDouble(50,12,"Enter new value ",&p2,1); break;
    }
  }
  
} /* in_set__ */


/* ************************************************* */
/* Physics model parameters menu                     */
/* ************************************************* */
static void param_menu(int sqtrS_on, int func_on, char ** strmen)
{
    int k;
    double val;
    char name[10];

     int pos;
     
     int npos;
/* **  menu loop */

    npos=nvar_;
    if(func_on)  npos +=nfunc_;    

    *strmen=malloc(24*(npos+1)+2);
    (*strmen)[0]='\030';
    
    pos=1;    
    for (k = !sqtrS_on; k <= npos; ++k)
    {  char c=' ';
       vinf_(k, name, &val);
       if(k>nvar_) c='*';
       sprintf((*strmen)+pos,"%c%7s= %-14.5lg",c,name,val); pos+=24;
    }
    (*strmen)[pos]=0;    
}


int selectParam(int x, int y, int sqtrS_on, int func_on,char * help)
{
    int mode;
    char* strmen;
    void * pscr=NULL;
    
/* **  menu loop */

    mode=1;
    param_menu( sqtrS_on, func_on, &strmen);
    menu1(x,y,"",strmen,help,&pscr,&mode);
    free(strmen);
    put_text(&pscr);

    if (mode == 0) return -1;
    if (sqtrS_on) mode--;
    if (mode>nvar_) 
    {  messanykey(x-10,y+3," This parameter is $"
                           "a functuon of above$"
                           "parameters$");
       mode=-1; 
    }                                                                              
    return mode; 
} 

int change_parameter(int x,int y)
{ 
 double val;
 char name[20];
 int first=1; 
 int m;

 do
 { if(!first)messanykey(15,15," Wrong parameters$ Can not evaluate constraints$");  
   do 
   {  m=selectParam(x,y,0,1,"n_data");
      if(m>=0) 
      { vinf_(m, name, &val);
         strcat(name," = ");
         if(correctDouble(x,y+1,name,&val,1)) asgn_(m,val); else if(first) return 0;
      }   
      first=0;
   } while(m>=0);    
 } while(calcFunc());
 return 1;
} 
