/*
 Copyright (C) 1997, Alexander Pukhov, e-mail: pukhov@theory.npi.msu.su
*/
#include"tptcmac.h"
#include"syst.h"
#include"histogram.h"
#include"crt_util.h"
#include"edittab.h"
#include"syst.h"
#include"read_func.h"
#include"rd_num.h"
#include"out_ext.h"
#include"plot.h"
#include"subproc.h" 
#include"phys_val.h"


table histTab={"*** Table ***","Distributions",
                   "  Parameter  |> Min bound <|> Max bound <|",NULL};
                   
typedef  struct  histRec 
{   struct histRec * next;
    linelist  mother;
    long  nPoints;
    char key;               
    char plist[10];
    double hMin,hMax;
    double f[300];
    double ff[300];   
} histRec;

static histRec * histPtr=NULL;

void clearHists(void)
{ histRec * hists=histPtr;
  int i;
  while(hists)
  {
    for(i=0;i<300;i++){hists->f[i]=0;hists->ff[i]=0;}
    hists->nPoints=0; 
    hists=hists->next;
  }
}



void  fillHists(double w)
{ histRec * hists=histPtr;
  int i;
  double z;   
  while(hists)
  { 
    z=calcPhysVal(hists->key,hists->plist);
           
    if( z>hists->hMin && z<hists->hMax) 
    {     
      i=300*(z-hists->hMin)/(hists->hMax-hists->hMin);    
      hists->f[i]+=w;
      hists->ff[i]+=w*w;    
    }
    hists->nPoints++; 
    hists=hists->next;
  }
}


int correctHistList(void)
{ 
   linelist ln=histTab.strings;
   int lineNum=0;
   int i;
   char keyChar;
   double rMin, rMax;
   char  histStr[STRSIZ], minStr[STRSIZ], maxStr[STRSIZ];
   char fieldName[50];    
   histRec * hptr = histPtr;
   while( hptr != NULL) { hptr->mother=NULL; hptr=hptr->next;}

   while (ln != NULL)
   {
      char lv[10]={0,0,0,0,0,0,0,0,0,0};
      histStr[0]=0;
      minStr[0]=0;
      histStr[0]=0;
      sscanf(ln->line,"%[^|]%*c%[^|]%*c%[^\n]%*c",histStr,minStr,maxStr);            
      lineNum++;
      trim(minStr);
      trim(histStr);
      trim(maxStr);
/*================ MIN bound ============*/
      strcpy(fieldName,"Wrong field 'Min. bound'");
      if (!minStr[0]|| calcExpression(minStr,rd_num,&rMin ))  goto errorExit;
/*================== MAX bound ==========*/
      strcpy(fieldName,"Wrong field 'Max bound'");
      if(!maxStr[0] ||calcExpression(maxStr,rd_num,&rMax ))  goto errorExit;
      if(rMin>rMax){ double tmp=rMin; rMin=rMax; rMax=tmp;}
/*============ Parameter ===========*/
      strcpy(fieldName,"Wrong field 'Parameter'");
      if(! checkPhysVal(histStr, &keyChar,lv)) goto errorExit;

      hptr = histPtr;
      while(hptr != NULL)
      { if ( (hptr->key==keyChar)&&(hptr->hMin==rMin)&&(hptr->hMax==rMax)
           &&(!strcmp(lv,hptr->plist) ) ) 
         {  if(hptr->mother) 
            {    strcpy(fieldName," Duplicate record");
                 goto errorExit;
            } else 
            {  hptr->mother=ln;
               goto cont;
            }
         } else hptr=hptr->next;
      }
      hptr=malloc(sizeof(histRec));
      hptr->next=histPtr;
      hptr->mother=ln;
      histPtr=hptr;
      hptr->key=keyChar;
      strcpy(hptr->plist,lv);
      hptr->hMin=rMin; 
      hptr->hMax=rMax;
      for(i=0;i<300;i++) {hptr->f[i]=0;hptr->ff[i]=0;}
      hptr->nPoints=0;
      cont: 
      ln=ln->next;
   }
      
   hptr = histPtr; 
   histPtr=NULL;  
   while(hptr != NULL) 
   { histRec *  hptr_=hptr;
     hptr=hptr->next;
     if(!hptr_->mother) free(hptr_); else {hptr_->next=histPtr; histPtr=hptr_;}                 
   }
   return 0;
   errorExit:
      sprintf(errorText," Error in  line %d .$"
                         "%s.$",lineNum,fieldName);
      messanykey(2,10,errorText);
      return 1;
}


void wrt_hist(FILE *nchan){ writetable0(&histTab,nchan); }
void rdr_hist(FILE *nchan){ readtable0(&histTab,nchan);}

  

static int nBinMenu(void)
{                   

static int kBinMenu=3;
char   strmen[] =
   "\015"
   " 300         "
   " 150         "
   " 100         "
   "  75         "
   "  60         "
   "  50         "
   "  30         " 
   "  25         "
   "  20         "
   "  15         "
   "  12         "
   "  10         "
   "  6          "
   "  5          "
   "  4          "
   "  3          "
   "  2          ";

   void * pscr=NULL;
   
   int n;
   if(!kBinMenu) kBinMenu=3;
   while(1)
   {                
      menu1(54,14,"number of bins",strmen,"",&pscr,&kBinMenu);
      if (kBinMenu)
      {
        sscanf(strmen+1+strmen[0]*(kBinMenu-1),"%d",&n);
        put_text(&pscr);
        return n;
      }
      return 0;
   }
}


void showHist(void)
{
   char  histStr[STRSIZ];
   linelist ln=histTab.strings;
   char * menutxt;
   void * pscr=NULL;
   int mode =0;
   
   int npos=0;
   int width;

   while(ln)
   {  npos++;
      ln=ln->next;     
   }
   if(!npos) return; 

   sscanf(histTab.format,"%[^|]",histStr);
   width=strlen(histStr);
   menutxt=malloc(2+width*npos);
   menutxt[0]=width;
   menutxt[1]=0;
   
   ln=histTab.strings;
   while(ln)
   {  
      sscanf(ln->line,"%[^|]",histStr);
      strcat(menutxt,histStr);
      ln=ln->next;
   }
   while(1)
   {  
      menu1(54,10,"",menutxt,"",&pscr,&mode);

      switch(mode)
      {
      case 0: free(menutxt);return;
      default: 
      {  histRec * hist=histPtr;
         ln=histTab.strings;
         for(npos=1;npos<mode;npos++) ln=ln->next; 
         while(hist!=NULL)
         {  
            if(hist->mother==ln)
            {  char xname[80],yname[80],units[80];
               
               if( hist->nPoints == 0) messanykey(10,10,"Distibution is empty$");
               else
               {  double f[300],df[300],coeff; 
                  int i;
                  int nBin;
                  nBin=nBinMenu();                  
                  if(!nBin) {  free(menutxt);return;}                                    
                  coeff=nBin/(hist->nPoints*(hist->hMax - hist->hMin));
                  for(i=0;i<nBin;i++) 
                  {  int k; 
                     f[i]=0;
                     df[i]=0;
                     for(k=0;k<300/nBin;k++)
                     {  f[i] += coeff*hist->f[i*300/nBin+k];
                       df[i] += coeff*coeff*hist->ff[i*300/nBin+k];
                     }  
                    df[i]=sqrt(df[i] - f[i]*f[i]/hist->nPoints);                  
                  }
                  
                 if(nin_==2) strcpy(yname,"Diff. cross section [pb");
                  else       strcpy(yname,"Diff. width [GeV");
                  xName(hist->key,hist->plist,xname,units);
                  if(units[0]) { strcat(yname,"/");strcat(yname,units);}
                  strcat(yname,"]");   
                                    
                  plot_0(hist->hMin,hist->hMax,nBin,f,df,proces_1.proces,
                                                                  xname,yname); 
               }
            }              
            hist=hist->next;          
         }
      }       
      }
   }
}

void editHist(void) {do  edittable(1,4,&histTab,1,"n_distrib",0); while(correctHistList());} 


void writeDistributions(FILE*iprt)
{
/* histRec * hists=histPtr;
  int i;
  linelist rec;
  
  
  writetable0(&histTab,iprt);

  rec=histTab.strings;

  while (rec)
  {
     hists=histPtr;
              
     while(hists)
     {  
        if(hists->mother == rec )
        {
            fprintf(iprt,"distribution\n");
     
            for(i=0;i<300;i++) fprintf(iprt,"%f  %f \n", hists->f[i],hists->ff[i]); 
        }
        hists=hists->next;
     }
     rec=rec->next;
  }
*/  
}

