/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "f_c.h"
#include "math.h"

long pow_ll(long ap, long bp)
{
        long pow, x, n;
        unsigned long u;

        x = ap;
        n = bp;

        if (n <= 0) {
                if (n == 0 || x == 1)
                        return 1;
                if (x != -1)
                        return x == 0 ? 1/x : 0;
                n = -n;
                }
        u = n;
        for(pow = 1; ; )
                {
                if(u & 01)
                        pow *= x;
                if(u >>= 1)
                        x *= x;
                else
                        break;
                }
        return(pow);
        }

double pow_dl(double ap, long bp)
{
double pow, x;
long n;
unsigned long u;

pow = 1;
x = ap;
n = bp;

if(n != 0)
        {
        if(n < 0)
                {
                n = -n;
                x = 1/x;
                }
        for(u = n; ; )
                {
                if(u & 01)
                        pow *= x;
                if(u >>= 1)
                        x *= x;
                else
                        break;
                }
        }
return(pow);
}

double d_int(double x)
{
return( (x>0) ? floor(x) : -floor(- x) );
}

long i_sign(long a, long b)
{
long x;
x = (a >= 0 ? a : - a);
return( b >= 0 ? x : -x);
}

