/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"4_vector.h"
#include<math.h>
#include"decay.h"

static int decay0_0_(int n__, int nvin, double *amm1, 
	double *amm2, double *factor, int nvpole, double *
	hsum, double *hdif, int nvout1, double *parcos, int
	nvath, double *parfi, int nvout2)
{
    /* Initialized data */

    static int first = 1;

    /* System generated locals */
    double d__1, d__2, d__3, d__4;


    /* Local variables */
    static long i;
    static double a0, a1, a2;
    static long n0, n1;
    static double p0, p1;
    static long n2, n3;
    static double v0, aa, pa, va, oo, po, pp, vo, vp, vv, e2a, am1, am2, 
	    e1p, e2p, e0v, e1v, e2v;
    static double c_pi__, cath, cinp, ceps, cpol, cinv, pout, e1out, 
	    e2out;
    static double cosfi, sinfi, parsin;

    /* Parameter adjustments */
    if (hsum) {
	--hsum;
	}

    /* Function Body */
    switch(n__) {
	case 1: goto L_decay1;
	case 2: goto L_decay2;
	case 3: goto L_decay3;
	}

    if (first) {
/* Computing 2nd power */
	d__1 = asin(1.) * 4;
	c_pi__ = d__1 * d__1 * 4;
	first = 0;
    }
    am1 = *amm1;
    am2 = *amm2;
    n0 = nvin;
    vv = vdot4_(nvin, nvin);
    v0 = sqrt(vv);
    e0v = 1 / v0;

/* Computing 2nd power */
    d__2 = am1 + am2;
/* Computing 2nd power */
    d__3 = v0;
/* Computing 2nd power */
    d__4 = am1 - am2;
    pout = sqrt((v0 * v0 - d__2 * d__2) * (v0 * v0 - d__4 * d__4)) / (
	    v0 * 2);
/* Computing 2nd power */
    d__1 = am1;
/* Computing 2nd power */
    d__2 = pout;
    e1out = sqrt(d__1 * d__1 + d__2 * d__2);
/* Computing 2nd power */
    d__1 = am2;
/* Computing 2nd power */
    d__2 = pout;
    e2out = sqrt(d__1 * d__1 + d__2 * d__2);
    *factor = pout / (c_pi__ * (e1out + e2out));
    return 0;

L_decay1:
    n1 = nvpole;
    vp = vdot4_(n0, nvpole);
    pp = vdot4_(nvpole, nvpole);
    p0 = e0v * vp;
/* Computing 2nd power */
    d__1 = p0;
    p1 = sqrt(d__1 * d__1 - pp);
    *hdif = p1 * 2 * pout;

/* Computing 2nd power */
    d__1 = am1;
    hsum[1] = pp + d__1 * d__1 + p0 * 2 * e1out;
/* Computing 2nd power */
    d__1 = am2;
    hsum[2] = pp + d__1 * d__1 + p0 * 2 * e2out;
    return 0;

L_decay2:
    oo = vdot4_(nvout1, nvout1);
    vo = vdot4_(n0, nvout1);
    po = vdot4_(n1, nvout1);
/* Computing 2nd power */
    d__1 = vp;
/* Computing 2nd power */
    d__2 = vo;
    *parcos = (po * vv - vp * vo) / sqrt((pp * vv - d__1 * d__1) * (oo * vv - 
	    d__2 * d__2));
    return 0;

L_decay3:
/* *   v = NVIN; p = NVPOLE; a = NVATH; */
/* *  scalar products: */
    va = vdot4_(n0, nvath);
    pa = vdot4_(n1, nvath);
    aa = vdot4_(nvath, nvath);
/* * bases: e0..e3 : v=V0*e0  ;  p=P0*e0 + P1*e1; a =A0*e0 + A1*e1 + A2*e2
 */
/* *                 e0=E0V*v ; e1=E1V*v + E1P*p; e2=E2V*v + E2P*p + E2A*a
 */
/* *   out1= E1OUT*e0 + POUT*( PARCOS*e1 + PARSIN*(e2*COSFI+ e3*SINFI)) */
/* *       = E1OUT*E0V*v + POUT*( PARCOS*(E1V*v + E1P*p ) */
/* *       + PARSIN*(COSFI*(E2V*v + E2P*p + E2A*a )  + SINFI*e3 )) */
/* *       =(E1OUT*E0V + POUT*( PARCOS*E1V +PARSIN*COSFI*E2V))*v */
/* *       +POUT*(PARCOS*E1P+PARSIN*COSFI*E2P)*p */
/* *       +POUT*PARSIN*COSFI*E2A*a */
/* *       +POUT*PARSIN*SINFI*e3 */
    e1p = 1 / p1;
    e1v = -e1p * p0 * e0v;
    a0 = e0v * va;
    a1 = -(e1v * va + e1p * pa);
/* Computing 2nd power */
    d__1 = a0;
/* Computing 2nd power */
    d__2 = a1;
    a2 = sqrt(d__1 * d__1 - d__2 * d__2 - aa);
    e2a = 1 / a2;
    e2p = -e2a * a1 * e1p;
    e2v = -e2a * (a0 * e0v + a1 * e1v);
/* **** out state ***** */
    if(*parcos>=1) {*parcos=1; parsin=0;} 
    else if(*parcos<=-1){*parcos=-1;parsin=0;}
    else   parsin = sqrt((1 - *parcos) * (*parcos + 1));
    
    sinfi = sin(*parfi);
    cosfi = cos(*parfi);
    n3 = nvout1;
    n2 = nvath;
    eps4_(n0, n1, n2, n3);
    cinv = e1out * e0v;
    cinp = pout * (*parcos * e1v + parsin * cosfi * e2v);
    cpol = pout * (*parcos * e1p + parsin * cosfi * e2p);
    cath = pout * parsin * cosfi * e2a;
    ceps = pout * parsin * sinfi / sqrt(-vdot4_(n3, n3));
    for (i = 0; i <= 3; ++i) {
/* L10: */
	pvect[i + (n3 << 2) - 4] = cinp * pvect[i + (n0 << 2) - 4] + 
		cpol * pvect[i + (n1 << 2) - 4] + cath * pvect[i + (
		n2 << 2) - 4] + ceps * pvect[i + (n3 << 2) - 4];
    }
    for (i = 0; i <= 3; ++i) {
	pvect[i + (nvout2 << 2) - 4] = e2out * e0v * pvect[i + (n0 <<
		 2) - 4] - pvect[i + (n3 << 2) - 4];
/* L20: */
	pvect[i + (nvout1 << 2) - 4] = e1out * e0v * pvect[i + (n0 <<
		 2) - 4] + pvect[i + (n3 << 2) - 4];
    }
    return 0;
} /* decay0_ */

/* Subroutine */int decay0_(int nvin, double amm1, double amm2, double *factor)
{
    return decay0_0_(0, nvin, &amm1, &amm2, factor, 0, (double *)
	    0, (double *)0, 0, (double *)0, 0, (
	    double *)0, 0);
    }

/* Subroutine */ int decay1_(int nvpole, double *hsum, double *hdif)
{
    return decay0_0_(1, 0, (double *)0, (double *)0, (
	    double *)0, nvpole, hsum, hdif, 0, (double *)0,
	     0, (double *)0, 0);
    }

/* Subroutine */ int decay2_(int nvout1, double *parcos)
{
    return decay0_0_(2, 0, (double *)0, (double *)0, (
	    double *)0, 0, (double *)0, (double *)0, 
	    nvout1, parcos, 0, (double *)0, 0);
    }

/* Subroutine */ int decay3_(int nvath, double parcos, double parfi, 
                int nvout1, int nvout2)
{
    return decay0_0_(3, 0, (double *)0, (double *)0, (
	    double *)0, 0, (double *)0, (double *)0, 
	    nvout1, &parcos, nvath, &parfi, nvout2);
    }

