/*
 Copyright (C) 1997, Slava Ilyin
*/
#include"syst.h"
#include"f_c.h"
#include"out_ext.h"  
#include"alphas2.h"
#include"crt_util.h"
#include"plot.h"
#include"4_vector.h"
#include"kinaux.h"
#include "const.h"

static double b0[7],b1[7],b2[7];

static double qcdL6=0.1185;

static   struct {
                   double rval;
                   char list[10];
                }  scale_str;


/* *************************************************** */
/*  Transformation of Lambda_QCD from NF to NF-1    * */
/*     (formula from PDG-94)                        * */
/* *************************************************** */

static double tonf_1__(double qcdl, double xmq, int nf)
{
    double rl, b10n, b10n1;

    rl = log(xmq / qcdl);

    b10n = b1[nf] / b0[nf];
    b10n1 = b1[nf-1] / b0[nf-1];

    return qcdl * exp( -1 / b0[nf-1] * 
    (
 
       (b0[nf]- b0[nf-1]) * rl 
	+ (b10n-b10n1) * log(rl * 2.)
	-b10n1 *log(b0[nf]/b0[nf-1]) + 
	 (  
	    b10n * (b10n- b10n1) * log(rl * 2.) 
	    
	    + b10n*b10n - b10n1*b10n1
	    - 0.5*b2[nf]/b0[nf]  + 0.5*b2[nf-1]/b0[nf-1]
	    -7./18.
	 )/(b0[nf] * rl)
    )
	                 );
} /* tonf_1__ */


static double alphas2_(double dscale)
{

    static int first = 1;
    static double qcdlf[7] = { 0.,0.,0.,0.,0.,0.,0.};

    /* System generated locals */
    double  d__2, d__4;

    /* Local variables */
    double b0_, b1_, b2_;
    int nf;
    double rl;


#define  XMB 4.3
#define  XMC 1.3
#define  XMTOP 175.
    if(first)
    {
       for (nf = 0; nf <= 6; ++nf) 
       {  
          b0[nf] = 11.   - (2./3.)   *nf;
          b1[nf] = 51.   - (19./3.)  *nf;
          b2[nf] = 2857. - (5033./9.)*nf + (325./27.) *nf*nf;
       }
       first=0;
    }

    if (qcdL6 != qcdlf[6]) 
    {
	qcdlf[6] = qcdL6;
	qcdlf[5] = tonf_1__(qcdlf[6], XMTOP, 6);
        qcdlf[4] = tonf_1__(qcdlf[5], XMB, 5);
	qcdlf[3] = tonf_1__(qcdlf[4], XMC, 4);
	first = FALSE;
    }

    if (dscale > XMTOP) nf = 6; else 
    if (dscale > XMB)   nf = 5; else 
    if (dscale > XMC)   nf = 4; else  nf = 3;


    b0_ = b0[nf];
    b1_ = b1[nf];
    b2_ = b2[nf];

/* printf("nf=%d, lambda=%f\n",nf,qcdlf[nf]); */
    rl = 2*log(dscale / qcdlf[nf]);

    d__4 = log(rl) - .5;
    d__2= 2*b1_/(b0_*b0_*rl);

    return    4*M_PI / (b0_ * rl) * 
    (   1 
      - 2*b1_*log(rl)  / (b0_*b0_*rl)  
      + d__2*d__2 *(d__4*d__4 + b2_*b0_ /(8*b1_*b1_) - 1.25)
    );

} /* alphas2_ */


/****************************************************************************
*/
/* Flavour number matching inALPHAS2: */

/*        NF              5        6        4        3       2 */
/*    Lambda_QCD (GeV)    0.135    0.0683   0.1985   0.2408  0.2293 */
/*                        0.200    0.1052   0.28275  0.33078 failed */

/*   Comment: for NF=2 and Lambda_QCD(5)=QCDLF(5)=0.2GeV matching is failed*/
/* because of the term with LOG(LOG(Ms/QCDLF(3))) where Ms<QCDLF(3). */
/****************************************************************************
*/
int qcdmen_(void)
{
    /* System generated locals */
    int i__1;

    int n, ll;
    char chtmp[25]="";
    void * pscr=NULL;
    char messln[80];
 
   int mode;
L10:
    {
      char strmen[]="\032"
      " QCD Lambda6= XXX         "           
      " Q^2 = YYY                "
      " Alpha(S) plot            ";
      
      improveStr(strmen,"XXX","%-.3lgGeV",qcdL6);
      if (scale_str.list[0] == 0)
      { 
        improveStr(strmen,"YYY","(%.4lgGeV)**2", scale_str.rval); 
        sprintf(messln,"alpha=%.4f",alphas2_(scale_str.rval)); 
      }
      else
      {
         int pos=2;
         char * sub;
         sub=strstr(strmen,"YYY");
         strcpy(messln,"");
  
         memcpy(sub,"|(",2);
         n = 1;
L21:
	 i__1 = scale_str.list[n - 1];
         if (i__1 <= nin_ ) sprintf(sub+pos,"-p%d",i__1 );
                  else sprintf(sub+pos,"+p%d", i__1 );                               
          pos+=3;
	 ++n;
	 if (scale_str.list[n - 1] != 0) {
	    goto L21;
	 }
	 memcpy(sub+pos,")^2|",4);
      }
            
      
          
      menu1(52,8,messln,strmen,"n_alpha",&pscr,&mode);
    }
    switch (mode) 
    { case 0: return 0;
      case 1:
         goto_xy(50,12);correctDouble(3,15,"Enter new value ",&qcdL6,1);
          break;
      case 2 :      
	if (mess_y_n(40,10,"Press Y to have a running scale $"
	"Press N to have a constant scale$" ))
	{
L22:	   for (ll = 1; ll <= 10; ++ll) scale_str.list[ll - 1] = 0;	    
	   goto_xy(45,12);print("Enter new invariant :");
	   {  int npos=1;
	      int kk=0; 
	      str_redact(chtmp,npos,25);
	      trim(chtmp);	      	        	    
	      for (ll = 0; ll <= strlen(chtmp); ++ll)
	      if (isdigit(chtmp[ll])) 
	      { 
	         scale_str.list[kk]=chtmp[ll]-'0';
	         kk++;
	      }
	   }
	   goto_xy(45,12); clr_eol();
	   coninv_(scale_str.list);   	   	   
	   if (scale_str.list[0] == 0) {
	      messanykey (50,10," Input error $");
	      goto L22;
	    }			
	} else
	{     
            goto_xy(45,12);
            correctDouble(3,15,"Enter QCD scale in GeV ",&scale_str.rval,1);
            goto_xy(45,12);clr_eol();	                   
	    scale_str.rval = ABS(scale_str.rval);
	    scale_str.list[0] = 0;
	}
	break;
	case 3:
	{ void * screen;
	  int i;
	  double f[150];

	  static double qMin=1, qMax=1000;
	  static int nPoints=100;
	  
	  get_text(1,1,maxCol(),maxRow(),&screen);

          if(correctDouble(40 ,15 ,"S_min=",&qMin,0)&& qMin>=0.5  
          && correctDouble(40 ,16 ,"S_max=",&qMax,0)&& qMax>qMin
          && correctInt(33,17,"number of points=" ,&nPoints,0)
          && nPoints>3&& nPoints<=150)
	  {
	  for(i=0;i<nPoints;i++) f[i]=alphas2_(qMin+i*(qMax-qMin)/(nPoints-1)); 
	  plot_0(qMin,qMax,nPoints,f,NULL, " ", "S [GeV]", "Alpha(S)");
	  } else  messanykey(40,18,
	          " Correct input is $"
	          " 0.5<= S_min <S_max$"
	          " number of points <=150$");                                                 
	  put_text(&screen);
	}
	
    } 
    goto L10;
} /* qcdmen_ */

int w_qcd__(FILE * mode)
{
 int i;
 fprintf(mode,"========  QCD  parameters ===========\n");
 fprintf(mode,"%f - lambda QCD\n",qcdL6);
 fprintf(mode,"%f   Q**2 (value)\n",scale_str.rval);
 for(i=0;i<10;i++) fprintf(mode,"%d ",scale_str.list[i]);
                   fprintf(mode," - Q**2 - vector\n"); 
 return 0;
}

 void i_qcd(void) 
 {
  scale_str.rval=91.187;
  scale_str.list[0]=0;
 }
 
 
 int r_qcd__(FILE *mode)
{
 int i,m;
 fscanf(mode,"%*c%*[^\n]");
 fscanf(mode,"%lf %*[^\n]",&qcdL6);
 fscanf(mode,"%lf %*[^\n]",&scale_str.rval);
 for(i=0;i<10;i++) { fscanf(mode,"%d",&m); scale_str.list[i]=m;}
 fscanf(mode,"%*[^\n]%*c"); 
 return 0;
}

/* ********************************************************************* */
/*    This subroutine is called during phase space integration        * */
/*      (during BASES and SPRING run)                                 * */
/*      for each phase space point after calculation particles        * */
/*      momenta and just before calculation of structure functions    * */
/*      and squared matrix element.                                   * */
/*                                                                    * */
/*    It can be used, for example, to provide QCD running strong      * */
/*      coupling constant. In the program there is used the notation  * */
/*                           GG                                       * */
/*      for QCD coupling constant.                                    * */
/* ***************************************************************** */
void alf_(void)
{
    int i__1;
    int k;
    char xname[7];

/* ****** search for QCD coupling constant among process parameters */
    i__1 = nvar_;
    for (k = 1; k <= i__1; ++k) 
    {
	vinf_(k, xname, NULL);
	if (strcmp("GG", xname) == 0) 
	{   
	    asgn_(k, sqrt(4*M_PI *  alphas2_(scale_())));
	    return;
	} 
    }
} /* alf_ */

/* ************************************************************* */
/*   This subroutine user can call to evaluate the transfered * */
/*     momentum scale of the process - could be necessary for * */
/*     structure function interface.                          * */
/*                                                            * */
/*   In the example from STRFUN.F this subroutine is called   * */
/*     for the evaluation of transfered momentum scale.       * */
/*   NSCALE = 0 for t-type, and =1 for s-type of              * */
/*     transfered momentum scale.                             * */
/* ************************************************************* */
double scale_(void)
{
   double d__1,dscale;
   int nvbuff;

   if (scale_str.list[0] == 0)
   {   dscale=scale_str.rval;
       if(dscale<0) dscale=-dscale;
   }    
   else 
   {
	nvbuff = nin_ + nout_ + 3;
	lvtonv_(scale_str.list, nvbuff);
	dscale = sqrt((d__1 = vdot4_(nvbuff, nvbuff), ABS(d__1)));
    }
    if (dscale < .3f)  dscale = .3f;
    return dscale;
} /* scale_ */
