/*
 Copyright (C) 1997, Slava Ilyin
*/
#include "out_ext.h"
#include"f_c.h"
#include"4_vector.h"
#include<math.h>

/* kinfun.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f_c.h"

double pvect[400];  /*was [4][100] */


/* ******************************** */
/* Improved SQRT function        * */
/* ******************************** */
double vsqrt_(double *a)
{
    /* System generated locals */
    double ret_val;

    /* Builtin functions */
    double sqrt(double);

    if (*a < 0.) {
	ret_val = 0.;
	return ret_val;
    }
    ret_val = sqrt(*a);
    return ret_val;
} /* vsqrt_ */

/* ****************************************** */
/*    Scalar product of two 4-vectors:     * */
/* ****************************************** */
double vdot4_(int i, int j)
{
    /* System generated locals */
    double ret_val;

    /* Local variables */
    static long ix, jx;

    ix = (i << 2) - 3;
    jx = (j << 2) - 3;
    ret_val = pvect[ix - 1] * pvect[jx - 1] - pvect[ix] * 
	    pvect[jx] - pvect[ix + 1] * pvect[jx + 1] - pvect[
	    ix + 2] * pvect[jx + 2];
    return ret_val;
} /* vdot4_ */

/* ******************************************************* */
/*       SUM or Difference of two 4-vectors:            * */
/* ISG=1  sum   and  ISG=-1   difference                * */
/*             P(I) + ISG*P(J)=>P(K)                    * */
/* ******************************************************* */
/* Subroutine */ int vsum4_(int i, int j, int k, int isg)
{
    static long ix, jx, kx;

    ix = (i << 2) - 3;
    jx = (j << 2) - 3;
    kx = (k << 2) - 3;
    if (isg == 1) {
	pvect[kx - 1] = pvect[ix - 1] + pvect[jx - 1];
	pvect[kx] = pvect[ix] + pvect[jx];
	pvect[kx + 1] = pvect[ix + 1] + pvect[jx + 1];
	pvect[kx + 2] = pvect[ix + 2] + pvect[jx + 2];
    } else {
	pvect[kx - 1] = pvect[ix - 1] - pvect[jx - 1];
	pvect[kx] = pvect[ix] - pvect[jx];
	pvect[kx + 1] = pvect[ix + 1] - pvect[jx + 1];
	pvect[kx + 2] = pvect[ix + 2] - pvect[jx + 2];
    }
    return 0;
} /* vsum4_ */

/* ****************************************** */
/* NULLification of a 4-vector:  P(I) => 0 * */
/* ****************************************** */
/* Subroutine */ int vnull4_(int  i)
{
    static long ix;

    ix = (i << 2) - 3;
    pvect[ix - 1] = 0.;
    pvect[ix] = 0.;
    pvect[ix + 1] = 0.;
    pvect[ix + 2] = 0.;
    return 0;
} /* vnull4_ */

/* Subroutine */ int eps4_(int n1, int  n2, int n3, int n4)
{
    static double a10, a11, a12, a13, a20, a21, a22, a23, a30, a31, a32, 
	    a33, d1021, d1022, d1023, d1122, d1123, d1223;

    a10 = pvect[(n1 << 2) - 4];
    a11 = pvect[(n1 << 2) - 3];
    a12 = pvect[(n1 << 2) - 2];
    a13 = pvect[(n1 << 2) - 1];
    a20 = pvect[(n2 << 2) - 4];
    a21 = pvect[(n2 << 2) - 3];
    a22 = pvect[(n2 << 2) - 2];
    a23 = pvect[(n2 << 2) - 1];
    a30 = pvect[(n3 << 2) - 4];
    a31 = pvect[(n3 << 2) - 3];
    a32 = pvect[(n3 << 2) - 2];
    a33 = pvect[(n3 << 2) - 1];
/*                               A10  A20  A30  X0 */
/*                               A11  A21  A31  X1 */
/*                               A12  A22  A32  X2 */
/*                               A13  A23  A33  X3 */
    d1021 = a10 * a21 - a20 * a11;
    d1022 = a10 * a22 - a20 * a12;
    d1023 = a10 * a23 - a20 * a13;
    d1122 = a11 * a22 - a21 * a12;
    d1123 = a11 * a23 - a21 * a13;
    d1223 = a12 * a23 - a22 * a13;
    pvect[(n4 << 2) - 4] = a31 * d1223 - a32 * d1123 + a33 * d1122;
    pvect[(n4 << 2) - 3] = a30 * d1223 - a32 * d1023 + a33 * d1022;
    pvect[(n4 << 2) - 2] = -(a30 * d1123 - a31 * d1023 + a33 * d1021);
    pvect[(n4 << 2) - 1] = a30 * d1122 - a31 * d1022 + a32 * d1021;
    return 0;
} /* eps4_ */

