#include"e_tools.h"
#include"4_vector.h"
#include"phys_val.h"
#define const
#include"out_ext.h"
#undef const
static void wrongParam(int N)
{ 
   if(N) fprintf(stderr,"Wrong parameter %d\n",N);
   else  fprintf(stderr,"Wrong number of parameters \n");  
   fprintf(stderr,  
    "Parameters:\n"
    " 1- name of variable,\n"
    " 2- minimum limit,\n"
    " 3- maximum limit,\n"
    " 4- number of bins(<=300).\n");
}


int nin_, nout_;

double sum;
static  char * p_names[MAXNP];
static  double p_masses[MAXNP];


int pinf_(int nsub,int num ,char * name, double* mass) 
{ 
  if(name) strcpy(name,p_names[num-1]);  
  if(mass) *mass=p_masses[num-1];
  return 0; 
}

int  main(int argc,char** argv)
{ 
  char buff[STRSIZE], word[100];
  char varName[NAMELEN];
  int i;
    
  double minX, maxX;
  int nbin;
  char  key;
  char plist[MAXNP];
  
  double *hist, *dhist;
  double weight,coef;
  long nPoints;
  char units[100];   

  if(argc != 5 ) 
  { 
/*    for (i=0; i<nin_; i++) fprintf(stdout," %s",p_names[i]);
    fprintf(stdout," ->");
    for (i=nin_; i<nin_+nout_; i++)  fprintf(stdout," %s",p_names[i]);
    fprintf(stdout,"\n");
*/    
    wrongParam(0); return 1;
  }


  do
  { 
    fscanf(stdin,"%s",word); fgets(buff,1000,stdin);
    if(!strcmp(word,"PROCESS:") ) getNames(buff,&nin_,&nout_,p_names);
    else if(!strcmp(word,"MASSES:")) getMasses(buff,p_masses);
  } while(strcmp(word,"Weight"));
  sscanf(buff,"%s",units);
  

  if(!checkPhysVal(argv[1], &key, plist)) { wrongParam(1); return 1;}
    else  strcpy(varName, argv[1]);


       
  if(sscanf(argv[2],"%lf",&minX)!=1){ wrongParam(2); return 1;}
  if(sscanf(argv[3],"%lf",&maxX)!=1 || minX>=maxX){ wrongParam(3); return 1;}
  if(sscanf(argv[4],"%d",&nbin)!=1  || nbin<=0)
    { wrongParam(4); return 1;}

  hist=(double*)malloc(nbin*sizeof(double));
  dhist=(double*)malloc(nbin*sizeof(double));
  for(i=0;i<nbin;i++){hist[i]=0; dhist[i]=0;}
  nPoints=0;
  sum=0;
  while(fscanf(stdin,"%lf",&weight)==1)
  { 
    for(i=0;i<4*nin_;i++) pvect[i]=0;
    if(nin_ ==2) fscanf(stdin,"%lf %lf",pvect+3,pvect+7); 
    for(i=nin_;i<nin_+nout_;i++)
    {  double *p = pvect+4*i;
       fscanf(stdin,"%lf%lf%lf",p+1,p+2,p+3);
    }
    for(i=0;i<nin_+nout_;i++) pvect[4*i]=ENERGY(p_masses[i],pvect+4*i+1);
    i=nbin*(calcPhysVal(key,plist)- minX)/(maxX-minX); 
    if(i>=0 && i<nbin) {hist[i]+=weight; dhist[i]+=weight*weight; nPoints++;}
    sum+=weight;
    fgets(buff,1000,stdin);
  }
  
  coef=nbin/(maxX - minX);
  
  for(i=0;i<nbin;i++)
  {   dhist[i]=coef*sqrt( dhist[i] - hist[i]*hist[i]/nPoints);
      hist[i]*=coef;
  }

  { char  xname[200], yname[200], xunits[100];
    for(i=0;i<nin_;i++) 
    { if(i) fprintf(stdout,",");
       fprintf(stdout," %s",p_names[i]);
    }
    fprintf(stdout," ->");
    for(i=nin_;i<nin_+nout_;i++) 
    {  if(i!=nin_) fprintf(stdout,",");
       fprintf(stdout," %s",p_names[i]);
    }
    if(!strcmp(units,"[pb]")) 
    {  fprintf(stdout,"(\\sigma=%.3E[pb])",sum);
       sprintf(yname,"Diff. cross section [pb");
    }  
    else if(!strcmp(units,"[GeV]")) 
    {  fprintf(stdout,"(\\Gamma=%.2E[GeV])",sum);
       sprintf(yname,"Diff. width [GeV");
    }    
    else 
    { fprintf(stdout,"(%.0f Events )",sum);
      sprintf(yname,"Event distribution [1");
    } 
    fprintf(stdout,"\n");
    
    xName(key, plist, xname,xunits); 
    fprintf(stdout,"x-axis: \"%s\"  from %f to %f N_bins= %d\n",
             xname ,minX,maxX,nbin);
    fprintf(stdout,"%s",yname);
    if(xunits[0])  fprintf(stdout,"/%s",xunits);
    fprintf(stdout,"]");
  }
  for(i=0;i<nbin;i++)
  {
     fprintf(stdout,"\n%-12E",hist[i]);
     fprintf(stdout," +/-  %-12E",dhist[i]);
  }
  fprintf(stdout,"\n");
                         
  return 0;
}
