#include"e_tools.h"

int  main(int argc,char** argv)
{ 
  char buff[STRSIZE], word[100];
/* main channel */ 
  int nIn, nOut;
  char * p_names[MAXNP];
  double p_masses[MAXNP];  
  int i;

/* subdecay channel */
  int nIn_, nOut_;
  char * p_names_[MAXNP];
  double p_masses_[MAXNP];  
  int i_;
  int nCopy;  /* weight if decay */
  FILE *fdecay;
  long dataStart;
 
  double fract,weight;
  char units[100];
       
  if(argc < 3) 
  { fprintf(stderr, "Program filterDN  needs  two parameters\n"
          " 1-  name of file with events of decay\n"
          " 2-  branching fraction\n");
    return 1;
  }
  
  fdecay=fopen(argv[1],"r");
  if(!fdecay) 
  { fprintf(stderr, "Can not open the file %s\n",argv[1]);
    return 1; 
  }
    
  if(!sscanf(argv[2],"%lf",&fract)) 
  {  fprintf(stderr, "Can not read value of the branchig fraction\n");
     return 1;
  }                  
  nCopy=0;

  do  /* read header of decay file */
  {
    if(1 != fscanf(fdecay,"%s",word))
    { fprintf(stderr, "Wrong format of %s file\n",argv[1]);
      return 1;
    }
    fgets(buff,STRSIZE-1,fdecay);
    if(!strcmp(word,"PROCESS:") ) getNames(buff,&nIn_,&nOut_,p_names_);
    else if(!strcmp(word,"MASSES:")) getMasses(buff,p_masses_);
  } while(strcmp(word,"Weight"));
  dataStart=ftell(fdecay);


  do /* read header of process */
  {
    fscanf(stdin,"%s",word);
    fgets(buff,1000,stdin);
    fprintf(stdout," %s",word);
    if(!strcmp(word,"PROCESS:") )
    { 
      getNames(buff,&nIn,&nOut,p_names);
      for (i=0; i<nIn; i++) 
      { if(i)  fprintf(stdout," , "); else  fprintf(stdout," ");
        fprintf(stdout,"%s",p_names[i]);
      }
      fprintf(stdout," ->");
      for (i=nIn; i<nIn+nOut; i++) 
      { if(i!=nIn)  fprintf(stdout," , "); else  fprintf(stdout," ");
        if(strcmp(p_names[i],p_names_[0])) fprintf(stdout,"%s",p_names[i]);
        else  for(i_=nIn_;i_< nIn_+nOut_;i_++)  
        { if(i_!=1) fprintf(stdout," , "); else fprintf(stdout," "); 
          fprintf(stdout,"%s", p_names_[i_]);
        }
      }
      fprintf(stdout,"\n");
    } else if(!strcmp(word,"MASSES:")) 
    { 
      getMasses(buff,p_masses);
      for (i=0; i<nIn+nOut; i++)
      {
        if(i>=nIn && !strcmp(p_names[i],p_names_[0]))
        {
          if(p_masses_[0] != p_masses[i]) 
          { fprintf(stderr,"ERROR: Different values for %s mass\n",p_names[i]);
            return 1;
          }  
          for(i_=nIn_;i_<nIn_+nOut_;i_++) fprintf(stdout," %f",p_masses_[i_]);
        }  
        else fprintf(stdout," %f",p_masses[i]);
      }
      fprintf(stdout,"\n");
    } else fprintf(stdout,"%s",buff);
  } while(strcmp(word,"Weight"));
  sscanf(buff,"%s",units);


  while(fscanf(stdin,"%lf",&weight)==1)
  { 
    weight*=fract;  
    if(!strcmp(units,"[pb]")||!strcmp(units,"[Gev]"))  fprintf(stdout," %14.6E ");
    else
    { int n, sgn=1;
      if(weight<0) {sgn=-1; weight*=-1;}
      n=weight;
      weight -=n;
      if(weight>drand48()) n++;
      n*=sgn;
      fprintf(stdout,"% 14d ",n);
    }

    if(nIn==2)
    for(i=0;i<2;i++)
    { double p;
      fscanf(stdin,"%lf",&p); 
      fprintf(stdout,FORMAT,p);
    }
   
    for(i=nIn;i<nIn+nOut;i++)
    {  double p[4], n[4], q[4]; 
       fscanf(stdin,"%lf%lf%lf",p+1,p+2,p+3);
       
       if(strcmp(p_names[i],p_names_[0]))
          fprintf(stdout,FORMAT FORMAT FORMAT,p[1],p[2],p[3]); else     
       { int k;
         double q_rest[4][MAXNP];
#ifdef CL_TEST
         double Q[4]=ENERGY(p_masses_[0],p+1);
#endif
         p[0]=p_masses_[0];
         findBoost(p,n);
         if(nCopy==0)
         { if(1 != fscanf(fdecay,"%d",&nCopy))
           { fseek(fdecay,dataStart,SEEK_SET);
             fscanf(fdecay,"%d",&nCopy);   
           }
           if(nCopy<=0) 
           { fprintf(stderr,"Error in %s file, position %ld\n" 
                "Negative or zero weight for decay event\n",
                 argv[1], ftell(fdecay));
             return 1;
           }  
         
           for(i_=0;i_<nOut_;i_++) 
           for(k=1;k<=3;k++)  fscanf(fdecay,"%lf",&q_rest[k][i_]);
           fgets(buff,1000,fdecay);
           
         }  
         
         for(i_=0; i_< nOut_ ; i_++)
         { 
           for(k=1;k<=3;k++) q[k]=q_rest[k][i_];
           q[0]=p_masses_[i_+1];
           boost(n,q); 
           fprintf(stdout,FORMAT FORMAT FORMAT,q[1],q[2],q[3]);
#ifdef CL_TEST
         for(k=1;k<=3;k++) Q[k]-=q[k];
         Q[0]-=ENERGY(p_masses_[i_+1], q+1);
#endif
         }
#ifdef CL_TEST
         fprintf(stderr,"CL_TEST: %f %f %f %f \n",Q[0],Q[1],Q[2],Q[3]);
#endif 
         nCopy--;
       }
    }
 
    fprintf(stdout,"\n");
    fgets(buff,1000,stdin);
  }
  return 0;
}
