#include"e_tools.h"

static void wrongParam(void)
{
   fprintf(stderr, 
    "Parameters:\n"
    " 1-decay particle name,\n"
    " 2-first outcoming particle name,\n"
    " 3-its mass,\n"
    " 4-second outcoming particle name,\n"
    " 5-its mass,\n"
    " 6-branching fraction.\n");
}

int  main(int argc,char** argv)
{ 
    char buff[STRSIZE], word[100];
    int nIn, nOut;
    char * p_names[MAXNP];
    double p_masses[MAXNP];  
    char name0[NAMELEN],name1[NAMELEN],name2[NAMELEN];
    double mass0,mass1,mass2,fract,weight;
    int i;
    char units[100];

  if(argc < 7 ) { wrongParam(); return 1;}
  strcpy(name0, argv[1]);
  strcpy(name1, argv[2]);
  strcpy(name2, argv[4]);
  if(!sscanf(argv[3],"%lf",&mass1)) { wrongParam(); return 1;}
  if(!sscanf(argv[5],"%lf",&mass2)) { wrongParam(); return 1;}
  if(!sscanf(argv[6],"%lf",&fract)) { wrongParam(); return 1;}
  
  if (argc == 10)
  {
     unsigned short int ini[3];
     for(i=0;i<3;i++)  
     if(sscanf(argv[7+i],"%hd",ini+i)!=1) 
     {  fprintf(stderr," %d-th parameter must be a number\n",7+i);
        return 3;
     } 
     seed48(ini); 
  } 

  do
  {
    fscanf(stdin,"%s",word);
    fgets(buff,1000,stdin);
    fprintf(stdout," %s",word);
    if(!strcmp(word,"PROCESS:") )
    { 
      getNames(buff,&nIn,&nOut,p_names);
      for (i=0; i<nIn; i++) 
      { if(i)  fprintf(stdout," , "); else  fprintf(stdout," ");
        fprintf(stdout,"%s",p_names[i]);
      }
      fprintf(stdout," ->");
      for (i=nIn; i<nIn+nOut; i++) 
      { if(i!=nIn)  fprintf(stdout," , "); else  fprintf(stdout," ");
        if(strcmp(p_names[i],name0)) fprintf(stdout,"%s",p_names[i]);
        else  fprintf(stdout,"%s , %s",name1,name2);
      }
      fprintf(stdout,"\n");
    } else if(!strcmp(word,"MASSES:")) 
    { 
      getMasses(buff,p_masses);
      for (i=0; i<nIn+nOut; i++)
      {
        if(i>=nIn && !strcmp(p_names[i],name0))
        { fprintf(stdout," %f %f",mass1,mass2);
          mass0=p_masses[i];
        } else fprintf(stdout," %f",p_masses[i]);
      }
      fprintf(stdout,"\n");
    } else fprintf(stdout,"%s",buff);
  } while(strcmp(word,"Weight"));
  sscanf(buff,"%s",units);  

  while(fscanf(stdin,"%lf",&weight)==1)
  {
    weight*=fract; 
    if(!strcmp(units,"[pb]")||!strcmp(units,"[Gev]"))  fprintf(stdout," %14.6E ",weight);
    else
    { int n, sgn=1;
      if(weight<0) {sgn=-1; weight*=-1;}
      n=weight;
      weight -=n;
      if(weight>drand48()) n++;
      n*=sgn;
      fprintf(stdout,"% 14d ",n);
    }
    if(nIn==2)
    for(i=0;i<2;i++)
    { double p;
      fscanf(stdin,"%lf",&p); 
      fprintf(stdout,FORMAT,p);
    }
   
    for(i=nIn;i<nIn+nOut;i++)
    {  double p[4], n[4], q1[4], q2[4]; 
       fscanf(stdin,"%lf%lf%lf",p+1,p+2,p+3);
       
       if(!strcmp(p_names[i],name0))
       { 
#ifdef CL_TEST
         double Q[4]=ENERGY(mass0,p+1);      
#endif
         p[0]=mass0;
         findBoost(p,n);
         q1[0]=mass1;
         q2[0]=mass2;
         decay2(mass0,q1,q2);
         boost(n,q1);
         boost(n,q2);

         fprintf(stdout,FORMAT FORMAT FORMAT,q1[1],q1[2],q1[3]);
         fprintf(stdout,FORMAT FORMAT FORMAT,q2[1],q2[2],q2[3]);

#ifdef CL_TEST
         for(i=1;i<=3;i++) Q[i]-=q1[i]+q2[i];
         Q[0]-=ENERGY(mass1,q1+1);
         Q[0]-=ENERGY(mass2,q2+1);
         fprintf(stderr,"CL_TEST: %f %f %f %f \n",Q[0],Q[1],Q[2],Q[3]);
#endif
       }
       else fprintf(stdout,FORMAT FORMAT FORMAT,p[1],p[2],p[3]);      
    }
    fprintf(stdout,"\n");
    fgets(buff,1000,stdin);
  }

  return 0;
}
