#include "e_tools.h"


void  boost(double * n, double *p)
{

   double M=p[0]; /* particle mass */
   double shY=n[0]; /* h-sine of rapidity */
   double chY=sqrt(1+ shY*shY);
   double f= ENERGY(M,p+1)*shY + (p[1]*n[1]+p[2]*n[2]+p[3]*n[3])*(chY-1);

   int i;
   for(i=1;i<=3;i++) p[i]+=n[i]*f;
} 
  

void findBoost(double * p, double *n)
{
  double p2=p[1]*p[1]+p[2]*p[2]+p[3]*p[3];
  double M=p[0];  
  int i;

  if(p2 == 0) {for(i=0;i<=3;i++) n[i]=0; return;}  
  p2=sqrt(p2);
  n[0]=p2/M;
  for(i=1;i<=3;i++) n[i]=p[i]/p2;
}

void getMasses(char * buff, double * mass)
{
  char * pos=strtok(buff," ");
  int i=0;
  while(pos)  {sscanf(pos,"%lf",mass+i++); pos=strtok(NULL," ");}
}

int getNames(char * buff,int * nIn, int * nOut, char ** names)
{
    char *posIn, *posOut;

    posIn=strtok(buff,"->");  if(!posIn) return 1;
    posOut=strtok(NULL,"->"); if(!posOut) return 1;

    *nIn=0;  posIn=strtok(posIn,",");
    while(posIn)
    { names[*nIn]=malloc(strlen(posIn)+1);
      sscanf(posIn,"%s",names[(*nIn)++]);
      posIn=strtok(NULL,",");
    }
    *nOut=0;  posIn=strtok(posOut,",");
    while(posOut)
    { names[*nIn+*nOut]=malloc(strlen(posOut)+1);
      sscanf(posOut,"%s",names[*nIn+(*nOut)++]);
      posOut=strtok(NULL,",");
    }
    return 0;
}

int decay2(double M, double * p1, double * p2)
{
double m1=p1[0];
double m2=p2[0];
double cosX,sinX, phi;
double P;
int i;

  if (m1+m2 >= M) return 1;

  P= sqrt( (M-m1-m2)*(M+m1+m2)*(M-m1+m2)*(M-m2+m1) )/(2*M);

  cosX=1-2*drand48();
  sinX=sqrt(1-cosX*cosX);

  phi= 2*M_PI*drand48();

  p1[3]=cosX;
  p1[2]=sinX*cos(phi);
  p1[1]=sinX*sin(phi);

  for(i=1;i<=3;i++) { p1[i]=P*p1[i]; p2[i]=-p1[i]; }
  return 0;
}
