/*
 Copyright (C) 1997, Alexander Pukhov 
*/

#include "chep_crt.h"
#include "tptcmac.h"
#include "s_files.h"
#include "screen.h"
#include "file_scr.h"
#include "read_mdl.h"
#include "process.h"

whohow     liminsp;
whohow     limout;


int  nin, nout, n_x;   /* Number of X-particles */
shortstr processch="", limpch="", deloutch="";

hadron hadrons[MAXINOUT];

#define ycons 19
#define errtxt  "This particle is absent in the model"


void  nilprtcl(whohow p_list)
{int  i; 
   for (i = 0; i < whohowMAX; i++) {p_list[i].who = 0; p_list[i].how = 0;}  
} 



static void  addlim(whohow p_list,int j,int k, int anti)
{int i; 

   if (anti && prtclbase[j-1].anti < j) j = prtclbase[j-1].anti; 

   for (i = 0; i < whohowMAX-1; i++) 
   { 
      if (p_list[i].who == j) return;
      if (p_list[i].who == 0) 
      {  p_list[i].who = j; 
         p_list[i].how = k; 
         p_list[i+1].who = 0; 
         return;
      } 
   } 
} 


static char ** stritems(char * format, char * s)
{
  int i, space=1, item=0, l=strlen(s);
  char ** res=NULL;

  for(i=0;i<l;i++) 
  if ( !strchr(format,s[i])) {if(space) { space=0;  item++; }}
  else space=1;
 
  res=malloc((item+1)*sizeof(char *));
  res[item]=NULL;
  
  item=0;
  space=1;
  for(i=0;i<l;i++) 
  if( !strchr(format,s[i]))
  {if (space) { space=0; res[item++]=s+i;}}
  else space=1;  

  return res;
}  

static void  prtcllist(int  key)
{
 char         fullname[STRSIZ];
 char         buf1[60],buf2[60],buf3[60],buf4[60];
 char         hlp[60];
 char         p1[60], p2[60];
 int         i, j, pnum;
 linelist     ln;
 int  tabMax,tabSz;

 static int    nTot,nFirst;

	tabMax=ycons -7;
	if (key==0)
	{
		scrcolor(FGmain,BGmain);
		for (i = 2; i <= 24; i++)
		{  goto_xy(1,i);
			clr_eol();
		}
		goto_xy(14,3);
		scrcolor(Blue,BGmain);
		print("List of particles (antiparticles)");
		nTot=0;
		nFirst=1;
	}
	else
	{
		if (nTot <= 3 *tabMax )   return;
		switch (key)
		{
		  case KB_DOWN : nFirst+=3;         break;
		  case KB_UP   : nFirst-=3;         break;
		  case KB_PAGED: nFirst +=3*tabMax; break;
		  case KB_PAGEU: nFirst -=3*tabMax; break;
		}
		if (nFirst <1) nFirst=1;
		if (nTot-nFirst+3<3*tabMax )  nFirst=1+3*((nTot+2)/3) -3*tabMax;
		clrbox(1,4,79,5+tabMax);
	}
	goto_xy(3,5);
	i=0;
	ln=prtcls_tab.strings;
	scrcolor(FGmain,BGmain);
	while (ln != NULL)
	{  sscanf(ln->line,"%[^|]%*c%[^|]%*c%[^|]%*c%[^|]%*c%[^|]%*c%[^|]%*c%[^|]%*c%[^|]",
			 fullname,p1,p2,buf1,buf2,buf3,buf4,hlp);
		trim(p1);
		locateinbase(p1,&pnum);
		trim(hlp);
		if (prtclbase[pnum-1].top != NULL && strcmp(hlp,"*") != 0)
		{
			i++;
			if (i>=nFirst && (i-nFirst)/3 <tabMax )
			{
				print("%s",p1);
				if (strcmp(p1,p2) == 0) print("     "); else print("(%s)",p2);
				trim(fullname);
				print("- %s",fullname);
				j = i % 3;
				if (j == 0)	goto_xy(3,where_y() + 1);
						else	goto_xy(3 + 26 * j,where_y());
			}
		}
		ln=ln->next;
	}
	nTot=i;
	tabSz=MIN((nTot+2)/3,tabMax);
	chepbox(1,4,79,5+tabSz);

	if (nFirst >1 ) { goto_xy(72,4); print("PgUp");  }

	if (nFirst+3*tabSz <= nTot    ) { goto_xy(72,5+tabMax); print("PgDn");  }

	scrcolor(FGmain,BGmain);
}




static char * errTxt=NULL;

static int input(int y0, char*hlp, char * directive, char * text, int cur, int lim)
{
   if(errTxt)
   {
      goto_xy(1,y0+1); 
      scrcolor(FGmain,BGmain);
      clr_eol();
      print("%s","Error: ");
      scrcolor(Red,BGmain);
      print("%s",errTxt);
      scrcolor(FGmain,BGmain);
      be_be();
      errTxt=NULL;
   }
   for(;;) 
   { int rc;
     goto_xy(1,y0);  
     scrcolor(FGmain,BGmain);
     print("%s",directive);
     rc=str_redact(text,cur, lim);
     switch(rc)
     { case  KB_UP:
       case  KB_DOWN: 
       case  KB_PAGED:
       case  KB_PAGEU:  prtcllist(rc); continue;
       case  KB_F1:     show_help(hlp); continue; 
     }
     return rc;                            
   }
}

static int enter_h(int * y, char* name, int  num)
{ int      i,m,j=0;
  int      redres;
  shortstr hadrch;  

  char ** items;
  char * errpos=NULL;

  if (strlen(name) == 0) return -1;
  if (strlen(name) >7 )  return -1;

  locateinbase(name,&j);
  if(j && !pseudop(j))
  {
    strcpy(hadrons[num].name,name);
    strcpy(hadrons[num].contents,name); 
    hadrons[num].parton[0] = j; 
    hadrons[num].pow = 1;
    return 0;
  }

  for(i=0;i<num;i++) 
  if(!strcmp(hadrons[i].name,name))
  {  strcpy(hadrons[num].name,name);
     strcpy(hadrons[num].contents,hadrons[i].contents);
     hadrons[num].pow=hadrons[i].pow;
     for(j=0;j<hadrons[num].pow;j++)hadrons[num].parton[j]=hadrons[i].parton[j];
     return 0;
  }

  hadrch[0]=0; 

  for(i=num;i<MAXINOUT;i++) if(!strcmp(hadrons[i].name,name))
  {  
     strcpy(hadrch,hadrons[i].contents);
     break;
  } 


  if(*y>=maxRow()-1) { goto_xy(1,*y); clr_eol();} else (*y)++;  

  do
  {
     m=errpos? errpos-hadrch+1: 0;
  
     do 
     {  char direction[100];
        sprintf(direction,"composit '%s'  consists of: ",name); 
        redres=input(*y, "s_ent_2", direction,  hadrch, m , SSTRLEN);
        if(redres==KB_ESC) return 1;               
     }  while (redres!=KB_ENTER && redres!=KB_ESC);

     if (redres == KB_ESC || strcmp(hadrch,"") == 0)  return 1;
  
      
     items=stritems(" ,",hadrch);
     for(m=0,hadrons[num].pow=0; items[m]; m++) 
     {  char  name[100];
        if(hadrons[num].pow>=100) {errTxt="too many partons";break;}   
        sscanf(items[m],"%[^ ,]",name);
        locateinbase(name,&j); 
        if (j==0 || pseudop(j)) 
        { errTxt= "This particle is absent in the model"; break;}
        hadrons[num].parton[hadrons[num].pow++]=j;
     }

     errpos=items[m]; 
     if(!errpos)
     {  for(i=0;i<hadrons[num].pow;i++)
        for(j=i+1;j<hadrons[num].pow;j++)
        if(hadrons[num].parton[i]==hadrons[num].parton[j])
        {  errpos=items[j];
           errTxt="duplicate parton";
        }
     }
     strcpy(hadrons[num].name,name);
     strcpy(hadrons[num].contents,hadrch);
     free(items);
  }
  while(errpos);   

  return 0;
}


static int restrict_p(int y0, int anti, char * mess, char * hlp, 
char *  inputstr, whohow  liminsp)
{ 
   int m, j, k;
   int ntot;

   char ** items;   
   char *errpos=NULL;

   int r; 

do{
    for(r=1;r!=KB_ENTER;) 
    { 
       r=input(y0, hlp,  mess,inputstr, errpos? 1+errpos-inputstr:1,SSTRLEN);
       if(r==KB_ESC) return 1;
    }

    nilprtcl(liminsp);
    ntot=0;

    items=stritems(",",inputstr);
    for(m=0 ; items[m]; m++)
    {  char frgm[100];
       char *n;
      sscanf(items[m],"%[^,]",frgm);       
      n=strchr(frgm,'>');
      if(n)  
      { n[0]=0; k=0; sscanf(n+1,"%d",&k); 
        if(k<1) { errTxt="wrong number"; break;}
      } else k=1;
      trim(frgm);

      locateinbase(frgm,&j);
      if ((j == 0) || pseudop(j))
      {  errTxt="wrong limit statement";
         break;
      }
      ntot++;
      if(ntot>=whohowMAX) { errTxt="To many items"; break;}
      addlim(liminsp,j,k,anti);
    }
    errpos=items[m];
    free(items);
  }while(errpos);
   return 0;
}




int enter(void)
{   
   int  i, y0;
   int  redres;
   double inMass,outMass;

   char ** items=NULL;
   char * errpos=NULL;
   char * arrpos=NULL;

   int curh=0;


   prtcllist(0);
   scrcolor(Red,BGmain);
   y0 = ycons;
label_1:
   if(y0<maxRow()) y0++;  
   for(;y0>ycons;y0--){goto_xy(1,y0); clr_eol();} 

   if(arrpos) strncpy(arrpos,"->",2);

   redres=input(y0,"s_ent_1", "Enter  process: ",processch,errpos?errpos-processch+1:1,SSTRLEN); 
   switch (redres)
   {
	case KB_F1:   /*  Help  */
	       show_help("s_ent_1");
	       goto label_1;
	case KB_ESC: 
	       clrbox(1,2,maxCol(),24);
               return 1;
   }   /*  Case  */

   arrpos=strstr(processch,"->");
   if(arrpos)  strncpy(arrpos,", ",2); 
   else { errTxt="'->' is absent "; goto label_1; }

   if(items) free(items);
   items=stritems(" ,",processch);

   for(i=0,nin=0,nout=0,n_x=0,curh=0; items[i]; i++)   
   {  char name[100];

      sscanf(items[i],"%[^, ]", name); 
      if(strlen(name)>7) {errTxt="too long name"; break;}

      if(items[i]>arrpos && strlen(name) == 3 && name[1] == '*' &&
             (name[2] == 'X' || name[2] == 'x')  &&
             isdigit(name[0])) {n_x += name[0]-'0'; nout +=name[0]-'0';}   
      else
      {
        if(curh==MAXINOUT-1){errTxt="Too many particles"; break;}
        if(enter_h(&y0,name,curh)) break;  
        if(items[i]>arrpos) nout++; else nin++; 
        if(nin>2){errTxt="Too many incoming particles"; break;}                  
        curh++;
      }
   }
   errpos=items[i];
   free(items); items=NULL;
       
   if(nout<2)
   {  errTxt="The number of outgoing particles should  exceed 1";
      goto label_1;
   }
   if(nin<1)
   {  errTxt="Incoming  particle(s) is not defined";
      goto label_1; 
   }

   if(errpos||nin+nout>MAXINOUT) 
   {if(!errTxt) errTxt=errtxt; goto label_1; }   
 
   for(curh=0,inMass=0,outMass=0;curh< nin+nout-n_x;curh++)
   { double m0=prtclbase[hadrons[curh].parton[0]-1].mass;
     for(i=1;i<hadrons[curh].pow;i++) 
     {  double m=prtclbase[hadrons[curh].parton[i]-1].mass;
        if(m<m0) m0=m;
     }
     if(curh<nin) inMass+=m0; else outMass+=m0;  
   }    
   
   y0++;
   if(y0>=maxRow()-1) {y0=maxRow()-1; goto_xy(1,y0); clr_eol();}

   if(restrict_p(y0,1, "Exclude diagrams with ","s_ent_4",limpch,liminsp)
     ) goto label_1;

   y0++;

   if(y0>=maxRow()-1) {y0=maxRow()-1; goto_xy(1,y0); clr_eol();} 
   if(n_x && restrict_p(y0,0,"Exclude X-particles ","s_ent_5",deloutch,limout)
     ) goto label_1;   
          
   for(i=nin+nout;i<MAXINOUT;i++) hadrons[i].name[0]=0;
  
   strncpy(arrpos,"->",2);

   return 0;
}
