/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "syst.h"
#include "syst2.h"
#include "physics.h"
#include "parser.h"
#include "pvars.h"
#include "s_files.h"
#include "os.h"
#include "out_serv.h"
#include "procvar.h"
#include "saveres.h"
#include "process.h"

int nProcessVar;
int all_params=0; 

singlevardescription *vararr = NULL;

 
static void * PP=(void *)"PP";

static void *  rd_hiddenVars(char* s)
{ int l;
  if (isdigit(*s)) return PP;
  for(l=0;l<=nmodelvar;l++)
     {if (!strcmp(modelvars[l].varname,s)) {vararr[l].used=1; break;}}
  return PP;
}

static void * act_hiddenVars(char * ch,int n,void ** mm1) {  return PP; }

int initvararray(int nsub, char key)
{  int i,j,k,kk,l; 
   catrec    cr;

   polyvars  allVars={0,NULL}; 
   int nvar,nfunc;        
    
   nProcessVar = nmodelvar + 2 +((MAXINOUT*(MAXINOUT-1)/2)); 
   if (vararr) free(vararr); 
   vararr = (singlevardescription*)m_alloc(nProcessVar 
                                            * sizeof(singlevardescription)); 

   sprintf(vararr[0].alias,"0"); 
   vararr[0].tmpvalue=0;
   vararr[0].used = 0;

   for(k=1; k<nProcessVar;k++)
   {  sprintf(vararr[k].alias,"#%d",k); 
      vararr[k].tmpvalue=0;
      vararr[k].used = 0;
   }
   for(k=1;k<=nmodelvar;k++) vararr[k].used=modelvars[k].need;
      
   vardef=&allVars;
   if((key=='c') && all_params){ for(l=1;l<=nmodelvar;l++)  
             if(strcmp(modelvars[l].varname,"i"))vararr[l].used=1;
                               } else
{
   fseek(catalog,0,SEEK_SET);
   while (FREAD1(cr,catalog))
   {  
      if(!nsub || cr.nsub_ == nsub)
      {
         seekArchiv(cr.factpos);
         readvardef();
         for(l=0;l<vardef->nvar;l++) vararr[vardef->vars[l].num].used=1;
         clearvardef();
         seekArchiv(cr.rnumpos);
         readvardef();
         for(l=0;l<vardef->nvar;l++) vararr[vardef->vars[l].num].used=1;
         clearvardef();
         seekArchiv(cr.denompos);
         readDenominators();
         for(l=0;l< denrno;l++) 
         { if( denom[l].mass)   vararr[denom[l].mass].used=1;
           if( denom[l].width)  vararr[denom[l].width].used=1;
         }
         clearvardef();
      }
   }
   for (k = nmodelvar ; k >=0; k--) 
   if( vararr[k].used && modelvars[k].func)
       readExpression(modelvars[k].func,rd_hiddenVars,act_hiddenVars,NULL); 
}
   kk=0;
   for (i = 2; i <= nin+nout; i++)
   for (j = 1; j <= i - 1; j++)
   { k=scalarProductPos(i,j); 
     switch(key)
     { case 'R':
       case 'F': sprintf( vararr[k].alias, "p%d.p%d", j, i);    break;
       case 'M': sprintf( vararr[k].alias, "SC[p%d,p%d]", j, i);break;
       case 'c': sprintf( vararr[k].alias, "DP[%d]",kk); break;
       case 'f': { char c=kk+1;
                    if(c<10) sprintf( vararr[k].alias, "P%c",'0'+c);
                    else     sprintf( vararr[k].alias, "P%c",'A'+c-10);
                 } break;
     } 
      vararr[k].used = 1;
      kk++; 
   }
   nvar=0;
   for(k=0;k<=nmodelvar;k++) 
   if (vararr[k].used && !modelvars[k].func)
   {  vararr[k].tmpvalue = modelvars[k].varvalue;
   
      switch(key)
      {
          case 'R':
          case 'F':
          case 'M':  strcpy( vararr[k].alias, modelvars[k].varname);break;
          case 'c':  sprintf(vararr[k].alias,"va_ext[%d]",++nvar); break;
          case 'f':  sprintf(vararr[k].alias,"A(%d)",++nvar); break;
      }
   }
   nfunc=0;
   for(k=0;k<=nmodelvar;k++) 
   if (vararr[k].used && modelvars[k].func)
   {  vararr[k].tmpvalue = modelvars[k].varvalue;
      switch(key)
      {
          case 'R':
          case 'F':
          case 'M':  strcpy( vararr[k].alias, modelvars[k].varname);break;
          case 'c':  sprintf(vararr[k].alias,"va_ext[%d]",++nfunc+nvar); break;
          case 'f':  sprintf(vararr[k].alias,"A(%d)", ++nfunc+nvar); break;
      }
   }

   for(k=1; k<=nmodelvar; k++) if(vararr[k].used && !modelvars[k].able) return 0;
   return 1;
} 
