#include"num_in.h"
#include"rootDir.h"

double *Q0=NULL;
double *Q1=NULL;
double *Q2=NULL;

double DP[28];  /* for 2->6 */
double Fmax; 
int  FError;
int  CalcConst;

int indx_(int k,int l)
{
  int i,j;
  if(k<l) {i=k;j=l;} else {i=l;j=k;}
  return i+(j*(j-1))/2;
}

void sprod_(int ntot, double * momenta)
{
   int k, i,j;
   for (i = 0; i < ntot-1; ++i)
   {
      for (j = i + 1; j < ntot; ++j)
      {  double *sum=DP+indx_(i,j);
         double *v1=momenta+4*(i);
         double *v2=momenta+4*(j);
         *sum=*v1**v2;
         for(k=1;k<=3;k++) (*sum)-=v1[k]*v2[k];
      }
   }
}


double sqrMom(int nin, char * momnum, double * lv)
{  char * ii;
   double s[4]={0,0,0,0};
   char nin_char;
   nin_char=nin;

   ii=momnum;
   while(*ii)
   {  int k;
      if(*ii>nin_char) for(k=0;k<4;k++) s[k]-=lv[k+4*(*ii-1)];
      else             for(k=0;k<4;k++) s[k]+=lv[k+4*(*ii-1)];
      ii++;
   }
   return (s[0]-s[1])*(s[0]+s[1])-s[2]*s[2]-s[3]*s[3];
}

int prepDen(int nden, int rwidth, int gwidth, double s0max, double * dmass,double * dwidth, double *q)
{ static int ndenmem=0;
  static double computer_eps=1;

  int i;
  int err=0;

  if(computer_eps>0.5)
  {  double one=1; double one_plus_eps;
     do{ computer_eps=computer_eps/2; one_plus_eps=one+computer_eps;}
     while( one_plus_eps !=one); computer_eps*=2;
  }

  s0max=computer_eps*s0max*s0max;

  if(ndenmem<nden+1)
  {
     ndenmem=nden+1;
     Q0=(double*)realloc(Q0,sizeof(double)*ndenmem);
     Q1=(double*)realloc(Q1,sizeof(double)*ndenmem);
     Q2=(double*)realloc(Q2,sizeof(double)*ndenmem);
  }

  for(i=1;i<=nden;i++) Q1[i]=q[i];

  for ( i=1;i<= nden;i++)
  if(dwidth[i]!=0.)
  {  double w, q2=Q1[i]*Q1[i];
     if(rwidth) w=(dmass[i]-q[i]/dmass[i]); else w=dmass[i];
     w*=dwidth[i];
     Q2[i]=1/(q2+w*w);
     if (gwidth) Q0[i]=Q2[i]*q2;else Q0[i]=1;
     Q1[i]*=Q2[i];
  } else
  {  if((Q1[i]>0? Q1[i]:-Q1[i]) < 10*s0max) err=2;
     if(!Q1[i]) Q1[i]=s0max;
     Q1[i]=1/Q1[i];
     Q2[i]=Q1[i]*Q1[i];
     Q0[i]=1;
  }
  return err;
}
