/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include <math.h>
#include "chep_crt.h"
#include "err_code.h"
#include "plot.h"
#include "num_serv.h"
#include "width_12.h"
#include "const.h"
#include "num_out.h"
#include "param.h"
#include "4_vector.h"

static char inParticle[10];
static double * widths=NULL;

static void  decay12information(double totwidth)
{  
   clrbox(1,16, maxRow(), maxCol());
   
   goto_xy(5,5);scrcolor(Red,BGmain); print(" Decay ");
   scrcolor(Blue,BGmain);print("%s -> 2*x      ",inParticle);
   goto_xy(1,13);
   scrcolor(Red,BGmain); 
   print(" Total width : "); 
   scrcolor(FGmain,BGmain); 
   if(err_code) {print(" incorrect       "); return;}

   print("%13E GeV",totwidth);
   if (totwidth > 0. ) 
   {  int i,xcount = 31, ycount = 15;
      int * sort= (int*) malloc(sizeof(int)*nprc_ext);

      for(i=0;i<nprc_ext;i++) sort[i]=i;  
      for(i=0;i<nprc_ext-1;)
      {   
         if(widths[sort[i]] < widths[sort[i+1]])
         {  int buff=sort[i];
            sort[i]=sort[i+1];
            sort[i+1]=buff;
            if (i!=0) i--;
         } else i++;
      }   

      goto_xy(1,14);
      scrcolor(Red,BGmain);
      print(" Modes and fractions :"); 
      for(i=0;i<nprc_ext&& ycount < maxRow();i++) if(widths[sort[i]]>0)
      { 
	 goto_xy(xcount,ycount-1);
         scrcolor(Blue,BGmain);
         print("%s ",pinf_ext(sort[i]+1,2,NULL));
         print("%s - ", pinf_ext(sort[i]+1,3,NULL));
         scrcolor(FGmain,BGmain); 
         print("%7.2G%%", 100*widths[sort[i]]/totwidth);
         xcount += 30; 
         if (xcount > maxCol()) {  xcount = 1; ++(ycount); }   
      } 
      free(sort);
   } 
   scrcolor(FGmain,BGmain); 
} 


static double  calcwidth12(void)
{ 
 int i,nsub;
 double width12 = 0.;

 err_code = 0; 

 for(nsub=1;nsub<=nprc_ext;nsub++)     /* err_code == 0 */
 {  double m1, m2, m3;
 
    if(strcmp(pinf_ext(nsub,1,&m1)  ,inParticle)!=0)  widths[nsub-1]=0; 
    else
    {   
      pinf_ext(nsub,2,&m2);  pinf_ext(nsub,3,&m3);
          
      if (m1 <=m2 + m3) widths[nsub-1] = 0.0; 
      else 
      { 
        double md=m2-m3;
        double ms=m2+m3; 
        double pRestOut=sqrt((m1*m1 - ms*ms)*(m1*m1-md*md))/(2*m1);
        double totcoef= pRestOut/(8. * M_PI * m1*m1);
                   
        for(i=1;i<12;i++) pvect[i]=0;
        pvect[0]=m1;
        pvect[7]=pRestOut;
        pvect[4]=sqrt(pRestOut*pRestOut+m2*m2);
        pvect[11]=-pRestOut;
        pvect[8]=sqrt(pRestOut*pRestOut+m3*m3);
            
        widths[nsub-1] = totcoef * sqme_ext(nsub,pvect,&err_code);
        if(err_code != 0) {  errormessage(); widths[nsub-1]=0; err_code=0;}
        width12 += widths[nsub-1];
      }
    }  
 } 
 return width12; 
} 

static void inmenutxt(char ** menutxt)
{ 
  char * n1,*n2;

  int i,pos=11;

  *menutxt=(char *)malloc(2+10*nprc_ext);
  *menutxt[0]=10;

  n1=pinf_ext(1,1,NULL);
  sprintf(*menutxt+1," %-9.9s",n1);
  for(i=2;i<=nprc_ext;i++) 
  { n2=pinf_ext(i,1,NULL);
    if(strcmp(n1,n2)!=0)
    { n1=n2;
       sprintf(*menutxt+pos," %-9.9s",n1);
       pos+=10;  
    }
  }
}


void  decay12(void)
{ 
   int  k,L;
   void * pscr=NULL; 
   char * mlist;

   widths=(double*)malloc(sizeof(double)*nprc_ext);
   
   inmenutxt(&mlist);
   L=mlist[0];
   sscanf(mlist+1,"%s",inParticle);   

   for(k=1;k;) 
   {  clrbox(1,13, maxCol(), maxRow());
      decay12information(calcwidth12());
 
      menu3(56,3,"","\026"
         " Incoming particle    "
         " Model parameters     "
         " Constarains          "
         " Parameter dependence ","n_13_*",&pscr,&k);
      switch (k)
      { 
        case 1:
           { 
             if(strlen(mlist)>L+2)
             { void * pscr2=NULL;
               int k=1;
                menu1(56,5,"",mlist,"",&pscr2,&k);
               if(k)  sscanf(mlist+(k-1)*L+1,"%s",inParticle);
               put_text(&pscr2);
             }
           }                 
           break;
        case 2:  change_parameter(54,8); break;
        case 3:  show_depend(54,8); break;
        case 4:
          { char proc[20];
            sprintf(proc,"%s -> 2*x",inParticle);
	    paramdependence( calcwidth12,proc,"Width  [GeV]");
	  } 
      } 
   }
   free(widths);
   free(mlist);
   clrbox(1,13,maxCol(),maxRow());
}
