/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include"num_out.h"
#include"f_c.h"
#include"sf_epa.h"
#include"sf_isr.h"
#include"sf_lsr.h"
#include"sf_pdf.h"
#include"strfun.h"
#include"f_c.h"
#include"subproc.h"
#include"tptcmac.h"
#include"crt_util.h"
#include"syst.h"

#define MAXFUN 4
#define FUNLEN 40  

int sf_num[2]={0,0}; /* switched off */
double sf_mass[2]={0,0};
double sf_be[2]={0,0};

static struct 
{  int (*myParticle)(char*);
   void(*fullName)(int,char *); 
   int (*readName)(int,char*);
   void(*menu)(int);
   int(*init)(int,double*,double*);
   double(*val)(int,double,double);
}  strFun [MAXFUN]={ {p_epa__,n_epa__,r_epa__,m_epa__,i_epa__,c_epa__},
                     {p_lsr__,n_lsr__,r_lsr__,m_lsr__,i_lsr__,c_lsr__},              
                     {p_isr__,n_isr__,r_isr__,m_isr__,i_isr__,c_isr__},
                     {p_pdf  ,n_pdf  ,r_pdf  ,m_pdf  ,be_pdf ,c_pdf},
                   };

int initStrFun(int mode )
{
  int l,i;
  int returnCode=0;

  if(nin_ext!=2) return returnCode;
   
  if(mode<=0||mode>2)
  {
    alphaMode=0;
    if(initStrFun(1)||initStrFun(2)) returnCode=2; 
    return returnCode;   
  }

  i=mode-1;
  l=sf_num[i];  
  if(l)
  { 
     l--;
     if(!strFun[l].myParticle(pinf_ext(proces_1.nsub,i+1,NULL))
         ||!strFun[l].init(i+1,sf_be+i,sf_mass+i))
     {  char txt[60];
        sprintf(txt,"%d-th Stucture function is switched OFF",i+1);
        sf_num[i]=0;
        messanykey(10,15,txt); 
        returnCode=2;
      }
  } else sf_be[i]=0;
    
  return returnCode;  
}


void strFunName(int i, char * mess)
{
  if(sf_num[i-1]) strFun[sf_num[i-1]-1].fullName(i,mess); 
  else strcpy(mess,"OFF");
}

int sf_menu(int i)
{
    int  k;
    char name[STRSIZ];
    int  nfun[MAXFUN];
    char * p_name__;
    char strmen[2+MAXFUN*(FUNLEN+1)];

    void * pscr =NULL;
    int mode,l;

    strmen[0]=FUNLEN+1;

    p_name__=pinf_ext( proces_1.nsub,i,NULL);
    
    sprintf(strmen+1," %-*.*s",FUNLEN,FUNLEN,"OFF");

    k = 0;          
    for(l=0;l<MAXFUN;l++)
    {    
       if ( strFun[l].myParticle(p_name__)  ) 
       {  
          nfun[k++] = l;
          strFun[l].fullName(i, name); 
	  sprintf(strmen+1+(FUNLEN+1)*k," %-*.*s",FUNLEN,FUNLEN,name);
       }
    }
    if(!k) 
    { messanykey(15,15,"Structure functions for this particle\n"
                       "are not known\n");
      return 0;
    }

    menu1(77-FUNLEN,7,"",strmen, "n_strfun", &pscr, &mode );
    if (mode == 0) return 0;
    if (mode == 1) sf_num[i-1]=0;
    else
    { 
       strFun[nfun[mode - 2]].menu(i);
       sf_num[i-1]=nfun[mode -2]+1;
    }
    put_text(&pscr);
    return 1;
} /* sf_menu__ */

double strfun_(int i, double x,double q)
{ return strFun[sf_num[i-1]-1].val(i,x,q);}

int rd_sf__(FILE *mode)
{ char sf_txt[2][STRSIZ];
  int l, i;

  for(i=0;i<2;i++) sf_num[i]=0;
 
  if(2 != fscanf(mode,"  StrFun1: %[^\n]\n  StrFun2: %[^\n]\n",
  sf_txt[0],sf_txt[1])) return 1;
  for(i=0;i<2;i++)
  { char * p_name=pinf_ext( proces_1.nsub,i+1,NULL);
    for(l=0;l<MAXFUN;l++)
    if(strFun[l].myParticle(p_name)  && strFun[l].readName(i+1,sf_txt[i]))
    { sf_num[i] = l+1; 
      break; 
    }
  }
  initStrFun(0);
  return 0;                                                                       
}


int wrt_sf__(FILE *mode)
{  
   char sf_txt[2][STRSIZ];
   int i;

   for(i=0;i<2;i++) 
   { fprintf(mode,"  StrFun%d: ",i+1);
     if(sf_num[i]) strFun[sf_num[i]-1].fullName(i+1,sf_txt[i]);
     else strcpy(sf_txt[i],"OFF");
     fprintf(mode,"%s\n",sf_txt[i]);
   }
   return 0; 
}
