/*
 Copyright (C) 1997, Alexander Pukhov 
*/

#include "pdf.h"
#include "os.h"
#include "files.h"
#include "num_out.h"
#include "subproc.h"
#include "chep_crt.h"
#include "strfun.h"
#include "n_calchep_.h"
#include "sf_pdf.h"

int alphaMode=0;

static char * pdfName[2]={NULL,NULL}; 
static pdfStr pdfData[2];

static void comphepPdfList(char * p_name,  pdfList **list)
{  int i;
   char * dNames[3];
   char path[STRSIZ];


   dNames[0]="..";
   dNames[1]=".";
   dNames[2]=pathtocomphep;

   for(i=0 ;i<3;i++)
   {  int len,err;
      searchrec s;
      strcpy(path,dNames[i]);
      if(i!=2) sprintf(path+strlen(path),"%c",f_slash);
      len=strlen(path);
      strcat(path,"*.pdf");
      err=find_first(path,&s,anyfile);
 
      while (!err)
      { 
        path[len]=0;  
        strcat(path,s.name);
        makePdfList(path, p_name, list);
        err=find_next(&s);
      } 
   }
} 


int p_pdf(char *p_name) 
{  
   pdfList *list=NULL; 
   comphepPdfList(p_name, &list);
   if(list)  {delPdfList(list); return 1;} else return  0; 
}

void n_pdf(int i, char *name) 
{i--;  if(pdfName[i]) strcpy(name,pdfName[i]); else strcpy(name,"PDF:"); }


int r_pdf(int i, char *name)
{   
   i--;
   if(name==strstr(name,"PDF") ) 
   {
      if(pdfName[i]) free(pdfName[i]);
      pdfName[i]=malloc(strlen(name)+1);
      strcpy(pdfName[i],name);
      return 1;
   }else return 0; 
}


int be_pdf(int i,double * be, double * mass) 
{  
   char p_name[20];
   pdfList *list=NULL;
   pdfList *list_;
   int ret_code=0; 
   static int  first[2]={1,1};

   i--;

  if(!first[i]) freePdfData(pdfData+i); 
   
   strcpy(p_name,pinf_ext( proces_1.nsub,i+1,NULL));
 
   
   comphepPdfList(p_name, &list);   
   list_=list;
   while(list_ && ret_code==0)  
   {   
     if(strcmp(list_->name,pdfName[i]+4)==0) 
      ret_code= !getPdfData(list_->file,list_->position,pdfData+i);   
     list_=list_->next;
   }    
   if(list) delPdfList(list);
   if(ret_code) 
   { first[i]=0; 
     if(pdfData[i].alpha) alphaMode=i+1;
     if(pdfData[i].pow1<0) *be=pdfData[i].pow1+1; else *be=1.;
     *mass=pdfData[i].mass;
   } 
     
   return ret_code; 
}

#define WIDTH 30
void m_pdf(int i)
{
   pdfList *list=NULL;
   pdfList *list_; 
   int k=0;
   char * strmen; 
   void * pscr=NULL;    
   char p_name[20];

   i--;
   strcpy(p_name,pinf_ext(proces_1.nsub,i+1,NULL));

   comphepPdfList(p_name, &list);
   if(!list) return;
   for(list_=list;list_;list_=list_->next,k++);
   strmen=malloc(2+WIDTH*k);
   strmen[0]=WIDTH;strmen[1]=0; 
   for(list_=list; list_; list_=list_->next) sprintf(strmen+strlen(strmen),
       " PDF:%-*.*s",WIDTH-5,WIDTH-5,list_->name);
   for(k=0;!k;)  menu1(80-4-WIDTH,7,"",strmen,"",&pscr,&k);  
   k--;   
   for(list_=list; k ; list_=list_->next, k--);
   if(pdfName[i]) free(pdfName[i]);
   pdfName[i]=malloc(5+strlen(list_->name));   
   sprintf(pdfName[i],"PDF:%s",list_->name); 

   free(strmen);
   put_text(&pscr); 
   delPdfList(list);
}

double c_pdf(int i, double x, double q)
{  double r;
   i--;
   r=interFunc( x, q , pdfData+i);
   if(!r) return 0.;
   if(pdfData[i].pow0) r*=pow(x,pdfData[i].pow0);
   if( pdfData[i].pow1>0) r*=pow(1-x,pdfData[i].pow1);

   if(r<0)r=0;
   return r;
}

double alpha_pdf(double q ){ return interAlpha(q, pdfData+alphaMode-1);}
