/*
 Copyright (C) 1997, Slava Ilyin
*/
#include"num_out.h"
#include "f_c.h"
#include"sf_epa.h"
#include "const.h"
#include <f_c.h>
#include "tptcmac.h"
#include "crt_util.h"
#include<math.h>

    static double xin[2] = { 5.11e-4,5.11e-4 };
    static double charge[2]={ -1, -1};
    static double q_max[2] = { 100.,100. };


/* ********************************************************* */
/*  Equivalent photon approximation structure function.   * */
/*     Improved Weizsaecker-Williams formula              * */
/*      C.F.Weizsaecker, Z.Phys. 88 (1934) 612            * */
/*      E.J.Williams,    Phys.Rev. 45 (1934) 729          * */
/*                                                        * */
/*   V.M.Budnev et al., Phys.Rep. 15C (1975) 181          * */
/* ********************************************************* */

int p_epa__(char *p_name__)
{
     if (strcmp(p_name__,"A") == 0) return 1; else return 0; 
} 
 

void n_epa__(int i,char * name)
{
  sprintf(name,"Equiv.Photon(mass=%.10G charge=%.6G |Q|max=%.8G)", xin[i-1], charge[i-1], q_max[i-1]);
}  

int r_epa__(int i, char *name)
{
    double xin__,q_max__,charge__;
    if(3!= sscanf(name,
    "Equiv.Photon(mass=%lf%*[^=]%*c%lf%*[^=]%*c%lf",&xin__,&charge__,&q_max__))  goto L10;
    if (xin__ <= 0.)  goto L10;
    
    if (q_max__ <= 0.) goto L10;
    i--;
    xin[i]= xin__;
    q_max[i]= q_max__;
    charge[i]= charge__;
    return 1;
L10: return 0;

 }

int i_epa__(int i, double *be, double * mass) { *be=1.; *mass=xin[i-1]; return 1;}

void m_epa__(int i)
{   
    void * pscr = NULL;
    i--;
    for(;;)
    { char strmen[]="\050"
      " Incoming particle mass = XXX           "
      " Incoming particle charge = YYY         "
      " |Q|max = ZZZ                           ";
      int mode;
   
      improveStr(strmen,"XXX","%.10G Gev", xin[i]);
      improveStr(strmen,"YYY","%.6G",   charge[i]);
      improveStr(strmen,"ZZZ","%.8G Gev",q_max[i]);
      menu1(38,10,"",strmen, "n_sf_epa",&pscr,&mode);
    
      switch(mode)
      {
      case 0: return ;
      case 1: correctDouble(40,16,"Enter new value ",xin+i   ,1); break;
      case 2: correctDouble(40,16,"Enter new value ",charge+i,1); break;
      case 3: correctDouble(40,16,"Enter new value ",q_max+i ,1);
      }
    }     
}


double c_epa__(int i, double x, double q)
{
#define alpha  .0072992701
  i--;
  {
     double d__1=xin[i]/q_max[i];
     double delt=d__1*d__1;
     double f=  alpha* charge[i] * charge[i]/(M_PI * 2) 
     * (log((1 - x) / (x * x * delt)) * ((1-x) * (1-x) + 1) / x 
      - (1 - x - delt * (x * x)) * 2/x);
     if(f<0)  f=0;
     return f; 
  }
}
