/*
 Copyright (C) 2002, Alexander Pukhov
*/
#include"num_out.h"
#include"tptcmac.h"

#include"cut.h"
#include"kinaux.h"
#include"kininpt.h"

#include"regul.h"
#include"rw_sess.h"
#include"alphas2.h"
#include"histogram.h"
#include"crt_util.h"
#include"n_calchep_.h"
#include"runVegas.h"
#include"drandXX.h"
#include"num_out.h"

#include"strfun.h"
#include"files.h"
#include"subproc.h"
#include"paragraphs.h"
#include"events.h"


static int writeIntegral(FILE *f)
{
  fprintf(f," %.17E %.17E %.17E %d %d %d", integral.s0,integral.s1,integral.s2,
  integral.n_it, integral.old, integral.nCallTot);
  return 0;
}
static int readIntegral(FILE *f)
{
  fscanf(f," %lf %lf %lf %d %d %ld", &(integral.s0),&(integral.s1),
  &(integral.s2),&(integral.n_it),&(integral.old), &(integral.nCallTot));
  return 0;
}

static int wnsess_(FILE *mode) { fprintf(mode,"%d",nSess); return 0; }
static int rnsess_(FILE *mode) { fscanf(mode,"%d",&nSess); return 0; }

static int w_prc__(FILE *mode)
{ return  fprintf(mode,"%d (%s)",proces_1.nsub,proces_1.proces); }
static int r_prc__(FILE *mode)
{  char proc_name[100];
   fscanf(mode,"%d (%[^)]",&proces_1.nsub,proc_name);
   if(proces_1.nsub> nprc_ext) return 2;
   if (strcmp(proc_name,proces_1.proces)==0) return 0; else return 2;
}

static int w_mc__(FILE *mode)
{ fprintf(mode,"%dx%d",mcintr_1.ncall0,mcintr_1.itmx0); return 0;}
static int r_mc__(FILE *mode)
{ fscanf(mode,"%ldx%d",&mcintr_1.ncall0,&mcintr_1.itmx0); return 0;}

static int w_widths(FILE *mode)
{ 
   fprintf(mode,"running width    %d\n"
                "gauge invariance %d\n"
                "t-channel widths %d", rwidth_ext,gwidth_ext,twidth_ext);
   return 0;             
}
static int r_widths(FILE *mode)
{    fscanf(mode,"running width    %d\n"
                 "gauge invariance %d\n"
                 "t-channel widths %d", &rwidth_ext,&gwidth_ext,&twidth_ext);     
     return 0;
}                                   

static int w_mdl__(FILE * mode)
{
  long i;

  fprintf(mode,"\n"); 
  for (i = 1; i <= nvar_ext; ++i) fprintf(mode,"%10s = %.15E\n",varName_ext[i],va_ext[i]);
 
  return 0;
}
static int r_mdl__(FILE * mode)
{
    static double val;
    long i;
    char name1[20];    
    for (i = 1; i <= nvar_ext; ++i) 
    { if(2!= fscanf(mode,"%s = %lf",name1,&val)) return 2;
      if(strcmp(name1,varName_ext[i])) return 2;
      va_ext[i] = val;
    }
    return 0;
} 

static int w_in__(FILE *mode)
{ 
  if(nin_ext==1)  fprintf(mode," inP1=%E\n",inP1); else
  {
    fprintf(mode," inP1=%E  inP2=%E\n",inP1,inP2);
    wrt_sf__(mode);
  }
  return 0;
}
static int r_in__(FILE *mode)
{ 
  if(nin_ext==1)   fscanf(mode," inP1=%lf\n",&inP1); else
  {
     fscanf(mode," inP1=%lf  inP2=%lf\n",&inP1,&inP2);
     rd_sf__(mode);
  }
  return 0;
}


static int saveRandom(FILE *f)
{ fprintf(f,"%s\n",seedXX(NULL)); return 0; }
static int readRandom(FILE *f)
{ char s[20]; fscanf(f,"%s",s); seedXX(s); return 0;}


int wrtprc_(void) /* write process string */
{
    int i;
    char * s=proces_1.proces;
    strcpy(s,pinf_ext(proces_1.nsub,1,NULL));
    for (i=2;i<=nin_ext+nout_ext ;i++)
    {  if( i==nin_ext+1) strcat(s," -> "); else strcat(s,", ");
       strcat(s, pinf_ext(proces_1.nsub,i,NULL));
    }   
    return 0;
}


int w_sess__(FILE *mode_)
{
   FILE*mode;
   rw_paragraph  wrt_array[16]=
   {
      {"Subprocess",  w_prc__},
      {"Session_number",  wnsess_},
      {"Initial_state",  w_in__},
      {"Physical_Parameters",  w_mdl__},
      {"Breit-Wigner", w_widths}, 
      {"Kinematical_scheme",  wrtkin_},
      {"Cuts",  wrtcut_},
      {"Regularization",  wrtreg_},
      {"QCD",  w_qcd__},
      {"Vegas_calls",  w_mc__},
      {"Vegas_integral", writeIntegral},
      {"Distributions", wrt_hist},
      {"Events",saveEventSettings},
      {"Random", saveRandom},
      {"VEGAS_Grid", saveVegasGrid},
      {"MAX",saveEventMax}
   };

   if (mode_ == NULL)
   { char fname[100];
     sprintf( fname,"%ssession.dat",outputDir);
       mode=fopen(fname,"w");
      if(mode == NULL) return 0;
   } else mode=mode_;

   if(mode_ == NULL)
   {
      writeParagraphs(mode,16,wrt_array);
      fclose(mode);
   } else   writeParagraphs(mode,8,wrt_array);

   return 0;
}    

int r_sess__(FILE *mode_)
{
  FILE*mode;
  
 rw_paragraph  rd_array[16]=
 {
   {"Subprocess",  r_prc__},
   {"Session_number",  rnsess_},
   {"Initial_state",  r_in__},
   {"Physical_Parameters",  r_mdl__},
   {"Breit-Wigner", r_widths},
   {"Kinematical_scheme",  rdrkin_},
   {"Cuts",  rdrcut_},
   {"Regularization",  rdrreg_},
   {"QCD",  r_qcd__},
   {"Distributions", rdr_hist},
   {"Vegas_integral", readIntegral},
   {"Vegas_calls",  r_mc__},  
   {"Events", readEventSettings},
   {"Random", readRandom},
   {"VEGAS_Grid",readVegasGrid},
   {"MAX", readEventMax}
 };
                       
                         
 if (mode_ == NULL) 
 { 
   mode=fopen("session.dat","r"); 
   if (mode ==NULL) return 0;
 }else mode=mode_;
 readParagraphs(mode, 16,rd_array); 
 
 if (mode_ == NULL) fclose(mode); 
 wrtprc_();
 return 0;
} /* r_sess__ */


void  inipar_(void)
{
 proces_1.nsub=1;
 wrtprc_();

 stdkin_();
 i_qcd();
 nSess = 1;
 rwidth_ext=0;
 gwidth_ext=0; 
 twidth_ext=0;
 if(nin_ext==1) inP1=0;
} 
