/*
 Copyright (C) 2002, Alexander Pukhov
*/

#include <unistd.h>
#include <stdarg.h>
#include <math.h>

#include "num_out.h"
#include "tptcmac.h"
#include "cut.h"
#include "4_vector.h"
#include "q_kin.h"
#include "regul.h"
#include "runVegas.h"
#include "rw_sess.h"
#include "subproc.h"
#include "vegas.h"
#include "strfun.h"
#include "alphas2.h"
#include "crt_util.h"
#include "os.h"
#include "histogram.h"
#include "drandXX.h"
#include "n_calchep_.h"
#include "files.h"
#include "events.h"

int nSess=1;
double inP1=100, inP2=100;
mcintr_ mcintr_1 = {10000,5,0};

static vegasGrid * veg_Ptr=NULL;
static int hFill=0;
vegas_integral integral={0,0,0,0,0,0}; 

static int afterVegas=0;

int saveVegasGrid( FILE * f)
{
  if(veg_Ptr)
  {  int i,j;
     double * x=veg_Ptr->x_grid;
     fprintf(f," Vegas_grid: dim=%d  size=%d\n", veg_Ptr->ndim, veg_Ptr->ndmx);
     for(i=0;i<veg_Ptr->ndim;i++)
     { for(j=0;j<=veg_Ptr->ndmx;j++) fprintf(f," %.15E",*(x++));
       fprintf(f,"\n");
     }
  }else  fprintf(f," Vegas_grid: dim=%d  size=%d\n", 0, 0);
  return 0;
}

int readVegasGrid(FILE * f)
{
  int i,j,ndim,ndmx;
  double * x;
  
  if(veg_Ptr) {vegas_finish(veg_Ptr);veg_Ptr=NULL;}  
  fscanf(f," Vegas_grid: dim=%d  size=%d\n", &ndim, &ndmx);
  if(ndim && ndmx)
  {
    veg_Ptr=vegas_init(ndim,ndmx);    
    x=veg_Ptr->x_grid;
    for(i=0;i<ndim;i++)for(j=0;j<=ndmx;j++) fscanf(f," %lf",(x++));
  }
  return 0;
}

static int nCall;
static double badPoints;
static double negPoints;

static void printLn(FILE * iprt,int *line,char * format, ...)
{  
   va_list args;
   char dump[STRSIZ];
   va_start(args, format);
   vsprintf(dump,format,args);
   va_end(args);

   goto_xy(1,*line); print("%53s","");
   goto_xy(1,*line);
   print("%s\n",dump); 
   (*line)++;
   if (*line >= maxRow()-2 ) *line=8; else 
   {
     scrcolor(Blue, BGmain);
     print("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
   }   
   if(iprt) {fprintf(iprt,"%s\n",dump); fflush(iprt);}
}

static double func_(double *x, double wgt)
{
    double ret_val=0.;
    int err=0;
    double factor_0;
    double q;

    nCall++; 
/* ** call kinematics preparation of scalar products */
    mkmom(x, &factor_0);
    if (!factor_0) goto exi;
    
    factor_0 *= calcCutFactor(); 
    if (!factor_0)   goto exi;

    q=scale_();
/* **  structure function  multiplication */
    if (nin_ext == 2) 
    {
	if(sf_num[0])  factor_0 *= strfun_(1, x[0],q);
	if(sf_num[1])  factor_0 *= strfun_(2, x[1],q);
    }   

    if (!factor_0)   goto exi;
/* ** call for 'running strong coupling constant' */
    alf_(q);
        
    ret_val = factor_0 * sqme_ext(proces_1.nsub,pvect,&err);
    if(err)       badPoints+=  (ret_val>0 ? ret_val*wgt : - ret_val*wgt); 
    if(ret_val<0) negPoints+=ret_val*wgt;
exi:

    if(hFill) fillHists(ret_val*wgt);

    return ret_val;
} /* func_ */


int runVegas(int init)
{
    int i;
    double sd;
    double avgi;
    char mess[25];
    int first = 1;
    FILE * iprt = NULL;
    int mode;
    void * pscr=NULL;
    static int n_Line=7;
    int ndim=0; 

    ndim=imkmom(inP1,inP2);

    if (nin_ext == 2) strcpy(mess, " Cross section [pb] ");
    else           strcpy(mess, "  Width     [Gev]   ");
    
/* ** save current session parameters */
     w_sess__(NULL);
/* ** open protocol and resulting files */
       
    {  char fname[50];
       sprintf(fname,"%sprt_%d",outputDir,nSess);
       iprt=fopen(fname,"a");
       if(ftell(iprt)==0) 
       { fprintf(iprt,"    CalcHEP kinematics module \n The session parameters:\n");
         w_sess__(iprt);
         fprintf(iprt,"===================================\n");   
       }
    }

/* **  initkinematics */
    if(init && veg_Ptr) { vegas_finish(veg_Ptr); veg_Ptr=NULL;}    
    if(!veg_Ptr) veg_Ptr=vegas_init(ndim,50);     

    correctHistList();
    
    mcintr_1.ncall0/=2;
    generateVegasCubs(veg_Ptr, &mcintr_1.ncall0);
    mcintr_1.ncall0*=2;

/* *** Main cycle */
    if(!integral.old || n_Line==7)
    { n_Line=7;
      scrcolor(Blue, BGmain);
      printLn(iprt,&n_Line," #IT  %20s Error %%    nCall   chi**2",mess); 
    }

    for(;;)
    {
        char strmen[]="\030"
         " Itmx   =    N2         "
         " nCall  =    N1         "
         " Set  Distributions     "
         " Start integration      "
         " Display Distributions  "
         " Clear statistic        "
	 " Clear  grid            ";

        improveStr(strmen,"N1","%d",mcintr_1.ncall0);
        improveStr(strmen,"N2","%d",mcintr_1.itmx0);

        menu1(54,7,"",strmen,"n_veg_*",&pscr,&mode);
        switch(mode)
        {     
        case 0:
          if(iprt) fclose(iprt);
          return 0;           
        case 1:  
          correctInt(50,12,"Enter new value ",&mcintr_1.itmx0,1); break;
        case 2: 
          correctLong(50,12,"Enter new value ",&mcintr_1.ncall0,1); 
	  mcintr_1.ncall0/=2;
	  generateVegasCubs(veg_Ptr,&mcintr_1.ncall0);
	  mcintr_1.ncall0*=2;
	  break;
        case 3:  editHist(); break;
        case 4:
          if(integral.n_it==0)
          { integral.s0=0;
            integral.s1=0;
            integral.s2=0;
            integral.nCallTot=0;
          }

          for (i = 1; i <= mcintr_1.itmx0; ++i)                                       
          { char  errtxt[100]="";                                                     
                                                                                      
            nCall=0;                                                                  
            first=0;                                                                  
            negPoints=0;                                                              
            badPoints=0; 
            hFill=1;                                                             
            if(vegas_int(veg_Ptr, mcintr_1.ncall0,1.5, func_, &avgi, &sd)        
              ) break;                    
            integral.old=1;                                              
            negPoints/=nCall;                                                         
            badPoints/=nCall;                                                         
            integral.nCallTot+=nCall;                                                          
            scrcolor(FGmain,BGmain);                                                  
            printLn(iprt,&n_Line,"%3d    %12.4E     %10.2E %8d ",                     
                 ++integral.n_it, avgi,100*sd/ABS(avgi),nCall);                                 
            if(negPoints<0) sprintf(errtxt," Negative points %.1G%%;",                
                                      -100*negPoints/(avgi-2*negPoints));             
            if(badPoints)  sprintf(errtxt+strlen(errtxt),                             
                 "Bad Precision %.1G%%;",100*badPoints/(avgi-2*negPoints));           
                                                                                      
            if(errtxt[0])                                                             
            {                                                                         
               scrcolor(Red,BGmain);                                                  
               printLn(iprt,&n_Line,"%s",errtxt);                                     
            }                                                                         
            sd=1/(sd*sd);                                                             
            integral.s0+=sd;                                                                  
            integral.s1+=avgi*sd;                                                             
            integral.s2+=avgi*avgi*sd;                                                        
          } 

          if(integral.n_it>1)                                                                  
          {  scrcolor(FGmain,BGmain);                                                 
             printLn(iprt,&n_Line," < >   %12.4E     %10.2E %8d %8.1G" ,         
             integral.s1/integral.s0, 100*sqrt(integral.s0)/ABS(integral.s1), 
             integral.nCallTot,                               
             (integral.s2-integral.s1*integral.s1/integral.s0)/(integral.n_it-1));
          }                                                                           
          afterVegas=1;
          messanykey(54,11,"Integration is over");                                   
          break;

        case 5:  showHist(); break;

        case 6:
          integral.s0=0; 
          integral.s1=0; 
          integral.s2=0; 
          integral.n_it=0; 
          integral.nCallTot=0; 

          clearHists();  
          messanykey(54,13,"Old results for integral\n"
                           "and distributions\nare deleted.\n"
                           "But grid is saved");
          break;
        case 7: vegas_finish(veg_Ptr);
                veg_Ptr=vegas_init(ndim,50);
                afterVegas=1;
                messanykey(57,11,"OK");
                break;
       }
    }    
}


int runEvents(int init)
{
    FILE * iprt = NULL;

    int ndim=0; 

    ndim=imkmom(inP1,inP2);
    w_sess__(NULL);
/* ** open protocol and resulting files */
       
    {  char fname[50];
       sprintf(fname,"%sprt_%d",outputDir,nSess);
       iprt=fopen(fname,"a");
       if(ftell(iprt)==0) 
       { fprintf(iprt,"    CalcHEP kinematics module \n The session parameters:\n");
         w_sess__(iprt);
         fprintf(iprt,"===================================\n");   
       }
    }

/* **  initkinematics */

    if(init && veg_Ptr) { vegas_finish(veg_Ptr); veg_Ptr=NULL;}    
    if(!veg_Ptr) veg_Ptr=vegas_init(ndim,50);     

    { char fname[50];

      sprintf(fname,"%sevents_%d.txt",outputDir,nSess);

      hFill=0;
      generateEvents(veg_Ptr,init||afterVegas,func_,fname, iprt);
      afterVegas=0;
    }
    fclose(iprt);
    return 0;
}
