/*
 Copyright (C) 2000, Alexander Pukhov, e-mail pukhov@theory.npi.msu.su
*/

#include"chep_crt.h"
#include"num_out.h"
#include"plot.h"
#include"param.h"

/* ************************************************* */
/* Physics model parameters menu                     */
/* ************************************************* */

int checkParam(void)
{ int err=calcFunc_ext();
  if(err)
  {  char mess[100];
       sprintf(mess,"Can not evaluate constraned parameter"
                " %s (va_ext[%d])", varName_ext[err], err);
    
       if(blind) fprintf(stderr,"%s\n",mess); 
       else     messanykey(10,10, mess);
  }
  return err;
}

static void param_menu(int sqtrS_on, int vars_on, int func_on, char ** strmen)
{
    int k;

    int pos;
    int npos=0;
/* **  menu loop */

    
    if(vars_on) npos += nvar_ext;
    if(func_on) npos +=nfunc_ext;    
    
    if(npos==0) {*strmen=NULL; return;}
    *strmen=malloc(24*(npos+1)+2);
    (*strmen)[0]='\030';
         
    pos=1;    
    for (k = !sqtrS_on; k <= nvar_ext + nfunc_ext; ++k)
    { 
       if(k==0 || (vars_on && k<=nvar_ext) || (func_on && k>nvar_ext) )
       { char c=' '; 
         if(k>nvar_ext && vars_on  ) c='*';
         sprintf((*strmen)+pos,"%c%7s= %-14.5lg",c,varName_ext[k],va_ext[k]); pos+=24;
       }
    }
    (*strmen)[pos]=0;    
}


void selectParam(int * position, int x, int y, int sqtrS_on, int vars_on, int func_on, 
                char * mess, void ** pscrPtr)
{
    char* strmen;
    void * pscr;

    if(pscrPtr) pscr=*pscrPtr; else pscr=NULL; 

    param_menu( sqtrS_on,vars_on,func_on,&strmen);
    if(strmen)
    {
      menu1(x,y,mess,strmen,"",&pscr,position);
      free(strmen);

      if (*position == 0){ if(pscrPtr) *pscrPtr=NULL; *position=-1; return ;}
      if(pscrPtr)   *pscrPtr=pscr; else  put_text(&pscr);
      if (sqtrS_on) (*position)--;
      if (!vars_on) *position+=nvar_ext; 
    } else *position= -1;
} 

int change_parameter(int x,int y)
{ 
  double val;
  char name[20];
  int i,m,err;
  int returnCode=0; 
  void * pscr=NULL;
  double *va_mem=(double*)malloc(sizeof(double)*(nvar_ext+1));

  for(i=1;i<=nvar_ext;i++) va_mem[i]=va_ext[i];
  
  for(err=1; err;)
  {  
    for(m=0;m>=0;)
    {  selectParam(&m, x,y,0,1,0,"Change parameter",&pscr);
       if(m>=0) 
       {  
          sprintf(name,"%s = ",varName_ext[m]);
          val=va_ext[m];
          if(correctDouble(x,y+4,name,&val,1)) { va_ext[m]=val; returnCode=1;}
       }   
    }
    if(returnCode) err=checkParam(); else  err=0;
    if(err) 
    { err=!mess_y_n(10,10, "Restore previous parameter set?");   
      if(err==0) 
      {  for(i=1;i<=nvar_ext;i++) va_ext[i]=va_mem[i];
         returnCode=0;
      }
    }
  }
  free(va_mem);
  return returnCode;
}

void show_depend(int x, int y)
{ void *pscr1=NULL; 
  for(;;) 
  {  void *pscr2=NULL;
    char name1[20];
    int k1=0;
    
    selectParam(&k1,x,y+1,0,0,1,"Display dependence",&pscr1);

    if(k1<0) return;
    strcpy(name1,varName_ext[k1]);
    for(;;)
    { char name2[20];
      double val2;
      void *pscr3=NULL;
      double xMin, xMax;
      int  nPoints=100;
      int k3;

      int k2=0;
      selectParam(&k2,x,y+5,0,1,0,"on parameter",&pscr2);
      if(k2<0) break;
      strcpy(name2,varName_ext[k2]); val2=va_ext[k2]; 
      xMin=val2 - fabs(val2)/10;
      xMax=val2 + fabs(val2)/10; 
      for(;;)
      {  
         char strmen[]="\030 "
            " x-Min = XXX            "
            " x-Max = YYY            "
            " Npoints = NNN          "
            " Display plot           ";
     
         improveStr(strmen,"XXX","%G",xMin);
         improveStr(strmen,"YYY","%G",xMax);
         improveStr(strmen,"NNN","%d",nPoints);
         
         menu1(x,y+9,"Plot design",strmen,"",&pscr3,&k3);
         if(!k3) break;
         switch(k3)
         {  case 1: correctDouble(x,y+12,"xMin = ",&xMin,1); break;
            case 2: correctDouble(x,y+12,"xMax = ",&xMax,1); break;
            case 3: correctInt(x,y+12,"nPoints = ",&nPoints,1); break;
            case 4:
            if( xMax>xMin && nPoints>=3 && nPoints<=150)
            {  double dx=(xMax-xMin)/(nPoints-1);
               double f[150];
               int i, NaN=0;;

               for(i=0;i<nPoints;i++)
               {  double x=xMin+i*dx;
                  va_ext[k2]=x;
                  NaN=checkParam();
                  if(NaN) 
                  {  char mess[100];
                     sprintf(mess,"Can not evaluate constrains for %s=%G",name2, x);
                     messanykey(16,5,mess);        
                     break;
                  }
                  f[i]=va_ext[k1]; 
               }
               va_ext[k2]=val2; 
               checkParam();
               if(!NaN) plot_0(xMin,xMax,nPoints,f,NULL,"Plot for Constrain",
                               name2,name1);
            } else messanykey(16,5," Correct input is \n"
                                   "  xMin<xMax,\n"
                                   " 3<=nPoints<=150");
            break;
         }
       }
     }
  }
}

static int enterParamRes=0;


static void enterParamFkey(int x)
{  int key;
   double * va_mem=(double*) malloc(sizeof(double)*(nvar_ext+1));
   int i;
   for(i=1;i<=nvar_ext;i++) va_mem[i]=va_ext[i];

   for(key=1,enterParamRes=0; key;)
   { char name[10]="";
     char mess[70]; 
     double val;
     int keyv=10;
     key=correctStr(5,11,"Enter name(Esc for exit):",name, 9, 1);
     if(key)
     { 
        for(i=1;i<=nvar_ext;i++)
        { 
          if(strcmp(name,varName_ext[i])==0) break;
        } 
        if(i<=nvar_ext) 
        { sprintf(mess,"New value for '%s' is:",name);
          val=va_ext[i]; 
          keyv=correctDouble(5,11,mess, &val,1);
          if(keyv) { va_ext[i]=val; enterParamRes=1; } 
          else  messanykey(8,11,"Assignment aborted");
        } else 
        { if(blind) { printf("Wrong name '%s'\n",name); exit(1);} 
          sprintf(mess,"The name '%s' is absent into\n"
                       " the list of parameteres",name);
          messanykey(8,11,mess);
        }
     } else
     {  
        if(enterParamRes) key=checkParam(); else  key=0;
        if(key) 
        {  if(blind) exit(1);
           key=!mess_y_n(10,10, "Restore previous parameter set?");
           if(key==0) 
           {  for(i=1;i<=nvar_ext;i++) va_ext[i]=va_mem[i];
              enterParamRes=0;
           }
        }
     }     
   }
   free(va_mem);
}

int menu3(int x,int y ,char *lbl ,char * menutxt, char*hlp ,void * pscr, 
                     int *mode)
{   void (*f3_key_save)(int)=f3_key[0];
    char * f3_mess_save=f3_mess[0];

    enterParamRes=0;
    f3_key[0]=enterParamFkey;
    f3_mess[0]="Parameters";
    menu1(54,4,lbl,menutxt,hlp,pscr, mode);
    f3_key[0]=f3_key_save;
    f3_mess[0]=f3_mess_save;
    return  enterParamRes;
}
