/*
 Copyright (C) 1997, Alexander Pukhov 
*/
#include "tptcmac.h"
#include "os.h"
#include "chep_crt.h"
#include "plot.h"
#include "param.h"
#include "num_out.h"
#include "err_code.h"

#include "num_serv.h"


void  paramdependence(r_func  ff, char*  procname, char*  resultname)
{  void *      pscr0 = NULL;
   char        prmname[10];
   int         nprm=0;
   double      minprm, maxprm;
   int         npoints;
   double      memprm, stepprm;
   unsigned    count;
   double f[201];

   double prmval;   
   

   selectParam(&nprm,54,11,nin_ext==2,1,0,"Choose parameter",NULL); 
   if (nprm < 0) return;
   strcpy(prmname,varName_ext[nprm]);
   memprm=va_ext[nprm];
 
   minprm = memprm; 
   maxprm = minprm; 
    
label1:

   if (!correctDouble(55,14,"min= ",&minprm,0)) 
   { 
      nprm = 0;
      goto exi;
   } 

label2:
   if (!correctDouble(55,15,"max= ",&maxprm,0)) 
   { 
      goto_xy(55,14);
      clr_eol(); 
      goto label1;
   } 
   if (maxprm <= minprm) 
   { 
      messanykey(55,17,"Range check error"); 
      goto_xy(55,15);
      clr_eol();
      goto label2;
   } 

label4: npoints = 101;
   if (correctInt(55,16,"Number of points= ",&npoints,0)) 
   { 
      if (npoints < 3) 
      { 
         messanykey(55,17,"Too few points!"); 
         goto label4;
      } 
      if (npoints > 201) 
      { 
          messanykey(55,17,"Too many points!"); 
          goto label4;
      } 
   } 
   else
   { 
      goto_xy(55,15);
      clr_eol(); 
      goto label2;
   }

   goto_xy(55,14); clr_eol();
   goto_xy(55,15); clr_eol();
   goto_xy(55,16); clr_eol();

   stepprm = (maxprm - minprm)/(npoints - 1); 

   informline(0,npoints);

   stepprm = (maxprm - minprm) / (npoints - 1); 
   prmval=minprm;
   err_code = 0; 
   for (count = 1; count <= npoints; count++)
   { 
      va_ext[nprm]=prmval;
      err_code=checkParam();
      if(err_code>1) break; 
      f[count-1] = ff();
      informline(count,npoints);       
      prmval += stepprm;
   } 
 
    if(err_code) errormessage();
   if (err_code <=1) 
   { 
      scrcolor(FGmain,BGmain);
      goto_xy(1,23); clr_eol(); 
      plot_0(minprm,maxprm ,npoints,f,NULL,procname,prmname,resultname); 
   } 
   va_ext[nprm]=memprm; checkParam();   
exi:
   put_text(&pscr0);
   goto_xy(1,23);
   scrcolor(FGmain,BGmain);
   clr_eol(); 
} 
