/*
 Copyright (C) 1997, Alexander Pukhov, e-mail pukhov@theory.npi.msu.su
*/

#include "tptcmac.h" 
#include "chep_crt.h"
#include "runVegas.h"
#include "alphas2.h"
#include "kininpt.h"
#include "num_out.h"
#include "cut.h"
#include "regul.h"
#include "edittab.h"
#include "rw_sess.h"
#include "strfun.h"
#include "cs_22.h"
#include "histogram.h"
#include "q_kin.h"
#include "subproc.h"
#include "n_calchep_.h"
#include "plot.h"
#include "param.h"
#include "events.h"
#include "vegas.h"
#include "mc_menu.h"
#include "4_vector.h"

static int sub_men__(void)
{
    int  n, npr, mode=0;
    char * strmen;
    void * pscr = NULL;
    int width,width_;
 
    if (nprc_ext > 1)
    {
       width=0;
       for(npr = 1; npr <= nprc_ext; ++npr)
       for(n=1;n<=nin_ext+nout_ext;n++) 
        width=MAX(width,strlen(pinf_ext(npr,n,NULL)));
       
       width++;
       width_=6+width*(nin_ext+nout_ext);
          
       strmen=malloc(2+nprc_ext*width_);
 
       for(n=1;n<=width_*nprc_ext;n++) strmen[n]=' ';
       strmen[0]= width_;
       strmen[1+nprc_ext*width_]=0;

       for(npr = 1; npr <= nprc_ext; ++npr)
       { 
         for(n=1;n<=nin_ext;n++) 
         { char *s=pinf_ext(npr, n,NULL);
           memcpy(strmen+(npr-1)*width_+2+(n-1)*width ,s,strlen(s));
         }                

         memcpy(strmen+(npr-1)*width_+2+(nin_ext)*width ," -> ",4);

         for(n=nin_ext+1;n<=nin_ext+nout_ext;n++) 
         { char* s=pinf_ext(npr, n,NULL);
             memcpy(strmen+(npr-1)*width_+6+(n-1)*width ,s,strlen(s));
         }                
       }         
       menu1(54,4,"Subprocesses",strmen,NULL,&pscr,&mode);
       free(strmen);
    }   
    if (mode) 
    {  put_text(&pscr);
       proces_1.nsub = mode;
       wrtprc_();
       if(nin_ext==2)initStrFun(0);
       return 1;
    } 
    return 0;
} /* sub_men__ */



static void f7_prog(int mode)
{ int pos=1;
  void *pscr=NULL;
  if(mode>2) 
  { messanykey(10,15," Highlight the corresponding\n"
                     "structure function");
    return;
  }     

  if(!sf_num[mode-1]) return;
  
  f3_key[4]=NULL;

  for(;;)
  {  static double xMin=0.0, xMax=1.0, scale = 10;
     static int nPoints=100;
     double f[150];
     
     char strmen[]="\030 "
                  " x-Min = XXX            "
                  " x-Max = YYY            "
                  " Npoints = NNN          "
                  " QCD-scale= QQQ         "
                  " Display plot           ";
     
     improveStr(strmen,"XXX","%.3f",xMin);
     improveStr(strmen,"YYY","%.3f",xMax);
     improveStr(strmen,"NNN","%d",nPoints);
     improveStr(strmen,"QQQ","%.1fGeV",scale); 

     menu1(54,14,"",strmen,"n_alpha_view",&pscr,&pos);

     switch(pos)
     {  case 0: f3_key[4]=f7_prog; 
                return;
        case 1:
          correctDouble(55,18,"xMin = ",&xMin,1);                  
          break; 
        case 2:
          correctDouble(55,18,"xMax = ",&xMax,1);                  
          break; 
        case 3:
          correctInt(50,18,"nPoints = ",&nPoints,1);
          break; 
        case 4: 
          correctDouble(50,18,"QCD-scale = ",&scale,1);
          break;
        case 5:
         if(xMin>=0 && xMax>xMin && xMax<=1 
            && nPoints>=3 && nPoints<=150 && scale>0.5)
         {
           void * screen;
           double dx=(xMax-xMin)/(2*nPoints);
           int i;
           get_text(1,1,maxCol(),maxRow(),&screen);
           for(i=0;i<nPoints;i++)
           {  double x=xMin+(i+0.5)*(xMax-xMin)/nPoints;
              f[i]=strfun_(mode,x,scale)*pow(1-x,sf_be[mode-1]-1.);
           }
           
           {
              char p_name[10], mess[STRSIZ];
              strcpy(p_name,pinf_ext(proces_1.nsub,mode,NULL));
              strcat(p_name,"(x)");
              strFunName(mode,mess);
              trim(mess);
              sprintf(mess+strlen(mess)," [QCD-scale = %.1f GeV]",scale); 
              plot_0(xMin+dx,xMax-dx,nPoints,f,NULL,mess,"x",p_name);  
           }
           put_text(&screen);
         } else messanykey(16,5," Correct input is \n"
                                "  0<=xMin<xMax<=1,\n"
                                " QCD-scale > 0.5 GeV\n"
                                " 3<=nPoints<=150");    
         break;    
      }
   }
}


static int  in_setting(void)
{
  int mode=1;
  void * pscr=NULL;    
  double Pcm; 
  void (*f7_tmp)(int)=f3_key[4];
  char * f7_mess_tmp= f3_mess[4];
  char sf_txt[STRSIZ];
  double mass[2];
  int i;
  int returnCode=0;

  if(nin_ext == 1)
  {  correctDouble(50,12,"Enter new value ",&inP1,1);
     returnCode=1;
     return returnCode;
  }    
  for(i=0;i<2;i++) 
  if(sf_num[i])mass[i]=sf_mass[i];else pinf_ext(proces_1.nsub,i+1,mass+i);
   
/* **   menu loop */

  for(;;)
  {    
    char strmen[] = "*"
    " S.F.1: First_structure_function                "                       
    " S.F.2: Second_structure_function               "
    " First  particle momentum[GeV] = PPP1           "
    " Second particle momentum[GeV] = PPP2           ";        
    Pcm=va_ext[0];
      
    strmen[0]=strlen(strmen)/4;           
      
    strFunName(1,sf_txt); improveStr(strmen,"First","%-40.40s", sf_txt);
    strFunName(2,sf_txt); improveStr(strmen,"Second","%-40.40s",sf_txt);
    improveStr(strmen,"PPP1","%-10.4G",inP1);
    improveStr(strmen,"PPP2","%-10.4G",inP2);

    f3_key[4]=f7_prog;   f3_mess[4]="Plot";
    menu1(30,7,"",strmen,"n_in_*",&pscr,&mode);
    f3_key[4]= f7_tmp;  f3_mess[4]=f7_mess_tmp;
   

    switch(mode)
    { case 0:
         for(i=0;i<2;i++) 
         if(sf_num[i])mass[i]=sf_mass[i];
         else pinf_ext(proces_1.nsub,i+1,mass+i);         

         if((mass[0]==0 && inP1<=0)|| (mass[1]==0 && inP2<=0)) 
           messanykey(10,10,"For massless particle\nmomentum should be positive\n");
         else 
         {
           initStrFun(0);                                                                                                    
           return returnCode;
         } break;
      case 1:
      case 2: if(sf_menu(mode))
              { initStrFun(mode);            
                returnCode=returnCode|3;
              } 
              break;
      case 3: correctDouble(50,12,"Enter new value ",&inP1,1);
              returnCode=returnCode|1; break;
      case 4: correctDouble(50,12,"Enter new value ",&inP2,1); 
              returnCode=returnCode|1; break;
    }
  }
} /* in_setting */




static  int w_men__(void)
{
    int key =1;
    void * pscr=NULL;     
L1:
   {
      char strmen[] ="\030"
                      " Gauge invariance  XXX  "
                      " S-dependence      YYY  "
                      " T-channel widths  ZZZ  " ;   

      if(gwidth_ext) improveStr(strmen,"XXX","ON");
                   else improveStr(strmen,"XXX","OFF");
      if(rwidth_ext) improveStr(strmen,"YYY","ON");
                   else improveStr(strmen,"YYY","OFF");
      if(twidth_ext) improveStr(strmen,"ZZZ","ON");
                   else improveStr(strmen,"ZZZ","OFF");
                          
      menu1(54,6,"",strmen,"n_width_*",&pscr ,&key);
   }    
   
   switch(key)
   { case 0:  return 0;
     case 1:  gwidth_ext = ! gwidth_ext; break;
     case 2:  rwidth_ext = ! rwidth_ext; break;
     case 3:  twidth_ext = ! twidth_ext; break; 
   }    
    goto L1;
} /* w_men__ */

static int checkEnergy(void)
{  int i;
   double ms,m_;

   for(i=nin_ext+1,ms=0; i<=nin_ext+nout_ext;i++)
   {  
       pinf_ext(proces_1.nsub,i,&m_);
       ms+=m_;
   }
 
   if(nin_ext==1)
   { 
      pinf_ext(proces_1.nsub,1,&m_);
      if(m_<=ms) return 1;
   } else 
   {                                                         
     double S=0,m1,m2;
     pinf_ext(proces_1.nsub,1,&m1);
     pinf_ext(proces_1.nsub,2,&m2); 
     incomkin(m1,m2,inP1,inP2,&S,NULL,NULL);
     if(S <= ms) return 1;
   }
   return 0;

}


void monte_carlo_menu(void)
{
   int r=0;
   int mode=1;
   void * pscr=NULL;
   void * pscr_mem=NULL;
   char menutxt[]="\030"
                  " Subprocess             "
                  " IN state               "
                  " Model parameters       "
                  " Constrains             "
                  " QCD coupling           "
                  " Breit-Wigner           "
	          " Cuts                   "
                  " Kinematics             "
                  " Regularization         "
                  " Vegas                  "
                  " Generate events        "
                  " Simpson                ";
 
   get_text(1,10,80,24,&pscr_mem);
   wrtprc_();
   for(;;)
   {  
      goto_xy(4,3); clr_eol();
      scrcolor(Red,BGmain);    print("(sub)Process: ");
      scrcolor(FGmain,BGmain); print(proces_1.proces);
      goto_xy(4,4); clr_eol();
      scrcolor(Red,BGmain);    print("Monte Carlo session: ");
      scrcolor(Black,BGmain);  print("%d",nSess);
             if(integral.old)  print("(continue)"); 
                         else 
      {   print("(begin)");
          scrcolor(FGmain,BGmain);                 
          clrbox(1,8,53,maxRow()-2);      
      }
                   
      if(nin_ext!=2||nout_ext!=2||sf_num[0]||sf_num[1])menutxt[menutxt[0]*11+1]=0;
      else menutxt[menutxt[0]*10+1]=' '; 

      r=r|menu3(54,4,"",menutxt,"n_mc_*",&pscr, &mode);

      switch (mode)
      { 
        case  0: put_text(&pscr_mem); return;
        case  1: r=r|(3*sub_men__()); break;
        case  2: r=r|in_setting(); break;
        case  3: r=r|change_parameter(54,7);  break;
        case  4: show_depend(54,7); break;
        case  5: r=r|qcdmen_();  break;
        case  6: w_men__();      break;
        case  8: r=r|entkin_();  break;
        case  7: do r=r|(3*edittable(1,4,&cutTab,1,"n_cut",0));
                 while (fillCutArray()); 
                 break;                   
        case  9: do r=r|(2*edittable(1,4,&regTab,1,"n_reg",0)); 
                 while(fillRegArray());
                 break;    
        case 10: 
        case 11:
        case 12: if(fillCutArray()) 
                   {messanykey(15,15,"Can not evaluate cuts limlts"); break;}

                 if(checkEnergy())   
                 { messanykey(15,15,"Energy is too small!");
                      break;
                 }
                  
                if(mode==12) 
                {  double m1,m2,Pcm;
                   pinf_ext(proces_1.nsub,1,&m1); 
                   pinf_ext(proces_1.nsub,2,&m2); 
                   incomkin(m1,m2,inP1,inP2,NULL,&Pcm,NULL);  
                   cs_numcalc(Pcm); 
                   break;
                } else if(fillRegArray()) 
                {  messanykey(15,15,
                       "Can not evaluate regularization paremeters");
                   break;    
                }
   
                if(mode==10) if(r&2) runVegas(1); else  runVegas(0);
                if(mode==11) if(r&2) runEvents(1);else  runEvents(0);  
                 
                r=0;  
                break;
                 
      }


      if((r&1) && integral.old) 
      { 
         messanykey(15,15,
           "Some parameters where changed.\nSo integral and statictics for\n"
           "distribushions is forgotten!\nSession number is increased.");
         integral.n_it=0;
         clearHists();
         integral.old=0;
         nSess++;
      } 

   }
}
