#ifndef __VEGAS__
#define __VEGAS__


typedef  struct vegasGrid 
{
   
int ndim,     /* number of dimensions */ 
    ndmx;   
    double * x_grid;
    double * c_grid;
} vegasGrid;
        
extern vegasGrid *  vegas_init
(int dim,  /* number of dimensions */
 int ndmx   /* size of grid */
);

extern void vegas_finish( vegasGrid * vegPtr);

extern int vegas_int(vegasGrid * vegPtr, 
 long ncall0,                       /* number of integrand calls */
 double alph,                       /* rate of grid improvement  */
 double(*fxn)(double *,double),     /* integrand */
 double *ti,                        /* integral estimation */ 
 double *tsi                        /* standard deviation */
);


extern int vegas_max(
vegasGrid * vegPtr, 
long  nCubs, 
long nRandom,
long nSimplex,
double (*fxn)( double *,double), 
double milk,
double * eff,
float * fmax
);


extern int vegas_events(
vegasGrid * vegPtr, 
long  nCubs, 
long  nEvents,
double gmax,
long nSimplex, 
double (*fxn)( double *,double), 
void (*out)(long ,int,char*),
float * fmax,
double * eff,  /* efficiency */
double * rmax, /* max reached */
double * mult, /* partion of multiple events */
double * neg   /* partion of events with negative weght */
);

void  generateVegasCubs(vegasGrid * vegPtr,long * nCubs);

#endif
