#ifndef __PDF__
#define __PDF__

#include <stdio.h>
#include <string.h>
#include<stdlib.h>
#include<math.h>

typedef struct pdfList
{ struct pdfList * next; 
  char *  name;      /* title name of distribution             */     
  char * file;       /* name of file where it is stored        */
  int   position;    /* ordering number of parton in the list of functions*/
} pdfList; 

typedef struct pdfStr
{ double mass;       /* mass of composite particle             */
  int  nq;           /* number of points in Q-scale grid       */ 
  int  nx;           /* number of points in X-scale grid       */
  int  lin;          /* flag to detect linear extrapolation    */
  double * x_grid;   /* data for the X-grid                    */
  double * q_grid;   /* log() data for the Q-grid              */
  double x_min;
  double x_max;
  double q_min;
  double q_max;      /* boundaries for x and q arguments       */
  double * alpha;    /* data for QCD-alpha(Q) corresponding to */ 
                     /* the Q-grid points*/ 
  double * strfun;   /* data for interpolation of distibution corresponding */
                     /* to  (Q-grid)*(X-grid) points;          */ 
                     /* index of (X-grid) is rinning first     */
  double pow0;       /* factor x^pow *(1-x)^pow1  must be      */   
  double pow1;       /* applied after interpolation            */ 
  int  approx;
} pdfStr;  

extern void   delPdfList(pdfList * list);

extern void   makePdfList(char * file, char * parton, pdfList ** list);
                     /* scan 'file' to detect does it contain  */
                     /* data for 'parton'. If yes, the         */
                     /* corresponding information is added to 'list' */

extern void   delPdfList(pdfList * list);
                     /* free  memory allocated for 'list' */
                     
extern int    getPdfData(char * file, int n_parton, pdfStr * data );
                     /* read 'file' and  fill items of  'data' */ 

extern void   freePdfData( pdfStr * data);
                    /* free  memory allocated for data items   */
                    /* and assigne NULL to  them.              */

extern double interFunc(double x, double q, pdfStr * W); 
                     /* interpolates data for given x and q    */ 
                     /* according to information stored in W.  */
                     /* result should be multiplied by the     */  
                     /* power factors later on                 */
extern double interAlpha(double q, pdfStr * W );
                     /* interpolates data for QCD-alpha(Q)     */

#endif
