/*
 Copyright (C) 2002, Alexander Pukhov pukhov@theory.sinp.msu.ru
*/
#include "syst.h"
#include "num_out.h"  
#include "alphas2.h"
#include "crt_util.h"
#include "plot.h"
#include "4_vector.h"
#include "kinaux.h"
#include "const.h"
#include "strfun.h"
#include "sf_pdf.h"
#include "read_func.h"
#include "phys_val.h"
#include "parser.h"


static double alpha3(double Q, double lambda, int nf)
{
 double b0=11-nf*2./3., b1=51-nf*19./3., b2=2857-nf*(5033./9.-nf*325./27.);
 double lg=2*log(Q/lambda), lg2=log(lg), x=2*b1/(b0*b0*lg);

 return 4*M_PI*(1-x*(lg2-x*((lg2-0.5)*(lg2-0.5)+b2*b0/(8*b1*b1)-1.25)))/(b0*lg);
}

static double getLambda(double alpha, double M, int nf)
{
 double b0=11-nf*2./3., b1=51-nf*19./3., b2=2857-nf*(5033./9.-nf*325./27.);
 double lambda0=M*exp(-2*M_PI/(b0*alpha));
 double lambda1;

int i;
 for(i=0;i<5;i++)
 {  double lg=2*log(M/lambda0), lg2=log(lg), x=2*b1/(b0*b0*lg);
    lambda1=M*exp(
   -2*M_PI*(1-x*(lg2-x*((lg2-0.5)*(lg2-0.5)+b2*b0/(8*b1*b1)-1.25)))/(b0*alpha)
                 );
   if(fabs(lambda0-lambda1)<1.E-4) return lambda1;
   lambda0=lambda1;
 }
}


static double qcd_lambda5=0.200;

static char scale_str[61]="91.187";

static double alpha_2(double dscale)
{
   static double lambda[7] = { 0.,0.,0.,0.,0.,0.,0.};
   int nf;

   if(alphaMode) return alpha_pdf(dscale);

#define  XMB 4.3
#define  XMC 1.3
#define  XMTOP 175.


    if (qcd_lambda5 != lambda[5]) 
    {
        double alpha;
        double C=7./(72.*M_PI*M_PI);
	lambda[5] = qcd_lambda5;
	
	alpha=alpha3(XMB,  qcd_lambda5, 5); alpha=alpha*(1+C*alpha); 
	lambda[4] = getLambda(alpha, XMB, 4);

	alpha=alpha3(XMTOP,qcd_lambda5, 5); alpha=alpha*(1-C*alpha);
	lambda[6] = getLambda(alpha, XMTOP, 6);	
/*printf("Lambdas(4,5,6)=(%f %f %f)\n",lambda[4],lambda[5],lambda[6]);*/	
    }

    if(dscale > XMTOP) nf=6; else if(dscale < XMB) nf=4; else nf=5;
    return alpha3(dscale, lambda[nf], nf); 
} 

static int qq0(char *s, double *v) 
{
  char key;
  char plist[20];
  if (isdigit(*s)) { sscanf(s,"%lf",v); return 1;}
  if(checkPhysVal(s,&key,plist))
  {  *v=100;
     return 1;
  }  else  return 0;
}



int qcdmen_(void)
{
   void * pscr=NULL;
   int mode;
   int returnCode=0;
   
   initStrFun(0);
L10:
    {
      char strmen[]="\032"
      " QCD Lambda5= XXX         "           
      " Q[Gev] = YYY             "
      " Alpha(Q) plot            ";
      
      if(alphaMode)  improveStr(strmen,"QCD","Defined via pdf-file");
      else    improveStr(strmen,"XXX","%-.3lgGeV",qcd_lambda5);

      improveStr(strmen,"YYY","%-.16s", scale_str);          
      menu1(52,8,"QCD alpha",strmen,"n_alpha",&pscr,&mode);
    }
    switch (mode) 
    { case 0: return returnCode;
      case 1:
         if(alphaMode) messanykey(20,20,"  You have implemented "
              "a distribution function,\n"
              " which contains his own definition of Alpha_QCD");    
         else
         {  goto_xy(50,12);
            if(correctDouble(3,15,"Enter new value ",&qcd_lambda5,1)) returnCode=1;
         }
         break;
      case 2:
         { int npos=1,rc;
           do
           {  double  dscale;
              goto_xy(2,12); print("QCD scale: ");
              if(str_redact(scale_str,npos,60)==KB_ENTER) returnCode=1;
              goto_xy(2,12); clr_eol();
              rc=calcExpression(scale_str, qq0, &dscale);
              if(rc && rc != cannotevaluate)
              { npos=rderrpos;
                if(rc==unknownidentifier) messanykey(10,10," Unknown parameter");
                else messanykey(10,10," Syntax error");
              }
           }  while(rc && rc != cannotevaluate);
         }  
	 break;
      case 3:
	{ void * screen;
	  int i;
	  double f[150];

	  static double qMin=1, qMax=1000;
	  static int nPoints=100;
	  
	  get_text(1,1,maxCol(),maxRow(),&screen);

          if(correctDouble(40 ,15 ,"Q_min=",&qMin,0)&& qMin>=0.5  
          && correctDouble(40 ,16 ,"Q_max=",&qMax,0)&& qMax>qMin
          && correctInt(33,17,"number of points=" ,&nPoints,0)
          && nPoints>3&& nPoints<=150)
	  {
	  for(i=0;i<nPoints;i++) f[i]=alpha_2(qMin+i*(qMax-qMin)/(nPoints-1)); 
	  plot_0(qMin,qMax,nPoints,f,NULL, " ", "Q [GeV]", "Alpha(Q)");
	  } else  messanykey(40,18,
	          " Correct input is \n"
	          " 0.5<= Q_min <Q_max\n"
	          " number of points <=150 and >=4");                                                 
	  put_text(&screen);
	}
	
    } 
    goto L10;
} /* qcdmen_ */

int w_qcd__(FILE * mode)
{
  fprintf(mode,"Lambda5= %E  Scale= %s", qcd_lambda5, scale_str);
  return 0;
}

void i_qcd(void) { strcpy(scale_str,"91.187"); }
 
int r_qcd__(FILE *mode)
{
  fscanf(mode," Lambda5= %lf  Scale= %s", &qcd_lambda5, scale_str);
  return 0;
}

/* ********************************************************************* */
/*    This subroutine is called during phase space integration        * */
/*      (during BASES and SPRING run)                                 * */
/*      for each phase space point after calculation particles        * */
/*      momenta and just before calculation of structure functions    * */
/*      and squared matrix element.                                   * */
/*                                                                    * */
/*    It can be used, for example, to provide QCD running strong      * */
/*      coupling constant. In the program there is used the notation  * */
/*                           GG                                       * */
/*      for QCD coupling constant.                                    * */
/* ***************************************************************** */
void alf_(double q)
{
    int i__1;
    int k;

/* ****** search for QCD coupling constant among process parameters */
    i__1 = nvar_ext;
    for (k = 1; k <= i__1; ++k) 
    {
	if (strcmp("GG", varName_ext[k]) == 0) 
	{   va_ext[k]= sqrt(4*M_PI *  alpha_2(q));
	    return;
	} 
    }
} /* alf_ */

/* ************************************************************* */
/*   This subroutine user can call to evaluate the transfered * */
/*     momentum scale of the process - could be necessary for * */
/*     structure function interface.                          * */
/*                                                            * */
/*   In the example from STRFUN.F this subroutine is called   * */
/*     for the evaluation of transfered momentum scale.       * */
/*   NSCALE = 0 for t-type, and =1 for s-type of              * */
/*     transfered momentum scale.                             * */
/* ************************************************************* */


static int qq1(char *s,double *v) 
{
  char key;
  char plist[20];

  if (isdigit(*s)) { sscanf(s,"%lf",v); return 1;}
  checkPhysVal(s,&key,plist); 
  *v=calcPhysVal(key,plist);
  return 1;   
}

double scale_(void)
{
   double dscale;
   if(calcExpression(scale_str ,qq1, &dscale))
   {  fprintf(stderr, " ERROR in evaluation of  QCD scale\n");
      exit(0);
   }
    
   if (dscale < .3f)  dscale = .3f;
   return dscale;
} /* scale_ */
