#include"f2c.h"
#include<math.h>

double z_abs(doublecomplex * z)
{ return sqrt(z->r*z->r + z->i*z->i);}

void z_div(doublecomplex*res,doublecomplex*n,doublecomplex*d)
{  double den=d->r*d->r + d->i * d->i;
   res->r = (n->r * d->r + n->i * d->i)/den;
   res->i = (n->i * d->r - n->r * d->i)/den;
}

void pow_zi(doublecomplex * res, doublecomplex * x, long* nn)
{
 int k;
 double pows2r=x->r;
 double pows2i=x->i; 
 int n=*nn;
 
 res->r=1;
 res->i=0;
 
 for(k=1; k<=n; k*=2)
 { if(k!=1)
   { double tmpr=pows2r;
     double tmpi=pows2i;
     pows2r = tmpr*tmpr -  tmpi* tmpi;
     pows2i = 2*tmpr*tmpi;
   }                
   if(k&n)
   {  double tmpr=res->r;
      double tmpi=res->i;  
      res->r =  tmpr*pows2r - tmpi*pows2i;
      res->i =  tmpr*pows2i + tmpi*pows2r; 
   }
 
 } 

} 


void z_log(doublecomplex * res, doublecomplex * z)
{ double zr=z->r;
  double zi=z->i;

  if( zi==0.)
  { if(zr >0) { res->i=0;res->r=log(zr); return; }
    else        { res->i=M_PI/2;res->r=log(-zr); return;}
  } else 
  { double n=sqrt(zr*zr + zi*zi);
    int sgn=1;
    int mir=0;
    if(zi<0.) {sgn=-1; zi=-zi;}
    if(zr<0.) {mir=1;  zr=-zr;}

    if(zi<zr) res->i=asin(zi/n); else res->i=acos(zr/n);
    
    if(mir) res->i=M_PI-res->i;
    res->i *= sgn;
    res->r=log(n);
  }
} 
/*
void main(void)
{     
   doublecomplex z,res;
   int i; 
   for(i=0;i<50;i++)
   {  double fi=2*i*M_PI/50;
      z.r=cos(fi);
      z.i=sin(fi);
      z_log(&res,&z);
      printf("fi=%f Im(res)=%f\n",fi,res.i);   
   }
}
*/
