#include<math.h>
#include<stdio.h>
#include"fhf.h"
#include "f2c.h"

static double msfkt(double * msusytl, double * msusytr,double * mtrun)
{
    /* System generated locals */
    double d__1, d__2, d__3, d__4, d__5, d__6;

    d__1 = *msusytl;
    d__2 = *msusytr;
    d__3 = *mtrun;
    d__4 = *msusytl;
    d__5 = *msusytr;
    d__6 = *mtrun, d__6 *= d__6;
    return   sqrt(sqrt(d__1 * d__1 * (d__2 * d__2) + d__3 * d__3 * (d__4 * 
	      d__4 + d__5 * d__5) + d__6 * d__6));
} 



static void matmult( double *a, double * b, double * c)
{
    c[0] = a[0] * b[0] + a[2] * b[1];
    c[2] = a[0] * b[2] + a[2] * b[3];
    c[1] = a[1] * b[0] + a[3] * b[1];
    c[3] = a[1] * b[2] + a[3] * b[3];
} /* matmult_ */


static void diagonalization(double * a,double *  b,double *  c,  double * d)
{
    double e[4];	
    matmult(a, b, e);
    matmult(e, c, d);
} /* diagonalization_ */


/* ------------------------------------------------------------------------ */
/*     subroutine for the fast (and approximate) calculation of the */
/*     neutral CP-even Higgs-boson masses in the MSSM */
/*     Two approaches are used: */
/*     1.) express mlh^2 through a closed formula. Here problems might */
/*         arise for small MA */
/*     2.) the Higgs mass matrix ist determined numerically up to 2-loop, */
/*         the diagonalisation yields the two Higgs masses */
/* Subroutine */ void mhiggslle(
 double * msusytl, 
 double *msusytr, 
 double *mtlr, 
 double *mblr, 
 double *mt, 
 double *mtrun, 
 double *mb, 
 double *mst1, 
 double *mst2, 
 double *stt, 
 double *ma, 
 double *tb, 
 double *alpha, 
 double *gf, 
 double *as, 
 double *cf, 
 double *el, 
 double *mz, 
 double *mw, 
 double *mue, 
 double *mlhlle1, 
 double *mlhlle2, 
 double *mlhllediag1, 
 double *mlhllediag2, 
 double *mhhllediag1, 
 double *mhhllediag2, 
 double *alphadiag1, 
 double *alphadiag2, 
 double *mhp)
{
    /* System generated locals */
    double d__1, d__2, d__3, d__4, d__5, d__6, d__7, d__8, d__9, d__10, 
	    d__11, d__12, d__13, d__14, d__15, d__16, d__17, d__18, d__19, 
	    d__20, d__21, d__22, d__23, d__24, d__25, d__26, d__27, d__28, 
	    d__29, d__30, d__31, d__32, d__33, d__34, d__35, d__36, d__37, 
	    d__38, d__39, d__40, d__41, d__42, d__43, d__44, d__45, d__46, 
	    d__47, d__48, d__49, d__50, d__51;


    /* Local variables */
    static double pref, delmlhsq, rott[4]	/* was [2][2] */, m11botmix, 
	    m12botmix, m22botmix, b, mlhlle1sq, mlhlle2sq, mhhllediag1sq, 
	    mhhllediag2sq, mlhllediag1sq, mlhllediag2sq, m22log, theta, 
	    m11top, m12top, m22top;
	    
    static double mhnondiag[4]	/* was [2][2] */, msusy, cb, eb, al, 
	    nc, pb, sb, ng, pf, et, pg, m11, m12, mhdiag[4]	/* was [2][2] 
	    */, msusy2, pt, sw, cb2, c2b, m11rest, m12rest, m22rest, ma2, sb2,
	     p1h, p2h, cw2, ms1, ms2, mt2, mt4, mw2, mz2, sw2, sw4, m221loop, 
	    m222loop, ms12, ms22, pgp, rot[4]	/* was [2][2] */, ttt, vvv;
    static  long  mwmzfak;
    static double xttilde, p2hp;


/*     meaning of variables: */
/*     msusyt[l,r]: SSB terms in the stop mass matrix */
/*     ms[1,2]: The Susy mass scale: ms1^2 = Msusy^2 + MT^2 (for 1-loop contr.) */
/*                                   ms2^2 = Msusy^2 + MTrun^2 (2-loop contr.) */
/*     ms[1,2]2: == ms[1,2]^2 */
/*     mtlr: the off-diagonal entry in the stop mass matrix */
/*     mt, mb: fermion pole masses */
/*     mtrun: running top mass, can be used for 2-loop contribution */
/*     ma, tb: the usual Higgs sector varialbes M_A and tan(beta) */
/*     gf: Fermi's constant */
/*     as: strong coupling constant at the scale mt */
/*     cf = 4/3 */
/*     el: electromagnetic coupling, derived from gf */
/*     mz, mw: gauge boson masses */
/*     mlhlle[1,2]: the mass of the light Higgs boson in approach 1 */
/*     m[l,h]hllediag[1,2]: the Higgs masses in approach 2 */
/*      write(*,*) 'LLE parameters:' */
/*      write(*,*) mt, mtrun */
/*      write(*,*) mb */
/*      write(*,*) real(mtlr), real(mblr), real(mue) */
    d__1 = *el;
    al = d__1 * d__1 / (M_PI * 4.);
    d__1 = *mw;
    d__2 = *mz;
    cw2 = d__1 * d__1 / (d__2 * d__2);
    d__1 = *mw;
    d__2 = *mz;
    sw2 = 1. - d__1 * d__1 / (d__2 * d__2);
    sw = sqrt(sw2);
    d__1 = sw2;
    sw4 = d__1 * d__1;
    et = .66666666666666663;
    eb = -.33333333333333331;
    b = atan(*tb);
    sb = sin(b);
    d__1 = sb;
    sb2 = d__1 * d__1;
    cb = cos(b);
    d__1 = cb;
    cb2 = d__1 * d__1;
    c2b = cos(b * 2.);
    d__1 = *ma;
    ma2 = d__1 * d__1;
    d__1 = *mz;
    mz2 = d__1 * d__1;
    d__1 = *mw;
    mw2 = d__1 * d__1;
    d__1 = *mt;
    mt2 = d__1 * d__1;
/* Computing 4th power */
    d__1 = *mt, d__1 *= d__1;
    mt4 = d__1 * d__1;
    if (*msusytl == *msusytr) {
	d__1 = *msusytl;
	d__2 = *mt;
	ms1 = sqrt(d__1 * d__1 + d__2 * d__2);
	d__1 = *msusytl;
	d__2 = *mtrun;
	ms2 = sqrt(d__1 * d__1 + d__2 * d__2);
    } else {
	ms1 = msfkt(msusytl, msusytr, mt);
	ms2 = msfkt(msusytl, msusytr, mtrun);
    }
    d__1 = ms1;
    ms12 = d__1 * d__1;
    d__1 = ms2;
    ms22 = d__1 * d__1;
    d__1 = *mt;
    msusy2 = ms12 - d__1 * d__1;
    msusy = sqrt(msusy2);
    nc = 3.;
    ng = 3.;
    d__1 = et;
    pt = nc * (1. - et * 4. * sw2 + d__1 * d__1 * 8. * sw4);
    d__1 = eb;
    pb = nc * (eb * 4. * sw2 + 1. + d__1 * d__1 * 8. * sw4);
    d__1 = et;
    d__2 = eb;
    pf = nc * (ng - 1.) * (2. - sw2 * 4. + (d__1 * d__1 + d__2 * d__2) * 8. * 
	    sw4) + ng * (2. - sw2 * 4. + sw4 * 8.);
    pg = sw2 * 106. - 44. - sw4 * 62.;
    pgp = sw2 * 34. + 10. - sw4 * 26.;
/* Computing 4th power */
    d__1 = c2b, d__1 *= d__1;
    d__2 = c2b;
    p1h = d__1 * d__1 * -9. + (1. - sw2 * 2. + sw4 * 2.) * (d__2 * d__2);
    p2h = sw2 * 2. - 10. - sw4 * 2.;
    p2hp = 8. - sw2 * 22. + sw4 * 10.;
    theta = 0.;
    if (ma2 >= mz2) {
	theta = 1.;
    }
/* --> 1. approach: the 'direct' formula for mh2 */
    d__1 = *ma;
    d__2 = *mz;
/* Computing 4th power */
    d__3 = *ma, d__3 *= d__3;
/* Computing 4th power */
    d__4 = *mz, d__4 *= d__4;
    d__5 = *ma;
    d__6 = *mz;
    d__7 = sb;
/* Computing 4th power */
    d__8 = sb, d__8 *= d__8;
/* Computing 4th power */
    d__9 = *mt, d__9 *= d__9;
/* Computing 4th power */
    d__10 = *mt, d__10 *= d__10;
/* Computing 8th power */
    d__11 = *mtlr, d__11 *= d__11, d__11 *= d__11;
/* Computing 12th power */
    d__12 = ms1, d__12 *= d__12, d__12 *= d__12;
    d__13 = *mz;
    d__14 = *mt;
/* Computing 4th power */
    d__15 = *mz, d__15 *= d__15;
/* Computing 4th power */
    d__16 = *mt, d__16 *= d__16;
    d__17 = *mtlr;
    d__18 = *mt;
    d__19 = ms1;
    d__20 = *mz;
    d__21 = *mt;
    d__22 = ms1;
/* Computing 6th power */
    d__23 = *mtlr, d__23 *= d__23;
    d__24 = *mt;
    d__25 = ms1;
/* Computing 4th power */
    d__26 = *mt, d__26 *= d__26;
/* Computing 4th power */
    d__27 = ms1, d__27 *= d__27;
/* Computing 6th power */
    d__28 = ms1, d__28 *= d__28;
/* Computing 4th power */
    d__29 = *mtlr, d__29 *= d__29;
    d__30 = *mt;
    d__31 = ms1;
/* Computing 4th power */
    d__32 = *mt, d__32 *= d__32;
/* Computing 4th power */
    d__33 = ms1, d__33 *= d__33;
/* Computing 4th power */
    d__34 = ms1, d__34 *= d__34;
    d__35 = *ma;
    d__36 = *mz;
    d__37 = sb;
/* Computing 4th power */
    d__38 = *ma, d__38 *= d__38;
/* Computing 4th power */
    d__39 = *mz, d__39 *= d__39;
    d__40 = *ma;
    d__41 = *mz;
    d__42 = sb;
/* Computing 4th power */
    d__43 = sb, d__43 *= d__43;
    d__44 = *mw;
    d__45 = sb;
    mlhlle1sq = (d__1 * d__1 + d__2 * d__2 - sqrt(d__3 * d__3 + d__4 * d__4 - 
	    d__5 * d__5 * 2 * (d__6 * d__6) * (1 - d__7 * d__7 * 8 + d__8 * 
	    d__8 * 8))) / 2. + al * (d__9 * d__9) * (d__10 * d__10 * 
	    -3 * (d__11 * d__11) / (d__12 * (d__12 * d__12) * 
	    55.99999999999999) + (d__13 * d__13 * .25 / (d__14 * d__14) - 
	    d__15 * d__15 * .13750000000000001 / (d__16 * d__16)) + d__17 * 
	    d__17 * (1.5 - d__18 * d__18 * 3 / (d__19 * d__19 * 
	    4.) + 0. - d__20 * d__20 / (d__21 * d__21 * 2.)) / (d__22 *
	     d__22) + d__23 * (d__23 * d__23) * (d__24 * d__24 * -3 / (d__25 *
	     d__25 * 40.) + d__26 * d__26 * 3 / (d__27 * d__27 * (
	    float)10.) + 0.) / (d__28 * (d__28 * d__28)) + d__29 * d__29 * (
	    d__30 * d__30 / (d__31 * d__31 * 2.) - .125 - d__32 
	    * d__32 * 3 / (d__33 * d__33 * 8.) + 0. + 0.) / (d__34 * 
	    d__34)) * ((-(d__35 * d__35) + d__36 * d__36) * (1 - d__37 * 
	    d__37 * 2) / sqrt(d__38 * d__38 + d__39 * d__39 - d__40 * d__40 * 
	    2 * (d__41 * d__41) * (1 - d__42 * d__42 * 8 + d__43 * d__43 * 8))
	     + 1) / (d__44 * d__44 * 2. * M_PI * (d__45 * d__45) * sw2);
/* Computing 4th power */
    d__1 = *mt, d__1 *= d__1;
    d__2 = *mz;
    d__3 = sb;
    d__4 = *mt;
/* Computing 4th power */
    d__5 = *mw, d__5 *= d__5;
    d__6 = *mw;
    d__7 = *mz;
/* Computing 4th power */
    d__8 = *mz, d__8 *= d__8;
    d__9 = sb;
/* Computing 4th power */
    d__10 = *mt, d__10 *= d__10;
    d__11 = *ma;
    d__12 = *mz;
    d__13 = sb;
    d__14 = sb;
    d__15 = *mz;
    d__16 = *mt;
/* Computing 4th power */
    d__17 = *mw, d__17 *= d__17;
    d__18 = *mw;
    d__19 = *mz;
/* Computing 4th power */
    d__20 = *mz, d__20 *= d__20;
    d__21 = sb;
/* Computing 4th power */
    d__22 = *mt, d__22 *= d__22;
/* Computing 4th power */
    d__23 = *ma, d__23 *= d__23;
/* Computing 4th power */
    d__24 = *mz, d__24 *= d__24;
    d__25 = *ma;
    d__26 = *mz;
    d__27 = sb;
/* Computing 4th power */
    d__28 = sb, d__28 *= d__28;
    d__29 = *ma;
    d__30 = *mz;
    d__31 = sb;
    d__32 = *mz;
    d__33 = sb;
    d__34 = *mt;
/* Computing 4th power */
    d__35 = *mw, d__35 *= d__35;
    d__36 = *mw;
    d__37 = *mz;
/* Computing 4th power */
    d__38 = *mz, d__38 *= d__38;
    d__39 = sb;
    d__40 = sb;
/* Computing 4th power */
    d__41 = *mt, d__41 *= d__41;
/* Computing 4th power */
    d__42 = *ma, d__42 *= d__42;
/* Computing 4th power */
    d__43 = *mz, d__43 *= d__43;
    d__44 = *ma;
    d__45 = *mz;
    d__46 = sb;
/* Computing 4th power */
    d__47 = sb, d__47 *= d__47;
    d__48 = *mt;
    d__49 = ms1;
    d__50 = *mw;
    d__51 = sb;
    mlhlle1sq -= al * (d__1 * d__1) * (1.5 - d__2 * d__2 * 3 * (d__3 * 
	    d__3) / (d__4 * d__4 * 4.) + (d__5 * d__5 * 32 - d__6 * 
	    d__6 * 40 * (d__7 * d__7) + d__8 * d__8 * 17) * (d__9 * d__9) / (
	    d__10 * d__10 * 72.) + (d__11 * d__11 + d__12 * d__12) * 4 
	    * (d__13 * d__13) * (1 - d__14 * d__14) * (d__15 * d__15 * 3 / (
	    d__16 * d__16 * 8.) - (d__17 * d__17 * 32 - d__18 * d__18 *
	     40 * (d__19 * d__19) + d__20 * d__20 * 17) * (d__21 * d__21) / (
	    d__22 * d__22 * 72.)) / sqrt(d__23 * d__23 + d__24 * d__24 
	    - d__25 * d__25 * 2 * (d__26 * d__26) * (1 - d__27 * d__27 * 8 + 
	    d__28 * d__28 * 8)) + (-(d__29 * d__29) + d__30 * d__30) * (1 - 
	    d__31 * d__31 * 2) * (1.5 - d__32 * d__32 * 3 * (d__33 * 
	    d__33) / (d__34 * d__34 * 4.) - (d__35 * d__35 * 32 - 
	    d__36 * d__36 * 40 * (d__37 * d__37) + d__38 * d__38 * 17) * (
	    d__39 * d__39) * (1 - d__40 * d__40 * 2) / (d__41 * d__41 * (
	    float)72.)) / sqrt(d__42 * d__42 + d__43 * d__43 - d__44 * d__44 *
	     2 * (d__45 * d__45) * (1 - d__46 * d__46 * 8 + d__47 * d__47 * 8)
	    )) * log(d__48 * d__48 / (d__49 * d__49)) / (d__50 * d__50 * (
	    float)2. * M_PI * (d__51 * d__51) * sw2);
/* Computing 4th power */
    d__1 = *mz, d__1 *= d__1;
    d__2 = msusy;
    d__3 = *mz;
/* Computing 4th power */
    d__4 = *mb, d__4 *= d__4;
/* Computing 4th power */
    d__5 = *mz, d__5 *= d__5;
    d__6 = *mb;
    d__7 = *mz;
    d__8 = cos(b * 2);
    d__9 = cos(b);
    d__10 = sin(b);
/* Computing 4th power */
    d__11 = cos(b), d__11 *= d__11;
/* Computing 4th power */
    d__12 = sin(b), d__12 *= d__12;
    d__13 = *ma;
    d__14 = *mz;
    d__15 = cos(b * 2);
/* Computing 4th power */
    d__16 = cos(b * 2), d__16 *= d__16;
    d__17 = cos(b);
    d__18 = sin(b);
/* Computing 4th power */
    d__19 = cos(b), d__19 *= d__19;
/* Computing 4th power */
    d__20 = sin(b), d__20 *= d__20;
    d__21 = *mw;
    mlhlle1sq += al * (d__1 * d__1) * (log(d__2 * d__2 / (d__3 * d__3)) * (
	    d__4 * d__4 * 36 / (d__5 * d__5) - d__6 * d__6 * 18 * cos(b * 2) /
	     (d__7 * d__7) + ((1 - sw2 * 4 / 3. + sw4 * 8 / 9.) 
	    * 3 + (2 - sw2 * 4 + sw4 * 40 / 9.) * 6 + (2 - sw2 * 4 + 
	    sw4 * 8) * 3) * (d__8 * d__8) - (sw2 * 12 + 18 - sw4 * 16) * 2 * (
	    d__9 * d__9) * (d__10 * d__10) + (sw2 * 108 - 54 - sw4 * 64) * (
	    d__11 * d__11 + d__12 * d__12)) - theta * log(d__13 * d__13 / (
	    d__14 * d__14)) * (-((1 - sw2 * 2 + sw4 * 2) * (d__15 * d__15)) + 
	    d__16 * d__16 * 9 - (8 - sw2 * 22 + sw4 * 10) * 2 * (d__17 * 
	    d__17) * (d__18 * d__18) + (sw2 * 2 - 10 - sw4 * 2) * (d__19 * 
	    d__19 + d__20 * d__20))) / (d__21 * d__21 * 
	    23.99999999999999 * M_PI * sw2);
/* Computing 4th power */
    d__1 = *mb, d__1 *= d__1;
    d__2 = *mblr;
    d__3 = *mblr;
    d__4 = msusy;
    d__5 = msusy;
    d__6 = *mb;
    d__7 = *mz;
    d__8 = *mblr;
    d__9 = *mue;
    d__10 = tan(b);
    d__11 = *mblr + *mue * tan(b);
    d__12 = msusy;
    d__13 = *mw;
    mlhlle1sq += al * 3 * (d__1 * d__1 * 2 * (d__2 * d__2) * (1 - d__3 * d__3 
	    / (d__4 * d__4 * 11.99999999999999)) / (d__5 * d__5) - 
	    d__6 * d__6 * (d__7 * d__7) * cos(b * 2) * (d__8 * d__8 + (-(d__9 
	    * d__9 * (d__10 * d__10)) + d__11 * d__11) / 3.) / (d__12 *
	     d__12 * 2.)) / (d__13 * d__13 * 4. * M_PI * sw2);
    if (mlhlle1sq > 0.) {
	*mlhlle1 = sqrt(mlhlle1sq);
    } else {
	*mlhlle1 = 119.9999;
    }
/*      write(*,*) 'lle 2loop' */
    if (selec_1.selec2 >= 3) {
/*         write(*,*) '1-loop with mtrun => changed 2-loop formula' */
/* Computing 4th power */
	d__1 = *mt, d__1 *= d__1;
	d__2 = *ma;
	d__3 = *mz;
	d__4 = sb;
/* Computing 4th power */
	d__5 = *ma, d__5 *= d__5;
/* Computing 4th power */
	d__6 = *mz, d__6 *= d__6;
	d__7 = *ma;
	d__8 = *mz;
	d__9 = sb;
/* Computing 4th power */
	d__10 = sb, d__10 *= d__10;
/* Computing 4th power */
	d__11 = *mtlr, d__11 *= d__11;
/* Computing 4th power */
	d__12 = ms2, d__12 *= d__12;
	d__13 = *mtlr;
	d__14 = ms2;
	d__15 = ms2;
	d__16 = *mt;
	d__18 = ms2;
	d__19 = *mt;
	d__17 = log(d__18 * d__18 / (d__19 * d__19));
	d__20 = *mtlr;
	d__21 = ms2;
	d__22 = *mw;
	d__23 = M_PI;
	d__24 = sb;
	mlhlle2sq = mlhlle1sq + al * *as * (d__1 * d__1) * ((-(d__2 * d__2) + 
		d__3 * d__3) * (1 - d__4 * d__4 * 2) / sqrt(d__5 * d__5 + 
		d__6 * d__6 - d__7 * d__7 * 2 * (d__8 * d__8) * (1 - d__9 * 
		d__9 * 8 + d__10 * d__10 * 8)) + 1) * (*mtlr * 6 / ms2 - 
		d__11 * d__11 * 12 / (d__12 * d__12 * 17.) + (2. - 
		d__13 * d__13 * 3 / (d__14 * d__14)) * log(d__15 * d__15 / (
		d__16 * d__16)) - d__17 * d__17 * 3 - 4. + d__20 * d__20 * 8. 
		/ (d__21 * d__21)) / (d__22 * d__22 * 2. * (d__23 * 
		d__23) * (d__24 * d__24) * sw2);
    } else {
/*         write(*,*) '1-loop with mt pole => original 2-loop formula' */
/* Computing 4th power */
	d__1 = *mt, d__1 *= d__1;
	d__2 = *ma;
	d__3 = *mz;
	d__4 = sb;
/* Computing 4th power */
	d__5 = *ma, d__5 *= d__5;
/* Computing 4th power */
	d__6 = *mz, d__6 *= d__6;
	d__7 = *ma;
	d__8 = *mz;
	d__9 = sb;
/* Computing 4th power */
	d__10 = sb, d__10 *= d__10;
/* Computing 4th power */
	d__11 = *mtlr, d__11 *= d__11;
/* Computing 4th power */
	d__12 = ms1, d__12 *= d__12;
	d__13 = *mtlr;
	d__14 = ms1;
	d__15 = ms1;
	d__16 = *mt;
	d__18 = ms1;
	d__19 = *mt;
	d__17 = log(d__18 * d__18 / (d__19 * d__19));
	d__20 = *mw;
	d__21 = M_PI;
	d__22 = sb;
	mlhlle2sq = mlhlle1sq + al * *as * (d__1 * d__1) * ((-(d__2 * d__2) + 
		d__3 * d__3) * (1 - d__4 * d__4 * 2) / sqrt(d__5 * d__5 + 
		d__6 * d__6 - d__7 * d__7 * 2 * (d__8 * d__8) * (1 - d__9 * 
		d__9 * 8 + d__10 * d__10 * 8)) + 1) * (*mtlr * 6 / ms1 - 
		d__11 * d__11 * 3 / (d__12 * d__12 * 4.) + (-6 - d__13 
		* d__13 * 3 / (d__14 * d__14)) * log(d__15 * d__15 / (d__16 * 
		d__16)) - d__17 * d__17 * 3) / (d__20 * d__20 * 2. * (
		d__21 * d__21) * (d__22 * d__22) * sw2);
    }
    if (mlhlle2sq > 0.) {
	*mlhlle2 = sqrt(mlhlle2sq);
    } else {
	*mlhlle2 = 119.9999;
    }
/* ---------------------------------------------------------------------- */
/* --> 2. approach: the Higgs mass matrix */
/*      write(*,*) '2. approach' */
    d__1 = *el;
    d__2 = M_PI;
    pref = d__1 * d__1 * mz2 / (d__2 * d__2 * 96. * cw2 * sw2);
/* Computing 4th power */
    d__1 = *mw, d__1 *= d__1;
/* Computing 4th power */
    d__2 = *mz, d__2 *= d__2;
    mwmzfak = (d__1 * d__1 * 32. - mw2 * 40. * mz2 + d__2 * d__2 * 17.);
/*      write(*,*) '2. approach' */
/* --> the top sector at 1-loop */
    d__1 = *el;
    d__2 = M_PI;
    m11top = -(d__1 * d__1) / (mw2 * 288. * (d__2 * d__2) * sw2) * mwmzfak * 
	    cb2 * log(mt2 / ms12);
    d__1 = *el;
    d__2 = M_PI;
    m12top = d__1 * d__1 * cb / (sb * 288. * mw2 * (d__2 * d__2) * sw2) * (
	    mt2 * -27 * mz2 + mwmzfak * sb2) * log(mt2 / ms12);
    d__1 = *el;
    d__2 = M_PI;
/* Computing 4th power */
    d__3 = *mt, d__3 *= d__3;
/* Computing 4th power */
    d__4 = sb, d__4 *= d__4;
    d__5 = *mz;
    d__6 = *mt;
/* Computing 4th power */
    d__7 = *mz, d__7 *= d__7;
/* Computing 4th power */
    d__8 = *mt, d__8 *= d__8;
/* Computing 4th power */
    d__9 = *mt, d__9 *= d__9;
    d__10 = *mtlr / ms1;
    d__11 = *mt / ms1;
/* Computing 4th power */
    d__12 = *mt, d__12 *= d__12;
/* Computing 4th power */
    d__13 = *mtlr / ms1, d__13 *= d__13;
/* Computing 4th power */
    d__14 = *mt / ms1, d__14 *= d__14;
/* Computing 4th power */
    d__15 = ms1, d__15 *= d__15;
    d__16 = ms1;
/* Computing 6th power */
    d__17 = *mtlr / ms1, d__17 *= d__17;
/* Computing 6th power */
    d__18 = *mt / ms1, d__18 *= d__18;
/* Computing 4th power */
    d__19 = ms1, d__19 *= d__19;
    d__20 = ms1;
/* Computing 8th power */
    d__21 = *mtlr / ms1, d__21 *= d__21, d__21 *= d__21;
/* Computing 8th power */
    d__22 = *mt / ms1, d__22 *= d__22, d__22 *= d__22;
/* Computing 4th power */
    d__23 = ms1, d__23 *= d__23;
    d__24 = ms1;
/* Computing 4th power */
    d__25 = *mt, d__25 *= d__25;
    m22top = d__1 * d__1 / (sb2 * 288. * mw2 * (d__2 * d__2) * sw2) * ((d__3 *
	     d__3 * -108. + mt2 * 54. * mz2 * sb2 - mwmzfak * (d__4 * d__4)) *
	     log(mt2 / ms12) + (d__5 * d__5 * 2. / (d__6 * d__6) - d__7 * 
	    d__7 * 1.1000000000000001 / (d__8 * d__8)) * 9. * (d__9 * d__9) + 
	    d__10 * d__10 * 9. * (d__11 * d__11) * (d__12 * d__12 * -6. + 
	    ms12 * 4. * (mt2 * 3. - mz2)) + d__13 * d__13 * 
	    .90000000000000002 * (d__14 * d__14) * (d__15 * d__15 * -10. + 
	    d__16 * d__16 * 4 * (mt2 * 10.) + mt2 * 15. * (mt2 * -2.)) + 
	    d__17 * (d__17 * d__17) * .25714285714285712 * (d__18 * (d__18 * 
	    d__18)) * (d__19 * d__19 * -21. + d__20 * d__20 * 12. * (mt2 * 7.)
	     + mt2 * 35. * (mt2 * -2.)) - d__21 * d__21 * 
	    6.1307634626116076e-7 * (d__22 * d__22) * (d__23 * d__23 * 
	    6291456. + d__24 * d__24 * (mt2 * -25165824.) + d__25 * d__25 * 
	    2. * 11010048.));
/*      write(*,*) '2. approach' */
/* --> all other sectors except for the sbottom mixing */
/* Computing 4th power */
    d__1 = *mb, d__1 *= d__1;
/* Computing 4th power */
    d__2 = *mz, d__2 *= d__2;
/* Computing 4th power */
    d__3 = cb, d__3 *= d__3;
    d__4 = *mb;
    d__5 = *mz;
    d__6 = cb;
    m11rest = pref * cb2 * ((nc * 12. * (d__1 * d__1) / (d__2 * d__2 * (d__3 *
	     d__3)) - nc * 6. * (d__4 * d__4) / (d__5 * d__5 * (d__6 * d__6)) 
	    + pb + pf + pg + p2h) * log(msusy2 / mz2) + theta * (p1h - p2h) * 
	    log(ma2 / mz2));
    d__1 = *mb;
    m12rest = -pref * sb * cb * ((nc * -3. * (d__1 * d__1) / (mz2 * cb2) + pb 
	    + pf + pgp + p2hp) * log(msusy2 / mz2) - theta * (p1h + p2hp) * 
	    log(ma2 / mz2));
    m22rest = pref * sb2 * ((pb + pf + pg + p2h) * log(msusy2 / mz2) + theta *
	     (p1h - p2h) * log(ma2 / mz2));
/*      write(*,*) '2. approach' */
/* --> the bottom mixing at 1-loop */
    d__1 = 1 / *mw;
    d__2 = *mb;
    d__3 = 1 / msusy;
    d__4 = *mz;
    d__5 = 1 / cb;
/* Computing 4th power */
    d__6 = *mb, d__6 *= d__6;
    d__7 = 1 / msusy;
    d__8 = 1 / msusy;
    m11botmix = al * (d__1 * d__1) * nc / sw2 * (-(d__2 * d__2 * (d__3 * d__3)
	     * (d__4 * d__4) * (*mtlr + *mue / tan(b)) * (*mblr + (*mtlr + *
	    mue / tan(b)) / 3.)) + d__5 * d__5 * 4. * (d__6 * d__6) * *mblr * 
	    (d__7 * d__7) * (*mtlr + *mue / tan(b)) * (1. - *mblr * (d__8 * 
	    d__8) * (*mtlr + *mue / tan(b)) / 12.)) / (M_PI * 8.);
    d__1 = 1 / *mw;
    d__2 = 1 / cb;
/* Computing 4th power */
    d__3 = *mb, d__3 *= d__3;
    d__4 = 1 / msusy;
    d__5 = 1 / msusy;
    d__6 = *mb;
    d__7 = 1 / msusy;
    d__8 = *mz;
    d__9 = *mue;
    d__10 = *mtlr + *mue / tan(b);
    m12botmix = -(al * (d__1 * d__1) * nc / sw2 * (d__2 * d__2 * 4. * (d__3 * 
	    d__3) * *mblr * (d__4 * d__4) * *mue * (1. - *mblr * (d__5 * d__5)
	     * (*mtlr + *mue / tan(b)) / 6.) - d__6 * d__6 * (d__7 * d__7) * (
	    d__8 * d__8) * (*mblr * (*mtlr + *mue * 2. / tan(b)) + (d__9 * 
	    d__9 + d__10 * d__10) / 3.) * tan(b)) / (M_PI * 16.));
    d__1 = 1 / *mw;
    d__2 = 1 / cb;
/* Computing 4th power */
    d__3 = *mb, d__3 *= d__3;
    d__4 = *mblr;
/* Computing 4th power */
    d__5 = 1 / msusy, d__5 *= d__5;
    d__6 = *mue;
    d__7 = *mb;
    d__8 = 1 / msusy;
    d__9 = *mz;
    m22botmix = al * (d__1 * d__1) * nc / sw2 * (-(d__2 * d__2 * 1. * (d__3 * 
	    d__3) * (d__4 * d__4) * (d__5 * d__5) * (d__6 * d__6) / 3.) - 
	    d__7 * d__7 * (d__8 * d__8) * *mue * (d__9 * d__9) * tan(b) * (*
	    mblr + *mue * tan(b) / 3.)) / (M_PI * 8.);
/* --> the top sector at 2-loop */
    if (selec_1.selec2 >= 3) {
/*         write(*,*) '1-loop with mtrun => changed 2-loop formula' */
/* Computing 4th power */
	d__1 = *mtrun, d__1 *= d__1;
	d__2 = sin(b);
/* Computing 4th power */
	d__3 = *mtlr, d__3 *= d__3;
/* Computing 4th power */
	d__4 = ms2, d__4 *= d__4;
	d__5 = *mtlr;
	d__6 = ms2;
	d__7 = ms2;
	d__8 = *mt;
	d__10 = ms2;
	d__11 = *mt;
	d__9 = log(d__10 * d__10 / (d__11 * d__11));
	d__12 = *mtlr;
	d__13 = ms2;
	d__14 = *mw;
	d__15 = M_PI;
	m22log = al * *as * (d__1 * d__1) / (d__2 * d__2) * (*mtlr * 6 / ms2 
		- d__3 * d__3 * 12 / (d__4 * d__4 * 17.) + (2. - d__5 *
		 d__5 * 3 / (d__6 * d__6)) * log(d__7 * d__7 / (d__8 * d__8)) 
		- d__9 * d__9 * 3 - 4. + d__12 * d__12 * 8. / (d__13 * d__13))
		 / (d__14 * d__14 * (d__15 * d__15) * sw2);
    } else {
/*         write(*,*) '1-loop with mt pole => original 2-loop formula' */
/* Computing 4th power */
	d__1 = *mt, d__1 *= d__1;
	d__2 = sin(b);
/* Computing 4th power */
	d__3 = *mtlr, d__3 *= d__3;
/* Computing 4th power */
	d__4 = ms2, d__4 *= d__4;
	d__5 = *mtlr;
	d__6 = ms2;
	d__7 = ms2;
	d__8 = *mt;
	d__10 = ms2;
	d__11 = *mt;
	d__9 = log(d__10 * d__10 / (d__11 * d__11));
	d__12 = *mw;
	d__13 = M_PI;
	m22log = al * *as * (d__1 * d__1) / (d__2 * d__2) * (*mtlr * 6 / ms2 
		- d__3 * d__3 * 3 / (d__4 * d__4 * 4.) + (-6 - d__5 * 
		d__5 * 3 / (d__6 * d__6)) * log(d__7 * d__7 / (d__8 * d__8)) 
		- d__9 * d__9 * 3) / (d__12 * d__12 * (d__13 * d__13) * sw2);
    }
/* $$$      write(*,*) 'Parameters in LLESub:' */
/* $$$      write(*,*) 'Msusy, MT, MtLR,' */
/* $$$      write(*,*) 'M22top1loop, M22rest, M22botmix, M22top2loop' */
/* $$$      write(*,*) real(msusy), real(mt), real(mtlr) */
/* $$$      write(*,*) real(m22top), real(m22rest), real(m22botmix), */
/* $$$     $           real(m22log) */
/* $$$      write(*,*) cf, el, al, sw, pi, sb, mtrun, mw, llexpansionp2mtrun */
/*     including the leading Yukawa term for the light Higgs mass */
/*     this term is taken from Carena, Espinosa, Quiros, Wagner */
/*     Nucl. Phys. B461 (1996) 407 */
/*    printf("adding Yukawa term\n"); */
    d__2 = *mst2;
    d__3 = *mst1;
    d__4 = *mt;
    d__6 = *stt;
    d__5 = *stt * 2. * sqrt(1. - d__6 * d__6);
    d__1 = (d__2 * d__2 - d__3 * d__3) / (d__4 * d__4 * 4.) * (d__5 * d__5);
    d__7 = *mst2;
    d__8 = *mst1;
    d__9 = *mst2;
    d__10 = *mst1;
    d__11 = *mst2;
    d__12 = *mst1;
    d__13 = *mst2;
    d__14 = *mst1;
    d__15 = *mt;
    d__17 = *stt;
    d__16 = *stt * 2. * sqrt(1. - d__17 * d__17);
    d__18 = *mst2;
    d__19 = *mst1;
    xttilde = d__1 * d__1 * (2. - (d__7 * d__7 + d__8 * d__8) / (d__9 * d__9 
	    - d__10 * d__10) * log(d__11 * d__11 / (d__12 * d__12))) + (d__13 
	    * d__13 - d__14 * d__14) / (d__15 * d__15 * 2.) * (d__16 * d__16) 
	    * log(d__18 * d__18 / (d__19 * d__19));
    d__1 = *mst2;
    d__2 = *mst1;
/* Computing 4th power */
    d__3 = *mt, d__3 *= d__3;
    ttt = log(d__1 * d__1 * (d__2 * d__2) / (d__3 * d__3)) * .5;
    vvv = 174.1;
    d__1 = M_PI;
/* Computing 4th power */
    d__2 = *mt, d__2 *= d__2;
    d__3 = vvv;
    d__4 = M_PI;
    d__5 = *mt;
    d__6 = vvv;
    d__7 = ttt;
    delmlhsq = 3. / (d__1 * d__1 * 4.) * (d__2 * d__2) / (d__3 * d__3) * (1. /
	     (d__4 * d__4 * 16.) * 3. / 2. * (d__5 * d__5) / (d__6 * d__6) * (
	    xttilde * ttt + d__7 * d__7));
/* ---------------------------------------------------------------- */
    m11 = m11top + m11rest + m11botmix;
    m12 = m12top + m12rest + m12botmix;
    m221loop = m22top + m22rest + m22botmix;
    m222loop = m221loop + m22log;
    if (selec_1.selec2 == 2 || selec_1.selec2 == 4) {
	m222loop += delmlhsq / sb2;
    }
/* ---------------------------------------------------------------- */
    d__1 = ma2 + mz2 + m221loop + m11;
    d__2 = m12;
/* Computing 4th power */
    d__3 = sb, d__3 *= d__3;
    mlhllediag1sq = (ma2 + mz2 + m221loop + m11 - sqrt(m12 * -8. * (ma2 + mz2)
	     * sb * cb + d__1 * d__1 - (-(d__2 * d__2) + mz2 * m221loop * cb2 
	    + m221loop * m11 + mz2 * sb2 * m11 + ma2 * (mz2 - mz2 * 4. * sb2 
	    + m221loop * sb2 + mz2 * 4. * (d__3 * d__3) + m11 * cb2)) * 4.)) /
	     2.;
    d__1 = ma2 + mz2 + m222loop + m11;
    d__2 = m12;
/* Computing 4th power */
    d__3 = sb, d__3 *= d__3;
    mlhllediag2sq = (ma2 + mz2 + m222loop + m11 - sqrt(m12 * -8. * (ma2 + mz2)
	     * sb * cb + d__1 * d__1 - (-(d__2 * d__2) + mz2 * m222loop * cb2 
	    + m222loop * m11 + mz2 * sb2 * m11 + ma2 * (mz2 - mz2 * 4. * sb2 
	    + m222loop * sb2 + mz2 * 4. * (d__3 * d__3) + m11 * cb2)) * 4.)) /
	     2.;
    d__1 = ma2 + mz2 + m221loop + m11;
    d__2 = m12;
/* Computing 4th power */
    d__3 = sb, d__3 *= d__3;
    mhhllediag1sq = (ma2 + mz2 + m221loop + m11 + sqrt(m12 * -8. * (ma2 + mz2)
	     * sb * cb + d__1 * d__1 - (-(d__2 * d__2) + mz2 * m221loop * cb2 
	    + m221loop * m11 + mz2 * sb2 * m11 + ma2 * (mz2 - mz2 * 4. * sb2 
	    + m221loop * sb2 + mz2 * 4. * (d__3 * d__3) + m11 * cb2)) * 4.)) /
	     2.;
    d__1 = ma2 + mz2 + m222loop + m11;
    d__2 = m12;
/* Computing 4th power */
    d__3 = sb, d__3 *= d__3;
    mhhllediag2sq = (ma2 + mz2 + m222loop + m11 + sqrt(m12 * -8. * (ma2 + mz2)
	     * sb * cb + d__1 * d__1 - (-(d__2 * d__2) + mz2 * m222loop * cb2 
	    + m222loop * m11 + mz2 * sb2 * m11 + ma2 * (mz2 - mz2 * 4. * sb2 
	    + m222loop * sb2 + mz2 * 4. * (d__3 * d__3) + m11 * cb2)) * 4.)) /
	     2.;
    if (mlhllediag1sq > 0.) {
	*mlhllediag1 = sqrt(mlhllediag1sq);
	*alphadiag1 = atan((-(ma2 + mz2) * sb * cb + m12) / (mz2 * cb2 + ma2 *
		 sb2 + m11 - mlhllediag1sq));
    } else {
	*mlhllediag1 = 119.9999;
	*alphadiag1 = 0.;
    }
    if (mlhllediag2sq > 0.) {
	*mlhllediag2 = sqrt(mlhllediag2sq);
	*alphadiag2 = atan((-(ma2 + mz2) * sb * cb + m12) / (mz2 * cb2 + ma2 *
		 sb2 + m11 - mlhllediag2sq));
    } else {
	*mlhllediag2 = 119.9999;
	*alphadiag2 = 0.;
    }
    *mhhllediag1 = sqrt(mhhllediag1sq);
    *mhhllediag2 = sqrt(mhhllediag2sq);
/* ---------------------------------------------------------------- */
    if (selec_1.selec2 == 2 || selec_1.selec2 == 4) {
/*     including the leading Yukawa term for the light Higgs mass */
/*     this term is taken from Carena, Espinosa, Quiros, Wagner */
/*     Nucl. Phys. B461 (1996) 407 */
	d__1 = *mlhlle2;
	*mlhlle2 = sqrt(d__1 * d__1 + delmlhsq);
/*      write(*,*) real(mlhlle2), real(mlhllediag2) */
    }
/* ---------------------------------------------------------------- */
/* --> rotation check */
    rot[0] = cos(*alpha);
    rot[2] = -sin(*alpha);
    rot[1] = -rot[2];
    rot[3] = rot[0];
    rott[0] = rot[0];
    rott[2] = rot[1];
    rott[1] = rot[2];
    rott[3] = rot[3];
    mhnondiag[0] = ma2 * sb2 + mz2 * cb2;
    mhnondiag[2] = -(ma2 + mz2) * sb * cb;
    mhnondiag[1] = mhnondiag[2];
    mhnondiag[3] = ma2 * cb2 + mz2 * sb2;
    diagonalization(rott, mhnondiag, rot, mhdiag);
    if (ABS(mhdiag[2]) <= 1e-6) {
	mhdiag[2] = 0.;
    }
    if (ABS(mhdiag[1]) <= 1e-6) {
	mhdiag[1] = 0.;
    }
/*      write(*,*) 'tree level diagonalization:' */
/*      write(*,*) real(dsqrt(mhdiag(1,1))), real(mhdiag(1,2)) */
/*      write(*,*) real(mhdiag(2,1)), real(dsqrt(mhdiag(2,2))) */
    rot[0] = cos(*alphadiag1);
    rot[2] = -sin(*alphadiag1);
    rot[1] = -rot[2];
    rot[3] = rot[0];
    rott[0] = rot[0];
    rott[2] = rot[1];
    rott[1] = rot[2];
    rott[3] = rot[3];
    mhnondiag[0] += m11;
    mhnondiag[2] += m12;
    mhnondiag[1] = mhnondiag[2];
    mhnondiag[3] += m221loop;
    diagonalization(rott, mhnondiag, rot, mhdiag);
    if (ABS(mhdiag[2]) <= 1e-6) {
	mhdiag[2] = 0.;
    }
    if (ABS(mhdiag[1]) <= 1e-6) {
	mhdiag[1] = 0.;
    }
    if ((d__1 = mlhllediag1sq - mhdiag[3], ABS(d__1)) > 1e-4 || (d__2 = 
	    mhhllediag1sq - mhdiag[0], ABS(d__2)) > 1e-4 || ABS(mhdiag[2]) > 
	    1e-6 || ABS(mhdiag[1]) > 1e-6) {
	
	printf("WARNING --- WARNING --- WARNING --- WARNING\n");
	printf("Error in 1-loop rotation !!!!!!!!!!!!!!!!!!\n");
	printf("WARNING --- WARNING --- WARNING --- WARNING\n");
    }
    rot[0] = cos(*alphadiag2);
    rot[2] = -sin(*alphadiag2);
    rot[1] = -rot[2];
    rot[3] = rot[0];
    rott[0] = rot[0];
    rott[2] = rot[1];
    rott[1] = rot[2];
    rott[3] = rot[3];
    mhnondiag[0] = mhnondiag[0];
    mhnondiag[2] = mhnondiag[2];
    mhnondiag[1] = mhnondiag[2];
    mhnondiag[3] = mhnondiag[3] - m221loop + m222loop;
    diagonalization(rott, mhnondiag, rot, mhdiag);
 
    if (ABS(mhdiag[2]) <= 1e-6) mhdiag[2] = 0.;
    if (ABS(mhdiag[1]) <= 1e-6) mhdiag[1] = 0.;
    
    if ((d__1 = mlhllediag2sq - mhdiag[3], ABS(d__1)) > 1e-4 || (d__2 = 
	    mhhllediag2sq - mhdiag[0], ABS(d__2)) > 1e-4 || ABS(mhdiag[2]) > 
	    1e-6 || ABS(mhdiag[1]) > 1e-6) {
	printf("WARNING --- WARNING --- WARNING --- WARNING\n");
	printf("Error in 2-loop rotation !!!!!!!!!!!!!!!!!!\n");
	printf("WARNING --- WARNING --- WARNING --- WARNING\n");
    }
/* --> end of rotation check */
/* ------------------------------------------------------------------- */
/* --> charged Higgs at one loop */
    d__1 = *mb;
    d__2 = *mb;
    d__3 = mw2;
    *mhp = sqrt(ma2 + mw2 + 3. / (M_PI * 4.) * al / (sw2 * mw2) * (mt2 * 2. * (
	    d__1 * d__1) / (sb2 * cb2) - mw2 * (mt2 / sb2 + d__2 * d__2 / cb2)
	     + d__3 * d__3 * .66666666666666663) * log(msusy / *mt) + mw2 / (
	    M_PI * 6.) * 15. * al / cw2 * log(msusy / *mw));
} /* mhiggslle_ */
