#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include "f2c.h"
#include"fhf.h"


/* Common blocks */
smpara_  smpara_1;
para_  para_1;
susypara_  susypara_1;
higgsmass_  higgsmass_1;
selec_ selec_1;
lle_ lle_1;

extern int FError;
     
static void feynhiggsfast(void)
{

/* -------------------------------------------------------------- */

/*     FeynHiggsFast */
/*     ============= */

/*       Calculation of the masses of the neutral CP-even */
/*       Higgs bosons in the MSSM */

/*       Author: Sven Heinemeyer */

/*       Based on hep-ph/9903404 */
/*       by S. Heinemeyer, W. Hollik, G. Weiglein */
/*       Based also on hep-ph/9803277, hep-ph/9807423, hep-ph/9812472, */
/*                     hep-ph/9910283 */
/*       by S. Heinemeyer, W. Hollik, G. Weiglein */
/*       and on hep-ph/0001002 */
/*       by M. Carena, H. Haber, S. Heinemeyer, W. Hollik, */
/*          C. Wagner and G. Weiglein */

/*       In case of problems or questions, */
/*       contact Sven Heinemeyer */
/*       email: Sven.Heinemeyer@desy.de */

/*       FeynHiggs homepage: */
/*       http://www-itp.physik.uni-karlsruhe.de/feynhiggs/ */

/* -------------------------------------------------------------- */
/* ---------------------------------------------------------------- */
/* setting the SM parameters */
/* ---------------------------------------------------------------- */
    smpara_1.mz = 91.187;
    smpara_1.mw = 80.39;
    smpara_1.gf = 1.16639e-5;
    smpara_1.as = .1095;
    smpara_1.alphasmz = .118;
    para_1.cf = 1.3333333333333333;
    para_1.eps = 1e-10;
/*      mt = 175d0 */
/*      mb = 4.5d0 */
/* ----------------------------------------------------------------- */

/*  switches */
/*  ======== */

/*  selec2 = 1: full 1-loop + 2-loop QCD with top pole mass */
/*           2: same as 1, but in addition with */
/*                         Yukawa term added for light Higgs */
/*           3: full 1-loop + 2-loop QCD with running top mass */
/*           4: same as 3, but in addition with */
/*                          Yukawa term added for light Higgs */
/*              The choice for the top mass (pole/running) will */
/*              also be applied on the top mass appearing in */
/*              the stop mass matrix */

/*  selec3 = 1: input is Msusy, MtLR, ... */
/*              output is MSt1, MSt2, MSb1, MSb2, stt, stb, ... */
/*           2: input is MSt2, delmst, stt */
/*              output is MSt1, MSb1, MSb2, stb, ... */

/* ----------------------------------------------------------------- */
/*     single point calculation with online parameter input */

    selec_1.selec2 = 4;
    selec_1.selec3 = 1;


/* --> Input of parameters */
/*    if (selec_1.selec3 == 1) { */
/* --> Input: OS, Msusy, Xt, Xb */
	susypara_1.msusy = susypara_1.msusytl;
	susypara_1.msusybl = susypara_1.msusytl;

/*	if (susypara_1.msusytr == 0.) susypara_1.msusytr = susypara_1.msusy;
	if (susypara_1.msusybr == 0.) susypara_1.msusybr = susypara_1.msusy;
	if (smpara_1.mt == 0.)        smpara_1.mt = 175.;
	if (smpara_1.mt == 1.)        smpara_1.mt = 174.3;
	if (smpara_1.mb == 0.)        smpara_1.mb = 4.5;
	if (smpara_1.mb == 1.)        smpara_1.mb = 2.97;
	if (susypara_1.mgl == 0.)     susypara_1.mgl = 500.;
	if (susypara_1.mgl == 1.)     susypara_1.mgl = susypara_1.msusy;
	if (susypara_1.mue == 1.)     susypara_1.mue = -200.;
	if (susypara_1.mue == 2.)     susypara_1.mue = -susypara_1.msusy;
	if (susypara_1.mmm == 1.)     susypara_1.mmm = 400.;
	if (susypara_1.mmm == 2.)     susypara_1.mmm = susypara_1.msusy;
*/
	susypara_1.au = susypara_1.mtlr + susypara_1.mue / susypara_1.tb;
/*	if (susypara_1.mblr == 1.)    susypara_1.mblr = susypara_1.au 
         - susypara_1.mue * susypara_1.tb;
*/         
	susypara_1.ad = susypara_1.mblr + susypara_1.mue * susypara_1.tb;
/*    } */
    feynhiggsfastsub();
} /* feynhiggsfast_ */

double fhf2(
double  itb, 
double  imu, 
double  iml, 
double  imr, 
double  imbr, 
double  iat, 
double  iab, 
double  img2, 
double  img3, 
double  ima, 
double  imt, 
double  imb, 
double  itp)
{
   int ntp=itp+0.1;  
static double sv_jtb=0, sv_jmu=0.,sv_jml=0.,sv_jmr=0.,sv_jat=0.,sv_jma=0.,
              sv_jmt=0.,sv_jmbr=0.,sv_jab=0.,sv_jmg3=0.,sv_jmg2=0.,sv_jmb;

     if(iml==0.0 && imr==0.0) { FError=1; return 0.0;} /*by Semenov */
                        

    if (itb!=sv_jtb || imu!=sv_jmu || iml!=sv_jml || imr!=sv_jmr || 
        iat!=sv_jat || ima!=sv_jma || imt!=sv_jmt || imb!=sv_jmb || 
        imbr!=sv_jmbr ||sv_jab!=iab || img2!=sv_jmg2 || img3!=sv_jmg3) 
    {
	susypara_1.tb = itb;
	susypara_1.mue = imu;
	susypara_1.msusytl = iml;
	susypara_1.msusytr = imr;
	susypara_1.msusybr = imbr;
	susypara_1.mtlr = iat;
	susypara_1.mblr = iab;
	smpara_1.mb = imb;
	smpara_1.mt = imt;
	susypara_1.mgl = img3;
	susypara_1.ma = ima;
	susypara_1.mmm = img2;
	sv_jtb = itb;
	sv_jmu = imu;
	sv_jml = iml;
	sv_jmr = imr;
	sv_jmbr = imbr;
	sv_jat = iat;
	sv_jab = iab;
	sv_jma = ima;
	sv_jmg2 = img2;
	sv_jmg3 = img3;
	sv_jmt = imt;
	sv_jmb = imb;
	feynhiggsfast();
    }
    switch(ntp)
    { case 1:  return lle_1.mlhllediag2;
      case 2:  return lle_1.mhhllediag2;
      case 3:  return sin(lle_1.alphadiag2);
      case 4:  return cos(lle_1.alphadiag2);
      case 5:  return lle_1.mhp;
      default: FError=1; return 0.;
    }
} /* fhf2f_ */

#ifdef QQQQ
int FError=0;
extern double fhf2f_(double*,double*,double*,double*,double*,double*,double*,
double*,double*,double*,double*,double*,long*);

int main(void)
{

/*fhf2(tb, hx, Mq3, Mu3, Md3, At-hx/tb, Ab-hx*tb, MG2, MG3, MH3, Mtop, Mb, 4)*/  

double itb=2, 
       imu=-600, 
       iml=900 , 
       imr=900 , 
       imbr=900;
double       iat= 1110+600/itb, 
       iab=1110+600*itb,  
       img2=200 ,  
       img3=300, 
       ima=300,  
       imt=175,  
       imb=4.62, 
       itp=1;
long ii;
  for(ii=1; ii<6; ii++)
  { double res1,res2; 
     itp=ii;
    res2=fhf2f_(&itb,&imu,&iml,&imr,&imbr,&iat,&iab,&img2,&img3,&ima,&imt,
    &imb,&ii);
    res1=fhf2(itb,imu,iml,imr,imbr,  iat,iab,img2,img3,ima,imt,imb,itp);
  
    printf("res1=%E res2=%E\n",res1,res2);
  }
return 0;
}
#endif
