#include "pdf/pilot.h"
*********************************************************************
*                                                                   *
*    POLARIZED RADIATIVELY GENERATED LO AND NLO PARTON DENSITIES    *
*                         AND DIS ASYMMETRIES                       *
*                                                                   *
*         M. GLUCK, E. REYA, M. STRATMANN AND W. VOGELSANG,         *
*                  (PHYS. REV. D53 (1996) 4775)                     *       
*          PROBLEMS/QUESTIONS TO VOGELSANG@V2.RL.AC.UK              *
*            OR TO STRAT@HAL1.PHYSIK.UNI-DORTMUND.DE                *
*                                                                   *
*   INPUT:   ISET = number of the parton set :                      *
*              ISET = 1  'STANDARD' SCENARIO, NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   * 
*                        (DATA FILE 'STDNLOA1.GRID' UNIT=11, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 2  'VALENCE' SCENARIO,  NEXT-TO-LEADING ORDER *
*                        (MS-bar)                                   *  
*                        (DATA FILE 'VALNLOA1.GRID' UNIT=22, TO BE  *
*                         DEFINED BY THE USER )                     *
*              ISET = 3  'STANDARD' SCENARIO, LEADING ORDER         *
*                        (DATA FILE 'STDLOA1.GRID' UNIT=33, TO BE   *
*                         DEFINED BY THE USER )                     *
*              ISET = 4  'VALENCE' SCENARIO,  LEADING ORDER         *
*                        (DATA FILE 'VALLOA1.GRID' UNIT=44, TO BE   *
*                         DEFINED BY THE USER )                     *
*                                                                   *
*            X  = Bjorken-x       (between  1.E-4  and  1)          *
*            Q2 = scale in GeV**2 (between  0.4  and   1.E4)        *
*             (for values outside the allowed range the program     *
*              writes a warning and extrapolates to the x and       *
*              Q2 values requested)                                 *
*                                                                   *
*   OUTPUT:  UV = x * ( DELTA u - DELTA u(bar) ),                   *
*            DV = x * ( DELTA d - DELTA d(bar) ),                   *        
*            QB = x * POLARIZED LIGHT SEA,                          *   
*                 QB= x * ( (DELTA U(BAR) + DELTA D(BAR))/2 )       * 
*            ST = x * DELTA STRANGE = x * DELTA STRANGE(BAR)        *     
*            GL = x * DELTA GLUON                                   *
*                                                                   *
*          (  For the parton distributions always x times           *
*                   the distribution is returned   )                *
*                                                                   *
*            A1P = A1-Proton                                        *
*            A1N = A1-Neutron                                       *
*            A1D = A1-Deuteron                                      *
*                                                                   *
*            The sets are the result of a combined fit to           *
*            data for the spin asymmetries A_1 (p,n,d)              *
*                                                                   *
*            Note: No charm is included                             *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINI / IINI , and  IINI     *
*            has always to be zero when PARPOL is called for the    *
*            first time or when 'ISET' has been changed.            *
*                                                                   *
*********************************************************************
*
      SUBROUTINE GRSVL2 (DX,DQ,DUV,DDV,DSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRSVL2 (X, Q2, UV, DV, QB, ST, GL, A1P, A1N, A1D)
#include "pdf/impdp.inc"
      PARAMETER (NPART=8, NX=42, NQ=25, NARG=2)
      DIMENSION
     +          XUVF(NX,NQ), XDVF(NX,NQ), XQBF(NX,NQ), 
     1          XSF(NX,NQ), XGF(NX,NQ), 
     2          XAPF(NX,NQ), XANF(NX,NQ), XADF(NX,NQ),
     3          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ)
      DIMENSION
     +       PARTON (NPART,NQ,NX-1)
      COMMON / GRSVA1 / A1P, A1N, A1D
C      COMMON / INTINI / IINI
      SAVE XUVF, XDVF, XQBF, XSF, XGF, XAPF, XANF, XADF, NA, ARRF
       DATA ZEROD/0.D0/
*...BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.4D0, 0.5d0, 0.6d0, 0.75D0, 1.0D0,
     1           1.25d0, 1.5D0, 2.d0, 2.5D0, 
     1           4.0D0, 6.4D0, 1.0D1, 1.5D1, 2.5D1, 4.0D1, 6.4D1,
     2           1.0D2, 1.8D2, 3.2D2, 5.8D2, 1.0D3, 1.8D3,
     3           3.2D3, 5.8D3, 1.0D4 /
       DATA XB / 1.D-4, 1.5D-4, 2.2D-4, 3.2D-4, 4.8D-4, 7.D-4,
     2           1.D-3, 1.5D-3, 2.2D-3, 3.2D-3, 4.8D-3, 7.D-3,
     3           1.D-2, 1.5D-2, 2.2D-2, 3.2D-2, 5.0D-2, 7.5D-2,
     4           0.1D0, 0.125D0, 0.15D0, 0.175D0, 0.2D0, 0.225D0, 
     +           0.25D0, 0.275D0,
     5           0.3D0, 0.325D0, 0.35D0, 0.375D0, 0.4D0, 0.45D0,  
     +           0.5D0, 0.55D0,
     6           0.6D0, 0.65D0,  0.7D0,  0.75D0,  0.8D0, 0.85D0,  
     +           0.9D0, 1.0D0 /
       DATA IINI/0/
C
        DATA ((PARTON(I,N,1),I=1,8),N=1,8)/
     +   .1846D-02, -.4278D-02, -.8964D-04, -.4213D-04,  .7594D-03,
     +   .2613D-02, -.1952D-01, -.7832D-02,
     +   .2018D-02, -.4422D-02, -.1379D-03, -.7827D-04,  .1780D-02,
     +   .1812D-02, -.1451D-01, -.5855D-02,
     +   .2155D-02, -.4533D-02, -.1852D-03, -.1157D-03,  .2965D-02,
     +   .1306D-02, -.1165D-01, -.4757D-02,
     +   .2317D-02, -.4661D-02, -.2522D-03, -.1706D-03,  .4857D-02,
     +   .8421D-03, -.9202D-02, -.3836D-02,
     +   .2518D-02, -.4816D-02, -.3516D-03, -.2544D-03,  .8014D-02,
     +   .4255D-03, -.7135D-02, -.3073D-02,
     +   .2670D-02, -.4930D-02, -.4376D-03, -.3284D-03,  .1101D-01,
     +   .1973D-03, -.6052D-02, -.2680D-02,
     +   .2790D-02, -.5018D-02, -.5127D-03, -.3938D-03,  .1380D-01,
     +   .5311D-04, -.5385D-02, -.2439D-02,
     +   .2975D-02, -.5151D-02, -.6390D-03, -.5049D-03,  .1880D-01,
     +  -.1198D-03, -.4597D-02, -.2156D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=9,16)/
     +   .3114D-02, -.5249D-02, -.7417D-03, -.5960D-03,  .2312D-01,
     +  -.2197D-03, -.4139D-02, -.1992D-02,
     +   .3399D-02, -.5445D-02, -.9729D-03, -.8030D-03,  .3363D-01,
     +  -.3711D-03, -.3457D-02, -.1749D-02,
     +   .3673D-02, -.5629D-02, -.1217D-02, -.1024D-02,  .4581D-01,
     +  -.4694D-03, -.3005D-02, -.1587D-02,
     +   .3924D-02, -.5793D-02, -.1457D-02, -.1241D-02,  .5876D-01,
     +  -.5323D-03, -.2699D-02, -.1476D-02,
     +   .4145D-02, -.5934D-02, -.1678D-02, -.1443D-02,  .7157D-01,
     +  -.5723D-03, -.2488D-02, -.1397D-02,
     +   .4412D-02, -.6101D-02, -.1955D-02, -.1695D-02,  .8877D-01,
     +  -.6053D-03, -.2279D-02, -.1317D-02,
     +   .4653D-02, -.6250D-02, -.2212D-02, -.1930D-02,  .1060D+00,
     +  -.6265D-03, -.2129D-02, -.1258D-02,
     +   .4888D-02, -.6392D-02, -.2467D-02, -.2163D-02,  .1242D+00,
     +  -.6403D-03, -.2008D-02, -.1209D-02 /
        DATA ((PARTON(I,N,1),I=1,8),N=17,25)/
     +   .5107D-02, -.6522D-02, -.2705D-02, -.2380D-02,  .1423D+00,
     +  -.6482D-03, -.1910D-02, -.1168D-02,
     +   .5387D-02, -.6687D-02, -.3011D-02, -.2659D-02,  .1673D+00,
     +  -.6528D-03, -.1802D-02, -.1121D-02,
     +   .5654D-02, -.6842D-02, -.3299D-02, -.2922D-02,  .1928D+00,
     +  -.6524D-03, -.1712D-02, -.1080D-02,
     +   .5922D-02, -.6995D-02, -.3584D-02, -.3181D-02,  .2201D+00,
     +  -.6481D-03, -.1632D-02, -.1041D-02,
     +   .6162D-02, -.7130D-02, -.3833D-02, -.3407D-02,  .2458D+00,
     +  -.6415D-03, -.1567D-02, -.1008D-02,
     +   .6415D-02, -.7270D-02, -.4087D-02, -.3636D-02,  .2742D+00,
     +  -.6321D-03, -.1504D-02, -.9753D-03,
     +   .6657D-02, -.7403D-02, -.4320D-02, -.3846D-02,  .3025D+00,
     +  -.6212D-03, -.1448D-02, -.9447D-03,
     +   .6901D-02, -.7536D-02, -.4546D-02, -.4048D-02,  .3323D+00,
     +  -.6085D-03, -.1395D-02, -.9147D-03,
     +   .7120D-02, -.7654D-02, -.4739D-02, -.4219D-02,  .3599D+00,
     +  -.5959D-03, -.1350D-02, -.8884D-03 /
        DATA ((PARTON(I,N,2),I=1,8),N=1,8)/
     +   .2447D-02, -.4980D-02, -.1280D-03, -.5656D-04,  .1206D-02,
     +   .3965D-02, -.2144D-01, -.8106D-02,
     +   .2671D-02, -.5150D-02, -.1913D-03, -.1028D-03,  .2601D-02,
     +   .2870D-02, -.1659D-01, -.6331D-02,
     +   .2848D-02, -.5280D-02, -.2522D-03, -.1497D-03,  .4168D-02,
     +   .2160D-02, -.1367D-01, -.5298D-02,
     +   .3059D-02, -.5431D-02, -.3366D-03, -.2171D-03,  .6613D-02,
     +   .1495D-02, -.1108D-01, -.4399D-02,
     +   .3320D-02, -.5613D-02, -.4594D-03, -.3182D-03,  .1060D-01,
     +   .8867D-03, -.8802D-02, -.3627D-02,
     +   .3516D-02, -.5746D-02, -.5636D-03, -.4059D-03,  .1432D-01,
     +   .5495D-03, -.7575D-02, -.3216D-02,
     +   .3672D-02, -.5850D-02, -.6537D-03, -.4825D-03,  .1775D-01,
     +   .3352D-03, -.6803D-02, -.2959D-02,
     +   .3911D-02, -.6006D-02, -.8029D-03, -.6110D-03,  .2382D-01,
     +   .7719D-04, -.5877D-02, -.2652D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=9,16)/
     +   .4089D-02, -.6121D-02, -.9226D-03, -.7149D-03,  .2901D-01,
     +  -.7265D-04, -.5329D-02, -.2469D-02,
     +   .4455D-02, -.6351D-02, -.1188D-02, -.9471D-03,  .4146D-01,
     +  -.2992D-03, -.4498D-02, -.2192D-02,
     +   .4805D-02, -.6566D-02, -.1463D-02, -.1190D-02,  .5567D-01,
     +  -.4456D-03, -.3935D-02, -.2001D-02,
     +   .5126D-02, -.6758D-02, -.1727D-02, -.1424D-02,  .7058D-01,
     +  -.5388D-03, -.3548D-02, -.1867D-02,
     +   .5408D-02, -.6924D-02, -.1967D-02, -.1638D-02,  .8518D-01,
     +  -.5976D-03, -.3277D-02, -.1769D-02,
     +   .5747D-02, -.7120D-02, -.2263D-02, -.1901D-02,  .1046D+00,
     +  -.6463D-03, -.3005D-02, -.1667D-02,
     +   .6053D-02, -.7294D-02, -.2533D-02, -.2142D-02,  .1238D+00,
     +  -.6766D-03, -.2808D-02, -.1591D-02,
     +   .6351D-02, -.7460D-02, -.2797D-02, -.2376D-02,  .1439D+00,
     +  -.6959D-03, -.2645D-02, -.1525D-02 /
        DATA ((PARTON(I,N,2),I=1,8),N=17,25)/
     +   .6627D-02, -.7613D-02, -.3040D-02, -.2592D-02,  .1638D+00,
     +  -.7065D-03, -.2514D-02, -.1470D-02,
     +   .6980D-02, -.7805D-02, -.3346D-02, -.2863D-02,  .1910D+00,
     +  -.7118D-03, -.2367D-02, -.1405D-02,
     +   .7316D-02, -.7985D-02, -.3629D-02, -.3113D-02,  .2186D+00,
     +  -.7098D-03, -.2243D-02, -.1348D-02,
     +   .7654D-02, -.8164D-02, -.3904D-02, -.3354D-02,  .2478D+00,
     +  -.7023D-03, -.2132D-02, -.1294D-02,
     +   .7955D-02, -.8321D-02, -.4138D-02, -.3558D-02,  .2752D+00,
     +  -.6917D-03, -.2042D-02, -.1248D-02,
     +   .8271D-02, -.8485D-02, -.4373D-02, -.3760D-02,  .3052D+00,
     +  -.6771D-03, -.1954D-02, -.1201D-02,
     +   .8573D-02, -.8639D-02, -.4584D-02, -.3941D-02,  .3350D+00,
     +  -.6604D-03, -.1875D-02, -.1158D-02,
     +   .8878D-02, -.8794D-02, -.4782D-02, -.4108D-02,  .3660D+00,
     +  -.6413D-03, -.1800D-02, -.1115D-02,
     +   .9151D-02, -.8931D-02, -.4947D-02, -.4245D-02,  .3947D+00,
     +  -.6224D-03, -.1737D-02, -.1077D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=1,8)/
     +   .3192D-02, -.5753D-02, -.1794D-03, -.7444D-04,  .1781D-02,
     +   .5542D-02, -.2330D-01, -.8244D-02,
     +   .3480D-02, -.5951D-02, -.2610D-03, -.1323D-03,  .3627D-02,
     +   .4166D-02, -.1870D-01, -.6712D-02,
     +   .3707D-02, -.6103D-02, -.3378D-03, -.1899D-03,  .5647D-02,
     +   .3245D-02, -.1580D-01, -.5781D-02,
     +   .3976D-02, -.6279D-02, -.4424D-03, -.2712D-03,  .8733D-02,
     +   .2361D-02, -.1312D-01, -.4941D-02,
     +   .4309D-02, -.6491D-02, -.5914D-03, -.3907D-03,  .1367D-01,
     +   .1534D-02, -.1068D-01, -.4191D-02,
     +   .4558D-02, -.6646D-02, -.7158D-03, -.4927D-03,  .1820D-01,
     +   .1068D-02, -.9318D-02, -.3778D-02,
     +   .4755D-02, -.6767D-02, -.8219D-03, -.5806D-03,  .2233D-01,
     +   .7693D-03, -.8447D-02, -.3513D-02,
     +   .5058D-02, -.6949D-02, -.9954D-03, -.7261D-03,  .2956D-01,
     +   .4067D-03, -.7381D-02, -.3189D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=9,16)/
     +   .5283D-02, -.7083D-02, -.1133D-02, -.8423D-03,  .3568D-01,
     +   .1945D-03, -.6738D-02, -.2992D-02,
     +   .5745D-02, -.7351D-02, -.1432D-02, -.1097D-02,  .5017D-01,
     +  -.1268D-03, -.5747D-02, -.2684D-02,
     +   .6186D-02, -.7601D-02, -.1735D-02, -.1358D-02,  .6647D-01,
     +  -.3348D-03, -.5060D-02, -.2464D-02,
     +   .6589D-02, -.7824D-02, -.2022D-02, -.1606D-02,  .8336D-01,
     +  -.4669D-03, -.4578D-02, -.2304D-02,
     +   .6941D-02, -.8016D-02, -.2279D-02, -.1827D-02,  .9972D-01,
     +  -.5502D-03, -.4235D-02, -.2185D-02,
     +   .7365D-02, -.8244D-02, -.2589D-02, -.2095D-02,  .1213D+00,
     +  -.6192D-03, -.3888D-02, -.2058D-02,
     +   .7747D-02, -.8445D-02, -.2868D-02, -.2335D-02,  .1423D+00,
     +  -.6614D-03, -.3633D-02, -.1961D-02,
     +   .8118D-02, -.8638D-02, -.3135D-02, -.2565D-02,  .1643D+00,
     +  -.6877D-03, -.3420D-02, -.1875D-02 /
        DATA ((PARTON(I,N,3),I=1,8),N=17,25)/
     +   .8460D-02, -.8815D-02, -.3377D-02, -.2771D-02,  .1858D+00,
     +  -.7017D-03, -.3246D-02, -.1803D-02,
     +   .8899D-02, -.9037D-02, -.3676D-02, -.3026D-02,  .2150D+00,
     +  -.7079D-03, -.3050D-02, -.1716D-02,
     +   .9315D-02, -.9246D-02, -.3947D-02, -.3254D-02,  .2443D+00,
     +  -.7039D-03, -.2885D-02, -.1638D-02,
     +   .9732D-02, -.9452D-02, -.4204D-02, -.3467D-02,  .2752D+00,
     +  -.6922D-03, -.2734D-02, -.1564D-02,
     +   .1010D-01, -.9633D-02, -.4418D-02, -.3642D-02,  .3039D+00,
     +  -.6763D-03, -.2611D-02, -.1501D-02,
     +   .1049D-01, -.9822D-02, -.4626D-02, -.3809D-02,  .3352D+00,
     +  -.6549D-03, -.2491D-02, -.1436D-02,
     +   .1086D-01, -.1000D-01, -.4808D-02, -.3952D-02,  .3660D+00,
     +  -.6308D-03, -.2383D-02, -.1376D-02,
     +   .1124D-01, -.1018D-01, -.4973D-02, -.4077D-02,  .3979D+00,
     +  -.6034D-03, -.2281D-02, -.1317D-02,
     +   .1157D-01, -.1034D-01, -.5104D-02, -.4173D-02,  .4272D+00,
     +  -.5765D-03, -.2193D-02, -.1264D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=1,8)/
     +   .4139D-02, -.6631D-02, -.2501D-03, -.9708D-04,  .2531D-02,
     +   .7393D-02, -.2517D-01, -.8255D-02,
     +   .4506D-02, -.6861D-02, -.3543D-03, -.1688D-03,  .4934D-02,
     +   .5754D-02, -.2091D-01, -.7001D-02,
     +   .4794D-02, -.7038D-02, -.4503D-03, -.2385D-03,  .7498D-02,
     +   .4620D-02, -.1809D-01, -.6207D-02,
     +   .5135D-02, -.7243D-02, -.5786D-03, -.3353D-03,  .1134D-01,
     +   .3503D-02, -.1539D-01, -.5461D-02,
     +   .5556D-02, -.7489D-02, -.7578D-03, -.4748D-03,  .1738D-01,
     +   .2432D-02, -.1283D-01, -.4766D-02,
     +   .5870D-02, -.7670D-02, -.9047D-03, -.5916D-03,  .2283D-01,
     +   .1816D-02, -.1135D-01, -.4368D-02,
     +   .6119D-02, -.7810D-02, -.1028D-02, -.6911D-03,  .2775D-01,
     +   .1417D-02, -.1039D-01, -.4106D-02,
     +   .6499D-02, -.8022D-02, -.1228D-02, -.8534D-03,  .3626D-01,
     +   .9275D-03, -.9181D-02, -.3775D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=9,16)/
     +   .6781D-02, -.8177D-02, -.1384D-02, -.9810D-03,  .4339D-01,
     +   .6386D-03, -.8441D-02, -.3567D-02,
     +   .7359D-02, -.8488D-02, -.1717D-02, -.1256D-02,  .6007D-01,
     +   .1989D-03, -.7273D-02, -.3232D-02,
     +   .7910D-02, -.8778D-02, -.2048D-02, -.1532D-02,  .7854D-01,
     +  -.8706D-04, -.6444D-02, -.2983D-02,
     +   .8411D-02, -.9036D-02, -.2355D-02, -.1787D-02,  .9745D-01,
     +  -.2690D-03, -.5851D-02, -.2795D-02,
     +   .8848D-02, -.9259D-02, -.2624D-02, -.2011D-02,  .1156D+00,
     +  -.3836D-03, -.5423D-02, -.2652D-02,
     +   .9373D-02, -.9522D-02, -.2944D-02, -.2276D-02,  .1392D+00,
     +  -.4791D-03, -.4983D-02, -.2494D-02,
     +   .9845D-02, -.9755D-02, -.3226D-02, -.2508D-02,  .1621D+00,
     +  -.5366D-03, -.4656D-02, -.2371D-02,
     +   .1030D-01, -.9977D-02, -.3492D-02, -.2725D-02,  .1857D+00,
     +  -.5719D-03, -.4380D-02, -.2261D-02 /
        DATA ((PARTON(I,N,4),I=1,8),N=17,25)/
     +   .1072D-01, -.1018D-01, -.3727D-02, -.2915D-02,  .2088D+00,
     +  -.5902D-03, -.4153D-02, -.2166D-02,
     +   .1126D-01, -.1044D-01, -.4012D-02, -.3143D-02,  .2397D+00,
     +  -.5974D-03, -.3895D-02, -.2051D-02,
     +   .1177D-01, -.1068D-01, -.4263D-02, -.3339D-02,  .2705D+00,
     +  -.5907D-03, -.3675D-02, -.1947D-02,
     +   .1228D-01, -.1091D-01, -.4494D-02, -.3515D-02,  .3027D+00,
     +  -.5734D-03, -.3474D-02, -.1848D-02,
     +   .1274D-01, -.1112D-01, -.4680D-02, -.3652D-02,  .3324D+00,
     +  -.5506D-03, -.3309D-02, -.1762D-02,
     +   .1321D-01, -.1134D-01, -.4855D-02, -.3775D-02,  .3645D+00,
     +  -.5204D-03, -.3147D-02, -.1674D-02,
     +   .1366D-01, -.1154D-01, -.5000D-02, -.3871D-02,  .3960D+00,
     +  -.4867D-03, -.3001D-02, -.1592D-02,
     +   .1412D-01, -.1175D-01, -.5125D-02, -.3947D-02,  .4284D+00,
     +  -.4486D-03, -.2863D-02, -.1511D-02,
     +   .1452D-01, -.1193D-01, -.5217D-02, -.3995D-02,  .4580D+00,
     +  -.4114D-03, -.2744D-02, -.1440D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=1,8)/
     +   .5481D-02, -.7740D-02, -.3592D-03, -.1289D-03,  .3615D-02,
     +   .9765D-02, -.2728D-01, -.8128D-02,
     +   .5956D-02, -.8012D-02, -.4944D-03, -.2186D-03,  .6775D-02,
     +   .7870D-02, -.2347D-01, -.7206D-02,
     +   .6328D-02, -.8220D-02, -.6160D-03, -.3037D-03,  .1006D-01,
     +   .6513D-02, -.2083D-01, -.6592D-02,
     +   .6767D-02, -.8462D-02, -.7753D-03, -.4193D-03,  .1490D-01,
     +   .5139D-02, -.1818D-01, -.5988D-02,
     +   .7308D-02, -.8753D-02, -.9926D-03, -.5820D-03,  .2233D-01,
     +   .3780D-02, -.1555D-01, -.5392D-02,
     +   .7710D-02, -.8965D-02, -.1167D-02, -.7153D-03,  .2894D-01,
     +   .2982D-02, -.1397D-01, -.5031D-02,
     +   .8028D-02, -.9131D-02, -.1312D-02, -.8273D-03,  .3482D-01,
     +   .2457D-02, -.1291D-01, -.4785D-02,
     +   .8512D-02, -.9380D-02, -.1542D-02, -.1007D-02,  .4489D-01,
     +   .1805D-02, -.1156D-01, -.4460D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=9,16)/
     +   .8872D-02, -.9562D-02, -.1719D-02, -.1145D-02,  .5322D-01,
     +   .1416D-02, -.1071D-01, -.4247D-02,
     +   .9605D-02, -.9927D-02, -.2089D-02, -.1438D-02,  .7245D-01,
     +   .8190D-03, -.9333D-02, -.3889D-02,
     +   .1030D-01, -.1027D-01, -.2448D-02, -.1722D-02,  .9339D-01,
     +   .4277D-03, -.8327D-02, -.3608D-02,
     +   .1093D-01, -.1057D-01, -.2773D-02, -.1979D-02,  .1145D+00,
     +   .1777D-03, -.7593D-02, -.3386D-02,
     +   .1148D-01, -.1083D-01, -.3052D-02, -.2198D-02,  .1346D+00,
     +   .2001D-04, -.7052D-02, -.3211D-02,
     +   .1214D-01, -.1114D-01, -.3376D-02, -.2450D-02,  .1604D+00,
     +  -.1123D-03, -.6488D-02, -.3013D-02,
     +   .1273D-01, -.1141D-01, -.3654D-02, -.2663D-02,  .1851D+00,
     +  -.1907D-03, -.6063D-02, -.2855D-02,
     +   .1330D-01, -.1167D-01, -.3910D-02, -.2856D-02,  .2104D+00,
     +  -.2383D-03, -.5700D-02, -.2711D-02 /
        DATA ((PARTON(I,N,5),I=1,8),N=17,25)/
     +   .1383D-01, -.1191D-01, -.4131D-02, -.3019D-02,  .2348D+00,
     +  -.2623D-03, -.5398D-02, -.2584D-02,
     +   .1450D-01, -.1221D-01, -.4391D-02, -.3204D-02,  .2673D+00,
     +  -.2705D-03, -.5052D-02, -.2429D-02,
     +   .1513D-01, -.1248D-01, -.4611D-02, -.3354D-02,  .2993D+00,
     +  -.2596D-03, -.4755D-02, -.2289D-02,
     +   .1576D-01, -.1276D-01, -.4804D-02, -.3477D-02,  .3325D+00,
     +  -.2340D-03, -.4482D-02, -.2153D-02,
     +   .1632D-01, -.1300D-01, -.4952D-02, -.3562D-02,  .3629D+00,
     +  -.2011D-03, -.4257D-02, -.2035D-02,
     +   .1690D-01, -.1325D-01, -.5081D-02, -.3625D-02,  .3955D+00,
     +  -.1582D-03, -.4035D-02, -.1914D-02,
     +   .1746D-01, -.1349D-01, -.5179D-02, -.3661D-02,  .4272D+00,
     +  -.1106D-03, -.3835D-02, -.1801D-02,
     +   .1802D-01, -.1372D-01, -.5252D-02, -.3672D-02,  .4597D+00,
     +  -.5718D-04, -.3644D-02, -.1689D-02,
     +   .1851D-01, -.1393D-01, -.5296D-02, -.3659D-02,  .4891D+00,
     +  -.5401D-05, -.3481D-02, -.1591D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=1,8)/
     +   .7115D-02, -.8947D-02, -.5045D-03, -.1673D-03,  .4950D-02,
     +   .1233D-01, -.2936D-01, -.7888D-02,
     +   .7716D-02, -.9265D-02, -.6761D-03, -.2767D-03,  .8992D-02,
     +   .1024D-01, -.2605D-01, -.7289D-02,
     +   .8187D-02, -.9509D-02, -.8268D-03, -.3780D-03,  .1310D-01,
     +   .8700D-02, -.2363D-01, -.6867D-02,
     +   .8740D-02, -.9791D-02, -.1020D-02, -.5127D-03,  .1903D-01,
     +   .7098D-02, -.2110D-01, -.6425D-02,
     +   .9420D-02, -.1013D-01, -.1279D-02, -.6978D-03,  .2798D-01,
     +   .5472D-02, -.1848D-01, -.5954D-02,
     +   .9923D-02, -.1038D-01, -.1482D-02, -.8463D-03,  .3581D-01,
     +   .4494D-02, -.1684D-01, -.5649D-02,
     +   .1032D-01, -.1057D-01, -.1648D-02, -.9690D-03,  .4270D-01,
     +   .3842D-02, -.1572D-01, -.5428D-02,
     +   .1093D-01, -.1086D-01, -.1908D-02, -.1162D-02,  .5436D-01,
     +   .3024D-02, -.1424D-01, -.5123D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=9,16)/
     +   .1137D-01, -.1107D-01, -.2104D-02, -.1309D-02,  .6391D-01,
     +   .2529D-02, -.1328D-01, -.4913D-02,
     +   .1229D-01, -.1150D-01, -.2509D-02, -.1611D-02,  .8563D-01,
     +   .1762D-02, -.1170D-01, -.4539D-02,
     +   .1315D-01, -.1189D-01, -.2890D-02, -.1895D-02,  .1089D+00,
     +   .1255D-02, -.1051D-01, -.4226D-02,
     +   .1393D-01, -.1224D-01, -.3226D-02, -.2143D-02,  .1321D+00,
     +   .9300D-03, -.9623D-02, -.3968D-02,
     +   .1460D-01, -.1254D-01, -.3508D-02, -.2349D-02,  .1538D+00,
     +   .7243D-03, -.8957D-02, -.3757D-02,
     +   .1541D-01, -.1290D-01, -.3828D-02, -.2577D-02,  .1815D+00,
     +   .5508D-03, -.8253D-02, -.3515D-02,
     +   .1614D-01, -.1321D-01, -.4096D-02, -.2762D-02,  .2078D+00,
     +   .4493D-03, -.7713D-02, -.3315D-02,
     +   .1683D-01, -.1351D-01, -.4335D-02, -.2920D-02,  .2343D+00,
     +   .3886D-03, -.7248D-02, -.3130D-02 /
        DATA ((PARTON(I,N,6),I=1,8),N=17,25)/
     +   .1747D-01, -.1378D-01, -.4535D-02, -.3047D-02,  .2598D+00,
     +   .3591D-03, -.6858D-02, -.2966D-02,
     +   .1829D-01, -.1413D-01, -.4761D-02, -.3180D-02,  .2933D+00,
     +   .3511D-03, -.6407D-02, -.2763D-02,
     +   .1906D-01, -.1445D-01, -.4943D-02, -.3274D-02,  .3261D+00,
     +   .3682D-03, -.6017D-02, -.2578D-02,
     +   .1982D-01, -.1476D-01, -.5092D-02, -.3335D-02,  .3597D+00,
     +   .4046D-03, -.5658D-02, -.2397D-02,
     +   .2050D-01, -.1504D-01, -.5196D-02, -.3361D-02,  .3903D+00,
     +   .4501D-03, -.5360D-02, -.2240D-02,
     +   .2120D-01, -.1532D-01, -.5275D-02, -.3359D-02,  .4228D+00,
     +   .5089D-03, -.5065D-02, -.2079D-02,
     +   .2187D-01, -.1559D-01, -.5322D-02, -.3329D-02,  .4542D+00,
     +   .5736D-03, -.4800D-02, -.1928D-02,
     +   .2254D-01, -.1586D-01, -.5341D-02, -.3271D-02,  .4861D+00,
     +   .6458D-03, -.4546D-02, -.1779D-02,
     +   .2313D-01, -.1610D-01, -.5334D-02, -.3196D-02,  .5148D+00,
     +   .7154D-03, -.4328D-02, -.1648D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=1,8)/
     +   .9098D-02, -.1027D-01, -.6976D-03, -.2132D-03,  .6585D-02,
     +   .1507D-01, -.3150D-01, -.7577D-02,
     +   .9847D-02, -.1064D-01, -.9114D-03, -.3440D-03,  .1165D-01,
     +   .1285D-01, -.2870D-01, -.7283D-02,
     +   .1043D-01, -.1093D-01, -.1095D-02, -.4622D-03,  .1668D-01,
     +   .1117D-01, -.2655D-01, -.7051D-02,
     +   .1112D-01, -.1125D-01, -.1326D-02, -.6158D-03,  .2383D-01,
     +   .9388D-02, -.2420D-01, -.6779D-02,
     +   .1196D-01, -.1165D-01, -.1628D-02, -.8217D-03,  .3441D-01,
     +   .7531D-02, -.2164D-01, -.6448D-02,
     +   .1258D-01, -.1193D-01, -.1861D-02, -.9832D-03,  .4352D-01,
     +   .6392D-02, -.1998D-01, -.6207D-02,
     +   .1307D-01, -.1216D-01, -.2048D-02, -.1114D-02,  .5146D-01,
     +   .5622D-02, -.1881D-01, -.6021D-02,
     +   .1381D-01, -.1249D-01, -.2337D-02, -.1317D-02,  .6474D-01,
     +   .4644D-02, -.1723D-01, -.5744D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=9,16)/
     +   .1436D-01, -.1274D-01, -.2552D-02, -.1468D-02,  .7549D-01,
     +   .4045D-02, -.1619D-01, -.5540D-02,
     +   .1548D-01, -.1322D-01, -.2985D-02, -.1771D-02,  .9964D-01,
     +   .3109D-02, -.1441D-01, -.5155D-02,
     +   .1653D-01, -.1368D-01, -.3382D-02, -.2044D-02,  .1251D+00,
     +   .2484D-02, -.1303D-01, -.4810D-02,
     +   .1747D-01, -.1408D-01, -.3723D-02, -.2274D-02,  .1501D+00,
     +   .2082D-02, -.1197D-01, -.4512D-02,
     +   .1829D-01, -.1443D-01, -.4002D-02, -.2457D-02,  .1733D+00,
     +   .1827D-02, -.1117D-01, -.4261D-02,
     +   .1927D-01, -.1483D-01, -.4311D-02, -.2650D-02,  .2025D+00,
     +   .1611D-02, -.1031D-01, -.3966D-02,
     +   .2014D-01, -.1519D-01, -.4560D-02, -.2796D-02,  .2300D+00,
     +   .1487D-02, -.9640D-02, -.3718D-02,
     +   .2098D-01, -.1553D-01, -.4775D-02, -.2912D-02,  .2574D+00,
     +   .1414D-02, -.9056D-02, -.3484D-02 /
        DATA ((PARTON(I,N,7),I=1,8),N=17,25)/
     +   .2175D-01, -.1584D-01, -.4948D-02, -.2995D-02,  .2835D+00,
     +   .1381D-02, -.8563D-02, -.3275D-02,
     +   .2272D-01, -.1623D-01, -.5134D-02, -.3065D-02,  .3176D+00,
     +   .1376D-02, -.7988D-02, -.3015D-02,
     +   .2364D-01, -.1659D-01, -.5271D-02, -.3094D-02,  .3506D+00,
     +   .1403D-02, -.7489D-02, -.2775D-02,
     +   .2455D-01, -.1695D-01, -.5370D-02, -.3086D-02,  .3842D+00,
     +   .1454D-02, -.7027D-02, -.2541D-02,
     +   .2535D-01, -.1726D-01, -.5426D-02, -.3048D-02,  .4143D+00,
     +   .1516D-02, -.6641D-02, -.2337D-02,
     +   .2619D-01, -.1758D-01, -.5452D-02, -.2975D-02,  .4463D+00,
     +   .1595D-02, -.6260D-02, -.2127D-02,
     +   .2698D-01, -.1789D-01, -.5446D-02, -.2877D-02,  .4769D+00,
     +   .1681D-02, -.5916D-02, -.1930D-02,
     +   .2777D-01, -.1819D-01, -.5409D-02, -.2748D-02,  .5077D+00,
     +   .1776D-02, -.5586D-02, -.1736D-02,
     +   .2847D-01, -.1845D-01, -.5352D-02, -.2608D-02,  .5353D+00,
     +   .1867D-02, -.5304D-02, -.1566D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=1,8)/
     +   .1202D-01, -.1205D-01, -.1014D-02, -.2777D-03,  .9043D-02,
     +   .1854D-01, -.3426D-01, -.7195D-02,
     +   .1298D-01, -.1249D-01, -.1286D-02, -.4355D-03,  .1553D-01,
     +   .1625D-01, -.3206D-01, -.7218D-02,
     +   .1373D-01, -.1282D-01, -.1513D-02, -.5737D-03,  .2182D-01,
     +   .1449D-01, -.3026D-01, -.7191D-02,
     +   .1460D-01, -.1321D-01, -.1793D-02, -.7486D-03,  .3056D-01,
     +   .1256D-01, -.2817D-01, -.7109D-02,
     +   .1567D-01, -.1368D-01, -.2149D-02, -.9757D-03,  .4323D-01,
     +   .1051D-01, -.2576D-01, -.6942D-02,
     +   .1645D-01, -.1401D-01, -.2417D-02, -.1149D-02,  .5394D-01,
     +   .9223D-02, -.2412D-01, -.6781D-02,
     +   .1707D-01, -.1428D-01, -.2629D-02, -.1286D-02,  .6315D-01,
     +   .8339D-02, -.2292D-01, -.6637D-02,
     +   .1800D-01, -.1467D-01, -.2950D-02, -.1493D-02,  .7837D-01,
     +   .7201D-02, -.2126D-01, -.6395D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=9,16)/
     +   .1869D-01, -.1496D-01, -.3184D-02, -.1643D-02,  .9053D-01,
     +   .6493D-02, -.2012D-01, -.6200D-02,
     +   .2009D-01, -.1553D-01, -.3642D-02, -.1932D-02,  .1174D+00,
     +   .5379D-02, -.1812D-01, -.5798D-02,
     +   .2139D-01, -.1606D-01, -.4049D-02, -.2179D-02,  .1452D+00,
     +   .4627D-02, -.1651D-01, -.5408D-02,
     +   .2257D-01, -.1653D-01, -.4386D-02, -.2373D-02,  .1721D+00,
     +   .4141D-02, -.1524D-01, -.5053D-02,
     +   .2358D-01, -.1693D-01, -.4654D-02, -.2517D-02,  .1967D+00,
     +   .3834D-02, -.1426D-01, -.4746D-02,
     +   .2478D-01, -.1740D-01, -.4937D-02, -.2653D-02,  .2273D+00,
     +   .3574D-02, -.1319D-01, -.4376D-02,
     +   .2585D-01, -.1782D-01, -.5155D-02, -.2742D-02,  .2556D+00,
     +   .3429D-02, -.1234D-01, -.4057D-02,
     +   .2688D-01, -.1821D-01, -.5333D-02, -.2795D-02,  .2836D+00,
     +   .3348D-02, -.1160D-01, -.3754D-02 /
        DATA ((PARTON(I,N,8),I=1,8),N=17,25)/
     +   .2782D-01, -.1857D-01, -.5466D-02, -.2815D-02,  .3100D+00,
     +   .3316D-02, -.1096D-01, -.3479D-02,
     +   .2900D-01, -.1902D-01, -.5594D-02, -.2799D-02,  .3440D+00,
     +   .3323D-02, -.1021D-01, -.3135D-02,
     +   .3011D-01, -.1943D-01, -.5671D-02, -.2742D-02,  .3766D+00,
     +   .3369D-02, -.9560D-02, -.2817D-02,
     +   .3121D-01, -.1984D-01, -.5705D-02, -.2645D-02,  .4093D+00,
     +   .3445D-02, -.8951D-02, -.2505D-02,
     +   .3218D-01, -.2020D-01, -.5700D-02, -.2524D-02,  .4385D+00,
     +   .3534D-02, -.8443D-02, -.2232D-02,
     +   .3319D-01, -.2057D-01, -.5660D-02, -.2364D-02,  .4691D+00,
     +   .3644D-02, -.7938D-02, -.1952D-02,
     +   .3413D-01, -.2091D-01, -.5590D-02, -.2180D-02,  .4981D+00,
     +   .3762D-02, -.7481D-02, -.1690D-02,
     +   .3508D-01, -.2125D-01, -.5487D-02, -.1965D-02,  .5271D+00,
     +   .3892D-02, -.7043D-02, -.1431D-02,
     +   .3592D-01, -.2155D-01, -.5370D-02, -.1749D-02,  .5529D+00,
     +   .4016D-02, -.6668D-02, -.1203D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=1,8)/
     +   .1563D-01, -.1403D-01, -.1442D-02, -.3545D-03,  .1208D-01,
     +   .2222D-01, -.3725D-01, -.6798D-02,
     +   .1683D-01, -.1455D-01, -.1780D-02, -.5402D-03,  .2020D-01,
     +   .1995D-01, -.3565D-01, -.7095D-02,
     +   .1777D-01, -.1495D-01, -.2056D-02, -.6975D-03,  .2788D-01,
     +   .1817D-01, -.3420D-01, -.7247D-02,
     +   .1886D-01, -.1540D-01, -.2387D-02, -.8906D-03,  .3835D-01,
     +   .1619D-01, -.3242D-01, -.7332D-02,
     +   .2019D-01, -.1595D-01, -.2798D-02, -.1133D-02,  .5322D-01,
     +   .1405D-01, -.3021D-01, -.7311D-02,
     +   .2116D-01, -.1634D-01, -.3100D-02, -.1311D-02,  .6556D-01,
     +   .1267D-01, -.2863D-01, -.7221D-02,
     +   .2193D-01, -.1665D-01, -.3335D-02, -.1449D-02,  .7604D-01,
     +   .1172D-01, -.2743D-01, -.7113D-02,
     +   .2308D-01, -.1711D-01, -.3683D-02, -.1651D-02,  .9312D-01,
     +   .1048D-01, -.2571D-01, -.6899D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=9,16)/
     +   .2392D-01, -.1744D-01, -.3931D-02, -.1792D-02,  .1066D+00,
     +   .9701D-02, -.2451D-01, -.6706D-02,
     +   .2563D-01, -.1810D-01, -.4405D-02, -.2050D-02,  .1359D+00,
     +   .8464D-02, -.2231D-01, -.6274D-02,
     +   .2722D-01, -.1872D-01, -.4810D-02, -.2253D-02,  .1657D+00,
     +   .7627D-02, -.2048D-01, -.5825D-02,
     +   .2865D-01, -.1926D-01, -.5132D-02, -.2396D-02,  .1940D+00,
     +   .7087D-02, -.1900D-01, -.5400D-02,
     +   .2988D-01, -.1972D-01, -.5377D-02, -.2487D-02,  .2195D+00,
     +   .6748D-02, -.1782D-01, -.5021D-02,
     +   .3133D-01, -.2026D-01, -.5624D-02, -.2553D-02,  .2508D+00,
     +   .6466D-02, -.1653D-01, -.4561D-02,
     +   .3261D-01, -.2073D-01, -.5801D-02, -.2570D-02,  .2794D+00,
     +   .6318D-02, -.1548D-01, -.4155D-02,
     +   .3384D-01, -.2118D-01, -.5933D-02, -.2550D-02,  .3075D+00,
     +   .6245D-02, -.1456D-01, -.3767D-02 /
        DATA ((PARTON(I,N,9),I=1,8),N=17,25)/
     +   .3497D-01, -.2159D-01, -.6020D-02, -.2499D-02,  .3335D+00,
     +   .6228D-02, -.1376D-01, -.3412D-02,
     +   .3638D-01, -.2209D-01, -.6084D-02, -.2389D-02,  .3668D+00,
     +   .6263D-02, -.1282D-01, -.2967D-02,
     +   .3770D-01, -.2256D-01, -.6096D-02, -.2239D-02,  .3982D+00,
     +   .6342D-02, -.1198D-01, -.2553D-02,
     +   .3900D-01, -.2302D-01, -.6062D-02, -.2048D-02,  .4295D+00,
     +   .6458D-02, -.1121D-01, -.2146D-02,
     +   .4014D-01, -.2342D-01, -.5995D-02, -.1842D-02,  .4570D+00,
     +   .6585D-02, -.1056D-01, -.1791D-02,
     +   .4133D-01, -.2384D-01, -.5889D-02, -.1594D-02,  .4856D+00,
     +   .6739D-02, -.9907D-02, -.1426D-02,
     +   .4244D-01, -.2422D-01, -.5755D-02, -.1327D-02,  .5125D+00,
     +   .6900D-02, -.9320D-02, -.1085D-02,
     +   .4355D-01, -.2460D-01, -.5590D-02, -.1029D-02,  .5391D+00,
     +   .7075D-02, -.8756D-02, -.7484D-03,
     +   .4453D-01, -.2494D-01, -.5417D-02, -.7403D-03,  .5625D+00,
     +   .7240D-02, -.8273D-02, -.4534D-03 /
        DATA ((PARTON(I,N,10),I=1,8),N=1,8)/
     +   .2018D-01, -.1633D-01, -.2036D-02, -.4455D-03,  .1594D-01,
     +   .2617D-01, -.4074D-01, -.6478D-02,
     +   .2168D-01, -.1694D-01, -.2449D-02, -.6587D-03,  .2596D-01,
     +   .2400D-01, -.3971D-01, -.6995D-02,
     +   .2284D-01, -.1741D-01, -.2778D-02, -.8328D-03,  .3523D-01,
     +   .2229D-01, -.3862D-01, -.7286D-02,
     +   .2419D-01, -.1794D-01, -.3164D-02, -.1039D-02,  .4759D-01,
     +   .2037D-01, -.3714D-01, -.7498D-02,
     +   .2582D-01, -.1857D-01, -.3629D-02, -.1288D-02,  .6477D-01,
     +   .1825D-01, -.3517D-01, -.7581D-02,
     +   .2702D-01, -.1903D-01, -.3962D-02, -.1464D-02,  .7877D-01,
     +   .1688D-01, -.3368D-01, -.7534D-02,
     +   .2795D-01, -.1939D-01, -.4217D-02, -.1595D-02,  .9051D-01,
     +   .1592D-01, -.3251D-01, -.7444D-02,
     +   .2935D-01, -.1992D-01, -.4585D-02, -.1779D-02,  .1094D+00,
     +   .1466D-01, -.3076D-01, -.7232D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=9,16)/
     +   .3038D-01, -.2030D-01, -.4842D-02, -.1901D-02,  .1241D+00,
     +   .1387D-01, -.2950D-01, -.7025D-02,
     +   .3245D-01, -.2107D-01, -.5318D-02, -.2108D-02,  .1555D+00,
     +   .1261D-01, -.2712D-01, -.6530D-02,
     +   .3437D-01, -.2177D-01, -.5705D-02, -.2247D-02,  .1868D+00,
     +   .1176D-01, -.2507D-01, -.5991D-02,
     +   .3608D-01, -.2239D-01, -.5999D-02, -.2321D-02,  .2160D+00,
     +   .1122D-01, -.2337D-01, -.5467D-02,
     +   .3754D-01, -.2291D-01, -.6210D-02, -.2345D-02,  .2419D+00,
     +   .1089D-01, -.2199D-01, -.4995D-02,
     +   .3927D-01, -.2353D-01, -.6408D-02, -.2323D-02,  .2733D+00,
     +   .1063D-01, -.2045D-01, -.4416D-02,
     +   .4080D-01, -.2406D-01, -.6534D-02, -.2257D-02,  .3016D+00,
     +   .1051D-01, -.1920D-01, -.3900D-02,
     +   .4225D-01, -.2457D-01, -.6611D-02, -.2153D-02,  .3290D+00,
     +   .1048D-01, -.1806D-01, -.3403D-02 /
        DATA ((PARTON(I,N,10),I=1,8),N=17,25)/
     +   .4357D-01, -.2502D-01, -.6645D-02, -.2022D-02,  .3541D+00,
     +   .1050D-01, -.1709D-01, -.2949D-02,
     +   .4523D-01, -.2559D-01, -.6636D-02, -.1809D-02,  .3859D+00,
     +   .1060D-01, -.1592D-01, -.2376D-02,
     +   .4678D-01, -.2612D-01, -.6578D-02, -.1561D-02,  .4154D+00,
     +   .1073D-01, -.1488D-01, -.1844D-02,
     +   .4830D-01, -.2663D-01, -.6474D-02, -.1272D-02,  .4445D+00,
     +   .1091D-01, -.1391D-01, -.1321D-02,
     +   .4963D-01, -.2707D-01, -.6344D-02, -.9815D-03,  .4698D+00,
     +   .1110D-01, -.1310D-01, -.8647D-03,
     +   .5100D-01, -.2753D-01, -.6172D-02, -.6455D-03,  .4958D+00,
     +   .1132D-01, -.1228D-01, -.3958D-03,
     +   .5229D-01, -.2795D-01, -.5978D-02, -.2976D-03,  .5200D+00,
     +   .1154D-01, -.1154D-01,  .4147D-04,
     +   .5357D-01, -.2837D-01, -.5753D-02,  .7828D-04,  .5437D+00,
     +   .1177D-01, -.1083D-01,  .4723D-03,
     +   .5470D-01, -.2874D-01, -.5529D-02,  .4344D-03,  .5643D+00,
     +   .1200D-01, -.1023D-01,  .8493D-03 /
        DATA ((PARTON(I,N,11),I=1,8),N=1,8)/
     +   .2658D-01, -.1932D-01, -.2955D-02, -.5610D-03,  .2139D-01,
     +   .3080D-01, -.4539D-01, -.6319D-02,
     +   .2847D-01, -.2004D-01, -.3460D-02, -.8010D-03,  .3386D-01,
     +   .2887D-01, -.4492D-01, -.6997D-02,
     +   .2992D-01, -.2059D-01, -.3850D-02, -.9878D-03,  .4507D-01,
     +   .2734D-01, -.4419D-01, -.7378D-02,
     +   .3160D-01, -.2122D-01, -.4294D-02, -.1199D-02,  .5969D-01,
     +   .2562D-01, -.4305D-01, -.7656D-02,
     +   .3362D-01, -.2197D-01, -.4813D-02, -.1440D-02,  .7949D-01,
     +   .2371D-01, -.4134D-01, -.7772D-02,
     +   .3509D-01, -.2251D-01, -.5174D-02, -.1599D-02,  .9529D-01,
     +   .2248D-01, -.3996D-01, -.7720D-02,
     +   .3624D-01, -.2292D-01, -.5442D-02, -.1712D-02,  .1083D+00,
     +   .2161D-01, -.3882D-01, -.7610D-02,
     +   .3797D-01, -.2354D-01, -.5821D-02, -.1858D-02,  .1290D+00,
     +   .2047D-01, -.3707D-01, -.7346D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=9,16)/
     +   .3922D-01, -.2399D-01, -.6078D-02, -.1946D-02,  .1448D+00,
     +   .1976D-01, -.3575D-01, -.7086D-02,
     +   .4174D-01, -.2487D-01, -.6533D-02, -.2068D-02,  .1779D+00,
     +   .1864D-01, -.3320D-01, -.6452D-02,
     +   .4406D-01, -.2568D-01, -.6880D-02, -.2111D-02,  .2102D+00,
     +   .1791D-01, -.3091D-01, -.5755D-02,
     +   .4612D-01, -.2639D-01, -.7124D-02, -.2088D-02,  .2397D+00,
     +   .1748D-01, -.2896D-01, -.5075D-02,
     +   .4788D-01, -.2699D-01, -.7283D-02, -.2021D-02,  .2655D+00,
     +   .1725D-01, -.2735D-01, -.4460D-02,
     +   .4994D-01, -.2768D-01, -.7409D-02, -.1886D-02,  .2961D+00,
     +   .1709D-01, -.2552D-01, -.3706D-02,
     +   .5176D-01, -.2829D-01, -.7467D-02, -.1715D-02,  .3233D+00,
     +   .1708D-01, -.2401D-01, -.3031D-02,
     +   .5348D-01, -.2886D-01, -.7474D-02, -.1508D-02,  .3491D+00,
     +   .1714D-01, -.2264D-01, -.2380D-02 /
        DATA ((PARTON(I,N,11),I=1,8),N=17,25)/
     +   .5504D-01, -.2937D-01, -.7440D-02, -.1283D-02,  .3725D+00,
     +   .1726D-01, -.2144D-01, -.1784D-02,
     +   .5699D-01, -.3000D-01, -.7346D-02, -.9510D-03,  .4016D+00,
     +   .1747D-01, -.2000D-01, -.1035D-02,
     +   .5879D-01, -.3058D-01, -.7207D-02, -.5941D-03,  .4283D+00,
     +   .1773D-01, -.1872D-01, -.3390D-03,
     +   .6056D-01, -.3115D-01, -.7023D-02, -.1989D-03,  .4541D+00,
     +   .1802D-01, -.1751D-01,  .3434D-03,
     +   .6211D-01, -.3164D-01, -.6825D-02,  .1816D-03,  .4763D+00,
     +   .1831D-01, -.1649D-01,  .9371D-03,
     +   .6370D-01, -.3214D-01, -.6585D-02,  .6074D-03,  .4988D+00,
     +   .1863D-01, -.1547D-01,  .1546D-02,
     +   .6518D-01, -.3260D-01, -.6328D-02,  .1036D-02,  .5194D+00,
     +   .1895D-01, -.1454D-01,  .2113D-02,
     +   .6665D-01, -.3305D-01, -.6044D-02,  .1488D-02,  .5393D+00,
     +   .1929D-01, -.1365D-01,  .2670D-02,
     +   .6794D-01, -.3345D-01, -.5772D-02,  .1907D-02,  .5564D+00,
     +   .1959D-01, -.1289D-01,  .3156D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=1,8)/
     +   .3427D-01, -.2268D-01, -.4169D-02, -.6791D-03,  .2801D-01,
     +   .3545D-01, -.5081D-01, -.6470D-02,
     +   .3659D-01, -.2353D-01, -.4762D-02, -.9358D-03,  .4312D-01,
     +   .3388D-01, -.5079D-01, -.7197D-02,
     +   .3837D-01, -.2417D-01, -.5205D-02, -.1125D-02,  .5635D-01,
     +   .3264D-01, -.5035D-01, -.7577D-02,
     +   .4041D-01, -.2490D-01, -.5697D-02, -.1326D-02,  .7319D-01,
     +   .3127D-01, -.4946D-01, -.7821D-02,
     +   .4286D-01, -.2577D-01, -.6252D-02, -.1538D-02,  .9545D-01,
     +   .2976D-01, -.4797D-01, -.7855D-02,
     +   .4464D-01, -.2639D-01, -.6625D-02, -.1665D-02,  .1128D+00,
     +   .2880D-01, -.4666D-01, -.7721D-02,
     +   .4602D-01, -.2687D-01, -.6896D-02, -.1746D-02,  .1269D+00,
     +   .2814D-01, -.4555D-01, -.7535D-02,
     +   .4809D-01, -.2757D-01, -.7266D-02, -.1836D-02,  .1489D+00,
     +   .2728D-01, -.4379D-01, -.7142D-02 /
        DATA ((PARTON(I,N,12),I=1,8),N=9,16)/
     +   .4959D-01, -.2808D-01, -.7508D-02, -.1876D-02,  .1655D+00,
     +   .2675D-01, -.4242D-01, -.6779D-02,
     +   .5257D-01, -.2909D-01, -.7915D-02, -.1888D-02,  .1995D+00,
     +   .2599D-01, -.3970D-01, -.5915D-02,
     +   .5532D-01, -.3000D-01, -.8199D-02, -.1815D-02,  .2319D+00,
     +   .2556D-01, -.3719D-01, -.4986D-02,
     +   .5774D-01, -.3079D-01, -.8374D-02, -.1680D-02,  .2608D+00,
     +   .2538D-01, -.3500D-01, -.4091D-02,
     +   .5979D-01, -.3146D-01, -.8467D-02, -.1514D-02,  .2856D+00,
     +   .2535D-01, -.3317D-01, -.3286D-02,
     +   .6219D-01, -.3223D-01, -.8509D-02, -.1258D-02,  .3146D+00,
     +   .2542D-01, -.3107D-01, -.2310D-02,
     +   .6429D-01, -.3290D-01, -.8489D-02, -.9804D-03,  .3398D+00,
     +   .2559D-01, -.2931D-01, -.1436D-02,
     +   .6628D-01, -.3352D-01, -.8420D-02, -.6719D-03,  .3635D+00,
     +   .2584D-01, -.2769D-01, -.5962D-03 /
        DATA ((PARTON(I,N,12),I=1,8),N=17,25)/
     +   .6807D-01, -.3408D-01, -.8318D-02, -.3561D-03,  .3845D+00,
     +   .2612D-01, -.2628D-01,  .1692D-03,
     +   .7030D-01, -.3477D-01, -.8137D-02,  .8655D-04,  .4103D+00,
     +   .2653D-01, -.2456D-01,  .1129D-02,
     +   .7235D-01, -.3539D-01, -.7920D-02,  .5418D-03,  .4335D+00,
     +   .2696D-01, -.2303D-01,  .2018D-02,
     +   .7436D-01, -.3600D-01, -.7662D-02,  .1028D-02,  .4556D+00,
     +   .2743D-01, -.2158D-01,  .2887D-02,
     +   .7610D-01, -.3652D-01, -.7402D-02,  .1484D-02,  .4742D+00,
     +   .2786D-01, -.2036D-01,  .3640D-02,
     +   .7789D-01, -.3705D-01, -.7103D-02,  .1982D-02,  .4928D+00,
     +   .2833D-01, -.1914D-01,  .4410D-02,
     +   .7955D-01, -.3754D-01, -.6794D-02,  .2472D-02,  .5096D+00,
     +   .2879D-01, -.1802D-01,  .5124D-02,
     +   .8118D-01, -.3802D-01, -.6464D-02,  .2980D-02,  .5256D+00,
     +   .2926D-01, -.1695D-01,  .5824D-02,
     +   .8262D-01, -.3843D-01, -.6153D-02,  .3443D-02,  .5391D+00,
     +   .2969D-01, -.1604D-01,  .6434D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=1,8)/
     +   .4350D-01, -.2651D-01, -.5743D-02, -.7880D-03,  .3607D-01,
     +   .4022D-01, -.5721D-01, -.6983D-02,
     +   .4629D-01, -.2749D-01, -.6411D-02, -.1046D-02,  .5400D-01,
     +   .3913D-01, -.5751D-01, -.7627D-02,
     +   .4842D-01, -.2823D-01, -.6894D-02, -.1222D-02,  .6926D-01,
     +   .3831D-01, -.5725D-01, -.7905D-02,
     +   .5086D-01, -.2907D-01, -.7413D-02, -.1395D-02,  .8824D-01,
     +   .3743D-01, -.5652D-01, -.7999D-02,
     +   .5378D-01, -.3006D-01, -.7977D-02, -.1552D-02,  .1127D+00,
     +   .3651D-01, -.5514D-01, -.7820D-02,
     +   .5588D-01, -.3076D-01, -.8342D-02, -.1629D-02,  .1313D+00,
     +   .3596D-01, -.5387D-01, -.7513D-02,
     +   .5751D-01, -.3130D-01, -.8599D-02, -.1665D-02,  .1462D+00,
     +   .3561D-01, -.5276D-01, -.7185D-02,
     +   .5993D-01, -.3210D-01, -.8935D-02, -.1679D-02,  .1690D+00,
     +   .3520D-01, -.5094D-01, -.6571D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=9,16)/
     +   .6169D-01, -.3267D-01, -.9145D-02, -.1658D-02,  .1859D+00,
     +   .3498D-01, -.4952D-01, -.6041D-02,
     +   .6516D-01, -.3379D-01, -.9471D-02, -.1537D-02,  .2199D+00,
     +   .3479D-01, -.4661D-01, -.4836D-02,
     +   .6833D-01, -.3479D-01, -.9664D-02, -.1331D-02,  .2514D+00,
     +   .3486D-01, -.4388D-01, -.3586D-02,
     +   .7111D-01, -.3566D-01, -.9750D-02, -.1076D-02,  .2789D+00,
     +   .3508D-01, -.4146D-01, -.2404D-02,
     +   .7346D-01, -.3639D-01, -.9763D-02, -.8048D-03,  .3021D+00,
     +   .3537D-01, -.3942D-01, -.1357D-02,
     +   .7619D-01, -.3722D-01, -.9709D-02, -.4282D-03,  .3285D+00,
     +   .3580D-01, -.3705D-01, -.1015D-03,
     +   .7857D-01, -.3794D-01, -.9603D-02, -.4707D-04,  .3511D+00,
     +   .3628D-01, -.3505D-01,  .1016D-02,
     +   .8080D-01, -.3860D-01, -.9454D-02,  .3561D-03,  .3719D+00,
     +   .3680D-01, -.3321D-01,  .2084D-02 /
        DATA ((PARTON(I,N,13),I=1,8),N=17,25)/
     +   .8281D-01, -.3919D-01, -.9281D-02,  .7536D-03,  .3901D+00,
     +   .3732D-01, -.3158D-01,  .3053D-02,
     +   .8530D-01, -.3992D-01, -.9015D-02,  .1292D-02,  .4119D+00,
     +   .3802D-01, -.2961D-01,  .4261D-02,
     +   .8758D-01, -.4058D-01, -.8723D-02,  .1828D-02,  .4312D+00,
     +   .3871D-01, -.2784D-01,  .5374D-02,
     +   .8979D-01, -.4121D-01, -.8398D-02,  .2386D-02,  .4491D+00,
     +   .3942D-01, -.2617D-01,  .6457D-02,
     +   .9171D-01, -.4175D-01, -.8084D-02,  .2897D-02,  .4640D+00,
     +   .4006D-01, -.2475D-01,  .7392D-02,
     +   .9366D-01, -.4229D-01, -.7735D-02,  .3445D-02,  .4785D+00,
     +   .4073D-01, -.2333D-01,  .8345D-02,
     +   .9547D-01, -.4279D-01, -.7384D-02,  .3975D-02,  .4914D+00,
     +   .4138D-01, -.2204D-01,  .9226D-02,
     +   .9725D-01, -.4327D-01, -.7018D-02,  .4515D-02,  .5034D+00,
     +   .4203D-01, -.2079D-01,  .1009D-01,
     +   .9880D-01, -.4369D-01, -.6680D-02,  .5001D-02,  .5134D+00,
     +   .4261D-01, -.1973D-01,  .1083D-01 /
        DATA ((PARTON(I,N,14),I=1,8),N=1,8)/
     +   .5689D-01, -.3187D-01, -.8178D-02, -.8774D-03,  .4809D-01,
     +   .4629D-01, -.6638D-01, -.8072D-02,
     +   .6032D-01, -.3302D-01, -.8897D-02, -.1106D-02,  .6954D-01,
     +   .4601D-01, -.6681D-01, -.8405D-02,
     +   .6291D-01, -.3388D-01, -.9394D-02, -.1240D-02,  .8714D-01,
     +   .4585D-01, -.6662D-01, -.8399D-02,
     +   .6586D-01, -.3484D-01, -.9905D-02, -.1348D-02,  .1084D+00,
     +   .4576D-01, -.6591D-01, -.8135D-02,
     +   .6937D-01, -.3597D-01, -.1043D-01, -.1405D-02,  .1349D+00,
     +   .4579D-01, -.6449D-01, -.7497D-02,
     +   .7188D-01, -.3677D-01, -.1075D-01, -.1397D-02,  .1545D+00,
     +   .4593D-01, -.6316D-01, -.6848D-02,
     +   .7381D-01, -.3738D-01, -.1096D-01, -.1360D-02,  .1698D+00,
     +   .4609D-01, -.6198D-01, -.6252D-02,
     +   .7668D-01, -.3827D-01, -.1121D-01, -.1259D-02,  .1928D+00,
     +   .4642D-01, -.6004D-01, -.5236D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=9,16)/
     +   .7874D-01, -.3891D-01, -.1135D-01, -.1150D-02,  .2094D+00,
     +   .4673D-01, -.5850D-01, -.4417D-02,
     +   .8280D-01, -.4014D-01, -.1153D-01, -.8468D-03,  .2420D+00,
     +   .4752D-01, -.5533D-01, -.2639D-02,
     +   .8647D-01, -.4123D-01, -.1158D-01, -.4716D-03,  .2712D+00,
     +   .4842D-01, -.5231D-01, -.8737D-03,
     +   .8967D-01, -.4217D-01, -.1153D-01, -.6941D-04,  .2958D+00,
     +   .4934D-01, -.4961D-01,  .7495D-03,
     +   .9235D-01, -.4294D-01, -.1143D-01,  .3221D-03,  .3160D+00,
     +   .5018D-01, -.4733D-01,  .2163D-02,
     +   .9544D-01, -.4382D-01, -.1125D-01,  .8321D-03,  .3385D+00,
     +   .5122D-01, -.4467D-01,  .3833D-02,
     +   .9811D-01, -.4456D-01, -.1103D-01,  .1322D-02,  .3571D+00,
     +   .5221D-01, -.4240D-01,  .5304D-02,
     +   .1006D+00, -.4525D-01, -.1078D-01,  .1819D-02,  .3738D+00,
     +   .5319D-01, -.4031D-01,  .6697D-02 /
        DATA ((PARTON(I,N,14),I=1,8),N=17,25)/
     +   .1028D+00, -.4586D-01, -.1052D-01,  .2293D-02,  .3880D+00,
     +   .5410D-01, -.3846D-01,  .7951D-02,
     +   .1056D+00, -.4659D-01, -.1016D-01,  .2915D-02,  .4045D+00,
     +   .5528D-01, -.3621D-01,  .9505D-02,
     +   .1081D+00, -.4725D-01, -.9781D-02,  .3516D-02,  .4187D+00,
     +   .5639D-01, -.3419D-01,  .1093D-01,
     +   .1105D+00, -.4788D-01, -.9385D-02,  .4125D-02,  .4314D+00,
     +   .5749D-01, -.3227D-01,  .1230D-01,
     +   .1126D+00, -.4840D-01, -.9017D-02,  .4670D-02,  .4417D+00,
     +   .5846D-01, -.3064D-01,  .1348D-01,
     +   .1146D+00, -.4893D-01, -.8619D-02,  .5242D-02,  .4513D+00,
     +   .5946D-01, -.2902D-01,  .1468D-01,
     +   .1166D+00, -.4941D-01, -.8231D-02,  .5785D-02,  .4595D+00,
     +   .6040D-01, -.2754D-01,  .1578D-01,
     +   .1185D+00, -.4987D-01, -.7835D-02,  .6329D-02,  .4669D+00,
     +   .6133D-01, -.2612D-01,  .1685D-01,
     +   .1201D+00, -.5026D-01, -.7478D-02,  .6811D-02,  .4729D+00,
     +   .6215D-01, -.2490D-01,  .1778D-01 /
        DATA ((PARTON(I,N,15),I=1,8),N=1,8)/
     +   .7315D-01, -.3821D-01, -.1123D-01, -.8727D-03,  .6341D-01,
     +   .5323D-01, -.7720D-01, -.9479D-02,
     +   .7726D-01, -.3952D-01, -.1193D-01, -.1027D-02,  .8826D-01,
     +   .5405D-01, -.7746D-01, -.9212D-02,
     +   .8034D-01, -.4049D-01, -.1238D-01, -.1086D-02,  .1079D+00,
     +   .5477D-01, -.7710D-01, -.8715D-02,
     +   .8383D-01, -.4157D-01, -.1282D-01, -.1091D-02,  .1308D+00,
     +   .5569D-01, -.7618D-01, -.7870D-02,
     +   .8794D-01, -.4282D-01, -.1322D-01, -.1009D-02,  .1584D+00,
     +   .5695D-01, -.7450D-01, -.6534D-02,
     +   .9087D-01, -.4369D-01, -.1344D-01, -.8912D-03,  .1782D+00,
     +   .5794D-01, -.7296D-01, -.5386D-02,
     +   .9311D-01, -.4435D-01, -.1357D-01, -.7677D-03,  .1933D+00,
     +   .5876D-01, -.7163D-01, -.4409D-02,
     +   .9640D-01, -.4531D-01, -.1369D-01, -.5335D-03,  .2154D+00,
     +   .6004D-01, -.6945D-01, -.2838D-02 /
        DATA ((PARTON(I,N,15),I=1,8),N=9,16)/
     +   .9876D-01, -.4599D-01, -.1373D-01, -.3278D-03,  .2309D+00,
     +   .6100D-01, -.6774D-01, -.1629D-02,
     +   .1034D+00, -.4728D-01, -.1371D-01,  .1625D-03,  .2605D+00,
     +   .6304D-01, -.6422D-01,  .8943D-03,
     +   .1075D+00, -.4841D-01, -.1356D-01,  .6995D-03,  .2858D+00,
     +   .6501D-01, -.6087D-01,  .3308D-02,
     +   .1110D+00, -.4936D-01, -.1336D-01,  .1232D-02,  .3065D+00,
     +   .6680D-01, -.5790D-01,  .5473D-02,
     +   .1140D+00, -.5014D-01, -.1312D-01,  .1723D-02,  .3228D+00,
     +   .6836D-01, -.5538D-01,  .7326D-02,
     +   .1174D+00, -.5101D-01, -.1279D-01,  .2335D-02,  .3403D+00,
     +   .7017D-01, -.5245D-01,  .9484D-02,
     +   .1203D+00, -.5174D-01, -.1246D-01,  .2900D-02,  .3543D+00,
     +   .7180D-01, -.4996D-01,  .1136D-01,
     +   .1230D+00, -.5240D-01, -.1211D-01,  .3455D-02,  .3663D+00,
     +   .7336D-01, -.4765D-01,  .1313D-01 /
        DATA ((PARTON(I,N,15),I=1,8),N=17,25)/
     +   .1253D+00, -.5298D-01, -.1177D-01,  .3970D-02,  .3762D+00,
     +   .7477D-01, -.4561D-01,  .1470D-01,
     +   .1282D+00, -.5367D-01, -.1131D-01,  .4628D-02,  .3872D+00,
     +   .7653D-01, -.4314D-01,  .1664D-01,
     +   .1308D+00, -.5427D-01, -.1087D-01,  .5247D-02,  .3961D+00,
     +   .7816D-01, -.4092D-01,  .1840D-01,
     +   .1333D+00, -.5484D-01, -.1041D-01,  .5859D-02,  .4037D+00,
     +   .7975D-01, -.3881D-01,  .2009D-01,
     +   .1355D+00, -.5531D-01, -.9999D-02,  .6395D-02,  .4094D+00,
     +   .8112D-01, -.3702D-01,  .2154D-01,
     +   .1376D+00, -.5577D-01, -.9566D-02,  .6947D-02,  .4145D+00,
     +   .8252D-01, -.3524D-01,  .2300D-01,
     +   .1395D+00, -.5618D-01, -.9154D-02,  .7461D-02,  .4185D+00,
     +   .8382D-01, -.3362D-01,  .2434D-01,
     +   .1414D+00, -.5657D-01, -.8741D-02,  .7967D-02,  .4217D+00,
     +   .8509D-01, -.3207D-01,  .2564D-01,
     +   .1431D+00, -.5690D-01, -.8375D-02,  .8409D-02,  .4240D+00,
     +   .8620D-01, -.3074D-01,  .2676D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=1,8)/
     +   .9347D-01, -.4600D-01, -.1496D-01, -.7030D-03,  .8397D-01,
     +   .6238D-01, -.8989D-01, -.1068D-01,
     +   .9831D-01, -.4744D-01, -.1551D-01, -.7257D-03,  .1117D+00,
     +   .6469D-01, -.8957D-01, -.9424D-02,
     +   .1019D+00, -.4849D-01, -.1583D-01, -.6704D-03,  .1328D+00,
     +   .6655D-01, -.8877D-01, -.8170D-02,
     +   .1060D+00, -.4965D-01, -.1610D-01, -.5341D-03,  .1564D+00,
     +   .6878D-01, -.8737D-01, -.6472D-02,
     +   .1107D+00, -.5096D-01, -.1629D-01, -.2771D-03,  .1837D+00,
     +   .7154D-01, -.8513D-01, -.4152D-02,
     +   .1140D+00, -.5186D-01, -.1634D-01, -.3328D-04,  .2025D+00,
     +   .7359D-01, -.8323D-01, -.2325D-02,
     +   .1165D+00, -.5254D-01, -.1633D-01,  .1862D-03,  .2165D+00,
     +   .7520D-01, -.8163D-01, -.8429D-03,
     +   .1202D+00, -.5351D-01, -.1626D-01,  .5579D-03,  .2362D+00,
     +   .7762D-01, -.7908D-01,  .1447D-02 /
        DATA ((PARTON(I,N,16),I=1,8),N=9,16)/
     +   .1228D+00, -.5419D-01, -.1617D-01,  .8578D-03,  .2498D+00,
     +   .7937D-01, -.7712D-01,  .3152D-02,
     +   .1279D+00, -.5545D-01, -.1587D-01,  .1517D-02,  .2744D+00,
     +   .8288D-01, -.7315D-01,  .6598D-02,
     +   .1324D+00, -.5653D-01, -.1550D-01,  .2184D-02,  .2943D+00,
     +   .8611D-01, -.6943D-01,  .9792D-02,
     +   .1362D+00, -.5742D-01, -.1511D-01,  .2809D-02,  .3097D+00,
     +   .8893D-01, -.6616D-01,  .1259D-01,
     +   .1393D+00, -.5813D-01, -.1473D-01,  .3361D-02,  .3212D+00,
     +   .9130D-01, -.6341D-01,  .1495D-01,
     +   .1428D+00, -.5891D-01, -.1425D-01,  .4023D-02,  .3329D+00,
     +   .9402D-01, -.6024D-01,  .1766D-01,
     +   .1458D+00, -.5955D-01, -.1380D-01,  .4612D-02,  .3416D+00,
     +   .9639D-01, -.5755D-01,  .2000D-01,
     +   .1486D+00, -.6011D-01, -.1335D-01,  .5175D-02,  .3486D+00,
     +   .9861D-01, -.5506D-01,  .2217D-01 /
        DATA ((PARTON(I,N,16),I=1,8),N=17,25)/
     +   .1510D+00, -.6059D-01, -.1293D-01,  .5683D-02,  .3539D+00,
     +   .1006D+00, -.5288D-01,  .2410D-01,
     +   .1539D+00, -.6114D-01, -.1239D-01,  .6316D-02,  .3593D+00,
     +   .1030D+00, -.5023D-01,  .2645D-01,
     +   .1564D+00, -.6162D-01, -.1188D-01,  .6895D-02,  .3631D+00,
     +   .1053D+00, -.4786D-01,  .2857D-01,
     +   .1589D+00, -.6204D-01, -.1138D-01,  .7453D-02,  .3657D+00,
     +   .1074D+00, -.4562D-01,  .3060D-01,
     +   .1609D+00, -.6239D-01, -.1094D-01,  .7931D-02,  .3673D+00,
     +   .1092D+00, -.4373D-01,  .3233D-01,
     +   .1629D+00, -.6271D-01, -.1048D-01,  .8414D-02,  .3681D+00,
     +   .1111D+00, -.4184D-01,  .3407D-01,
     +   .1648D+00, -.6299D-01, -.1006D-01,  .8854D-02,  .3683D+00,
     +   .1128D+00, -.4013D-01,  .3566D-01,
     +   .1665D+00, -.6325D-01, -.9637D-02,  .9279D-02,  .3680D+00,
     +   .1145D+00, -.3850D-01,  .3719D-01,
     +   .1680D+00, -.6345D-01, -.9272D-02,  .9643D-02,  .3672D+00,
     +   .1159D+00, -.3710D-01,  .3851D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=1,8)/
     +   .1255D+00, -.5791D-01, -.2005D-01, -.1622D-03,  .1194D+00,
     +   .7981D-01, -.1069D+00, -.9859D-02,
     +   .1312D+00, -.5938D-01, -.2021D-01,  .5299D-04,  .1486D+00,
     +   .8453D-01, -.1053D+00, -.6774D-02,
     +   .1354D+00, -.6043D-01, -.2022D-01,  .2898D-03,  .1694D+00,
     +   .8815D-01, -.1035D+00, -.4200D-02,
     +   .1401D+00, -.6155D-01, -.2013D-01,  .6272D-03,  .1916D+00,
     +   .9231D-01, -.1011D+00, -.1078D-02,
     +   .1454D+00, -.6278D-01, -.1990D-01,  .1107D-02,  .2154D+00,
     +   .9724D-01, -.9781D-01,  .2810D-02,
     +   .1491D+00, -.6360D-01, -.1966D-01,  .1495D-02,  .2309D+00,
     +   .1007D+00, -.9525D-01,  .5680D-02,
     +   .1519D+00, -.6420D-01, -.1944D-01,  .1815D-02,  .2418D+00,
     +   .1034D+00, -.9318D-01,  .7920D-02,
     +   .1559D+00, -.6504D-01, -.1906D-01,  .2317D-02,  .2564D+00,
     +   .1074D+00, -.9001D-01,  .1126D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=9,16)/
     +   .1587D+00, -.6560D-01, -.1875D-01,  .2696D-02,  .2658D+00,
     +   .1102D+00, -.8766D-01,  .1367D-01,
     +   .1641D+00, -.6662D-01, -.1807D-01,  .3472D-02,  .2815D+00,
     +   .1156D+00, -.8302D-01,  .1840D-01,
     +   .1686D+00, -.6743D-01, -.1740D-01,  .4199D-02,  .2928D+00,
     +   .1204D+00, -.7880D-01,  .2265D-01,
     +   .1724D+00, -.6806D-01, -.1677D-01,  .4838D-02,  .3003D+00,
     +   .1245D+00, -.7517D-01,  .2628D-01,
     +   .1755D+00, -.6853D-01, -.1621D-01,  .5376D-02,  .3051D+00,
     +   .1279D+00, -.7215D-01,  .2929D-01,
     +   .1789D+00, -.6901D-01, -.1555D-01,  .5992D-02,  .3090D+00,
     +   .1317D+00, -.6873D-01,  .3270D-01,
     +   .1817D+00, -.6937D-01, -.1497D-01,  .6517D-02,  .3111D+00,
     +   .1350D+00, -.6585D-01,  .3561D-01,
     +   .1842D+00, -.6966D-01, -.1442D-01,  .6999D-02,  .3120D+00,
     +   .1380D+00, -.6321D-01,  .3828D-01 /
        DATA ((PARTON(I,N,17),I=1,8),N=17,25)/
     +   .1863D+00, -.6989D-01, -.1392D-01,  .7420D-02,  .3120D+00,
     +   .1407D+00, -.6090D-01,  .4063D-01,
     +   .1888D+00, -.7011D-01, -.1331D-01,  .7924D-02,  .3109D+00,
     +   .1440D+00, -.5812D-01,  .4348D-01,
     +   .1910D+00, -.7027D-01, -.1275D-01,  .8368D-02,  .3091D+00,
     +   .1469D+00, -.5565D-01,  .4604D-01,
     +   .1930D+00, -.7038D-01, -.1221D-01,  .8781D-02,  .3066D+00,
     +   .1497D+00, -.5333D-01,  .4847D-01,
     +   .1946D+00, -.7044D-01, -.1174D-01,  .9123D-02,  .3040D+00,
     +   .1521D+00, -.5137D-01,  .5054D-01,
     +   .1962D+00, -.7047D-01, -.1128D-01,  .9456D-02,  .3008D+00,
     +   .1545D+00, -.4943D-01,  .5261D-01,
     +   .1975D+00, -.7047D-01, -.1085D-01,  .9751D-02,  .2974D+00,
     +   .1567D+00, -.4768D-01,  .5449D-01,
     +   .1988D+00, -.7044D-01, -.1044D-01,  .1003D-01,  .2938D+00,
     +   .1589D+00, -.4600D-01,  .5631D-01,
     +   .1998D+00, -.7040D-01, -.1008D-01,  .1025D-01,  .2904D+00,
     +   .1607D+00, -.4457D-01,  .5788D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=1,8)/
     +   .1651D+00, -.7159D-01, -.2444D-01,  .6957D-03,  .1656D+00,
     +   .1080D+00, -.1217D+00, -.2680D-02,
     +   .1715D+00, -.7281D-01, -.2400D-01,  .1161D-02,  .1916D+00,
     +   .1154D+00, -.1182D+00,  .2643D-02,
     +   .1761D+00, -.7363D-01, -.2358D-01,  .1561D-02,  .2087D+00,
     +   .1208D+00, -.1152D+00,  .6744D-02,
     +   .1810D+00, -.7446D-01, -.2303D-01,  .2053D-02,  .2254D+00,
     +   .1269D+00, -.1116D+00,  .1144D-01,
     +   .1865D+00, -.7531D-01, -.2231D-01,  .2671D-02,  .2416D+00,
     +   .1338D+00, -.1071D+00,  .1698D-01,
     +   .1903D+00, -.7584D-01, -.2174D-01,  .3127D-02,  .2510D+00,
     +   .1386D+00, -.1038D+00,  .2090D-01,
     +   .1930D+00, -.7620D-01, -.2129D-01,  .3482D-02,  .2571D+00,
     +   .1422D+00, -.1012D+00,  .2389D-01,
     +   .1969D+00, -.7666D-01, -.2060D-01,  .4008D-02,  .2643D+00,
     +   .1474D+00, -.9739D-01,  .2824D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=9,16)/
     +   .1996D+00, -.7694D-01, -.2009D-01,  .4384D-02,  .2682D+00,
     +   .1511D+00, -.9466D-01,  .3131D-01,
     +   .2045D+00, -.7736D-01, -.1907D-01,  .5108D-02,  .2732D+00,
     +   .1580D+00, -.8938D-01,  .3719D-01,
     +   .2085D+00, -.7761D-01, -.1813D-01,  .5738D-02,  .2749D+00,
     +   .1640D+00, -.8472D-01,  .4235D-01,
     +   .2117D+00, -.7772D-01, -.1732D-01,  .6260D-02,  .2744D+00,
     +   .1691D+00, -.8079D-01,  .4669D-01,
     +   .2141D+00, -.7774D-01, -.1663D-01,  .6676D-02,  .2728D+00,
     +   .1732D+00, -.7758D-01,  .5024D-01,
     +   .2167D+00, -.7769D-01, -.1585D-01,  .7129D-02,  .2698D+00,
     +   .1778D+00, -.7399D-01,  .5422D-01,
     +   .2188D+00, -.7758D-01, -.1519D-01,  .7495D-02,  .2662D+00,
     +   .1818D+00, -.7099D-01,  .5758D-01,
     +   .2205D+00, -.7741D-01, -.1458D-01,  .7816D-02,  .2622D+00,
     +   .1854D+00, -.6826D-01,  .6066D-01 /
        DATA ((PARTON(I,N,18),I=1,8),N=17,25)/
     +   .2219D+00, -.7722D-01, -.1404D-01,  .8083D-02,  .2581D+00,
     +   .1885D+00, -.6589D-01,  .6335D-01,
     +   .2234D+00, -.7693D-01, -.1339D-01,  .8388D-02,  .2526D+00,
     +   .1923D+00, -.6305D-01,  .6660D-01,
     +   .2247D+00, -.7660D-01, -.1281D-01,  .8641D-02,  .2470D+00,
     +   .1958D+00, -.6053D-01,  .6950D-01,
     +   .2257D+00, -.7624D-01, -.1226D-01,  .8864D-02,  .2413D+00,
     +   .1990D+00, -.5818D-01,  .7226D-01,
     +   .2264D+00, -.7589D-01, -.1180D-01,  .9037D-02,  .2361D+00,
     +   .2018D+00, -.5620D-01,  .7459D-01,
     +   .2270D+00, -.7550D-01, -.1134D-01,  .9197D-02,  .2307D+00,
     +   .2046D+00, -.5424D-01,  .7694D-01,
     +   .2275D+00, -.7510D-01, -.1092D-01,  .9329D-02,  .2255D+00,
     +   .2072D+00, -.5248D-01,  .7908D-01,
     +   .2278D+00, -.7469D-01, -.1052D-01,  .9444D-02,  .2204D+00,
     +   .2097D+00, -.5079D-01,  .8114D-01,
     +   .2281D+00, -.7430D-01, -.1018D-01,  .9533D-02,  .2158D+00,
     +   .2119D+00, -.4935D-01,  .8292D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=1,8)/
     +   .2020D+00, -.8269D-01, -.2651D-01,  .1397D-02,  .2050D+00,
     +   .1403D+00, -.1289D+00,  .1036D-01,
     +   .2083D+00, -.8343D-01, -.2556D-01,  .1997D-02,  .2238D+00,
     +   .1494D+00, -.1239D+00,  .1736D-01,
     +   .2128D+00, -.8386D-01, -.2481D-01,  .2464D-02,  .2349D+00,
     +   .1560D+00, -.1200D+00,  .2255D-01,
     +   .2175D+00, -.8424D-01, -.2392D-01,  .2998D-02,  .2445D+00,
     +   .1631D+00, -.1155D+00,  .2832D-01,
     +   .2226D+00, -.8453D-01, -.2284D-01,  .3621D-02,  .2521D+00,
     +   .1711D+00, -.1101D+00,  .3494D-01,
     +   .2259D+00, -.8464D-01, -.2207D-01,  .4054D-02,  .2555D+00,
     +   .1766D+00, -.1063D+00,  .3952D-01,
     +   .2283D+00, -.8467D-01, -.2147D-01,  .4378D-02,  .2569D+00,
     +   .1806D+00, -.1034D+00,  .4296D-01,
     +   .2315D+00, -.8464D-01, -.2059D-01,  .4838D-02,  .2575D+00,
     +   .1864D+00, -.9919D-01,  .4790D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=9,16)/
     +   .2337D+00, -.8456D-01, -.1997D-01,  .5153D-02,  .2569D+00,
     +   .1904D+00, -.9622D-01,  .5135D-01,
     +   .2374D+00, -.8426D-01, -.1876D-01,  .5730D-02,  .2536D+00,
     +   .1980D+00, -.9056D-01,  .5788D-01,
     +   .2403D+00, -.8384D-01, -.1769D-01,  .6200D-02,  .2485D+00,
     +   .2045D+00, -.8565D-01,  .6352D-01,
     +   .2424D+00, -.8337D-01, -.1679D-01,  .6566D-02,  .2429D+00,
     +   .2099D+00, -.8156D-01,  .6822D-01,
     +   .2439D+00, -.8290D-01, -.1606D-01,  .6843D-02,  .2374D+00,
     +   .2142D+00, -.7825D-01,  .7204D-01,
     +   .2453D+00, -.8227D-01, -.1524D-01,  .7128D-02,  .2303D+00,
     +   .2191D+00, -.7458D-01,  .7632D-01,
     +   .2462D+00, -.8166D-01, -.1455D-01,  .7345D-02,  .2238D+00,
     +   .2232D+00, -.7151D-01,  .7990D-01,
     +   .2469D+00, -.8104D-01, -.1392D-01,  .7522D-02,  .2174D+00,
     +   .2270D+00, -.6874D-01,  .8317D-01 /
        DATA ((PARTON(I,N,19),I=1,8),N=17,25)/
     +   .2473D+00, -.8043D-01, -.1338D-01,  .7661D-02,  .2115D+00,
     +   .2303D+00, -.6633D-01,  .8603D-01,
     +   .2476D+00, -.7963D-01, -.1273D-01,  .7807D-02,  .2040D+00,
     +   .2343D+00, -.6346D-01,  .8948D-01,
     +   .2476D+00, -.7885D-01, -.1216D-01,  .7917D-02,  .1971D+00,
     +   .2378D+00, -.6092D-01,  .9256D-01,
     +   .2474D+00, -.7804D-01, -.1162D-01,  .8002D-02,  .1903D+00,
     +   .2412D+00, -.5854D-01,  .9549D-01,
     +   .2471D+00, -.7731D-01, -.1117D-01,  .8059D-02,  .1845D+00,
     +   .2442D+00, -.5654D-01,  .9797D-01,
     +   .2467D+00, -.7653D-01, -.1073D-01,  .8102D-02,  .1785D+00,
     +   .2471D+00, -.5456D-01,  .1005D+00,
     +   .2461D+00, -.7579D-01, -.1033D-01,  .8130D-02,  .1731D+00,
     +   .2498D+00, -.5278D-01,  .1027D+00,
     +   .2454D+00, -.7503D-01, -.9953D-02,  .8145D-02,  .1678D+00,
     +   .2524D+00, -.5107D-01,  .1050D+00,
     +   .2447D+00, -.7435D-01, -.9631D-02,  .8150D-02,  .1632D+00,
     +   .2547D+00, -.4961D-01,  .1069D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=1,8)/
     +   .2368D+00, -.9150D-01, -.2694D-01,  .1849D-02,  .2338D+00,
     +   .1750D+00, -.1304D+00,  .2782D-01,
     +   .2426D+00, -.9161D-01, -.2563D-01,  .2489D-02,  .2437D+00,
     +   .1849D+00, -.1244D+00,  .3592D-01,
     +   .2465D+00, -.9156D-01, -.2464D-01,  .2955D-02,  .2482D+00,
     +   .1920D+00, -.1198D+00,  .4178D-01,
     +   .2504D+00, -.9138D-01, -.2353D-01,  .3460D-02,  .2505D+00,
     +   .1996D+00, -.1147D+00,  .4819D-01,
     +   .2545D+00, -.9101D-01, -.2225D-01,  .4017D-02,  .2502D+00,
     +   .2080D+00, -.1088D+00,  .5541D-01,
     +   .2571D+00, -.9064D-01, -.2135D-01,  .4386D-02,  .2482D+00,
     +   .2137D+00, -.1046D+00,  .6035D-01,
     +   .2588D+00, -.9031D-01, -.2067D-01,  .4651D-02,  .2458D+00,
     +   .2178D+00, -.1016D+00,  .6402D-01,
     +   .2610D+00, -.8973D-01, -.1970D-01,  .5013D-02,  .2412D+00,
     +   .2237D+00, -.9710D-01,  .6924D-01 /
        DATA ((PARTON(I,N,20),I=1,8),N=9,16)/
     +   .2624D+00, -.8926D-01, -.1901D-01,  .5252D-02,  .2373D+00,
     +   .2278D+00, -.9399D-01,  .7287D-01,
     +   .2645D+00, -.8821D-01, -.1772D-01,  .5666D-02,  .2281D+00,
     +   .2354D+00, -.8813D-01,  .7968D-01,
     +   .2659D+00, -.8712D-01, -.1662D-01,  .5980D-02,  .2187D+00,
     +   .2419D+00, -.8309D-01,  .8551D-01,
     +   .2665D+00, -.8606D-01, -.1570D-01,  .6207D-02,  .2100D+00,
     +   .2472D+00, -.7892D-01,  .9035D-01,
     +   .2668D+00, -.8511D-01, -.1496D-01,  .6367D-02,  .2024D+00,
     +   .2515D+00, -.7556D-01,  .9428D-01,
     +   .2667D+00, -.8394D-01, -.1414D-01,  .6518D-02,  .1934D+00,
     +   .2563D+00, -.7184D-01,  .9866D-01,
     +   .2663D+00, -.8286D-01, -.1346D-01,  .6620D-02,  .1856D+00,
     +   .2604D+00, -.6873D-01,  .1023D+00,
     +   .2658D+00, -.8181D-01, -.1285D-01,  .6694D-02,  .1783D+00,
     +   .2641D+00, -.6593D-01,  .1057D+00 /
        DATA ((PARTON(I,N,20),I=1,8),N=17,25)/
     +   .2650D+00, -.8083D-01, -.1232D-01,  .6742D-02,  .1718D+00,
     +   .2673D+00, -.6349D-01,  .1086D+00,
     +   .2639D+00, -.7957D-01, -.1169D-01,  .6781D-02,  .1639D+00,
     +   .2712D+00, -.6058D-01,  .1121D+00,
     +   .2626D+00, -.7838D-01, -.1114D-01,  .6797D-02,  .1568D+00,
     +   .2747D+00, -.5801D-01,  .1153D+00,
     +   .2612D+00, -.7719D-01, -.1063D-01,  .6796D-02,  .1501D+00,
     +   .2780D+00, -.5559D-01,  .1182D+00,
     +   .2597D+00, -.7614D-01, -.1020D-01,  .6783D-02,  .1444D+00,
     +   .2809D+00, -.5356D-01,  .1208D+00,
     +   .2581D+00, -.7504D-01, -.9781D-02,  .6758D-02,  .1388D+00,
     +   .2838D+00, -.5155D-01,  .1234D+00,
     +   .2565D+00, -.7401D-01, -.9404D-02,  .6726D-02,  .1337D+00,
     +   .2865D+00, -.4972D-01,  .1257D+00,
     +   .2548D+00, -.7297D-01, -.9047D-02,  .6687D-02,  .1288D+00,
     +   .2891D+00, -.4797D-01,  .1280D+00,
     +   .2533D+00, -.7205D-01, -.8744D-02,  .6646D-02,  .1247D+00,
     +   .2914D+00, -.4648D-01,  .1300D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=1,8)/
     +   .2695D+00, -.9816D-01, -.2623D-01,  .2059D-02,  .2503D+00,
     +   .2101D+00, -.1275D+00,  .4836D-01,
     +   .2742D+00, -.9755D-01, -.2469D-01,  .2673D-02,  .2512D+00,
     +   .2203D+00, -.1207D+00,  .5705D-01,
     +   .2771D+00, -.9697D-01, -.2357D-01,  .3098D-02,  .2495D+00,
     +   .2274D+00, -.1158D+00,  .6325D-01,
     +   .2799D+00, -.9619D-01, -.2234D-01,  .3538D-02,  .2454D+00,
     +   .2350D+00, -.1103D+00,  .6995D-01,
     +   .2826D+00, -.9512D-01, -.2094D-01,  .3999D-02,  .2384D+00,
     +   .2433D+00, -.1041D+00,  .7741D-01,
     +   .2840D+00, -.9426D-01, -.1999D-01,  .4290D-02,  .2324D+00,
     +   .2489D+00, -.9978D-01,  .8246D-01,
     +   .2849D+00, -.9355D-01, -.1929D-01,  .4491D-02,  .2272D+00,
     +   .2530D+00, -.9658D-01,  .8620D-01,
     +   .2858D+00, -.9244D-01, -.1828D-01,  .4756D-02,  .2190D+00,
     +   .2587D+00, -.9201D-01,  .9150D-01 /
        DATA ((PARTON(I,N,21),I=1,8),N=9,16)/
     +   .2862D+00, -.9158D-01, -.1759D-01,  .4923D-02,  .2128D+00,
     +   .2626D+00, -.8885D-01,  .9517D-01,
     +   .2863D+00, -.8979D-01, -.1629D-01,  .5194D-02,  .2001D+00,
     +   .2699D+00, -.8290D-01,  .1020D+00,
     +   .2858D+00, -.8806D-01, -.1519D-01,  .5381D-02,  .1883D+00,
     +   .2761D+00, -.7780D-01,  .1078D+00,
     +   .2848D+00, -.8647D-01, -.1429D-01,  .5502D-02,  .1782D+00,
     +   .2811D+00, -.7359D-01,  .1127D+00,
     +   .2837D+00, -.8508D-01, -.1357D-01,  .5576D-02,  .1697D+00,
     +   .2852D+00, -.7020D-01,  .1166D+00,
     +   .2820D+00, -.8342D-01, -.1278D-01,  .5632D-02,  .1602D+00,
     +   .2898D+00, -.6646D-01,  .1209D+00,
     +   .2802D+00, -.8193D-01, -.1213D-01,  .5658D-02,  .1522D+00,
     +   .2936D+00, -.6333D-01,  .1246D+00,
     +   .2783D+00, -.8051D-01, -.1155D-01,  .5665D-02,  .1449D+00,
     +   .2971D+00, -.6049D-01,  .1279D+00 /
        DATA ((PARTON(I,N,21),I=1,8),N=17,25)/
     +   .2764D+00, -.7921D-01, -.1105D-01,  .5657D-02,  .1385D+00,
     +   .3001D+00, -.5803D-01,  .1308D+00,
     +   .2738D+00, -.7757D-01, -.1046D-01,  .5632D-02,  .1310D+00,
     +   .3038D+00, -.5508D-01,  .1343D+00,
     +   .2711D+00, -.7604D-01, -.9938D-02,  .5594D-02,  .1244D+00,
     +   .3071D+00, -.5246D-01,  .1375D+00,
     +   .2684D+00, -.7454D-01, -.9457D-02,  .5546D-02,  .1182D+00,
     +   .3102D+00, -.5000D-01,  .1404D+00,
     +   .2659D+00, -.7323D-01, -.9058D-02,  .5496D-02,  .1131D+00,
     +   .3129D+00, -.4793D-01,  .1430D+00,
     +   .2632D+00, -.7188D-01, -.8666D-02,  .5438D-02,  .1081D+00,
     +   .3157D+00, -.4587D-01,  .1456D+00,
     +   .2606D+00, -.7062D-01, -.8315D-02,  .5377D-02,  .1036D+00,
     +   .3183D+00, -.4400D-01,  .1479D+00,
     +   .2579D+00, -.6937D-01, -.7983D-02,  .5313D-02,  .9942D-01,
     +   .3208D+00, -.4221D-01,  .1503D+00,
     +   .2555D+00, -.6828D-01, -.7702D-02,  .5253D-02,  .9587D-01,
     +   .3231D+00, -.4067D-01,  .1523D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=1,8)/
     +   .2998D+00, -.1028D+00, -.2475D-01,  .2073D-02,  .2545D+00,
     +   .2444D+00, -.1210D+00,  .7085D-01,
     +   .3028D+00, -.1014D+00, -.2309D-01,  .2623D-02,  .2475D+00,
     +   .2544D+00, -.1139D+00,  .7973D-01,
     +   .3045D+00, -.1003D+00, -.2191D-01,  .2987D-02,  .2406D+00,
     +   .2613D+00, -.1087D+00,  .8601D-01,
     +   .3058D+00, -.9891D-01, -.2064D-01,  .3348D-02,  .2315D+00,
     +   .2685D+00, -.1031D+00,  .9273D-01,
     +   .3066D+00, -.9715D-01, -.1923D-01,  .3709D-02,  .2198D+00,
     +   .2764D+00, -.9669D-01,  .1002D+00,
     +   .3067D+00, -.9582D-01, -.1827D-01,  .3926D-02,  .2109D+00,
     +   .2817D+00, -.9234D-01,  .1052D+00,
     +   .3065D+00, -.9475D-01, -.1757D-01,  .4071D-02,  .2039D+00,
     +   .2855D+00, -.8911D-01,  .1089D+00,
     +   .3059D+00, -.9312D-01, -.1658D-01,  .4252D-02,  .1935D+00,
     +   .2909D+00, -.8451D-01,  .1141D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=9,16)/
     +   .3051D+00, -.9191D-01, -.1590D-01,  .4359D-02,  .1861D+00,
     +   .2946D+00, -.8133D-01,  .1177D+00,
     +   .3030D+00, -.8945D-01, -.1465D-01,  .4520D-02,  .1717D+00,
     +   .3014D+00, -.7536D-01,  .1244D+00,
     +   .3004D+00, -.8714D-01, -.1360D-01,  .4615D-02,  .1592D+00,
     +   .3071D+00, -.7026D-01,  .1301D+00,
     +   .2977D+00, -.8508D-01, -.1274D-01,  .4662D-02,  .1487D+00,
     +   .3118D+00, -.6605D-01,  .1348D+00,
     +   .2951D+00, -.8331D-01, -.1206D-01,  .4679D-02,  .1403D+00,
     +   .3155D+00, -.6265D-01,  .1386D+00,
     +   .2917D+00, -.8123D-01, -.1132D-01,  .4676D-02,  .1311D+00,
     +   .3198D+00, -.5889D-01,  .1429D+00,
     +   .2885D+00, -.7941D-01, -.1071D-01,  .4656D-02,  .1235D+00,
     +   .3233D+00, -.5574D-01,  .1465D+00,
     +   .2852D+00, -.7768D-01, -.1016D-01,  .4624D-02,  .1167D+00,
     +   .3264D+00, -.5288D-01,  .1497D+00 /
        DATA ((PARTON(I,N,22),I=1,8),N=17,25)/
     +   .2822D+00, -.7612D-01, -.9697D-02,  .4586D-02,  .1110D+00,
     +   .3292D+00, -.5040D-01,  .1525D+00,
     +   .2781D+00, -.7418D-01, -.9148D-02,  .4528D-02,  .1042D+00,
     +   .3325D+00, -.4741D-01,  .1559D+00,
     +   .2742D+00, -.7240D-01, -.8669D-02,  .4465D-02,  .9833D-01,
     +   .3356D+00, -.4476D-01,  .1590D+00,
     +   .2703D+00, -.7066D-01, -.8226D-02,  .4396D-02,  .9296D-01,
     +   .3385D+00, -.4225D-01,  .1619D+00,
     +   .2668D+00, -.6916D-01, -.7860D-02,  .4332D-02,  .8856D-01,
     +   .3410D+00, -.4014D-01,  .1645D+00,
     +   .2631D+00, -.6762D-01, -.7500D-02,  .4261D-02,  .8429D-01,
     +   .3436D+00, -.3803D-01,  .1670D+00,
     +   .2595D+00, -.6620D-01, -.7179D-02,  .4192D-02,  .8051D-01,
     +   .3460D+00, -.3612D-01,  .1693D+00,
     +   .2559D+00, -.6480D-01, -.6876D-02,  .4121D-02,  .7698D-01,
     +   .3484D+00, -.3427D-01,  .1717D+00,
     +   .2528D+00, -.6359D-01, -.6620D-02,  .4058D-02,  .7402D-01,
     +   .3506D+00, -.3268D-01,  .1737D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=1,8)/
     +   .3271D+00, -.1055D+00, -.2276D-01,  .1949D-02,  .2478D+00,
     +   .2768D+00, -.1117D+00,  .9435D-01,
     +   .3281D+00, -.1034D+00, -.2109D-01,  .2417D-02,  .2346D+00,
     +   .2863D+00, -.1044D+00,  .1031D+00,
     +   .3282D+00, -.1017D+00, -.1991D-01,  .2714D-02,  .2240D+00,
     +   .2928D+00, -.9918D-01,  .1093D+00,
     +   .3277D+00, -.9978D-01, -.1866D-01,  .2999D-02,  .2115D+00,
     +   .2996D+00, -.9350D-01,  .1159D+00,
     +   .3264D+00, -.9737D-01, -.1728D-01,  .3269D-02,  .1967D+00,
     +   .3069D+00, -.8713D-01,  .1231D+00,
     +   .3250D+00, -.9560D-01, -.1636D-01,  .3423D-02,  .1863D+00,
     +   .3118D+00, -.8279D-01,  .1280D+00,
     +   .3237D+00, -.9421D-01, -.1569D-01,  .3521D-02,  .1784D+00,
     +   .3153D+00, -.7958D-01,  .1315D+00,
     +   .3213D+00, -.9212D-01, -.1475D-01,  .3637D-02,  .1671D+00,
     +   .3203D+00, -.7500D-01,  .1366D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=9,16)/
     +   .3193D+00, -.9059D-01, -.1410D-01,  .3700D-02,  .1593D+00,
     +   .3237D+00, -.7185D-01,  .1400D+00,
     +   .3148D+00, -.8754D-01, -.1292D-01,  .3783D-02,  .1447D+00,
     +   .3298D+00, -.6592D-01,  .1465D+00,
     +   .3101D+00, -.8474D-01, -.1194D-01,  .3815D-02,  .1324D+00,
     +   .3350D+00, -.6084D-01,  .1520D+00,
     +   .3056D+00, -.8229D-01, -.1114D-01,  .3816D-02,  .1225D+00,
     +   .3393D+00, -.5664D-01,  .1565D+00,
     +   .3015D+00, -.8021D-01, -.1051D-01,  .3800D-02,  .1146D+00,
     +   .3427D+00, -.5325D-01,  .1602D+00,
     +   .2965D+00, -.7780D-01, -.9829D-02,  .3765D-02,  .1062D+00,
     +   .3465D+00, -.4950D-01,  .1643D+00,
     +   .2919D+00, -.7571D-01, -.9270D-02,  .3721D-02,  .9939D-01,
     +   .3496D+00, -.4634D-01,  .1677D+00,
     +   .2873D+00, -.7375D-01, -.8772D-02,  .3672D-02,  .9340D-01,
     +   .3525D+00, -.4347D-01,  .1708D+00 /
        DATA ((PARTON(I,N,23),I=1,8),N=17,25)/
     +   .2831D+00, -.7199D-01, -.8347D-02,  .3621D-02,  .8836D-01,
     +   .3550D+00, -.4096D-01,  .1735D+00,
     +   .2778D+00, -.6983D-01, -.7847D-02,  .3551D-02,  .8252D-01,
     +   .3580D+00, -.3795D-01,  .1768D+00,
     +   .2727D+00, -.6786D-01, -.7413D-02,  .3480D-02,  .7753D-01,
     +   .3607D+00, -.3527D-01,  .1798D+00,
     +   .2677D+00, -.6596D-01, -.7012D-02,  .3407D-02,  .7300D-01,
     +   .3633D+00, -.3273D-01,  .1826D+00,
     +   .2632D+00, -.6433D-01, -.6682D-02,  .3341D-02,  .6932D-01,
     +   .3656D+00, -.3058D-01,  .1851D+00,
     +   .2586D+00, -.6267D-01, -.6358D-02,  .3271D-02,  .6576D-01,
     +   .3680D+00, -.2843D-01,  .1875D+00,
     +   .2542D+00, -.6115D-01, -.6070D-02,  .3204D-02,  .6265D-01,
     +   .3702D+00, -.2647D-01,  .1898D+00,
     +   .2499D+00, -.5966D-01, -.5798D-02,  .3137D-02,  .5975D-01,
     +   .3724D+00, -.2458D-01,  .1921D+00,
     +   .2461D+00, -.5837D-01, -.5570D-02,  .3078D-02,  .5733D-01,
     +   .3744D+00, -.2295D-01,  .1941D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=1,8)/
     +   .3509D+00, -.1064D+00, -.2050D-01,  .1740D-02,  .2325D+00,
     +   .3069D+00, -.1001D+00,  .1181D+00,
     +   .3495D+00, -.1037D+00, -.1888D-01,  .2123D-02,  .2151D+00,
     +   .3157D+00, -.9291D-01,  .1266D+00,
     +   .3479D+00, -.1015D+00, -.1775D-01,  .2357D-02,  .2021D+00,
     +   .3216D+00, -.8771D-01,  .1326D+00,
     +   .3455D+00, -.9902D-01, -.1655D-01,  .2573D-02,  .1878D+00,
     +   .3279D+00, -.8209D-01,  .1389D+00,
     +   .3419D+00, -.9603D-01, -.1525D-01,  .2768D-02,  .1717D+00,
     +   .3346D+00, -.7580D-01,  .1458D+00,
     +   .3388D+00, -.9387D-01, -.1439D-01,  .2872D-02,  .1607D+00,
     +   .3390D+00, -.7152D-01,  .1504D+00,
     +   .3362D+00, -.9219D-01, -.1376D-01,  .2935D-02,  .1527D+00,
     +   .3422D+00, -.6835D-01,  .1538D+00,
     +   .3321D+00, -.8971D-01, -.1289D-01,  .3004D-02,  .1414D+00,
     +   .3467D+00, -.6384D-01,  .1586D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=9,16)/
     +   .3288D+00, -.8791D-01, -.1229D-01,  .3037D-02,  .1338D+00,
     +   .3498D+00, -.6073D-01,  .1619D+00,
     +   .3219D+00, -.8438D-01, -.1121D-01,  .3068D-02,  .1199D+00,
     +   .3554D+00, -.5488D-01,  .1680D+00,
     +   .3152D+00, -.8119D-01, -.1030D-01,  .3063D-02,  .1086D+00,
     +   .3600D+00, -.4986D-01,  .1733D+00,
     +   .3089D+00, -.7842D-01, -.9580D-02,  .3039D-02,  .9959D-01,
     +   .3638D+00, -.4570D-01,  .1776D+00,
     +   .3034D+00, -.7611D-01, -.9008D-02,  .3006D-02,  .9265D-01,
     +   .3669D+00, -.4232D-01,  .1810D+00,
     +   .2968D+00, -.7345D-01, -.8389D-02,  .2956D-02,  .8526D-01,
     +   .3703D+00, -.3858D-01,  .1850D+00,
     +   .2908D+00, -.7117D-01, -.7884D-02,  .2905D-02,  .7939D-01,
     +   .3731D+00, -.3543D-01,  .1882D+00,
     +   .2851D+00, -.6904D-01, -.7437D-02,  .2850D-02,  .7428D-01,
     +   .3756D+00, -.3256D-01,  .1912D+00 /
        DATA ((PARTON(I,N,24),I=1,8),N=17,25)/
     +   .2799D+00, -.6716D-01, -.7056D-02,  .2797D-02,  .7002D-01,
     +   .3778D+00, -.3005D-01,  .1938D+00,
     +   .2734D+00, -.6485D-01, -.6610D-02,  .2728D-02,  .6512D-01,
     +   .3805D+00, -.2702D-01,  .1969D+00,
     +   .2673D+00, -.6277D-01, -.6223D-02,  .2660D-02,  .6098D-01,
     +   .3829D+00, -.2432D-01,  .1997D+00,
     +   .2613D+00, -.6077D-01, -.5867D-02,  .2592D-02,  .5725D-01,
     +   .3853D+00, -.2175D-01,  .2024D+00,
     +   .2560D+00, -.5906D-01, -.5575D-02,  .2531D-02,  .5423D-01,
     +   .3873D+00, -.1958D-01,  .2048D+00,
     +   .2506D+00, -.5734D-01, -.5289D-02,  .2469D-02,  .5133D-01,
     +   .3894D+00, -.1740D-01,  .2071D+00,
     +   .2456D+00, -.5576D-01, -.5035D-02,  .2409D-02,  .4880D-01,
     +   .3914D+00, -.1541D-01,  .2093D+00,
     +   .2406D+00, -.5423D-01, -.4797D-02,  .2351D-02,  .4645D-01,
     +   .3935D+00, -.1349D-01,  .2115D+00,
     +   .2363D+00, -.5292D-01, -.4596D-02,  .2299D-02,  .4451D-01,
     +   .3953D+00, -.1183D-01,  .2134D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=1,8)/
     +   .3708D+00, -.1058D+00, -.1811D-01,  .1490D-02,  .2110D+00,
     +   .3344D+00, -.8690D-01,  .1417D+00,
     +   .3669D+00, -.1024D+00, -.1659D-01,  .1794D-02,  .1914D+00,
     +   .3424D+00, -.7978D-01,  .1498D+00,
     +   .3634D+00, -.9981D-01, -.1553D-01,  .1973D-02,  .1774D+00,
     +   .3478D+00, -.7469D-01,  .1554D+00,
     +   .3588D+00, -.9685D-01, -.1443D-01,  .2131D-02,  .1625D+00,
     +   .3535D+00, -.6918D-01,  .1613D+00,
     +   .3528D+00, -.9337D-01, -.1323D-01,  .2267D-02,  .1464D+00,
     +   .3596D+00, -.6302D-01,  .1679D+00,
     +   .3481D+00, -.9088D-01, -.1244D-01,  .2335D-02,  .1357D+00,
     +   .3635D+00, -.5884D-01,  .1722D+00,
     +   .3443D+00, -.8897D-01, -.1187D-01,  .2373D-02,  .1281D+00,
     +   .3664D+00, -.5574D-01,  .1754D+00,
     +   .3383D+00, -.8616D-01, -.1107D-01,  .2409D-02,  .1175D+00,
     +   .3705D+00, -.5132D-01,  .1799D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=9,16)/
     +   .3338D+00, -.8415D-01, -.1054D-01,  .2423D-02,  .1105D+00,
     +   .3733D+00, -.4827D-01,  .1831D+00,
     +   .3246D+00, -.8025D-01, -.9556D-02,  .2423D-02,  .9795D-01,
     +   .3782D+00, -.4252D-01,  .1889D+00,
     +   .3158D+00, -.7676D-01, -.8747D-02,  .2400D-02,  .8793D-01,
     +   .3824D+00, -.3758D-01,  .1938D+00,
     +   .3079D+00, -.7377D-01, -.8099D-02,  .2364D-02,  .8014D-01,
     +   .3857D+00, -.3347D-01,  .1978D+00,
     +   .3011D+00, -.7129D-01, -.7590D-02,  .2326D-02,  .7419D-01,
     +   .3884D+00, -.3014D-01,  .2011D+00,
     +   .2930D+00, -.6847D-01, -.7039D-02,  .2273D-02,  .6794D-01,
     +   .3915D+00, -.2643D-01,  .2048D+00,
     +   .2859D+00, -.6606D-01, -.6593D-02,  .2222D-02,  .6302D-01,
     +   .3940D+00, -.2330D-01,  .2079D+00,
     +   .2792D+00, -.6384D-01, -.6198D-02,  .2171D-02,  .5878D-01,
     +   .3962D+00, -.2044D-01,  .2107D+00 /
        DATA ((PARTON(I,N,25),I=1,8),N=17,25)/
     +   .2731D+00, -.6188D-01, -.5863D-02,  .2122D-02,  .5526D-01,
     +   .3981D+00, -.1793D-01,  .2131D+00,
     +   .2655D+00, -.5950D-01, -.5471D-02,  .2059D-02,  .5125D-01,
     +   .4005D+00, -.1491D-01,  .2161D+00,
     +   .2585D+00, -.5736D-01, -.5133D-02,  .2000D-02,  .4787D-01,
     +   .4026D+00, -.1220D-01,  .2187D+00,
     +   .2517D+00, -.5532D-01, -.4823D-02,  .1941D-02,  .4484D-01,
     +   .4046D+00, -.9627D-02,  .2213D+00,
     +   .2458D+00, -.5359D-01, -.4569D-02,  .1889D-02,  .4240D-01,
     +   .4064D+00, -.7443D-02,  .2235D+00,
     +   .2398D+00, -.5185D-01, -.4321D-02,  .1836D-02,  .4007D-01,
     +   .4083D+00, -.5246D-02,  .2257D+00,
     +   .2343D+00, -.5027D-01, -.4102D-02,  .1787D-02,  .3804D-01,
     +   .4101D+00, -.3236D-02,  .2278D+00,
     +   .2288D+00, -.4874D-01, -.3897D-02,  .1738D-02,  .3616D-01,
     +   .4119D+00, -.1287D-02,  .2299D+00,
     +   .2241D+00, -.4743D-01, -.3724D-02,  .1696D-02,  .3460D-01,
     +   .4136D+00,  .3962D-03,  .2318D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=1,8)/
     +   .3864D+00, -.1037D+00, -.1573D-01,  .1233D-02,  .1860D+00,
     +   .3593D+00, -.7231D-01,  .1647D+00,
     +   .3798D+00, -.9979D-01, -.1433D-01,  .1467D-02,  .1657D+00,
     +   .3665D+00, -.6538D-01,  .1723D+00,
     +   .3744D+00, -.9683D-01, -.1337D-01,  .1600D-02,  .1519D+00,
     +   .3714D+00, -.6043D-01,  .1775D+00,
     +   .3677D+00, -.9350D-01, -.1237D-01,  .1713D-02,  .1375D+00,
     +   .3765D+00, -.5508D-01,  .1831D+00,
     +   .3593D+00, -.8961D-01, -.1129D-01,  .1805D-02,  .1222D+00,
     +   .3819D+00, -.4910D-01,  .1892D+00,
     +   .3529D+00, -.8686D-01, -.1059D-01,  .1847D-02,  .1124D+00,
     +   .3855D+00, -.4503D-01,  .1932D+00,
     +   .3479D+00, -.8477D-01, -.1007D-01,  .1868D-02,  .1055D+00,
     +   .3881D+00, -.4201D-01,  .1962D+00,
     +   .3402D+00, -.8172D-01, -.9365D-02,  .1885D-02,  .9607D-01,
     +   .3917D+00, -.3770D-01,  .2005D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=9,16)/
     +   .3345D+00, -.7955D-01, -.8886D-02,  .1887D-02,  .8987D-01,
     +   .3942D+00, -.3473D-01,  .2034D+00,
     +   .3231D+00, -.7538D-01, -.8018D-02,  .1871D-02,  .7900D-01,
     +   .3986D+00, -.2910D-01,  .2088D+00,
     +   .3125D+00, -.7169D-01, -.7305D-02,  .1840D-02,  .7045D-01,
     +   .4023D+00, -.2426D-01,  .2134D+00,
     +   .3031D+00, -.6856D-01, -.6736D-02,  .1803D-02,  .6390D-01,
     +   .4053D+00, -.2023D-01,  .2172D+00,
     +   .2951D+00, -.6599D-01, -.6290D-02,  .1765D-02,  .5895D-01,
     +   .4076D+00, -.1694D-01,  .2202D+00,
     +   .2858D+00, -.6308D-01, -.5810D-02,  .1717D-02,  .5379D-01,
     +   .4104D+00, -.1327D-01,  .2238D+00,
     +   .2777D+00, -.6061D-01, -.5422D-02,  .1671D-02,  .4976D-01,
     +   .4126D+00, -.1018D-01,  .2266D+00,
     +   .2700D+00, -.5835D-01, -.5080D-02,  .1626D-02,  .4631D-01,
     +   .4145D+00, -.7344D-02,  .2292D+00 /
        DATA ((PARTON(I,N,26),I=1,8),N=17,25)/
     +   .2632D+00, -.5637D-01, -.4791D-02,  .1584D-02,  .4346D-01,
     +   .4162D+00, -.4861D-02,  .2315D+00,
     +   .2548D+00, -.5397D-01, -.4453D-02,  .1532D-02,  .4022D-01,
     +   .4182D+00, -.1855D-02,  .2343D+00,
     +   .2471D+00, -.5183D-01, -.4163D-02,  .1482D-02,  .3751D-01,
     +   .4200D+00,  .8410D-03,  .2368D+00,
     +   .2397D+00, -.4980D-01, -.3898D-02,  .1434D-02,  .3508D-01,
     +   .4218D+00,  .3408D-02,  .2392D+00,
     +   .2333D+00, -.4809D-01, -.3681D-02,  .1392D-02,  .3314D-01,
     +   .4234D+00,  .5592D-02,  .2413D+00,
     +   .2268D+00, -.4638D-01, -.3470D-02,  .1349D-02,  .3127D-01,
     +   .4251D+00,  .7792D-02,  .2434D+00,
     +   .2209D+00, -.4483D-01, -.3285D-02,  .1309D-02,  .2966D-01,
     +   .4267D+00,  .9808D-02,  .2454D+00,
     +   .2151D+00, -.4334D-01, -.3111D-02,  .1271D-02,  .2816D-01,
     +   .4283D+00,  .1177D-01,  .2473D+00,
     +   .2100D+00, -.4206D-01, -.2966D-02,  .1237D-02,  .2692D-01,
     +   .4298D+00,  .1346D-01,  .2491D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=1,8)/
     +   .3976D+00, -.1005D+00, -.1343D-01,  .9884D-03,  .1595D+00,
     +   .3818D+00, -.5668D-01,  .1868D+00,
     +   .3883D+00, -.9605D-01, -.1218D-01,  .1164D-02,  .1400D+00,
     +   .3882D+00, -.4999D-01,  .1939D+00,
     +   .3808D+00, -.9279D-01, -.1133D-01,  .1261D-02,  .1270D+00,
     +   .3926D+00, -.4521D-01,  .1988D+00,
     +   .3721D+00, -.8916D-01, -.1044D-01,  .1341D-02,  .1138D+00,
     +   .3971D+00, -.4004D-01,  .2039D+00,
     +   .3613D+00, -.8496D-01, -.9489D-02,  .1401D-02,  .1002D+00,
     +   .4020D+00, -.3426D-01,  .2096D+00,
     +   .3534D+00, -.8203D-01, -.8866D-02,  .1426D-02,  .9154D-01,
     +   .4051D+00, -.3032D-01,  .2133D+00,
     +   .3472D+00, -.7981D-01, -.8416D-02,  .1437D-02,  .8549D-01,
     +   .4074D+00, -.2739D-01,  .2161D+00,
     +   .3379D+00, -.7659D-01, -.7795D-02,  .1442D-02,  .7739D-01,
     +   .4107D+00, -.2322D-01,  .2201D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=9,16)/
     +   .3311D+00, -.7433D-01, -.7377D-02,  .1438D-02,  .7213D-01,
     +   .4129D+00, -.2032D-01,  .2228D+00,
     +   .3177D+00, -.6999D-01, -.6622D-02,  .1416D-02,  .6299D-01,
     +   .4169D+00, -.1485D-01,  .2278D+00,
     +   .3055D+00, -.6620D-01, -.6004D-02,  .1385D-02,  .5592D-01,
     +   .4201D+00, -.1012D-01,  .2321D+00,
     +   .2948D+00, -.6301D-01, -.5513D-02,  .1350D-02,  .5055D-01,
     +   .4227D+00, -.6170D-02,  .2356D+00,
     +   .2858D+00, -.6040D-01, -.5130D-02,  .1317D-02,  .4653D-01,
     +   .4248D+00, -.2950D-02,  .2385D+00,
     +   .2754D+00, -.5747D-01, -.4718D-02,  .1276D-02,  .4236D-01,
     +   .4273D+00,  .6619D-03,  .2418D+00,
     +   .2665D+00, -.5500D-01, -.4387D-02,  .1238D-02,  .3912D-01,
     +   .4291D+00,  .3708D-02,  .2445D+00,
     +   .2582D+00, -.5276D-01, -.4095D-02,  .1201D-02,  .3635D-01,
     +   .4308D+00,  .6501D-02,  .2469D+00 /
        DATA ((PARTON(I,N,27),I=1,8),N=17,25)/
     +   .2508D+00, -.5079D-01, -.3850D-02,  .1167D-02,  .3408D-01,
     +   .4323D+00,  .8952D-02,  .2490D+00,
     +   .2418D+00, -.4844D-01, -.3564D-02,  .1124D-02,  .3150D-01,
     +   .4340D+00,  .1192D-01,  .2516D+00,
     +   .2336D+00, -.4634D-01, -.3320D-02,  .1085D-02,  .2934D-01,
     +   .4356D+00,  .1459D-01,  .2539D+00,
     +   .2257D+00, -.4437D-01, -.3097D-02,  .1047D-02,  .2742D-01,
     +   .4372D+00,  .1714D-01,  .2561D+00,
     +   .2190D+00, -.4271D-01, -.2916D-02,  .1014D-02,  .2587D-01,
     +   .4385D+00,  .1931D-01,  .2581D+00,
     +   .2122D+00, -.4106D-01, -.2740D-02,  .9801D-03,  .2440D-01,
     +   .4400D+00,  .2150D-01,  .2601D+00,
     +   .2060D+00, -.3957D-01, -.2585D-02,  .9494D-03,  .2311D-01,
     +   .4414D+00,  .2351D-01,  .2619D+00,
     +   .2000D+00, -.3814D-01, -.2441D-02,  .9195D-03,  .2193D-01,
     +   .4429D+00,  .2547D-01,  .2638D+00,
     +   .1948D+00, -.3693D-01, -.2321D-02,  .8936D-03,  .2095D-01,
     +   .4442D+00,  .2717D-01,  .2655D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=1,8)/
     +   .4041D+00, -.9611D-01, -.1129D-01,  .7706D-03,  .1333D+00,
     +   .4019D+00, -.4030D-01,  .2080D+00,
     +   .3921D+00, -.9137D-01, -.1019D-01,  .9001D-03,  .1156D+00,
     +   .4077D+00, -.3387D-01,  .2145D+00,
     +   .3828D+00, -.8789D-01, -.9448D-02,  .9692D-03,  .1040D+00,
     +   .4115D+00, -.2927D-01,  .2190D+00,
     +   .3720D+00, -.8405D-01, -.8674D-02,  .1024D-02,  .9244D-01,
     +   .4156D+00, -.2430D-01,  .2238D+00,
     +   .3591D+00, -.7964D-01, -.7848D-02,  .1063D-02,  .8067D-01,
     +   .4199D+00, -.1873D-01,  .2290D+00,
     +   .3497D+00, -.7659D-01, -.7309D-02,  .1077D-02,  .7335D-01,
     +   .4227D+00, -.1493D-01,  .2325D+00,
     +   .3425D+00, -.7430D-01, -.6921D-02,  .1082D-02,  .6827D-01,
     +   .4247D+00, -.1210D-01,  .2350D+00,
     +   .3318D+00, -.7099D-01, -.6386D-02,  .1081D-02,  .6154D-01,
     +   .4276D+00, -.8063D-02,  .2387D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=9,16)/
     +   .3240D+00, -.6867D-01, -.6028D-02,  .1075D-02,  .5720D-01,
     +   .4296D+00, -.5253D-02,  .2412D+00,
     +   .3089D+00, -.6428D-01, -.5382D-02,  .1053D-02,  .4974D-01,
     +   .4331D+00,  .6058D-04,  .2459D+00,
     +   .2953D+00, -.6046D-01, -.4856D-02,  .1025D-02,  .4403D-01,
     +   .4360D+00,  .4658D-02,  .2498D+00,
     +   .2835D+00, -.5728D-01, -.4439D-02,  .9952D-03,  .3973D-01,
     +   .4383D+00,  .8507D-02,  .2531D+00,
     +   .2738D+00, -.5469D-01, -.4115D-02,  .9680D-03,  .3652D-01,
     +   .4401D+00,  .1165D-01,  .2558D+00,
     +   .2626D+00, -.5180D-01, -.3769D-02,  .9345D-03,  .3320D-01,
     +   .4423D+00,  .1519D-01,  .2589D+00,
     +   .2530D+00, -.4939D-01, -.3491D-02,  .9042D-03,  .3064D-01,
     +   .4440D+00,  .1818D-01,  .2613D+00,
     +   .2442D+00, -.4720D-01, -.3247D-02,  .8750D-03,  .2845D-01,
     +   .4454D+00,  .2092D-01,  .2636D+00 /
        DATA ((PARTON(I,N,28),I=1,8),N=17,25)/
     +   .2364D+00, -.4529D-01, -.3043D-02,  .8485D-03,  .2665D-01,
     +   .4467D+00,  .2333D-01,  .2656D+00,
     +   .2269D+00, -.4302D-01, -.2806D-02,  .8154D-03,  .2462D-01,
     +   .4482D+00,  .2625D-01,  .2680D+00,
     +   .2184D+00, -.4101D-01, -.2603D-02,  .7851D-03,  .2292D-01,
     +   .4496D+00,  .2888D-01,  .2701D+00,
     +   .2102D+00, -.3912D-01, -.2420D-02,  .7558D-03,  .2139D-01,
     +   .4509D+00,  .3140D-01,  .2722D+00,
     +   .2033D+00, -.3754D-01, -.2271D-02,  .7306D-03,  .2017D-01,
     +   .4521D+00,  .3355D-01,  .2740D+00,
     +   .1964D+00, -.3598D-01, -.2127D-02,  .7052D-03,  .1901D-01,
     +   .4534D+00,  .3572D-01,  .2759D+00,
     +   .1901D+00, -.3457D-01, -.2001D-02,  .6819D-03,  .1799D-01,
     +   .4546D+00,  .3771D-01,  .2776D+00,
     +   .1840D+00, -.3323D-01, -.1883D-02,  .6593D-03,  .1706D-01,
     +   .4559D+00,  .3966D-01,  .2794D+00,
     +   .1788D+00, -.3209D-01, -.1786D-02,  .6398D-03,  .1628D-01,
     +   .4571D+00,  .4134D-01,  .2809D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=1,8)/
     +   .4060D+00, -.9092D-01, -.9337D-02,  .5854D-03,  .1089D+00,
     +   .4200D+00, -.2336D-01,  .2281D+00,
     +   .3914D+00, -.8594D-01, -.8393D-02,  .6789D-03,  .9341D-01,
     +   .4251D+00, -.1720D-01,  .2341D+00,
     +   .3804D+00, -.8232D-01, -.7754D-02,  .7275D-03,  .8349D-01,
     +   .4285D+00, -.1280D-01,  .2382D+00,
     +   .3678D+00, -.7834D-01, -.7092D-02,  .7649D-03,  .7372D-01,
     +   .4321D+00, -.8035D-02,  .2426D+00,
     +   .3529D+00, -.7383D-01, -.6387D-02,  .7899D-03,  .6395D-01,
     +   .4359D+00, -.2686D-02,  .2474D+00,
     +   .3423D+00, -.7073D-01, -.5929D-02,  .7977D-03,  .5794D-01,
     +   .4384D+00,  .9697D-03,  .2506D+00,
     +   .3341D+00, -.6841D-01, -.5600D-02,  .7992D-03,  .5381D-01,
     +   .4402D+00,  .3693D-02,  .2530D+00,
     +   .3221D+00, -.6508D-01, -.5148D-02,  .7954D-03,  .4836D-01,
     +   .4427D+00,  .7590D-02,  .2563D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=9,16)/
     +   .3136D+00, -.6276D-01, -.4846D-02,  .7890D-03,  .4488D-01,
     +   .4446D+00,  .1031D-01,  .2587D+00,
     +   .2971D+00, -.5839D-01, -.4303D-02,  .7698D-03,  .3895D-01,
     +   .4477D+00,  .1545D-01,  .2630D+00,
     +   .2823D+00, -.5463D-01, -.3863D-02,  .7465D-03,  .3443D-01,
     +   .4502D+00,  .1991D-01,  .2666D+00,
     +   .2698D+00, -.5152D-01, -.3516D-02,  .7231D-03,  .3104D-01,
     +   .4522D+00,  .2364D-01,  .2697D+00,
     +   .2594D+00, -.4900D-01, -.3247D-02,  .7018D-03,  .2852D-01,
     +   .4538D+00,  .2670D-01,  .2721D+00,
     +   .2477D+00, -.4620D-01, -.2961D-02,  .6759D-03,  .2592D-01,
     +   .4559D+00,  .3017D-01,  .2750D+00,
     +   .2377D+00, -.4388D-01, -.2732D-02,  .6526D-03,  .2391D-01,
     +   .4573D+00,  .3309D-01,  .2773D+00,
     +   .2285D+00, -.4178D-01, -.2532D-02,  .6304D-03,  .2220D-01,
     +   .4586D+00,  .3577D-01,  .2794D+00 /
        DATA ((PARTON(I,N,29),I=1,8),N=17,25)/
     +   .2205D+00, -.3997D-01, -.2364D-02,  .6103D-03,  .2079D-01,
     +   .4597D+00,  .3812D-01,  .2813D+00,
     +   .2108D+00, -.3781D-01, -.2171D-02,  .5853D-03,  .1919D-01,
     +   .4610D+00,  .4099D-01,  .2835D+00,
     +   .2021D+00, -.3592D-01, -.2007D-02,  .5626D-03,  .1786D-01,
     +   .4622D+00,  .4357D-01,  .2855D+00,
     +   .1938D+00, -.3414D-01, -.1859D-02,  .5406D-03,  .1666D-01,
     +   .4633D+00,  .4604D-01,  .2874D+00,
     +   .1869D+00, -.3267D-01, -.1738D-02,  .5219D-03,  .1570D-01,
     +   .4644D+00,  .4816D-01,  .2891D+00,
     +   .1799D+00, -.3121D-01, -.1623D-02,  .5029D-03,  .1478D-01,
     +   .4655D+00,  .5030D-01,  .2908D+00,
     +   .1736D+00, -.2990D-01, -.1522D-02,  .4856D-03,  .1398D-01,
     +   .4666D+00,  .5227D-01,  .2925D+00,
     +   .1676D+00, -.2866D-01, -.1428D-02,  .4689D-03,  .1324D-01,
     +   .4677D+00,  .5420D-01,  .2941D+00,
     +   .1624D+00, -.2761D-01, -.1351D-02,  .4545D-03,  .1263D-01,
     +   .4688D+00,  .5587D-01,  .2956D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=1,8)/
     +   .4033D+00, -.8504D-01, -.7598D-02,  .4338D-03,  .8688D-01,
     +   .4363D+00, -.6040D-02,  .2472D+00,
     +   .3864D+00, -.7993D-01, -.6800D-02,  .5003D-03,  .7395D-01,
     +   .4408D+00, -.1600D-03,  .2526D+00,
     +   .3738D+00, -.7625D-01, -.6261D-02,  .5341D-03,  .6577D-01,
     +   .4438D+00,  .4044D-02,  .2564D+00,
     +   .3596D+00, -.7223D-01, -.5705D-02,  .5595D-03,  .5783D-01,
     +   .4469D+00,  .8605D-02,  .2604D+00,
     +   .3430D+00, -.6770D-01, -.5115D-02,  .5754D-03,  .4996D-01,
     +   .4503D+00,  .1373D-01,  .2648D+00,
     +   .3313D+00, -.6461D-01, -.4732D-02,  .5797D-03,  .4518D-01,
     +   .4525D+00,  .1724D-01,  .2677D+00,
     +   .3224D+00, -.6230D-01, -.4458D-02,  .5797D-03,  .4191D-01,
     +   .4541D+00,  .1985D-01,  .2699D+00,
     +   .3094D+00, -.5902D-01, -.4083D-02,  .5756D-03,  .3763D-01,
     +   .4563D+00,  .2360D-01,  .2730D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=9,16)/
     +   .3002D+00, -.5675D-01, -.3832D-02,  .5701D-03,  .3490D-01,
     +   .4580D+00,  .2623D-01,  .2752D+00,
     +   .2826D+00, -.5248D-01, -.3384D-02,  .5545D-03,  .3028D-01,
     +   .4608D+00,  .3119D-01,  .2792D+00,
     +   .2671D+00, -.4884D-01, -.3022D-02,  .5365D-03,  .2677D-01,
     +   .4630D+00,  .3550D-01,  .2825D+00,
     +   .2540D+00, -.4585D-01, -.2738D-02,  .5187D-03,  .2414D-01,
     +   .4648D+00,  .3912D-01,  .2853D+00,
     +   .2432D+00, -.4344D-01, -.2519D-02,  .5027D-03,  .2218D-01,
     +   .4662D+00,  .4209D-01,  .2876D+00,
     +   .2311D+00, -.4078D-01, -.2286D-02,  .4832D-03,  .2017D-01,
     +   .4681D+00,  .4547D-01,  .2904D+00,
     +   .2209D+00, -.3859D-01, -.2101D-02,  .4659D-03,  .1861D-01,
     +   .4694D+00,  .4831D-01,  .2925D+00,
     +   .2116D+00, -.3661D-01, -.1940D-02,  .4495D-03,  .1727D-01,
     +   .4705D+00,  .5092D-01,  .2944D+00 /
        DATA ((PARTON(I,N,30),I=1,8),N=17,25)/
     +   .2035D+00, -.3491D-01, -.1806D-02,  .4346D-03,  .1617D-01,
     +   .4714D+00,  .5322D-01,  .2961D+00,
     +   .1937D+00, -.3290D-01, -.1651D-02,  .4162D-03,  .1493D-01,
     +   .4726D+00,  .5602D-01,  .2982D+00,
     +   .1850D+00, -.3113D-01, -.1521D-02,  .3995D-03,  .1388D-01,
     +   .4736D+00,  .5855D-01,  .3000D+00,
     +   .1768D+00, -.2950D-01, -.1403D-02,  .3834D-03,  .1294D-01,
     +   .4746D+00,  .6097D-01,  .3018D+00,
     +   .1700D+00, -.2814D-01, -.1308D-02,  .3697D-03,  .1219D-01,
     +   .4755D+00,  .6305D-01,  .3034D+00,
     +   .1631D+00, -.2680D-01, -.1217D-02,  .3558D-03,  .1146D-01,
     +   .4765D+00,  .6515D-01,  .3050D+00,
     +   .1569D+00, -.2560D-01, -.1137D-02,  .3431D-03,  .1083D-01,
     +   .4775D+00,  .6710D-01,  .3066D+00,
     +   .1510D+00, -.2447D-01, -.1064D-02,  .3309D-03,  .1025D-01,
     +   .4785D+00,  .6900D-01,  .3081D+00,
     +   .1460D+00, -.2352D-01, -.1004D-02,  .3204D-03,  .9764D-02,
     +   .4795D+00,  .7065D-01,  .3095D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=1,8)/
     +   .3961D+00, -.7867D-01, -.6082D-02,  .3139D-03,  .6785D-01,
     +   .4510D+00,  .1153D-01,  .2652D+00,
     +   .3773D+00, -.7353D-01, -.5419D-02,  .3605D-03,  .5744D-01,
     +   .4549D+00,  .1713D-01,  .2702D+00,
     +   .3633D+00, -.6985D-01, -.4973D-02,  .3840D-03,  .5093D-01,
     +   .4576D+00,  .2114D-01,  .2736D+00,
     +   .3477D+00, -.6587D-01, -.4513D-02,  .4012D-03,  .4467D-01,
     +   .4603D+00,  .2550D-01,  .2772D+00,
     +   .3298D+00, -.6141D-01, -.4027D-02,  .4116D-03,  .3854D-01,
     +   .4632D+00,  .3040D-01,  .2812D+00,
     +   .3172D+00, -.5838D-01, -.3714D-02,  .4140D-03,  .3484D-01,
     +   .4652D+00,  .3376D-01,  .2839D+00,
     +   .3077D+00, -.5613D-01, -.3489D-02,  .4136D-03,  .3231D-01,
     +   .4666D+00,  .3626D-01,  .2859D+00,
     +   .2940D+00, -.5295D-01, -.3183D-02,  .4101D-03,  .2902D-01,
     +   .4686D+00,  .3986D-01,  .2888D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=9,16)/
     +   .2844D+00, -.5076D-01, -.2979D-02,  .4058D-03,  .2693D-01,
     +   .4701D+00,  .4240D-01,  .2908D+00,
     +   .2660D+00, -.4667D-01, -.2615D-02,  .3941D-03,  .2339D-01,
     +   .4725D+00,  .4717D-01,  .2945D+00,
     +   .2500D+00, -.4320D-01, -.2323D-02,  .3808D-03,  .2070D-01,
     +   .4745D+00,  .5132D-01,  .2976D+00,
     +   .2366D+00, -.4037D-01, -.2095D-02,  .3678D-03,  .1869D-01,
     +   .4761D+00,  .5482D-01,  .3001D+00,
     +   .2256D+00, -.3810D-01, -.1920D-02,  .3561D-03,  .1719D-01,
     +   .4774D+00,  .5770D-01,  .3023D+00,
     +   .2134D+00, -.3561D-01, -.1735D-02,  .3420D-03,  .1564D-01,
     +   .4792D+00,  .6099D-01,  .3048D+00,
     +   .2032D+00, -.3357D-01, -.1588D-02,  .3294D-03,  .1443D-01,
     +   .4803D+00,  .6375D-01,  .3068D+00,
     +   .1939D+00, -.3174D-01, -.1461D-02,  .3175D-03,  .1340D-01,
     +   .4813D+00,  .6629D-01,  .3086D+00 /
        DATA ((PARTON(I,N,31),I=1,8),N=17,25)/
     +   .1859D+00, -.3017D-01, -.1355D-02,  .3068D-03,  .1254D-01,
     +   .4821D+00,  .6853D-01,  .3102D+00,
     +   .1762D+00, -.2832D-01, -.1234D-02,  .2935D-03,  .1157D-01,
     +   .4831D+00,  .7126D-01,  .3121D+00,
     +   .1677D+00, -.2671D-01, -.1131D-02,  .2814D-03,  .1075D-01,
     +   .4841D+00,  .7373D-01,  .3139D+00,
     +   .1597D+00, -.2521D-01, -.1040D-02,  .2698D-03,  .1002D-01,
     +   .4850D+00,  .7610D-01,  .3155D+00,
     +   .1530D+00, -.2398D-01, -.9661D-03,  .2598D-03,  .9424D-02,
     +   .4858D+00,  .7814D-01,  .3170D+00,
     +   .1464D+00, -.2277D-01, -.8957D-03,  .2499D-03,  .8856D-02,
     +   .4866D+00,  .8021D-01,  .3185D+00,
     +   .1404D+00, -.2169D-01, -.8347D-03,  .2407D-03,  .8359D-02,
     +   .4875D+00,  .8212D-01,  .3200D+00,
     +   .1347D+00, -.2068D-01, -.7784D-03,  .2319D-03,  .7899D-02,
     +   .4884D+00,  .8399D-01,  .3214D+00,
     +   .1299D+00, -.1983D-01, -.7321D-03,  .2244D-03,  .7517D-02,
     +   .4893D+00,  .8562D-01,  .3227D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=1,8)/
     +   .3699D+00, -.6511D-01, -.3699D-02,  .1534D-03,  .3892D-01,
     +   .4763D+00,  .4704D-01,  .2983D+00,
     +   .3480D+00, -.6018D-01, -.3266D-02,  .1758D-03,  .3286D-01,
     +   .4793D+00,  .5212D-01,  .3024D+00,
     +   .3322D+00, -.5670D-01, -.2976D-02,  .1871D-03,  .2915D-01,
     +   .4813D+00,  .5576D-01,  .3052D+00,
     +   .3148D+00, -.5297D-01, -.2679D-02,  .1953D-03,  .2562D-01,
     +   .4834D+00,  .5971D-01,  .3082D+00,
     +   .2951D+00, -.4886D-01, -.2368D-02,  .2004D-03,  .2219D-01,
     +   .4856D+00,  .6417D-01,  .3115D+00,
     +   .2815D+00, -.4610D-01, -.2168D-02,  .2016D-03,  .2013D-01,
     +   .4871D+00,  .6723D-01,  .3137D+00,
     +   .2714D+00, -.4407D-01, -.2026D-02,  .2014D-03,  .1873D-01,
     +   .4881D+00,  .6952D-01,  .3154D+00,
     +   .2570D+00, -.4123D-01, -.1832D-02,  .1998D-03,  .1690D-01,
     +   .4897D+00,  .7283D-01,  .3178D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=9,16)/
     +   .2470D+00, -.3928D-01, -.1705D-02,  .1978D-03,  .1574D-01,
     +   .4910D+00,  .7517D-01,  .3195D+00,
     +   .2281D+00, -.3569D-01, -.1479D-02,  .1922D-03,  .1375D-01,
     +   .4929D+00,  .7957D-01,  .3226D+00,
     +   .2120D+00, -.3270D-01, -.1299D-02,  .1858D-03,  .1223D-01,
     +   .4945D+00,  .8341D-01,  .3253D+00,
     +   .1987D+00, -.3027D-01, -.1161D-02,  .1794D-03,  .1107D-01,
     +   .4958D+00,  .8666D-01,  .3275D+00,
     +   .1880D+00, -.2836D-01, -.1055D-02,  .1737D-03,  .1020D-01,
     +   .4969D+00,  .8934D-01,  .3293D+00,
     +   .1762D+00, -.2628D-01, -.9440D-03,  .1667D-03,  .9289D-02,
     +   .4984D+00,  .9247D-01,  .3316D+00,
     +   .1665D+00, -.2458D-01, -.8569D-03,  .1605D-03,  .8574D-02,
     +   .4994D+00,  .9506D-01,  .3334D+00,
     +   .1577D+00, -.2308D-01, -.7820D-03,  .1546D-03,  .7957D-02,
     +   .5002D+00,  .9746D-01,  .3350D+00 /
        DATA ((PARTON(I,N,32),I=1,8),N=17,25)/
     +   .1501D+00, -.2180D-01, -.7202D-03,  .1492D-03,  .7444D-02,
     +   .5009D+00,  .9957D-01,  .3363D+00,
     +   .1412D+00, -.2030D-01, -.6500D-03,  .1426D-03,  .6856D-02,
     +   .5018D+00,  .1022D+00,  .3380D+00,
     +   .1334D+00, -.1901D-01, -.5913D-03,  .1365D-03,  .6359D-02,
     +   .5025D+00,  .1045D+00,  .3396D+00,
     +   .1261D+00, -.1782D-01, -.5391D-03,  .1307D-03,  .5910D-02,
     +   .5033D+00,  .1068D+00,  .3411D+00,
     +   .1201D+00, -.1685D-01, -.4974D-03,  .1257D-03,  .5547D-02,
     +   .5040D+00,  .1087D+00,  .3424D+00,
     +   .1141D+00, -.1590D-01, -.4580D-03,  .1206D-03,  .5198D-02,
     +   .5047D+00,  .1107D+00,  .3437D+00,
     +   .1089D+00, -.1507D-01, -.4239D-03,  .1160D-03,  .4892D-02,
     +   .5054D+00,  .1126D+00,  .3450D+00,
     +   .1039D+00, -.1428D-01, -.3928D-03,  .1116D-03,  .4609D-02,
     +   .5062D+00,  .1144D+00,  .3463D+00,
     +   .9964D-01, -.1363D-01, -.3673D-03,  .1077D-03,  .4374D-02,
     +   .5069D+00,  .1160D+00,  .3474D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=1,8)/
     +   .3302D+00, -.5141D-01, -.2086D-02,  .6874D-04,  .2072D-01,
     +   .4974D+00,  .8273D-01,  .3279D+00,
     +   .3070D+00, -.4700D-01, -.1824D-02,  .7936D-04,  .1770D-01,
     +   .4996D+00,  .8733D-01,  .3313D+00,
     +   .2904D+00, -.4391D-01, -.1650D-02,  .8491D-04,  .1585D-01,
     +   .5011D+00,  .9061D-01,  .3336D+00,
     +   .2724D+00, -.4065D-01, -.1472D-02,  .8921D-04,  .1408D-01,
     +   .5026D+00,  .9419D-01,  .3360D+00,
     +   .2524D+00, -.3709D-01, -.1288D-02,  .9215D-04,  .1236D-01,
     +   .5042D+00,  .9822D-01,  .3387D+00,
     +   .2389D+00, -.3473D-01, -.1170D-02,  .9313D-04,  .1131D-01,
     +   .5053D+00,  .1010D+00,  .3405D+00,
     +   .2289D+00, -.3301D-01, -.1087D-02,  .9337D-04,  .1059D-01,
     +   .5061D+00,  .1031D+00,  .3419D+00,
     +   .2148D+00, -.3061D-01, -.9744D-03,  .9302D-04,  .9630D-02,
     +   .5073D+00,  .1061D+00,  .3438D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=9,16)/
     +   .2051D+00, -.2899D-01, -.9007D-03,  .9234D-04,  .9011D-02,
     +   .5084D+00,  .1083D+00,  .3454D+00,
     +   .1871D+00, -.2603D-01, -.7715D-03,  .9015D-04,  .7935D-02,
     +   .5100D+00,  .1123D+00,  .3480D+00,
     +   .1719D+00, -.2360D-01, -.6701D-03,  .8742D-04,  .7088D-02,
     +   .5113D+00,  .1158D+00,  .3503D+00,
     +   .1596D+00, -.2165D-01, -.5924D-03,  .8460D-04,  .6434D-02,
     +   .5123D+00,  .1189D+00,  .3522D+00,
     +   .1498D+00, -.2012D-01, -.5337D-03,  .8199D-04,  .5932D-02,
     +   .5133D+00,  .1214D+00,  .3538D+00,
     +   .1391D+00, -.1848D-01, -.4728D-03,  .7877D-04,  .5402D-02,
     +   .5148D+00,  .1243D+00,  .3560D+00,
     +   .1303D+00, -.1716D-01, -.4254D-03,  .7584D-04,  .4981D-02,
     +   .5157D+00,  .1268D+00,  .3575D+00,
     +   .1226D+00, -.1599D-01, -.3850D-03,  .7302D-04,  .4615D-02,
     +   .5164D+00,  .1290D+00,  .3589D+00 /
        DATA ((PARTON(I,N,33),I=1,8),N=17,25)/
     +   .1159D+00, -.1501D-01, -.3520D-03,  .7045D-04,  .4308D-02,
     +   .5170D+00,  .1310D+00,  .3602D+00,
     +   .1081D+00, -.1387D-01, -.3147D-03,  .6724D-04,  .3956D-02,
     +   .5178D+00,  .1335D+00,  .3617D+00,
     +   .1013D+00, -.1289D-01, -.2838D-03,  .6429D-04,  .3656D-02,
     +   .5185D+00,  .1357D+00,  .3631D+00,
     +   .9513D-01, -.1200D-01, -.2566D-03,  .6144D-04,  .3385D-02,
     +   .5192D+00,  .1379D+00,  .3645D+00,
     +   .9001D-01, -.1128D-01, -.2350D-03,  .5899D-04,  .3166D-02,
     +   .5199D+00,  .1398D+00,  .3657D+00,
     +   .8503D-01, -.1058D-01, -.2148D-03,  .5652D-04,  .2955D-02,
     +   .5206D+00,  .1418D+00,  .3670D+00,
     +   .8061D-01, -.9968D-02, -.1974D-03,  .5425D-04,  .2771D-02,
     +   .5213D+00,  .1435D+00,  .3682D+00,
     +   .7646D-01, -.9396D-02, -.1816D-03,  .5206D-04,  .2600D-02,
     +   .5220D+00,  .1453D+00,  .3693D+00,
     +   .7299D-01, -.8921D-02, -.1688D-03,  .5018D-04,  .2459D-02,
     +   .5226D+00,  .1468D+00,  .3704D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=1,8)/
     +   .2811D+00, -.3857D-01, -.1080D-02,  .2846D-04,  .1037D-01,
     +   .5154D+00,  .1185D+00,  .3548D+00,
     +   .2581D+00, -.3485D-01, -.9339D-03,  .3352D-04,  .9098D-02,
     +   .5169D+00,  .1227D+00,  .3574D+00,
     +   .2419D+00, -.3229D-01, -.8377D-03,  .3635D-04,  .8300D-02,
     +   .5179D+00,  .1256D+00,  .3593D+00,
     +   .2247D+00, -.2961D-01, -.7405D-03,  .3871D-04,  .7517D-02,
     +   .5189D+00,  .1289D+00,  .3612D+00,
     +   .2058D+00, -.2672D-01, -.6402D-03,  .4054D-04,  .6721D-02,
     +   .5201D+00,  .1325D+00,  .3634D+00,
     +   .1931D+00, -.2483D-01, -.5769D-03,  .4131D-04,  .6218D-02,
     +   .5209D+00,  .1350D+00,  .3648D+00,
     +   .1839D+00, -.2346D-01, -.5325D-03,  .4165D-04,  .5862D-02,
     +   .5215D+00,  .1369D+00,  .3660D+00,
     +   .1710D+00, -.2157D-01, -.4729D-03,  .4179D-04,  .5376D-02,
     +   .5224D+00,  .1397D+00,  .3676D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=9,16)/
     +   .1622D+00, -.2030D-01, -.4341D-03,  .4166D-04,  .5053D-02,
     +   .5234D+00,  .1417D+00,  .3690D+00,
     +   .1461D+00, -.1801D-01, -.3668D-03,  .4095D-04,  .4475D-02,
     +   .5246D+00,  .1454D+00,  .3712D+00,
     +   .1327D+00, -.1614D-01, -.3146D-03,  .3987D-04,  .4007D-02,
     +   .5257D+00,  .1486D+00,  .3731D+00,
     +   .1220D+00, -.1467D-01, -.2751D-03,  .3867D-04,  .3636D-02,
     +   .5266D+00,  .1514D+00,  .3748D+00,
     +   .1135D+00, -.1353D-01, -.2455D-03,  .3751D-04,  .3349D-02,
     +   .5275D+00,  .1538D+00,  .3762D+00,
     +   .1044D+00, -.1231D-01, -.2151D-03,  .3605D-04,  .3041D-02,
     +   .5290D+00,  .1566D+00,  .3783D+00,
     +   .9707D-01, -.1134D-01, -.1917D-03,  .3469D-04,  .2795D-02,
     +   .5298D+00,  .1589D+00,  .3797D+00,
     +   .9057D-01, -.1049D-01, -.1720D-03,  .3337D-04,  .2581D-02,
     +   .5306D+00,  .1611D+00,  .3811D+00 /
        DATA ((PARTON(I,N,34),I=1,8),N=17,25)/
     +   .8508D-01, -.9785D-02, -.1559D-03,  .3215D-04,  .2401D-02,
     +   .5312D+00,  .1630D+00,  .3822D+00,
     +   .7869D-01, -.8969D-02, -.1380D-03,  .3063D-04,  .2193D-02,
     +   .5320D+00,  .1653D+00,  .3837D+00,
     +   .7320D-01, -.8275D-02, -.1233D-03,  .2922D-04,  .2017D-02,
     +   .5327D+00,  .1675D+00,  .3850D+00,
     +   .6820D-01, -.7650D-02, -.1105D-03,  .2785D-04,  .1858D-02,
     +   .5335D+00,  .1696D+00,  .3863D+00,
     +   .6412D-01, -.7144D-02, -.1004D-03,  .2668D-04,  .1729D-02,
     +   .5342D+00,  .1715D+00,  .3875D+00,
     +   .6017D-01, -.6659D-02, -.9100D-04,  .2549D-04,  .1606D-02,
     +   .5349D+00,  .1734D+00,  .3887D+00,
     +   .5670D-01, -.6235D-02, -.8300D-04,  .2440D-04,  .1499D-02,
     +   .5356D+00,  .1751D+00,  .3899D+00,
     +   .5346D-01, -.5844D-02, -.7580D-04,  .2335D-04,  .1400D-02,
     +   .5363D+00,  .1769D+00,  .3910D+00,
     +   .5077D-01, -.5520D-02, -.6999D-04,  .2245D-04,  .1319D-02,
     +   .5369D+00,  .1784D+00,  .3920D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=1,8)/
     +   .2268D+00, -.2727D-01, -.5043D-03,  .1105D-04,  .4963D-02,
     +   .5310D+00,  .1546D+00,  .3794D+00,
     +   .2057D+00, -.2435D-01, -.4312D-03,  .1346D-04,  .4538D-02,
     +   .5320D+00,  .1584D+00,  .3815D+00,
     +   .1910D+00, -.2237D-01, -.3832D-03,  .1490D-04,  .4243D-02,
     +   .5326D+00,  .1611D+00,  .3830D+00,
     +   .1756D+00, -.2031D-01, -.3353D-03,  .1617D-04,  .3927D-02,
     +   .5333D+00,  .1640D+00,  .3845D+00,
     +   .1588D+00, -.1812D-01, -.2862D-03,  .1724D-04,  .3577D-02,
     +   .5340D+00,  .1673D+00,  .3862D+00,
     +   .1478D+00, -.1670D-01, -.2556D-03,  .1773D-04,  .3340D-02,
     +   .5345D+00,  .1695D+00,  .3874D+00,
     +   .1398D+00, -.1568D-01, -.2342D-03,  .1799D-04,  .3165D-02,
     +   .5350D+00,  .1712D+00,  .3883D+00,
     +   .1288D+00, -.1428D-01, -.2059D-03,  .1818D-04,  .2918D-02,
     +   .5357D+00,  .1738D+00,  .3897D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=9,16)/
     +   .1213D+00, -.1336D-01, -.1875D-03,  .1819D-04,  .2749D-02,
     +   .5366D+00,  .1756D+00,  .3909D+00,
     +   .1078D+00, -.1170D-01, -.1561D-03,  .1797D-04,  .2436D-02,
     +   .5376D+00,  .1790D+00,  .3928D+00,
     +   .9680D-01, -.1037D-01, -.1320D-03,  .1753D-04,  .2176D-02,
     +   .5385D+00,  .1820D+00,  .3945D+00,
     +   .8807D-01, -.9332D-02, -.1140D-03,  .1700D-04,  .1968D-02,
     +   .5393D+00,  .1846D+00,  .3959D+00,
     +   .8128D-01, -.8535D-02, -.1007D-03,  .1648D-04,  .1805D-02,
     +   .5401D+00,  .1868D+00,  .3972D+00,
     +   .7403D-01, -.7695D-02, -.8721D-04,  .1581D-04,  .1630D-02,
     +   .5417D+00,  .1896D+00,  .3993D+00,
     +   .6822D-01, -.7030D-02, -.7691D-04,  .1518D-04,  .1491D-02,
     +   .5425D+00,  .1918D+00,  .4006D+00,
     +   .6315D-01, -.6455D-02, -.6831D-04,  .1456D-04,  .1368D-02,
     +   .5433D+00,  .1938D+00,  .4018D+00 /
        DATA ((PARTON(I,N,35),I=1,8),N=17,25)/
     +   .5890D-01, -.5977D-02, -.6138D-04,  .1400D-04,  .1266D-02,
     +   .5439D+00,  .1957D+00,  .4029D+00,
     +   .5400D-01, -.5432D-02, -.5373D-04,  .1328D-04,  .1149D-02,
     +   .5448D+00,  .1980D+00,  .4043D+00,
     +   .4984D-01, -.4974D-02, -.4752D-04,  .1262D-04,  .1050D-02,
     +   .5456D+00,  .2001D+00,  .4057D+00,
     +   .4607D-01, -.4563D-02, -.4213D-04,  .1198D-04,  .9612D-03,
     +   .5465D+00,  .2022D+00,  .4070D+00,
     +   .4303D-01, -.4234D-02, -.3795D-04,  .1143D-04,  .8898D-03,
     +   .5473D+00,  .2040D+00,  .4082D+00,
     +   .4010D-01, -.3920D-02, -.3408D-04,  .1087D-04,  .8217D-03,
     +   .5481D+00,  .2059D+00,  .4094D+00,
     +   .3755D-01, -.3648D-02, -.3082D-04,  .1037D-04,  .7627D-03,
     +   .5489D+00,  .2076D+00,  .4106D+00,
     +   .3518D-01, -.3398D-02, -.2791D-04,  .9882D-05,  .7085D-03,
     +   .5497D+00,  .2093D+00,  .4117D+00,
     +   .3323D-01, -.3193D-02, -.2558D-04,  .9470D-05,  .6640D-03,
     +   .5503D+00,  .2108D+00,  .4127D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=1,8)/
     +   .1720D+00, -.1796D-01, -.2078D-03,  .4101D-05,  .2316D-02,
     +   .5448D+00,  .1915D+00,  .4024D+00,
     +   .1539D+00, -.1584D-01, -.1753D-03,  .5212D-05,  .2217D-02,
     +   .5455D+00,  .1949D+00,  .4041D+00,
     +   .1416D+00, -.1441D-01, -.1542D-03,  .5902D-05,  .2121D-02,
     +   .5459D+00,  .1974D+00,  .4052D+00,
     +   .1287D+00, -.1295D-01, -.1333D-03,  .6526D-05,  .1998D-02,
     +   .5462D+00,  .2000D+00,  .4064D+00,
     +   .1150D+00, -.1141D-01, -.1122D-03,  .7062D-05,  .1842D-02,
     +   .5467D+00,  .2030D+00,  .4078D+00,
     +   .1060D+00, -.1043D-01, -.9917D-04,  .7316D-05,  .1727D-02,
     +   .5470D+00,  .2050D+00,  .4087D+00,
     +   .9961D-01, -.9729D-02, -.9016D-04,  .7451D-05,  .1639D-02,
     +   .5473D+00,  .2066D+00,  .4095D+00,
     +   .9081D-01, -.8779D-02, -.7829D-04,  .7560D-05,  .1511D-02,
     +   .5479D+00,  .2089D+00,  .4106D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=9,16)/
     +   .8494D-01, -.8152D-02, -.7071D-04,  .7572D-05,  .1421D-02,
     +   .5487D+00,  .2107D+00,  .4117D+00,
     +   .7445D-01, -.7045D-02, -.5784D-04,  .7479D-05,  .1253D-02,
     +   .5495D+00,  .2138D+00,  .4134D+00,
     +   .6600D-01, -.6170D-02, -.4816D-04,  .7277D-05,  .1112D-02,
     +   .5502D+00,  .2165D+00,  .4148D+00,
     +   .5940D-01, -.5495D-02, -.4103D-04,  .7037D-05,  .9979D-03,
     +   .5510D+00,  .2190D+00,  .4161D+00,
     +   .5433D-01, -.4982D-02, -.3583D-04,  .6794D-05,  .9092D-03,
     +   .5517D+00,  .2210D+00,  .4173D+00,
     +   .4897D-01, -.4446D-02, -.3059D-04,  .6486D-05,  .8145D-03,
     +   .5534D+00,  .2237D+00,  .4193D+00,
     +   .4472D-01, -.4026D-02, -.2666D-04,  .6198D-05,  .7390D-03,
     +   .5542D+00,  .2258D+00,  .4205D+00,
     +   .4105D-01, -.3667D-02, -.2341D-04,  .5913D-05,  .6737D-03,
     +   .5550D+00,  .2278D+00,  .4217D+00 /
        DATA ((PARTON(I,N,36),I=1,8),N=17,25)/
     +   .3800D-01, -.3371D-02, -.2082D-04,  .5655D-05,  .6194D-03,
     +   .5557D+00,  .2296D+00,  .4228D+00,
     +   .3452D-01, -.3036D-02, -.1799D-04,  .5335D-05,  .5574D-03,
     +   .5566D+00,  .2318D+00,  .4242D+00,
     +   .3158D-01, -.2757D-02, -.1573D-04,  .5035D-05,  .5055D-03,
     +   .5576D+00,  .2339D+00,  .4255D+00,
     +   .2896D-01, -.2509D-02, -.1378D-04,  .4752D-05,  .4593D-03,
     +   .5586D+00,  .2360D+00,  .4269D+00,
     +   .2685D-01, -.2312D-02, -.1229D-04,  .4510D-05,  .4224D-03,
     +   .5595D+00,  .2378D+00,  .4281D+00,
     +   .2484D-01, -.2125D-02, -.1092D-04,  .4267D-05,  .3876D-03,
     +   .5604D+00,  .2397D+00,  .4294D+00,
     +   .2311D-01, -.1965D-02, -.9784D-05,  .4049D-05,  .3576D-03,
     +   .5614D+00,  .2414D+00,  .4306D+00,
     +   .2151D-01, -.1818D-02, -.8777D-05,  .3837D-05,  .3302D-03,
     +   .5623D+00,  .2432D+00,  .4317D+00,
     +   .2020D-01, -.1699D-02, -.7976D-05,  .3660D-05,  .3078D-03,
     +   .5630D+00,  .2446D+00,  .4327D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=1,8)/
     +   .1208D+00, -.1082D-01, -.7284D-04,  .1464D-05,  .1059D-02,
     +   .5575D+00,  .2298D+00,  .4243D+00,
     +   .1066D+00, -.9415D-02, -.6050D-04,  .1930D-05,  .1050D-02,
     +   .5580D+00,  .2330D+00,  .4257D+00,
     +   .9703D-01, -.8482D-02, -.5259D-04,  .2222D-05,  .1019D-02,
     +   .5582D+00,  .2353D+00,  .4267D+00,
     +   .8718D-01, -.7535D-02, -.4484D-04,  .2484D-05,  .9666D-03,
     +   .5584D+00,  .2377D+00,  .4276D+00,
     +   .7682D-01, -.6555D-02, -.3712D-04,  .2703D-05,  .8923D-03,
     +   .5586D+00,  .2404D+00,  .4287D+00,
     +   .7017D-01, -.5933D-02, -.3241D-04,  .2802D-05,  .8350D-03,
     +   .5588D+00,  .2422D+00,  .4295D+00,
     +   .6544D-01, -.5495D-02, -.2919D-04,  .2855D-05,  .7900D-03,
     +   .5590D+00,  .2437D+00,  .4301D+00,
     +   .5901D-01, -.4907D-02, -.2500D-04,  .2891D-05,  .7239D-03,
     +   .5595D+00,  .2458D+00,  .4311D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=9,16)/
     +   .5477D-01, -.4522D-02, -.2234D-04,  .2888D-05,  .6774D-03,
     +   .5602D+00,  .2475D+00,  .4321D+00,
     +   .4728D-01, -.3852D-02, -.1791D-04,  .2832D-05,  .5903D-03,
     +   .5609D+00,  .2504D+00,  .4335D+00,
     +   .4136D-01, -.3329D-02, -.1464D-04,  .2735D-05,  .5177D-03,
     +   .5615D+00,  .2529D+00,  .4347D+00,
     +   .3679D-01, -.2931D-02, -.1227D-04,  .2621D-05,  .4600D-03,
     +   .5621D+00,  .2551D+00,  .4358D+00,
     +   .3331D-01, -.2632D-02, -.1057D-04,  .2514D-05,  .4153D-03,
     +   .5628D+00,  .2571D+00,  .4369D+00,
     +   .2969D-01, -.2324D-02, -.8881D-05,  .2379D-05,  .3682D-03,
     +   .5645D+00,  .2598D+00,  .4389D+00,
     +   .2685D-01, -.2084D-02, -.7633D-05,  .2256D-05,  .3310D-03,
     +   .5653D+00,  .2618D+00,  .4401D+00,
     +   .2442D-01, -.1881D-02, -.6616D-05,  .2133D-05,  .2992D-03,
     +   .5661D+00,  .2636D+00,  .4412D+00 /
        DATA ((PARTON(I,N,37),I=1,8),N=17,25)/
     +   .2242D-01, -.1716D-02, -.5817D-05,  .2026D-05,  .2729D-03,
     +   .5668D+00,  .2654D+00,  .4422D+00,
     +   .2016D-01, -.1530D-02, -.4955D-05,  .1894D-05,  .2433D-03,
     +   .5678D+00,  .2675D+00,  .4436D+00,
     +   .1828D-01, -.1377D-02, -.4277D-05,  .1771D-05,  .2188D-03,
     +   .5689D+00,  .2696D+00,  .4449D+00,
     +   .1661D-01, -.1242D-02, -.3700D-05,  .1658D-05,  .1973D-03,
     +   .5699D+00,  .2716D+00,  .4463D+00,
     +   .1528D-01, -.1136D-02, -.3263D-05,  .1564D-05,  .1802D-03,
     +   .5710D+00,  .2734D+00,  .4475D+00,
     +   .1403D-01, -.1036D-02, -.2870D-05,  .1468D-05,  .1642D-03,
     +   .5721D+00,  .2753D+00,  .4488D+00,
     +   .1295D-01, -.9512D-03, -.2544D-05,  .1383D-05,  .1505D-03,
     +   .5731D+00,  .2771D+00,  .4501D+00,
     +   .1197D-01, -.8741D-03, -.2266D-05,  .1299D-05,  .1381D-03,
     +   .5742D+00,  .2789D+00,  .4513D+00,
     +   .1117D-01, -.8117D-03, -.2044D-05,  .1236D-05,  .1281D-03,
     +   .5750D+00,  .2803D+00,  .4524D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=1,8)/
     +   .7685D-01, -.5794D-02, -.2050D-04,  .4762D-06,  .4605D-03,
     +   .5694D+00,  .2705D+00,  .4456D+00,
     +   .6676D-01, -.4966D-02, -.1670D-04,  .6382D-06,  .4629D-03,
     +   .5698D+00,  .2736D+00,  .4470D+00,
     +   .6005D-01, -.4423D-02, -.1431D-04,  .7375D-06,  .4494D-03,
     +   .5701D+00,  .2757D+00,  .4478D+00,
     +   .5326D-01, -.3881D-02, -.1200D-04,  .8219D-06,  .4245D-03,
     +   .5702D+00,  .2780D+00,  .4487D+00,
     +   .4622D-01, -.3326D-02, -.9736D-05,  .8907D-06,  .3881D-03,
     +   .5704D+00,  .2805D+00,  .4496D+00,
     +   .4177D-01, -.2980D-02, -.8376D-05,  .9148D-06,  .3601D-03,
     +   .5705D+00,  .2822D+00,  .4502D+00,
     +   .3863D-01, -.2738D-02, -.7457D-05,  .9280D-06,  .3382D-03,
     +   .5707D+00,  .2835D+00,  .4507D+00,
     +   .3442D-01, -.2416D-02, -.6277D-05,  .9352D-06,  .3065D-03,
     +   .5710D+00,  .2855D+00,  .4516D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=9,16)/
     +   .3168D-01, -.2209D-02, -.5541D-05,  .9258D-06,  .2844D-03,
     +   .5717D+00,  .2871D+00,  .4526D+00,
     +   .2689D-01, -.1851D-02, -.4335D-05,  .8970D-06,  .2437D-03,
     +   .5723D+00,  .2898D+00,  .4537D+00,
     +   .2317D-01, -.1576D-02, -.3474D-05,  .8538D-06,  .2104D-03,
     +   .5727D+00,  .2921D+00,  .4548D+00,
     +   .2034D-01, -.1370D-02, -.2856D-05,  .8069D-06,  .1845D-03,
     +   .5732D+00,  .2942D+00,  .4557D+00,
     +   .1822D-01, -.1217D-02, -.2424D-05,  .7637D-06,  .1648D-03,
     +   .5738D+00,  .2960D+00,  .4566D+00,
     +   .1604D-01, -.1061D-02, -.2001D-05,  .7152D-06,  .1443D-03,
     +   .5755D+00,  .2986D+00,  .4586D+00,
     +   .1435D-01, -.9421D-03, -.1699D-05,  .6716D-06,  .1284D-03,
     +   .5763D+00,  .3005D+00,  .4596D+00,
     +   .1292D-01, -.8419D-03, -.1457D-05,  .6252D-06,  .1149D-03,
     +   .5770D+00,  .3023D+00,  .4606D+00 /
        DATA ((PARTON(I,N,38),I=1,8),N=17,25)/
     +   .1175D-01, -.7610D-03, -.1269D-05,  .5878D-06,  .1040D-03,
     +   .5777D+00,  .3039D+00,  .4616D+00,
     +   .1045D-01, -.6712D-03, -.1072D-05,  .5425D-06,  .9183D-04,
     +   .5787D+00,  .3059D+00,  .4629D+00,
     +   .9376D-02, -.5979D-03, -.9240D-06,  .4991D-06,  .8183D-04,
     +   .5797D+00,  .3079D+00,  .4641D+00,
     +   .8434D-02, -.5341D-03, -.7930D-06,  .4622D-06,  .7323D-04,
     +   .5808D+00,  .3099D+00,  .4655D+00,
     +   .7694D-02, -.4843D-03, -.6974D-06,  .4358D-06,  .6643D-04,
     +   .5819D+00,  .3117D+00,  .4667D+00,
     +   .7000D-02, -.4380D-03, -.6187D-06,  .4030D-06,  .6017D-04,
     +   .5831D+00,  .3136D+00,  .4681D+00,
     +   .6410D-02, -.3988D-03, -.5469D-06,  .3792D-06,  .5488D-04,
     +   .5843D+00,  .3154D+00,  .4694D+00,
     +   .5876D-02, -.3636D-03, -.4928D-06,  .3512D-06,  .5016D-04,
     +   .5854D+00,  .3171D+00,  .4706D+00,
     +   .5445D-02, -.3353D-03, -.4477D-06,  .3322D-06,  .4624D-04,
     +   .5864D+00,  .3185D+00,  .4717D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=1,8)/
     +   .4253D-01, -.2624D-02, -.4135D-05,  .1090D-06,  .1771D-03,
     +   .5809D+00,  .3149D+00,  .4670D+00,
     +   .3628D-01, -.2210D-02, -.3284D-05,  .1451D-06,  .1761D-03,
     +   .5816D+00,  .3180D+00,  .4685D+00,
     +   .3221D-01, -.1943D-02, -.2768D-05,  .1635D-06,  .1689D-03,
     +   .5820D+00,  .3202D+00,  .4694D+00,
     +   .2814D-01, -.1680D-02, -.2276D-05,  .1788D-06,  .1570D-03,
     +   .5823D+00,  .3224D+00,  .4703D+00,
     +   .2400D-01, -.1416D-02, -.1807D-05,  .1890D-06,  .1407D-03,
     +   .5826D+00,  .3248D+00,  .4712D+00,
     +   .2142D-01, -.1253D-02, -.1525D-05,  .1916D-06,  .1286D-03,
     +   .5827D+00,  .3265D+00,  .4718D+00,
     +   .1963D-01, -.1141D-02, -.1341D-05,  .1934D-06,  .1195D-03,
     +   .5829D+00,  .3277D+00,  .4723D+00,
     +   .1725D-01, -.9933D-03, -.1110D-05,  .1958D-06,  .1065D-03,
     +   .5833D+00,  .3296D+00,  .4731D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=9,16)/
     +   .1571D-01, -.8991D-03, -.9676D-06,  .1887D-06,  .9762D-04,
     +   .5840D+00,  .3312D+00,  .4740D+00,
     +   .1309D-01, -.7393D-03, -.7414D-06,  .1795D-06,  .8185D-04,
     +   .5844D+00,  .3336D+00,  .4750D+00,
     +   .1108D-01, -.6189D-03, -.5915D-06,  .1663D-06,  .6934D-04,
     +   .5846D+00,  .3357D+00,  .4758D+00,
     +   .9582D-02, -.5302D-03, -.4880D-06,  .1533D-06,  .5986D-04,
     +   .5849D+00,  .3375D+00,  .4765D+00,
     +   .8476D-02, -.4653D-03, -.4184D-06,  .1396D-06,  .5282D-04,
     +   .5853D+00,  .3391D+00,  .4772D+00,
     +   .7351D-02, -.3999D-03, -.3453D-06,  .1302D-06,  .4561D-04,
     +   .5870D+00,  .3416D+00,  .4790D+00,
     +   .6494D-02, -.3506D-03, -.3000D-06,  .1225D-06,  .4017D-04,
     +   .5875D+00,  .3433D+00,  .4798D+00,
     +   .5778D-02, -.3097D-03, -.2670D-06,  .1096D-06,  .3567D-04,
     +   .5880D+00,  .3449D+00,  .4806D+00 /
        DATA ((PARTON(I,N,39),I=1,8),N=17,25)/
     +   .5202D-02, -.2770D-03, -.2416D-06,  .9983D-07,  .3207D-04,
     +   .5886D+00,  .3463D+00,  .4814D+00,
     +   .4565D-02, -.2412D-03, -.2176D-06,  .9009D-07,  .2812D-04,
     +   .5893D+00,  .3481D+00,  .4824D+00,
     +   .4047D-02, -.2124D-03, -.2047D-06,  .7890D-07,  .2491D-04,
     +   .5902D+00,  .3499D+00,  .4835D+00,
     +   .3599D-02, -.1876D-03, -.1840D-06,  .7418D-07,  .2225D-04,
     +   .5913D+00,  .3518D+00,  .4847D+00,
     +   .3250D-02, -.1684D-03, -.1738D-06,  .6878D-07,  .2013D-04,
     +   .5923D+00,  .3534D+00,  .4859D+00,
     +   .2927D-02, -.1508D-03, -.1681D-06,  .6146D-07,  .1823D-04,
     +   .5935D+00,  .3552D+00,  .4872D+00,
     +   .2655D-02, -.1360D-03, -.1591D-06,  .6035D-07,  .1665D-04,
     +   .5946D+00,  .3569D+00,  .4884D+00,
     +   .2411D-02, -.1229D-03, -.1551D-06,  .5269D-07,  .1524D-04,
     +   .5957D+00,  .3585D+00,  .4896D+00,
     +   .2216D-02, -.1124D-03, -.1544D-06,  .5093D-07,  .1408D-04,
     +   .5966D+00,  .3599D+00,  .4906D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=1,8)/
     +   .1898D-01, -.9151D-03, -.4107D-06, -.2033D-07,  .5257D-04,
     +   .5925D+00,  .3651D+00,  .4892D+00,
     +   .1585D-01, -.7545D-03, -.3159D-06, -.2888D-07,  .5029D-04,
     +   .5940D+00,  .3686D+00,  .4913D+00,
     +   .1384D-01, -.6531D-03, -.2579D-06, -.3323D-07,  .4690D-04,
     +   .5949D+00,  .3709D+00,  .4925D+00,
     +   .1188D-01, -.5547D-03, -.2209D-06, -.3871D-07,  .4226D-04,
     +   .5956D+00,  .3732D+00,  .4936D+00,
     +   .9917D-02, -.4579D-03, -.1818D-06, -.4182D-07,  .3649D-04,
     +   .5962D+00,  .3757D+00,  .4947D+00,
     +   .8719D-02, -.3993D-03, -.1571D-06, -.4467D-07,  .3261D-04,
     +   .5965D+00,  .3774D+00,  .4954D+00,
     +   .7898D-02, -.3595D-03, -.1407D-06, -.4153D-07,  .2967D-04,
     +   .5968D+00,  .3786D+00,  .4959D+00,
     +   .6824D-02, -.3078D-03, -.1241D-06, -.3680D-07,  .2581D-04,
     +   .5972D+00,  .3805D+00,  .4967D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=9,16)/
     +   .6143D-02, -.2754D-03, -.1129D-06, -.3626D-07,  .2325D-04,
     +   .5981D+00,  .3821D+00,  .4977D+00,
     +   .4996D-02, -.2212D-03, -.1039D-06, -.3593D-07,  .1893D-04,
     +   .5983D+00,  .3842D+00,  .4984D+00,
     +   .4141D-02, -.1814D-03, -.9895D-07, -.3211D-07,  .1570D-04,
     +   .5982D+00,  .3859D+00,  .4988D+00,
     +   .3516D-02, -.1526D-03, -.9600D-07, -.3047D-07,  .1333D-04,
     +   .5981D+00,  .3874D+00,  .4992D+00,
     +   .3062D-02, -.1319D-03, -.9812D-07, -.3267D-07,  .1166D-04,
     +   .5982D+00,  .3886D+00,  .4996D+00,
     +   .2609D-02, -.1114D-03, -.9655D-07, -.2824D-07,  .9981D-05,
     +   .5995D+00,  .3909D+00,  .5010D+00,
     +   .2270D-02, -.9623D-04, -.1006D-06, -.2221D-07,  .8818D-05,
     +   .5996D+00,  .3921D+00,  .5015D+00,
     +   .1990D-02, -.8381D-04, -.1035D-06, -.2375D-07,  .7875D-05,
     +   .5997D+00,  .3932D+00,  .5018D+00 /
        DATA ((PARTON(I,N,40),I=1,8),N=17,25)/
     +   .1769D-02, -.7403D-04, -.1062D-06, -.2402D-07,  .7175D-05,
     +   .5998D+00,  .3943D+00,  .5021D+00,
     +   .1528D-02, -.6346D-04, -.1109D-06, -.2034D-07,  .6367D-05,
     +   .6000D+00,  .3956D+00,  .5027D+00,
     +   .1335D-02, -.5509D-04, -.1208D-06, -.2238D-07,  .5771D-05,
     +   .6004D+00,  .3969D+00,  .5033D+00,
     +   .1170D-02, -.4798D-04, -.1188D-06, -.1720D-07,  .5331D-05,
     +   .6010D+00,  .3983D+00,  .5040D+00,
     +   .1044D-02, -.4255D-04, -.1198D-06, -.1643D-07,  .4931D-05,
     +   .6017D+00,  .3996D+00,  .5048D+00,
     +   .9281D-03, -.3764D-04, -.1268D-06, -.1383D-07,  .4667D-05,
     +   .6024D+00,  .4009D+00,  .5057D+00,
     +   .8320D-03, -.3357D-04, -.1245D-06, -.9966D-08,  .4381D-05,
     +   .6033D+00,  .4022D+00,  .5066D+00,
     +   .7470D-03, -.3000D-04, -.1319D-06, -.1298D-07,  .4178D-05,
     +   .6041D+00,  .4034D+00,  .5075D+00,
     +   .6796D-03, -.2717D-04, -.1357D-06, -.9707D-08,  .3957D-05,
     +   .6047D+00,  .4045D+00,  .5082D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=1,8)/
     +   .5761D-02, -.1992D-03,  .9025D-07, -.6099D-07,  .8322D-05,
     +   .6045D+00,  .4242D+00,  .5130D+00,
     +   .4672D-02, -.1596D-03,  .6087D-07, -.7820D-07,  .6788D-05,
     +   .6076D+00,  .4287D+00,  .5162D+00,
     +   .3993D-02, -.1353D-03,  .3658D-07, -.8653D-07,  .5627D-05,
     +   .6095D+00,  .4316D+00,  .5182D+00,
     +   .3345D-02, -.1122D-03,  .1336D-07, -.9518D-07,  .4367D-05,
     +   .6111D+00,  .4344D+00,  .5201D+00,
     +   .2715D-02, -.9012D-04, -.1170D-07, -.9913D-07,  .3138D-05,
     +   .6125D+00,  .4373D+00,  .5217D+00,
     +   .2339D-02, -.7708D-04, -.2212D-07, -.1000D-06,  .2450D-05,
     +   .6133D+00,  .4391D+00,  .5227D+00,
     +   .2087D-02, -.6836D-04, -.2488D-07, -.9568D-07,  .2010D-05,
     +   .6138D+00,  .4404D+00,  .5234D+00,
     +   .1763D-02, -.5727D-04, -.3712D-07, -.8644D-07,  .1509D-05,
     +   .6144D+00,  .4422D+00,  .5243D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=9,16)/
     +   .1561D-02, -.5042D-04, -.4344D-07, -.8132D-07,  .1279D-05,
     +   .6154D+00,  .4439D+00,  .5253D+00,
     +   .1230D-02, -.3930D-04, -.5672D-07, -.7328D-07,  .9483D-06,
     +   .6154D+00,  .4456D+00,  .5258D+00,
     +   .9912D-03, -.3136D-04, -.6729D-07, -.6451D-07,  .7819D-06,
     +   .6148D+00,  .4466D+00,  .5256D+00,
     +   .8211D-03, -.2576D-04, -.7769D-07, -.6130D-07,  .7762D-06,
     +   .6141D+00,  .4472D+00,  .5253D+00,
     +   .7005D-03, -.2183D-04, -.8442D-07, -.5494D-07,  .7453D-06,
     +   .6134D+00,  .4477D+00,  .5250D+00,
     +   .5827D-03, -.1802D-04, -.9091D-07, -.4804D-07,  .8094D-06,
     +   .6139D+00,  .4491D+00,  .5257D+00,
     +   .4965D-03, -.1526D-04, -.9474D-07, -.3831D-07,  .8720D-06,
     +   .6131D+00,  .4493D+00,  .5251D+00,
     +   .4270D-03, -.1306D-04, -.1042D-06, -.3802D-07,  .1020D-05,
     +   .6121D+00,  .4492D+00,  .5244D+00 /
        DATA ((PARTON(I,N,41),I=1,8),N=17,25)/
     +   .3729D-03, -.1135D-04, -.1093D-06, -.3412D-07,  .1097D-05,
     +   .6111D+00,  .4491D+00,  .5238D+00,
     +   .3151D-03, -.9543D-05, -.1173D-06, -.3054D-07,  .1211D-05,
     +   .6099D+00,  .4487D+00,  .5229D+00,
     +   .2699D-03, -.8139D-05, -.1263D-06, -.2920D-07,  .1326D-05,
     +   .6089D+00,  .4485D+00,  .5222D+00,
     +   .2321D-03, -.6961D-05, -.1248D-06, -.2299D-07,  .1473D-05,
     +   .6082D+00,  .4484D+00,  .5217D+00,
     +   .2036D-03, -.6084D-05, -.1293D-06, -.2121D-07,  .1531D-05,
     +   .6076D+00,  .4482D+00,  .5212D+00,
     +   .1780D-03, -.5295D-05, -.1355D-06, -.1991D-07,  .1620D-05,
     +   .6071D+00,  .4480D+00,  .5209D+00,
     +   .1570D-03, -.4666D-05, -.1327D-06, -.1580D-07,  .1749D-05,
     +   .6066D+00,  .4477D+00,  .5205D+00,
     +   .1388D-03, -.4112D-05, -.1411D-06, -.1413D-07,  .1790D-05,
     +   .6063D+00,  .4473D+00,  .5202D+00,
     +   .1245D-03, -.3680D-05, -.1446D-06, -.1358D-07,  .1792D-05,
     +   .6058D+00,  .4467D+00,  .5197D+00 /
C
         X  = DX
         Q  = DQ
         Q2 = DQ*DQ
*...CHECK OF X AND Q2 VALUES : 
C       IF ( (X.LT.1.0D-4) .OR. (X.GT.1.0D0) ) THEN
C           WRITE(6,91) 
C  91       FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C          GOTO 60
C       ENDIF
C       IF ( (Q2.LT.0.4D0) .OR. (Q2.GT.1.D4) ) THEN
C           WRITE(6,92) 
C  92       FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C          GOTO 60
C       ENDIF
C
*...INITIALIZATION :
*    SELECTION AND READING OF THE GRID :
*    FILE - NO. = 11 FOR NLO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.040D-03 )     
*    FILE - NO. = 22 FOR NLO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 9.740D-04 )     
*    FILE - NO. = 33 FOR  LO 'STANDARD' SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.731D-03 )     
*    FILE - NO. = 44 FOR  LO 'VALENCE'  SCENARIO ( FIRST NUMBER IN THE 
*                                                  GRID: 1.846D-03 )     
      IF (IINI.NE.0) GOTO 16
C      IF (ISET.EQ.1) THEN
C       IIREAD=11       
C       OPEN(UNIT=11,FILE='stdnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.2) THEN
C       IIREAD=22
C       OPEN(UNIT=22,FILE='valnloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.3) THEN
C       IIREAD=33       
C       OPEN(UNIT=33,FILE='stdloa1.grid',STATUS='OLD')
C      ELSE IF (ISET.EQ.4) THEN
C       IIREAD=44
C       OPEN(UNIT=44,FILE='valloa1.grid',STATUS='OLD')
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'PARTON INTERPOLATION: ISET OUT OF RANGE')
C        GOTO 60
C      END IF
C
C       DO 15 M = 1, NX-1 
C       DO 15 N = 1, NQ
C       READ(IIREAD,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1                 PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M),
C     2                 PARTON(7,N,M), PARTON(8,N,M)
C  90   FORMAT (8(1PE10.3))
C  15   CONTINUE
C
      IINI = 1
*....ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0 = XB(IX) 
        XB1 = 1.D0-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0**0.7)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0**0.6)
        XQBF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0**0.3) 
        XSF(IX,IQ)  = PARTON(4,IQ,IX) / (XB1**7 * XB0**0.3) 
        XGF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**10 * XB0**0.3)
        XAPF(IX,IQ)  = PARTON(6,IQ,IX) / XB0
        XANF(IX,IQ)  = PARTON(7,IQ,IX) / XB0
        XADF(IX,IQ)  = PARTON(8,IQ,IX) / XB0
  20  CONTINUE
        XUVF(NX,IQ) = 0.D0
        XDVF(NX,IQ) = 0.D0
        XQBF(NX,IQ) = 0.D0
        XSF(NX,IQ)  = 0.D0
        XGF(NX,IQ)  = 0.D0
        XAPF(NX,IQ)  = 0.D0
        XANF(NX,IQ)  = 0.D0
        XADF(NX,IQ)  = 0.D0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
  16  CONTINUE
C
*...INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * (1.D0-X)**3 * X**0.7
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * (1.D0-X)**4 * X**0.6 
      DDV = DV 
      QB = DBFINT(NARG,XT,NA,ARRF,XQBF) * (1.D0-X)**7 * X**0.3
      DSEA = QB
      ST = DBFINT(NARG,XT,NA,ARRF,XSF)  * (1.D0-X)**7 * X**0.3
      DSTR = ST
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * (1.D0-X)**10 * X**0.3
      DGL = GL
      A1P = DBFINT(NARG,XT,NA,ARRF,XAPF)  * X
      A1N = DBFINT(NARG,XT,NA,ARRF,XANF)  * X
      A1D = DBFINT(NARG,XT,NA,ARRF,XADF)  * X
 60   RETURN
      END
