*
* $Id: cevap1.F,v 1.1.1.1 1995/10/24 10:21:55 cernlib Exp $
*
* $Log: cevap1.F,v $
* Revision 1.1.1.1  1995/10/24 10:21:55  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.48  by  S.Giani
*-- Author :
      SUBROUTINE CEVAP1(EOLD,E,Q,ATAR,CB,EX)
C       THIS ROUTINE SAMPLES AN EXIT ENERGY FROM AN
C       EVAPORATION SPECTRUM FOR AN (N,N-PRIME X) REACTION
#include "geant321/minput.inc"
      SAVE
C       CONVERT THE COULOMB BARRIER (CB) TO UNITS OF EV
      CB=CB*1.00E+06
C       CALCULATE THE MAXIMUM ENERGY AVAILABLE
      CBI=CB
      EMAX=EOLD+Q-CB-E
      IF(EMAX.GT.0.0)GO TO 10
      CB=0.5*CB
      EMAX=EOLD+Q-CB-E
      IF(EMAX.GT.0.0)GO TO 10
      CB=0.0
      EMAX=EOLD+Q-CB-E
      IF(EMAX.LE.0.0)EMAX=1.0E+00
C       CALCULATE THE NUCLEAR TEMPERATURE (THETA)
   10 THETA=4.0161E+03*(SQRT(EMAX)/(ATAR**0.8333333))
C       SELECT THE EXIT ENERGY FROM AN EVAPORATION SPECTRUM
      ITRY = 0
   20 R1=FLTRNF(0)
      R2=FLTRNF(0)
      W=-LOG(R1*R2)
      EX=THETA*W
      IF(EX.LE.EMAX)RETURN
C       RESAMPLE 75% OF THE TIME IF EX IS GREATER THAN EMAX
      R=FLTRNF(0)
      ITRY = ITRY + 1
      IF(R.LE.0.75.AND.ITRY.LT.5)GO TO 20
#if defined(CERNLIB_MDEBUG)
      WRITE(IOUT,10000)EX,EMAX
10000 FORMAT(' MICAP: WARNING-EX,EMAX=',2PE13.5,' IN ROUTINE EVAP1')
#endif
      EX=EMAX
      RETURN
      END
