//////////////////////////////////////////////////////////////////////////
//                                                                      //
// XrdClientSock                                                        //
//                                                                      //
// Author: Fabrizio Furano (INFN Padova, 2004)                          //
// Adapted from TXNetFile (root.cern.ch) originally done by             //
//  Alvise Dorigo, Fabrizio Furano                                      //
//          INFN Padova, 2003                                           //
//                                                                      //
// Client Socket with timeout features                                  //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

//           $Id: XrdClientSock.hh,v 1.16 2006/05/23 12:12:38 ganis Exp $

#ifndef XRC_SOCK_H
#define XRC_SOCK_H

#include <XrdClient/XrdClientUrlInfo.hh>

struct XrdClientSockConnectParms {
   XrdClientUrlInfo TcpHost;
   int TcpWindowSize;
};

class XrdClientSock {

friend class XrdClientPhyConnection;

private:

   int                       fRequestTimeout;
   XrdClientSockConnectParms fHost;
   bool                      fConnected;
   bool                      fInterrupt;
   int fSocket;

   int    SaveSocket() { int fd = fSocket; fSocket = -1;
                         fConnected = 0; fInterrupt = 0; return fd; }
   void   SetInterrupt() { fInterrupt = 1; }

public:
   XrdClientSock(XrdClientUrlInfo host, int windowsize = 0);
   virtual ~XrdClientSock();

   int    RecvRaw(void* buffer, int length);
   int    SendRaw(const void* buffer, int length);

   void   SetRequestTimeout(int timeout = -1);

   void   TryConnect(bool isUnix = 0);

   void   Disconnect();

   bool   IsConnected() {return fConnected;}
};

#endif
