//////////////////////////////////////////////////////////////////////////
//                                                                      //
// XrdClientEnv                                                         // 
//                                                                      //
// Author: Fabrizio Furano (INFN Padova, 2004)                          //
// Adapted from TXNetFile (root.cern.ch) originally done by             //
//  Alvise Dorigo, Fabrizio Furano                                      //
//          INFN Padova, 2003                                           //
//                                                                      //
// Singleton used to handle the default parameter values                //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

//       $Id: XrdClientEnv.hh,v 1.8 2005/08/16 14:07:16 furano Exp $

#ifndef XRD_CENV_H
#define XRD_CENV_H

#include "XrdOuc/XrdOucEnv.hh"
#include "XrdOuc/XrdOucPthread.hh"

#include <string.h>

using namespace std;


#define EnvGetLong(x) XrdClientEnv::Instance()->GetInt(x)
#define EnvGetString(x) XrdClientEnv::Instance()->Get(x)
#define EnvPutString(name, val) XrdClientEnv::Instance()->Put(name, val)
#define EnvPutInt(name, val) XrdClientEnv::Instance()->PutInt(name, val)

class XrdClientEnv {
 private:

   XrdOucEnv      *fOucEnv;
   XrdOucRecMutex    fMutex;
   static XrdClientEnv *fgInstance;

 protected:
   XrdClientEnv();
   ~XrdClientEnv();

 public:

   const char *          Get(const char *varname) {
      const char *res;
      XrdOucMutexHelper m(fMutex);

      res = fOucEnv->Get(varname);
      return res;
   }

   long                   GetInt(const char *varname) {
      long res;
      XrdOucMutexHelper m(fMutex);

      res = fOucEnv->GetInt(varname);
      return res;
   }

   void                   Put(const char *varname, const char *value) {
      XrdOucMutexHelper m(fMutex);

      fOucEnv->Put(varname, value);
   }

   void  PutInt(const char *varname, long value) {
      XrdOucMutexHelper m(fMutex);

      fOucEnv->PutInt(varname, value);
   }

   static XrdClientEnv    *Instance();

};

#endif
