//Example illustrating how to save histograms in Tree branches.
//To run this example, do
// root > .L htest.C
// root > htw()
// root > htr1()
// root > htr2()
// root > htr3()
   
void htw() {
   //create a Tree with a few branches of type histogram
   //25000 entries are filled in the Tree
   //For each entry, the copy of 3 histograms is written
   //The data base will contain 75000 histograms.
   gBenchmark->Start("hsimple");
   TFile f("ht.root","recreate");
   TTree *T     = new TTree("T","test");
   TH1F *hpx    = new TH1F("hpx","This is the px distribution",100,-4,4);
   TH2F *hpxpy  = new TH2F("hpxpy","py vs px",40,-4,4,40,-4,4);
   TProfile *hprof  = new TProfile("hprof","Profile of pz versus px",100,-4,4,0,20);
   T->Branch("hpx","TH1F",&hpx,32000,0);
   T->Branch("hpxpy","TH2F",&hpxpy,32000,0);
   T->Branch("hprof","TProfile",&hprof,32000,0);
   Float_t px, py, pz;
   for (Int_t i = 0; i < 25000; i++) {
      if (i%1000 == 0) printf("at entry: %d\n",i);
      gRandom->Rannor(px,py);
      pz = px*px + py*py;
      hpx->Fill(px);
      hpxpy->Fill(px,py);
      hprof->Fill(px,pz);
      T->Fill();
   }
   T->Print();
   f.Write();
   gBenchmark->Show("hsimple");
}
void htr1() {
   //connect Tree generated by htw and show histograms for entry 12345
   TFile *f = new TFile("ht.root");
   TTree *T = (TTree*)f->Get("T");
   TH1F *hpx = 0;
   TH2F *hpxpy = 0;
   TProfile *hprof = 0;
   T->SetBranchAddress("hpx",&hpx);
   T->SetBranchAddress("hpxpy",&hpxpy);
   T->SetBranchAddress("hprof",&hprof);
   T->GetEntry(12345);
   TCanvas *c1 = new TCanvas("c1","test",10,10,600,1000);
   c1->Divide(1,3);
   c1->cd(1);
   hpx->Draw();
   c1->cd(2);
   hpxpy->Draw();
   c1->cd(3);
   hprof->Draw();
}
void htr2() {
   //connect Tree generated by htw and show histograms for entry 12345
   // a variant of htr1
   TFile *f = new TFile("ht.root");
   TTree *T = (TTree*)f->Get("T");
   TCanvas *c1 = new TCanvas("c1","test",10,10,600,1000);
   c1->Divide(1,3);
   c1->cd(1);
   T->Draw("hpx.Draw()","","goff",1,12345);
   c1->cd(2);
   T->Draw("hpxpy.Draw()","","goff",1,12345);
   c1->cd(3);
   T->Draw("hprof.Draw()","","goff",1,12345);
}
void htr3() {
   //connect Tree generated by htw
   //read all histograms and plot the RMS of hpx versus the Mean of hprof
   //for each of the 25000 entries
   TFile *f = new TFile("ht.root");
   TTree *T = (TTree*)f->Get("T");
   T->Draw("hpx.GetRMS():hprof.GetMean()");
}
