{
// Example of Root macro to copy a subset of a Tree to a new Tree
// Only selected entries are copied to the new Tree.
// The input file has been generated by the program in $ROOTSYS/test/Event
// with   Event 1000 1 99 1

   gROOT->Reset();
   gSystem->Load("$ROOTSYS/test/libEvent");

   //Get old file, old tree and set top branch address
   TFile *oldfile = new TFile("$ROOTSYS/test/Event.root");
   TTree *oldtree = (TTree*)oldfile->Get("T");
   Int_t nentries = (Int_t)oldtree->GetEntries();
   Event *event   = 0;
   oldtree->SetBranchAddress("event",&event);

   //Create a new file + a clone of old tree in new file
   TFile *newfile = new TFile("small.root","recreate");
   TTree *newtree = oldtree->CloneTree(0);

   for (Int_t i=0;i<nentries; i++) {
      oldtree->GetEntry(i);
      if (event->GetNtrack() > 605) newtree->Fill();
      event->Clear();
   }
   newtree->Print();
   newtree->AutoSave();
   delete oldfile;
   delete newfile;
}
