#
# author  Valeri Fine (fine@bnl.gov)
#-------------------------------------------------------------------------
# Qmake include file to add the rules to create RootCint Dictionary
#-------------------------------------------------------------------------
#
# $Id: rootcint.pri,v 1.4 2006/03/24 15:31:10 antcheva Exp $
#
# Copyright (C) 2002 by Valeri Fine.  All rights reserved.
#
# This file may be distributed under the terms of the Q Public License
# as defined by Trolltech AS of Norway and appearing in the file
# LICENSE.QPL included in the packaging of this file.
#-------------------------------------------------------------------------
#
# Usage:
# -----
# To link against of the ROOT Qt layer and generate the RootCint dictionary with qmake 
#-------------------------------------------------------------------------------------
# 1. Include this file into your project with QMAKE inlcude statement:
#
#    !exists ($(ROOTSYS)/include/rootcint.pri){
#        message "The Rootcint.pri was not found"
#    }
#    exists ($(ROOTSYS)/include/rootcint.pri){
#       include ($(ROOTSYS)/include/rootcint.pri)
#    }
#
# 2. Provide the list of the class header files followed by the appropriated LinkDef.f file
#    within your prpoject with CREATE_ROOT_DICT_FOR_CLASSES  QMAKE variable
# -----------------------------------------------
#
#   For example
#
#    . . . 
#    !exists ($(ROOTSYS)/include/rootcint.pri){
#        message "The Rootcint.pri was not found"
#    }
#    exists ($(ROOTSYS)/include/rootcint.pri){
#       include ($(ROOTSYS)/include/rootcint.pri)
#       CREATE_ROOT_DICT_FOR_CLASSES  = ${HEADERS} MyParticle.h MyDetector.h MyEvent.h ShowerMain.h 
#       CREATE_ROOT_DICT_FOR_CLASSES *= ${HEADERS} RSLinkDef.h
#    }
#    . . . 
# -----------------------------------------------
#
# 3. Run "qmake"
# 4. Run "make"
#
# -----------------------------------------------

#-- permanent components to be included into any ".pro" file to build the RootCint dictionary
#

# -- define the LIBS and INCLUDEPATH variable
#
# -------  define rootlibs.pri -----------------
ROOTLIBSPRI = 
ROOTLIBSPRIFILE = rootlibs.pri


# Wow !!! Qt exists function for the nested include file applies the relative path
exists ($$ROOTLIBSPRIFILE){
  ROOTLIBSPRI = inc/$$ROOTLIBSPRIFILE
}

isEmpty(ROOTLIBSPRI) 
{
  exists ($(QTROOTSYSDIR)/include/$$ROOTLIBSPRIFILE){
     ROOTLIBSPRI = $(QTROOTSYSDIR)/include/$$ROOTLIBSPRIFILE
  }
}

isEmpty(ROOTLIBSPRI) 
{
  exists ($(ROOTSYS)/include/$$ROOTLIBSPRIFILE){
     ROOTLIBSPRI = $(ROOTSYS)/include/$$ROOTLIBSPRIFILE
  }
}

isEmpty(ROOTLIBSPRI){
    message ("The $$ROOTLIBSPRIFILE was not found")
}

!isEmpty(ROOTLIBSPRI){
   include ($$ROOTLIBSPRI)
}

#
# ----------  define rootcintrule.pri  -----------------
# -- define the RootCint ROOT dictionary building rule
#
ROOTCINTRULEPRI = 
ROOTCINTRULEPRIFILE = rootcintrule.pri

isEmpty(ROOTCINTRULEPRI) 
{
  exists ($$ROOTCINTRULEPRIFILE){
     ROOTCINTRULEPRI = inc/$$ROOTCINTRULEPRIFILE 
  }
}

isEmpty(ROOTCINTRULEPRI) 
{
  exists ($(QTROOTSYSDIR)/include/$$ROOTCINTRULEPRIFILE ){
     ROOTCINTRULEPRI = $(QTROOTSYSDIR)/include/$$ROOTCINTRULEPRIFILE 
  }
}

isEmpty(ROOTCINTRULEPRI) 
{
  exists ($(ROOTSYS)/include/$$ROOTCINTRULEPRIFILE ){
     ROOTCINTRULEPRI = $(ROOTSYS)/include/$$ROOTCINTRULEPRIFILE 
  }
}

isEmpty(ROOTCINTRULEPRI){
    message ("The $$ROOTCINTRULEPRIFILE was not found")
}
!isEmpty(ROOTCINTRULEPRI){
   include ($$ROOTCINTRULEPRI)
}

