// @(#):$Name: v5-12-00e $:$Id: TGeoEltuEditor.h,v 1.1 2006/06/23 16:00:13 brun Exp $
// Author: M.Gheata 
/*************************************************************************
 * Copyright (C) 1995-2002, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

#ifndef ROOT_TGeoEltuEditor
#define ROOT_TGeoEltuEditor

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//  TGeoEltuEditor                                                      //
//                                                                      //
//  Editor for a TGeoEltu.                                              //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TGButton
#include "TGWidget.h"
#endif
#ifndef ROOT_TGedFrame
#include "TGedFrame.h"
#endif

class TGeoEltu;
class TGeoTabManager;
class TGTextEntry;
class TGNumberEntry;
class TGTab;
class TGComboBox;
class TGTextButton;
class TGCheckButton;
class TString;

class TGeoEltuEditor : public TGedFrame {

protected:

   Double_t             fAi;                // Initial  semi-axis of the ellipse along x
   Double_t             fBi;                // Initial  semi-axis of the ellipse along y
   Double_t             fDzi;               // Initial  half length in z
   TString              fNamei;             // Initial name
   TGeoEltu            *fShape;             // Shape object
   Bool_t               fIsModified;        // Flag that volume was modified
   Bool_t               fIsShapeEditable;   // Flag that the shape can be changed
   TGeoTabManager      *fTabMgr;            // Tab manager
   TGTextEntry         *fShapeName;         // Shape name text entry
   TGNumberEntry       *fEA;                // Number entry for  A
   TGNumberEntry       *fEB;                // Number entry for  B
   TGNumberEntry       *fEDz;               // Number entry for  DZ
   TGTextButton        *fApply;             // Apply-Button to accept changes
   TGTextButton        *fUndo;              // Undo-Button
   TGCheckButton       *fDelayed;           // Check button for delayed draw
  
   virtual void ConnectSignals2Slots();   // Connect the signals to the slots
   Bool_t       IsDelayed() const; 

public:
   TGeoEltuEditor(const TGWindow *p, Int_t id,               
                   Int_t width = 140, Int_t height = 30,
                   UInt_t options = kChildFrame,
                   Pixel_t back = GetDefaultFrameBackground());
   virtual ~TGeoEltuEditor();
   virtual void   SetModel(TVirtualPad *pad, TObject *obj, Int_t event);

   void           DoA();
   void           DoB();
   void           DoDz();
   void           DoModified();
   void           DoName();
   void           DoApply();
   void           DoUndo();
   
   ClassDef(TGeoEltuEditor,0)   // TGeoEltu editor
};   
  
#endif                    
