# Makefile include to build configcint.h (aka $@)
$(CINTCONF): config/Makefile.$(ARCH) $(CINTCONFMK)
	@-rm -f $@
	@echo Generating $@...
	@echo '/* Generated by cint/Module.mk */' > $@
	@( case $(ARCH) in \
	  win32) \
	    if [ $(VC_MAJOR) -ge 14 ]; then \
	       echo '#define G__CFG_ARCH "msvc8"' >> $@; \
	    else \
	       echo '#define G__CFG_ARCH "msvc7"' >> $@; \
	    fi && \
	    echo '#define G__CFG_LDOUT "-out:"' >> $@ && \
	    echo '#define G__CFG_LIBL "lib@imp@"' >> $@ && \
	    echo '#define G__CFG_LIBEXT ".lib"' >> $@ && \
	    echo '#define G__CFG_IMPLIBEXT ".lib"' >> $@ && \
	    echo '#define G__CFG_MANGLEPATHS "cygpath -m "' >> $@ && \
	    echo '#define G__CFG_PLATFORMO "v6_winnt"' >> $@ && \
	    echo '#define G__CFG_AR "lib /OUT:"' >> $@ ;;\
	  *) case $(ARCH) in \
	     macosx) \
	       echo '#define G__CFG_ARCH "macgcc"' >> $@ && \
	       echo '#define G__CFG_IMPLIBEXT ".dylib"' >> $@ ;;\
	     win32gcc) \
	       echo '#define G__CFG_ARCH "cygwin"' >> $@ && \
	       echo '#define G__CFG_IMPLIBEXT ".a"' >> $@ ;; \
	     *)	\
	       echo '#define G__CFG_ARCH "$(ARCH)"' >> $@ && \
	       echo '#define G__CFG_IMPLIBEXT ".a"' >> $@ ;; \
	    esac && \
	    echo '#define G__CFG_LDOUT "-o "' >> $@ && \
	    echo '#define G__CFG_LIBL "-l@imp@"' >> $@ && \
	    echo '#define G__CFG_LIBEXT ".a"' >> $@ && \
	    echo '#define G__CFG_MANGLEPATHS "echo "' >> $@ && \
	    echo '#define G__CFG_PLATFORMO ""' >> $@ && \
	    echo '#define G__CFG_AR "ar qcs"' >> $@ ;; \
	esac && \
	echo '#define G__CFG_CC "$(CC)"' >> $@ && \
	echo '#define G__CFG_CFLAGS "$(CINTCFLAGS)"' >> $@ && \
	echo '#define G__CFG_CMACROS "$(filter -D%,$(CINTCFLAGS))"' >> $@ && \
	echo '#define G__CFG_COMP "-c "' >> $@ && \
	echo '#define G__CFG_CPP "$(CPPPREP)"' >> $@ && \
	echo '#define G__CFG_COUT "$(CXXOUT)"' >> $@ && \
	echo '#define G__CFG_COUTEXE "$(CXXOUT)"' >> $@ && \
	echo '#define G__CFG_INCP "-I"' >> $@ && \
	echo '#define G__CFG_CXX "$(CXX)"' >> $@ && \
	echo '#define G__CFG_CXXFLAGS "$(CINTCXXFLAGS)"' >> $@ && \
	echo '#define G__CFG_CXXMACROS "$(filter -D%,$(CINTCXXFLAGS))"' >> $@ && \
	echo '#define G__CFG_LD "$(LD)"' >> $@ && \
	echo '#define G__CFG_LDFLAGS "$(LDFLAGS)"' >> $@ && \
	echo '#define G__CFG_LIBP "-L"' >> $@ && \
	echo '#define G__CFG_SOFLAGS "$(SOFLAGS)"' >> $@ && \
	echo '#define G__CFG_SOOUT G__CFG_LDOUT' >> $@ && \
	echo '#define G__CFG_OBJEXT ".o"' >> $@ && \
	echo '#define G__CFG_EXEEXT "$(EXEEXT)"' >> $@ && \
	echo '#define G__CFG_SOEXT ".$(SOEXT)"' >> $@ && \
	echo '#define G__CFG_DEBUG "$(DEBUG)"' >> $@ && \
	echo '#define G__CFG_DEFAULTLIBS "$(SYSLIBS)"' >> $@ && \
	echo '#define G__CFG_DEFAULTLIBS "$(SYSLIBS)"' >> $@ && \
	echo '#define G__CFG_CINTEXINCDIR "./"' >> $@ && \
	echo '#define G__CFG_CINTEXLIBDIR "lib/"' >> $@ && \
	echo '#define G__CFG_REFLEXINCDIR "./"' >> $@ && \
	echo '#define G__CFG_REFLEXLIBDIR "lib"' >> $@ && \
	echo '#define G__CFG_STREAMDIR "$(patsubst $(MODDIRS)/%strm.cxx,%,$(filter $(MODDIRS)/%strm.cxx, $(CINTS2)))"' >> $@ && \
	echo '#define G__CFG_EXPLLINK "$(EXPLICITLINK)"' >> $@ && \
	echo '#define G__CFG_BUILDREADLINE ""' >> $@ && \
	echo '#define G__CFG_READLINELIBDIR ""' >> $@ && \
	echo '#define G__CFG_READLINEINCDIR ""' >> $@ && \
	echo '#define G__CFG_NEEDCURSES ""' >> $@ && \
	echo '#define G__CFG_RM "rm -f"' >> $@ && \
	echo '#define G__CFG_MV "mv -f"' >> $@ && \
	echo '#define G__CFG_INPUTMODE "root"' >> $@ && \
	echo '#define G__CFG_INPUTMODELOCK "off"' >> $@ && \
	echo '#define G__CFG_MAKEIMPLIB ""' >> $@ && \
	echo '#define G__CFG_CINTSYSDIR "$(PWD)"' >> $@ && \
	echo '#define G__CFG_HAVE_CONFIG "1"' >> $@ && \
	echo '#define CINTSYSDIR "$(PWD)"' >> $@ && \
	echo '#define G__CFG_MAKEIMPLIB ""' >> $@ && \
	echo '#define G__CFG_HAVE_CONFIG "1"' >> $@ \
	)
