#!/bin/sh

# Script to produce list of files to be included in the binary distribution of ROOT.
# Called by makedist.sh.
#
# Axel, 2006-05-16

# $1 contains dir to prepend to file names

# dir name to prepend (e.g. for tar) - make sure it ends on '/'
PREPENDDIR=`echo ${1}|sed 's,/$,,'`/
if [ "x${PREPENDDIR}" = "x/" ]; then
   PREPENDDIR=
else
   cd $PREPENDDIR || exit 1
fi


# mixture of files, wildcards, and directories
WILDCARDS="LICENSE README bin \
   include lib cint/include \
   cint/lib cint/stl gdml/*.py tutorials/*.cxx tutorials/*.C \
   tutorials/*.h tutorials/*.dat tutorials/mlpHiggs.root \
   tutorials/gallery.root tutorials/galaxy.root \
   tutorials/stock.root tutorials/worldmap.jpg tutorials/rose512.jpg \
   tutorials/mditestbg.xpm tutorials/fore.xpm \
   tutorials/runcatalog.sql tutorials/*.py tutorials/*.rb \
   tutorials/saxexample.xml tutorials/person.xml \
   tutorials/person.dtd tutorials/FileDialog.png \
   tutorials/rose512.jpg tutorials/foam_README \
   test/*.cxx test/*.h test/Makefile* test/README \
   test/*.C test/*.sh test/dt_Makefile test/linearIO.root \
   test/RootShower/*.h test/RootShower/*.cxx \
   test/RootShower/*.rc test/RootShower/*.ico \
   test/RootShower/*.png test/RootShower/Makefile \
   test/RootShower/anim test/RootShower/icons test/ProofBench \
   tmva/test/*.gif tmva/test/*.C \
   macros icons fonts etc include/rmain.cxx"

# expand wildcards, recursively add directories
FILES=
for wc in ${WILDCARDS}; do
   if [ -d "${wc}" ]; then
      FILES="${FILES} `find ${wc} -type f -o -type l`"
   else
      FILES="${FILES} ${wc}"
   fi
done

# check whether we have a precompiled header, so we can keep it
HAVEPRECOMP=`echo ${FILES} | grep include/precompile.h`
if [ "x${HAVEPRECOMP}" != "x" ]; then
   HAVEPRECOMP=include/precompile.h
fi

FILES=`echo ${FILES} | tr ' ' '\n'`

ARCH=`grep -e '^ARCH' config/Makefile.config | sed 's,^ARCH.*:= ,,'`
if [ "x$ARCH" = "xwin32" ]; then
    FILES=`echo ${FILES} | tr ' ' '\n' | sed -e 's,^lib/.*\.dll$,,'`
fi
# remove all files we don't want, put one file per line
echo `echo ${FILES} | tr ' ' '\n' | sed \
  -e 's,^include/precompile\..*$,,' \
  -e 's,^.*.cvsignore$,,' \
  -e 's,^.*/CVS/.*$,,' \
   | grep -v '^$'` ${HAVEPRECOMP} | tr ' ' '\n' | sort | uniq | sed -e 's,^,'${PREPENDDIR}','
