// @(#)root/graf:$Name: v4-04-02d $:$Id: TGaxis.h,v 1.18 2004/06/17 15:33:49 brun Exp $
// Author: Rene Brun, Olivier Couet   12/12/94

/*************************************************************************
 * Copyright (C) 1995-2000, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

#ifndef ROOT_TGaxis
#define ROOT_TGaxis


//////////////////////////////////////////////////////////////////////////
//                                                                      //
// TGaxis                                                               //
//                                                                      //
// Service class for the graphical representation of axis.              //
// Instances of this class are generated by the histogram classes and   //
// TGraph.                                                              //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TNamed
#include "TNamed.h"
#endif
#ifndef ROOT_TLine
#include "TLine.h"
#endif
#ifndef ROOT_TAttText
#include "TAttText.h"
#endif

class TF1;
class TAxis;

class TGaxis : public TLine, public TAttText {

protected:
    Double_t   fWmin;                //Lowest value on the axis
    Double_t   fWmax;                //Highest value on the axis
    Float_t    fGridLength;          //Length of the grid in NDC
    Float_t    fTickSize;            //Size of primary tick mark in NDC
    Float_t    fLabelOffset;         //Offset of label wrt axis
    Float_t    fLabelSize;           //Size of labels in NDC
    Float_t    fTitleOffset;         //Offset of title wrt axis
    Float_t    fTitleSize;           //Size of title in NDC
    Int_t      fNdiv;                //Number of divisions
    Int_t      fLabelColor;          //Color for labels
    Int_t      fLabelFont;           //Font for labels
    TString    fChopt;               //Axis options
    TString    fName;                //axis name
    TString    fTitle;               //axis title
    TString    fTimeFormat;          //Time format, ex: 09/12/99 12:34:00
    TString    fFunctionName;        //name of mapping function pointed by fFunction
    TF1       *fFunction;            //!Pointer to function computing axis values
    TAxis     *fAxis;                //!pointer to original TAxis axis (if any)

  static Int_t fgMaxDigits;          //!Number of digits above which the 10>N notation is used

public:

        TGaxis();
        TGaxis(Double_t xmin,Double_t ymin,Double_t xmax,Double_t ymax,
               Double_t wmin,Double_t wmax,Int_t ndiv=510, Option_t *chopt="",
               Double_t gridlength = 0);
        TGaxis(Double_t xmin,Double_t ymin,Double_t xmax,Double_t ymax,
               const char *funcname, Int_t ndiv=510, Option_t *chopt="",
               Double_t gridlength = 0);
        virtual ~TGaxis();
        virtual void    AdjustBinSize(Double_t A1,  Double_t A2,  Int_t nold
                       ,Double_t &BinLow, Double_t &BinHigh, Int_t &nbins, Double_t &BinWidth);
        virtual void    CenterLabels(Bool_t center=kTRUE);
        virtual void    CenterTitle(Bool_t center=kTRUE);
        virtual void    DrawAxis(Double_t xmin,Double_t ymin,Double_t xmax,Double_t ymax,
                                 Double_t wmin,Double_t wmax,Int_t ndiv=510, Option_t *chopt="",
                                 Double_t gridlength = 0);
             Float_t    GetGridLength() const   {return fGridLength;}
             TF1       *GetFunction() const     {return fFunction;}
               Int_t    GetLabelColor() const   {return fLabelColor;}
               Int_t    GetLabelFont() const    {return fLabelFont;}
             Float_t    GetLabelOffset() const  {return fLabelOffset;}
             Float_t    GetLabelSize() const    {return fLabelSize;}
             Float_t    GetTitleOffset() const  {return fTitleOffset;}
             Float_t    GetTitleSize() const    {return fTitleSize;}
virtual const char     *GetName() const  {return fName.Data();}
virtual const char     *GetOption() const {return fChopt.Data();}
virtual const char     *GetTitle() const {return fTitle.Data();}
        static Int_t    GetMaxDigits();
               Int_t    GetNdiv() const         {return fNdiv;}
             Double_t   GetWmin() const         {return fWmin;}
             Double_t   GetWmax()  const        {return fWmax;}
             Float_t    GetTickSize() const     {return fTickSize;}
        virtual void    ImportAxisAttributes(TAxis *axis);
                void    LabelsLimits(const char *label, Int_t &first, Int_t &last);
        virtual void    Paint(Option_t *chopt="");
        virtual void    PaintAxis(Double_t xmin,Double_t ymin,Double_t xmax,Double_t ymax,
                                  Double_t &wmin,Double_t &wmax,Int_t &ndiv, Option_t *chopt="",
                                  Double_t gridlength = 0, Bool_t drawGridOnly = kFALSE);
        virtual void    Rotate(Double_t X,  Double_t Y,  Double_t CFI, Double_t SFI
                              ,Double_t XT, Double_t YT, Double_t &U,   Double_t &V);
        virtual void    SavePrimitive(ofstream &out, Option_t *option);
                void    SetFunction(const char *funcname="");
                void    SetOption(Option_t *option="");
                void    SetLabelColor(Int_t labelcolor) {fLabelColor = labelcolor;} // *MENU*
                void    SetLabelFont(Int_t labelfont) {fLabelFont = labelfont;} // *MENU*
                void    SetLabelOffset(Float_t labeloffset) {fLabelOffset = labeloffset;} // *MENU*
                void    SetLabelSize(Float_t labelsize) {fLabelSize = labelsize;} // *MENU*
         static void    SetMaxDigits(Int_t maxd=5);
        virtual void    SetName(const char *name); // *MENU*
        virtual void    SetNdivisions(Int_t ndiv) {fNdiv = ndiv;} // *MENU*
        virtual void    SetMoreLogLabels(Bool_t more=kTRUE);  // *MENU*
        virtual void    SetNoExponent(Bool_t noExponent=kTRUE);  // *MENU*
        virtual void    SetDecimals(Bool_t dot=kTRUE);  // *MENU*
                void    SetTickSize(Float_t ticksize) {fTickSize = ticksize;} // *MENU*
                void    SetGridLength(Float_t gridlength) {fGridLength = gridlength;}
                void    SetTimeFormat(const char *tformat);
                void    SetTimeOffset(Double_t toffset, Option_t *option="local");
        virtual void    SetTitle(const char *title=""); // *MENU*
                void    SetTitleOffset(Float_t titleoffset=1) {fTitleOffset = titleoffset;} // *MENU*
                void    SetTitleSize(Float_t titlesize) {fTitleSize = titlesize;} // *MENU*
                void    SetWmin(Double_t wmin) {fWmin = wmin;}
                void    SetWmax(Double_t wmax) {fWmax = wmax;}

                ClassDef(TGaxis,5)  //Graphics axis
};

#endif


