/*
 *	Copyright 1996-1999, The Portland Group, Incorporated.
 *	All rights reserved.
 *
 *	THE PORTLAND GROUP, INCORPORATED PROPRIETARY INFORMATION
 * This software is supplied under the terms of a license agreement
 * or nondisclosure agreement with The Portland Group and may not be
 * copied or disclosed except in accordance with the terms of that
 * agreement.
 */

/* MPI implementation-dependent routines */

#include "mpi.h"

extern int __hpf_lcpu;
extern int __hpf_tcpus;

#define MAXREQS	(4*1024)		/* maximum requests */

int __hpf_maxreqs = MAXREQS;		/* a variable too */

static MPI_Comm __hpf_mpi_comm;
static MPI_Status sstatus;		/* struct status */
static MPI_Request reqs[MAXREQS];	/* request structures */
static int __hpf_typl;

/* non-blocking send */

void
__hpf_ISEND(int cpu,char *adr,int len,int req)
{
	MPI_Isend(adr,len,MPI_BYTE,cpu,__hpf_typl,__hpf_mpi_comm,&reqs[req]);
}

/* non-blocking receive */

void __hpf_IRECV(int cpu,char *adr,int len,int req)
{
	MPI_Irecv(adr,len,MPI_BYTE,cpu,__hpf_typl,__hpf_mpi_comm,&reqs[req]);
}

/* wait */

void
__hpf_IWAIT(int req) 
{
	MPI_Wait(&reqs[req],&sstatus);
}

/* blocking send */

void
__hpf_SEND(int cpu,char *adr,int len)
{
	MPI_Send(adr,len,MPI_BYTE,cpu,__hpf_typl,__hpf_mpi_comm);
}

/* blocking receive */

void
__hpf_RECV(int cpu,char *adr,int len)
{
	MPI_Recv(adr,len,MPI_BYTE,cpu,__hpf_typl,__hpf_mpi_comm,&sstatus);
}

/* abort */

void
__hpf_Abort()
{
#ifdef C90
	MPI_Finalize(); /* Cray MPT MPI doesn't like Abort */
	_exit(1);
#else
	MPI_Abort(MPI_COMM_WORLD,0);
#endif
}

/* finalize */

void
__hpf_Finalize()
{
	MPI_Finalize();
}

/* init */

void
__hpf_Init(int *argc,char ***argv)
{
        MPI_Init(argc,argv);
        __hpf_mpi_comm = MPI_COMM_WORLD;
        MPI_Comm_rank(__hpf_mpi_comm,&__hpf_lcpu);
        MPI_Comm_size(__hpf_mpi_comm,&__hpf_tcpus);
        __hpf_typl = 0;
}

/* barrier */

void
__hpf_Barrier()
{
	MPI_Barrier(__hpf_mpi_comm);
}

