!       Copyright 1995-2001, The Portland Group, Incorporated.
!       All rights reserved.
!
!       THE PORTLAND GROUP, INCORPORATED PROPRIETARY INFORMATION
! This software is supplied under the terms of a license agreement
! or nondisclosure agreement with The Portland Group and may not be
! copied or disclosed except in accordance with the terms of that
! agreement.

! Extrinsic interfaces for lib3f routines.
! Version 3.2

      interface

        extrinsic (f77_local) subroutine abort()
!pgi$   l3f abort
        end subroutine

        extrinsic (f77_local) integer function access(fil,mod)
!pgi$   l3f access
        character*(*), intent(in) :: fil, mod
        end function

        extrinsic (f77_local) integer function alarm(time,proc)
!pgi$   l3f alarm
        integer, intent(in) :: time
        external proc
        end function

        extrinsic (f77_local) pure real function besj0(x)
!pgi$   l3f besj0
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function besj1(x)
!pgi$   l3f besj1
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function besjn(n,x)
!pgi$   l3f besjn
        integer, intent(in) :: n
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function besy0(x)
!pgi$   l3f besy0
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function besy1(x)
!pgi$   l3f besy1
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function besyn(n,x)
!pgi$   l3f besyn
        integer, intent(in) :: n
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dbesj0(x)
!pgi$   l3f dbesj0
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dbesj1(x)
!pgi$   l3f dbesj1
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dbesjn(n,x)
!pgi$   l3f dbesjn
        integer, intent(in) :: n
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dbesy0(x)
!pgi$   l3f dbesy0
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dbesy1(x)
!pgi$   l3f dbesy1
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dbesyn(n,x)
!pgi$   l3f dbesyn
        integer, intent(in) :: n
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) integer function chdir(path)
!pgi$   l3f chdir
        character*(*), intent(in) :: path
        end function

        extrinsic (f77_local) integer function chmod(nam,mode)
!pgi$   l3f chmod
        character*(*), intent(in) :: nam
        integer, intent(in) :: mode
        end function

        extrinsic (f77_local) pure character*(24) function ctime(stime)
!pgi$   l3f ctime
        integer, intent(in) :: stime
        end function

        extrinsic (f77_local) pure subroutine date(str)
!pgi$   l3f date
        character*(*), intent(out) :: str
        end subroutine

        extrinsic (f77_local) pure real function erf(x)
!pgi$   l3f erf
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function erfc(x)
!pgi$   l3f erfc
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function derf(x)
!pgi$   l3f derf
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function derfc(x)
!pgi$   l3f derfc
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) pure real function etime(tarray)
!pgi$   l3f etime
        real, intent(out) :: tarray(2)
        end function

        extrinsic (f77_local) pure real function dtime(tarray)
!pgi$   l3f dtime
        real, intent(out) :: tarray(2)
        end function

        extrinsic (f77_local) subroutine exit(s)
!pgi$   l3f exit
        integer, intent(in) :: s
        end subroutine

        extrinsic (f77_local) pure subroutine fdate(str)
!pgi$   l3f fdate
        character*(*), intent(out) :: str
        end subroutine

        extrinsic (f77_local) integer function fgetc(lu,ch)
!pgi$   l3f fgetc
        integer, intent(in) :: lu
        character*(*), intent(out) :: ch
        end function

        extrinsic (f77_local) subroutine flush(lu)
!pgi$   l3f flush
        integer, intent(in) :: lu
        end subroutine

        extrinsic (f77_local) integer function fork()
!pgi$   l3f fork
        end function

        extrinsic (f77_local) integer function fputc(lu,ch)
!pgi$   l3f fputc
        integer, intent(in) :: lu
        character*(*), intent(in) :: ch
        end function

        extrinsic (f77_local) subroutine free(p)
!pgi$   l3f free
        integer, intent(in) :: p
        end subroutine

        extrinsic (f77_local) integer function fseek(lu,offset,from)
!pgi$   l3f fseek
        integer, intent(in) :: lu, offset, from
        end function

        extrinsic (f77_local) integer function ftell(lu)
!pgi$   l3f ftell
        integer, intent(in) :: lu
        end function

        extrinsic (f77_local) subroutine gerror(str)
!pgi$   l3f gerror
        character*(*), intent(out) :: str
        end subroutine

        extrinsic (f77_local) subroutine getarg(i,c)
!pgi$   l3f getarg
        integer, intent(in) :: i
        character*(*), intent(out) :: c
        end subroutine

        extrinsic (f77_local) integer function iargc()
!pgi$   l3f iargc
        end function

        extrinsic (f77_local) integer function getc(ch)
!pgi$   l3f getc
        character*(*), intent(out) :: ch
        end function

        extrinsic (f77_local) integer function getcwd(dir)
!pgi$   l3f getcwd
        character*(*), intent(out) :: dir
        end function

        extrinsic (f77_local) subroutine getenv(en,ev)
!pgi$   l3f getenv
        character*(*), intent(in) :: en
        character*(*), intent(out) :: ev
        end subroutine

        extrinsic (f77_local) integer function getfd(lu)
!pgi$   l3f getfd
	integer, intent(in) :: lu
        end function

        extrinsic (f77_local) integer function getgid()
!pgi$   l3f getgid
        end function

        extrinsic (f77_local) subroutine getlog(name)
!pgi$   l3f getlog
        character*(*), intent(out) :: name
        end subroutine

        extrinsic (f77_local) integer function getpid()
!pgi$   l3f getpid
        end function

        extrinsic (f77_local) integer function getuid()
!pgi$   l3f getuid
        end function

        extrinsic (f77_local) pure subroutine gmtime(stime,tarray)
!pgi$   l3f gmtime
        integer, intent(in) :: stime
        integer, intent(out) :: tarray(9)
        end subroutine

        extrinsic (f77_local) integer function hostnm(nm)
!pgi$   l3f hostnm
        character*(*), intent(out) :: nm
        end function

        extrinsic (f77_local) pure subroutine idate(date_array)
!pgi$   l3f idate
        integer, intent(out) :: date_array(3)
        end subroutine

        extrinsic (f77_local) integer function ierrno()
!pgi$   l3f ierrno
        end function

        extrinsic (f77_local) subroutine ioinit(cc,bz,ap,pf,vb)
!pgi$   l3f ioinit
        logical, intent(in) :: cc, bz, ap, vb
        character*(*), intent(in) :: pf
        end subroutine

        extrinsic (f77_local) logical function isatty(lu)
!pgi$   l3f isatty
        integer, intent(in) :: lu
        end function

        extrinsic (f77_local) pure subroutine itime(iarray)
!pgi$   l3f itime
        integer, intent(out) :: iarray(3)
        end subroutine

        extrinsic (f77_local) integer function kill(pid,sig)
!pgi$   l3f kill
        integer, intent(in) :: pid, sig
        end function

        extrinsic (f77_local) integer function link(n1,n2)
!pgi$   l3f link
        character*(*), intent(in) :: n1, n2
        end function

        extrinsic (f77_local) pure integer function lnblnk(a1)
!pgi$   l3f lnblnk
        character*(*), intent(in) :: a1
        end function

        extrinsic (f77_local) pure integer function loc(a)
!pgi$   l3f loc
        integer, intent(in) :: a
        end function

        extrinsic (f77_local) pure subroutine ltime(stime,tarray)
!pgi$   l3f ltime
        integer, intent(in) :: stime
        integer, intent(out) :: tarray(9)
        end subroutine

        extrinsic (f77_local) integer function malloc(n)
!pgi$   l3f malloc
        integer, intent(in) :: n
        end function

        extrinsic (f77_local) pure integer function mclock()
!pgi$   l3f mclock
        end function

        extrinsic (f77_local) integer function outstr(ch)
!pgi$   l3f outstr
        character*(*), intent(in) :: ch
        end function

        extrinsic (f77_local) subroutine perror(str)
!pgi$   l3f perror
        character*(*), intent(in) :: str
        end subroutine

        extrinsic (f77_local) integer function putc(ch)
!pgi$   l3f putc
        character*(*), intent(in) :: ch
        end function

        extrinsic (f77_local) integer function putenv(str)
!pgi$   l3f putenv
        character*(*), intent(in) :: str
        end function

        extrinsic (f77_local) pure subroutine qsort(arr,len,isiz,comp)
!pgi$   l3f qsort
        integer, intent(inout) :: arr(*)
        integer, intent(in) :: len, isiz
        external comp
        integer comp
        end subroutine

        extrinsic (f77_local) double precision function rand()
!pgi$   l3f rand
        end function

        extrinsic (f77_local) integer function irand()
!pgi$   l3f irand
        end function

        extrinsic (f77_local) subroutine srand(iseed)
!pgi$   l3f srand
        integer, intent(in) :: iseed
        end subroutine

        extrinsic (f77_local) real function random(flag)
!pgi$   l3f random
        integer, intent(in) :: flag
        end function

        extrinsic (f77_local) integer function irandm(flag)
!pgi$   l3f irandm
        integer, intent(in) :: flag
        end function

        extrinsic (f77_local) double precision function drandm(flag)
!pgi$   l3f drandm
        integer, intent(in) :: flag
        end function

        extrinsic (f77_local) pure real function flmin()
!pgi$   l3f flmin
        end function

        extrinsic (f77_local) pure real function flmax()
!pgi$   l3f flmax
        end function

        extrinsic (f77_local) pure real function ffrac()
!pgi$   l3f ffrac
        end function

        extrinsic (f77_local) pure double precision function dflmin()
!pgi$   l3f dflmin
        end function

        extrinsic (f77_local) pure double precision function dflmax()
!pgi$   l3f dflmax
        end function

        extrinsic (f77_local) pure double precision function dffrac()
!pgi$   l3f dffrac
        end function

        extrinsic (f77_local) pure integer function inmax()
!pgi$   l3f inmax
        end function

        extrinsic (f77_local) integer function rename(from,to)
!pgi$   l3f rename
        character*(*), intent(in) :: from, to
        end function

        extrinsic (f77_local) pure integer function rindex(a1,a2)
!pgi$   l3f rindex
        character*(*), intent(in) :: a1, a2
        end function

        extrinsic (f77_local) pure real function secnds(x)
!pgi$   l3f secnds
        real, intent(in) :: x
        end function

        extrinsic (f77_local) pure double precision function dsecnds(x)
!pgi$   l3f dsecnds
        double precision, intent(in) :: x
        end function

        extrinsic (f77_local) integer function signal(sig,proc,flag)
!pgi$   l3f signal
        integer, intent(in) :: sig, flag
        external proc
        end function

        extrinsic (f77_local) subroutine sleep(itime)
!pgi$   l3f sleep
        integer, intent(in) :: itime
        end subroutine

        extrinsic (f77_local) integer function stat(nm,statb)
!pgi$   l3f stat
        character*(*), intent(in) :: nm
        integer, intent(out) :: statb(*)
        end function

        extrinsic (f77_local) integer function lstat(nm,statb)
!pgi$   l3f lstat
        character*(*), intent(in) :: nm
        integer, intent(out) :: statb(*)
        end function

        extrinsic (f77_local) integer function fstat(lu,statb)
!pgi$   l3f fstat
        integer, intent(in) :: lu
        integer, intent(out) :: statb(*)
        end function

        extrinsic (f77_local) integer function stime(tp)
!pgi$   l3f stime
        integer, intent(in) :: tp
        end function

        extrinsic (f77_local) integer function symlnk(n1,n2)
!pgi$   l3f symlnk
        character*(*), intent(in) :: n1, n2
        end function

        extrinsic (f77_local) integer function system(str)
!pgi$   l3f system
        character*(*), intent(in) :: str
        end function

        extrinsic (f77_local) pure integer function time()
!pgi$   l3f time
        end function

        extrinsic (f77_local) pure integer function times(buf)
!pgi$   l3f times
        integer, intent(out) :: buf(*)
        end function

        extrinsic (f77_local) character*(100) function ttynam(lu)
!pgi$   l3f ttynam
        integer, intent(in) :: lu
        end function

        extrinsic (f77_local) integer function unlink(fil)
!pgi$   l3f unlink
        character*(*), intent(in) :: fil
        end function

        extrinsic (f77_local) integer function wait(st)
!pgi$   l3f wait
        integer, intent(out) :: st
        end function

      end interface
