/*
 *	Copyright 1998-1999, The Portland Group, Incorporated.
 *	All rights reserved.
 *
 *	THE PORTLAND GROUP, INCORPORATED PROPRIETARY INFORMATION
 * This software is supplied under the terms of a license agreement
 * or nondisclosure agreement with The Portland Group and may not be
 * copied or disclosed except in accordance with the terms of that
 * agreement.
 */

/* simple lock */

typedef long omp_lock_t;

/* nestable lock */

struct omp_nest_lock {
	omp_lock_t act;		/* actual nested lock */
	int cnt;		/* lock count */
	int tid;		/* owning thread number */
};
typedef struct omp_nest_lock omp_nest_lock_t;

#ifdef __cplusplus
extern "C" {
#endif

extern void omp_set_num_threads(int n);
extern int omp_get_thread_num(void);
extern int omp_get_num_procs(void);
extern int omp_get_num_threads(void);
extern int omp_get_max_threads(void);
extern int omp_in_parallel(void);
extern void omp_set_dynamic(int n);
extern int omp_get_dynamic(void);
extern void omp_set_nested(int n);
extern int omp_get_nested(void);
extern void omp_init_lock(omp_lock_t *s);
extern void omp_destroy_lock(omp_lock_t *s);
extern void omp_set_lock(omp_lock_t *s);
extern void omp_unset_lock(omp_lock_t *s);
extern int omp_test_lock(omp_lock_t *s);
extern void omp_init_nest_lock(omp_nest_lock_t *s);
extern void omp_destroy_nest_lock(omp_nest_lock_t *s);
extern void omp_set_nest_lock(omp_nest_lock_t *s);
extern void omp_unset_nest_lock(omp_nest_lock_t *s);
extern int omp_test_nest_lock(omp_nest_lock_t *s);

#ifdef __cplusplus
}
#endif
