/* 
* varargs.h
*
*      Copyright 1995, The Portland Group, Incorporated.
*      All rights reserved.
*
*        THE PORTLAND GROUP, INCORPORATED PROPRIETARY INFORMATION
* This software is supplied under the terms of a license agreement
* or nondisclosure agreement with The Portland Group and may not be
* copied or disclosed except in accordance with the terms of that
* agreement.
*/

#ifndef _VARARGS_H
#define _VARARGS_H

#ifdef __cplusplus
extern "C" {

extern int   __builtin_va_arg_size(...);

#endif /* __cplusplus */

typedef char *va_list;

#ifdef __cplusplus
/* get the C++ correct prototype style */
#define va_alist int __builtin_va_alist, ...
#define va_dcl 
#define va_start(list) list = (char *)&__builtin_va_alist
#else
#define va_dcl int va_alist;
#define va_start(list) list = (char *)&va_alist
#endif


#define va_end(list)

#define va_arg(list, mode) \
    ( \
	list += (int)__builtin_va_arg_size((mode *)0), \
	*(mode *)((char *)list - __builtin_va_arg_size((mode *)0)) \
    )

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
